<?php
// Do not allow directly accessing this file.
if (!defined('ABSPATH')) {
    exit('Direct script access denied.');
}
add_action( 'vc_after_init', 'g5element_custom_vc_icon_per_page' );
function g5element_custom_vc_icon_per_page() {
    $shortcodes = array(
        'vc_tta_section' => 'i_',
        'vc_btn' => 'i_',
        'vc_text_separator' => 'i_',
        'vc_icon' => ''
    );
    $icons_type =  array(
        'icon_fontawesome',
        'icon_openiconic',
        'icon_typicons',
        'icon_entypo',
        'icon_linecons',
        'icon_monosocial',
        'icon_material'
    );
    foreach ($shortcodes as $shortcode => $prefix) {
        foreach ($icons_type as $icon_type) {
            $param_icon               = WPBMap::getParam( $shortcode, "{$prefix}{$icon_type}");
            if (isset($param_icon['settings']) ) {
                $param_icon['settings']      = wp_parse_args(array(
                    'iconsPerPage' => 50
                ),$param_icon['settings']);
                vc_update_shortcode_param( $shortcode, $param_icon );
            }
        }
    }
}

/*add_action( 'vc_after_init', 'g5element_custom_vc_icon_color' );
function g5element_custom_vc_icon_color() {
    $shortcodes = array(
        'vc_text_separator' => 'i_',
        'vc_icon' => ''
    );

    foreach ($shortcodes as $shortcode => $prefix) {
        $param_color               = WPBMap::getParam( $shortcode, "{$prefix}color" );
        if (is_array($param_color)) {
            $param_color['value']      = array_merge( g5element_vc_sources_colors(), $param_color['value'] );
            $param_color['std']        = 'accent';
            vc_update_shortcode_param( $shortcode, $param_color );
        }
    }
}*/



add_action('init','g5element_custom_fontawsome',100);
function g5element_custom_fontawsome() {
    remove_filter( 'vc_iconpicker-type-fontawesome', 'vc_iconpicker_type_fontawesome' );

}

add_filter( 'vc_iconpicker-type-fontawesome', 'g5element_iconpicker_type_fontawesome' );
function g5element_iconpicker_type_fontawesome($icons) {
    $fontawesome_icons = array(
        'Accessibility' => array(
            array('fab fa-accessible-icon' => 'accessible-icon(accessibility,handicap,person,wheelchair,wheelchair-alt)'),
            array('fas fa-american-sign-language-interpreting' => 'american-sign-language-interpreting(asl,deaf,finger,hand,interpret,speak)'),
            array('far fa-american-sign-language-interpreting' => 'american-sign-language-interpreting(asl,deaf,finger,hand,interpret,speak)'),
            array('fal fa-american-sign-language-interpreting' => 'american-sign-language-interpreting(asl,deaf,finger,hand,interpret,speak)'),
            array('fas fa-assistive-listening-systems' => 'assistive-listening-systems(amplify,audio,deaf,ear,headset,hearing,sound)'),
            array('far fa-assistive-listening-systems' => 'assistive-listening-systems(amplify,audio,deaf,ear,headset,hearing,sound)'),
            array('fal fa-assistive-listening-systems' => 'assistive-listening-systems(amplify,audio,deaf,ear,headset,hearing,sound)'),
            array('fas fa-audio-description' => 'audio-description(blind,narration,video,visual)'),
            array('far fa-audio-description' => 'audio-description(blind,narration,video,visual)'),
            array('fal fa-audio-description' => 'audio-description(blind,narration,video,visual)'),
            array('fas fa-blind' => 'blind(cane,disability,person,sight)'),
            array('far fa-blind' => 'blind(cane,disability,person,sight)'),
            array('fal fa-blind' => 'blind(cane,disability,person,sight)'),
            array('fas fa-braille' => 'braille(alphabet,blind,dots,raised,vision)'),
            array('far fa-braille' => 'braille(alphabet,blind,dots,raised,vision)'),
            array('fal fa-braille' => 'braille(alphabet,blind,dots,raised,vision)'),
            array('fas fa-closed-captioning' => 'closed-captioning(cc,deaf,hearing,subtitle,subtitling,text,video)'),
            array('far fa-closed-captioning' => 'closed-captioning(cc,deaf,hearing,subtitle,subtitling,text,video)'),
            array('fal fa-closed-captioning' => 'closed-captioning(cc,deaf,hearing,subtitle,subtitling,text,video)'),
            array('fas fa-deaf' => 'deaf(ear,hearing,sign language)'),
            array('far fa-deaf' => 'deaf(ear,hearing,sign language)'),
            array('fal fa-deaf' => 'deaf(ear,hearing,sign language)'),
            array('fas fa-dog-leashed' => 'dog-leashed(animal,canine,fauna,mammal,pet,pooch,puppy,walk,woof)'),
            array('far fa-dog-leashed' => 'dog-leashed(animal,canine,fauna,mammal,pet,pooch,puppy,walk,woof)'),
            array('fal fa-dog-leashed' => 'dog-leashed(animal,canine,fauna,mammal,pet,pooch,puppy,walk,woof)'),
            array('fas fa-low-vision' => 'low-vision(blind,eye,sight)'),
            array('far fa-low-vision' => 'low-vision(blind,eye,sight)'),
            array('fal fa-low-vision' => 'low-vision(blind,eye,sight)'),
            array('fas fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('far fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fal fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fas fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('far fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('fal fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('fas fa-sign-language' => 'sign-language(Translate,asl,deaf,hands)'),
            array('far fa-sign-language' => 'sign-language(Translate,asl,deaf,hands)'),
            array('fal fa-sign-language' => 'sign-language(Translate,asl,deaf,hands)'),
            array('fas fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('far fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('fal fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('fas fa-universal-access' => 'universal-access(accessibility,hearing,person,seeing,visual impairment)'),
            array('far fa-universal-access' => 'universal-access(accessibility,hearing,person,seeing,visual impairment)'),
            array('fal fa-universal-access' => 'universal-access(accessibility,hearing,person,seeing,visual impairment)'),
            array('fas fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('far fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fal fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
        ),
        'Alert' => array(
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('far fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fal fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fas fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('far fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fal fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fas fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('far fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fal fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fas fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('far fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fal fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fas fa-comment-alt-exclamation' => 'comment-alt-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('far fa-comment-alt-exclamation' => 'comment-alt-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fal fa-comment-alt-exclamation' => 'comment-alt-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fas fa-comment-exclamation' => 'comment-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('far fa-comment-exclamation' => 'comment-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fal fa-comment-exclamation' => 'comment-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fas fa-engine-warning' => 'engine-warning(alert,automobile,car,mechanic,warning)'),
            array('far fa-engine-warning' => 'engine-warning(alert,automobile,car,mechanic,warning)'),
            array('fal fa-engine-warning' => 'engine-warning(alert,automobile,car,mechanic,warning)'),
            array('fas fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('far fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('fal fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('fas fa-lightbulb-exclamation' => 'lightbulb-exclamation(alert,energy,idea,inspiration,light)'),
            array('far fa-lightbulb-exclamation' => 'lightbulb-exclamation(alert,energy,idea,inspiration,light)'),
            array('fal fa-lightbulb-exclamation' => 'lightbulb-exclamation(alert,energy,idea,inspiration,light)'),
            array('fas fa-map-marker-exclamation' => 'map-marker-exclamation(agree,alert,coordinates,destination,important,location,map,navigation,pin,place)'),
            array('far fa-map-marker-exclamation' => 'map-marker-exclamation(agree,alert,coordinates,destination,important,location,map,navigation,pin,place)'),
            array('fal fa-map-marker-exclamation' => 'map-marker-exclamation(agree,alert,coordinates,destination,important,location,map,navigation,pin,place)'),
            array('fas fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('far fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fal fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fas fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('far fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('fal fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('fas fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
            array('far fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
            array('fal fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
        ),
        'Animals' => array(
            array('fas fa-alicorn' => 'alicorn(animal,fantasy,fauna,horse,mammal,pegasus,unicorn,wing)'),
            array('far fa-alicorn' => 'alicorn(animal,fantasy,fauna,horse,mammal,pegasus,unicorn,wing)'),
            array('fal fa-alicorn' => 'alicorn(animal,fantasy,fauna,horse,mammal,pegasus,unicorn,wing)'),
            array('fas fa-badger-honey' => 'badger-honey(animal,care,dont,ewww,fauna,mammal,nasty)'),
            array('far fa-badger-honey' => 'badger-honey(animal,care,dont,ewww,fauna,mammal,nasty)'),
            array('fal fa-badger-honey' => 'badger-honey(animal,care,dont,ewww,fauna,mammal,nasty)'),
            array('fas fa-bat' => 'bat(animal,batman,bruce wayne,flying,gotham,halloween,mammal,vampire,wings)'),
            array('far fa-bat' => 'bat(animal,batman,bruce wayne,flying,gotham,halloween,mammal,vampire,wings)'),
            array('fal fa-bat' => 'bat(animal,batman,bruce wayne,flying,gotham,halloween,mammal,vampire,wings)'),
            array('fas fa-cat' => 'cat(feline,halloween,holiday,kitten,kitty,meow,pet)'),
            array('far fa-cat' => 'cat(feline,halloween,holiday,kitten,kitty,meow,pet)'),
            array('fal fa-cat' => 'cat(feline,halloween,holiday,kitten,kitty,meow,pet)'),
            array('fas fa-cow' => 'cow(agriculture,animal,beef,bovine,farm,fauna,mammal,milk,moo)'),
            array('far fa-cow' => 'cow(agriculture,animal,beef,bovine,farm,fauna,mammal,milk,moo)'),
            array('fal fa-cow' => 'cow(agriculture,animal,beef,bovine,farm,fauna,mammal,milk,moo)'),
            array('fas fa-crow' => 'crow(bird,bullfrog,fauna,halloween,holiday,toad)'),
            array('far fa-crow' => 'crow(bird,bullfrog,fauna,halloween,holiday,toad)'),
            array('fal fa-crow' => 'crow(bird,bullfrog,fauna,halloween,holiday,toad)'),
            array('fas fa-deer' => 'deer(animal,antlers,blitzen,comet,cupid,dancer,dasher,donner,fauna,mammal,prancer,reindeer,vixen)'),
            array('far fa-deer' => 'deer(animal,antlers,blitzen,comet,cupid,dancer,dasher,donner,fauna,mammal,prancer,reindeer,vixen)'),
            array('fal fa-deer' => 'deer(animal,antlers,blitzen,comet,cupid,dancer,dasher,donner,fauna,mammal,prancer,reindeer,vixen)'),
            array('fas fa-deer-rudolph' => 'deer-rudolph(animal,antlers,fauna,mammal,reindeer)'),
            array('far fa-deer-rudolph' => 'deer-rudolph(animal,antlers,fauna,mammal,reindeer)'),
            array('fal fa-deer-rudolph' => 'deer-rudolph(animal,antlers,fauna,mammal,reindeer)'),
            array('fas fa-dog' => 'dog(animal,canine,fauna,mammal,pet,pooch,puppy,woof)'),
            array('far fa-dog' => 'dog(animal,canine,fauna,mammal,pet,pooch,puppy,woof)'),
            array('fal fa-dog' => 'dog(animal,canine,fauna,mammal,pet,pooch,puppy,woof)'),
            array('fas fa-dog-leashed' => 'dog-leashed(animal,canine,fauna,mammal,pet,pooch,puppy,walk,woof)'),
            array('far fa-dog-leashed' => 'dog-leashed(animal,canine,fauna,mammal,pet,pooch,puppy,walk,woof)'),
            array('fal fa-dog-leashed' => 'dog-leashed(animal,canine,fauna,mammal,pet,pooch,puppy,walk,woof)'),
            array('fas fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('far fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fal fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fas fa-dragon' => 'dragon(Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)'),
            array('far fa-dragon' => 'dragon(Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)'),
            array('fal fa-dragon' => 'dragon(Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)'),
            array('fas fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('far fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('fal fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('fas fa-elephant' => 'elephant(animal,dumbo,fauna,mammal,pachyderm,trunk)'),
            array('far fa-elephant' => 'elephant(animal,dumbo,fauna,mammal,pachyderm,trunk)'),
            array('fal fa-elephant' => 'elephant(animal,dumbo,fauna,mammal,pachyderm,trunk)'),
            array('fas fa-feather' => 'feather(bird,light,plucked,quill,write)'),
            array('far fa-feather' => 'feather(bird,light,plucked,quill,write)'),
            array('fal fa-feather' => 'feather(bird,light,plucked,quill,write)'),
            array('fas fa-feather-alt' => 'feather-alt(bird,light,plucked,quill,write)'),
            array('far fa-feather-alt' => 'feather-alt(bird,light,plucked,quill,write)'),
            array('fal fa-feather-alt' => 'feather-alt(bird,light,plucked,quill,write)'),
            array('fas fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('far fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('fal fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('fas fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('far fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fal fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fas fa-hippo' => 'hippo(animal,fauna,hippopotamus,hungry,mammal)'),
            array('far fa-hippo' => 'hippo(animal,fauna,hippopotamus,hungry,mammal)'),
            array('fal fa-hippo' => 'hippo(animal,fauna,hippopotamus,hungry,mammal)'),
            array('fas fa-horse' => 'horse(equus,fauna,mammmal,mare,neigh,pony)'),
            array('far fa-horse' => 'horse(equus,fauna,mammmal,mare,neigh,pony)'),
            array('fal fa-horse' => 'horse(equus,fauna,mammmal,mare,neigh,pony)'),
            array('fas fa-horse-head' => 'horse-head(equus,fauna,mammmal,mare,neigh,pony)'),
            array('far fa-horse-head' => 'horse-head(equus,fauna,mammmal,mare,neigh,pony)'),
            array('fal fa-horse-head' => 'horse-head(equus,fauna,mammmal,mare,neigh,pony)'),
            array('fas fa-kiwi-bird' => 'kiwi-bird(bird,fauna,new zealand)'),
            array('far fa-kiwi-bird' => 'kiwi-bird(bird,fauna,new zealand)'),
            array('fal fa-kiwi-bird' => 'kiwi-bird(bird,fauna,new zealand)'),
            array('fas fa-monkey' => 'monkey(animal,banana,fauna,mammal,tail)'),
            array('far fa-monkey' => 'monkey(animal,banana,fauna,mammal,tail)'),
            array('fal fa-monkey' => 'monkey(animal,banana,fauna,mammal,tail)'),
            array('fas fa-narwhal' => 'narwhal(animal,fauna,holiday,ivory,mammal,tusk,unicorn,whale)'),
            array('far fa-narwhal' => 'narwhal(animal,fauna,holiday,ivory,mammal,tusk,unicorn,whale)'),
            array('fal fa-narwhal' => 'narwhal(animal,fauna,holiday,ivory,mammal,tusk,unicorn,whale)'),
            array('fas fa-otter' => 'otter(animal,badger,fauna,fur,mammal,marten)'),
            array('far fa-otter' => 'otter(animal,badger,fauna,fur,mammal,marten)'),
            array('fal fa-otter' => 'otter(animal,badger,fauna,fur,mammal,marten)'),
            array('fas fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('far fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('fal fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('fas fa-paw-alt' => 'paw-alt(animal,cat,dog,pet,print)'),
            array('far fa-paw-alt' => 'paw-alt(animal,cat,dog,pet,print)'),
            array('fal fa-paw-alt' => 'paw-alt(animal,cat,dog,pet,print)'),
            array('fas fa-paw-claws' => 'paw-claws(Dungeons & Dragons,animal,beast,d&d,dnd,fantasy,lion,pet,print)'),
            array('far fa-paw-claws' => 'paw-claws(Dungeons & Dragons,animal,beast,d&d,dnd,fantasy,lion,pet,print)'),
            array('fal fa-paw-claws' => 'paw-claws(Dungeons & Dragons,animal,beast,d&d,dnd,fantasy,lion,pet,print)'),
            array('fas fa-pegasus' => 'pegasus(fantasy,horse,unicorn,wings)'),
            array('far fa-pegasus' => 'pegasus(fantasy,horse,unicorn,wings)'),
            array('fal fa-pegasus' => 'pegasus(fantasy,horse,unicorn,wings)'),
            array('fas fa-pig' => 'pig(agriculture,animal,farm,fauna,mammal,oink)'),
            array('far fa-pig' => 'pig(agriculture,animal,farm,fauna,mammal,oink)'),
            array('fal fa-pig' => 'pig(agriculture,animal,farm,fauna,mammal,oink)'),
            array('fas fa-rabbit' => 'rabbit(animal,bunny,fast,fauna,hare,mammal,speed,wabbit)'),
            array('far fa-rabbit' => 'rabbit(animal,bunny,fast,fauna,hare,mammal,speed,wabbit)'),
            array('fal fa-rabbit' => 'rabbit(animal,bunny,fast,fauna,hare,mammal,speed,wabbit)'),
            array('fas fa-rabbit-fast' => 'rabbit-fast(animal,bunny,fast,fauna,hare,mammal,running,speed,wabbit)'),
            array('far fa-rabbit-fast' => 'rabbit-fast(animal,bunny,fast,fauna,hare,mammal,running,speed,wabbit)'),
            array('fal fa-rabbit-fast' => 'rabbit-fast(animal,bunny,fast,fauna,hare,mammal,running,speed,wabbit)'),
            array('fas fa-ram' => 'ram(animal,fauna,horns,mammal)'),
            array('far fa-ram' => 'ram(animal,fauna,horns,mammal)'),
            array('fal fa-ram' => 'ram(animal,fauna,horns,mammal)'),
            array('fas fa-sheep' => 'sheep(agriculture,animal,farming,fauna,mammal,wool,yarn)'),
            array('far fa-sheep' => 'sheep(agriculture,animal,farming,fauna,mammal,wool,yarn)'),
            array('fal fa-sheep' => 'sheep(agriculture,animal,farming,fauna,mammal,wool,yarn)'),
            array('fas fa-snake' => 'snake(cobra,fauna,reptile,slither)'),
            array('far fa-snake' => 'snake(cobra,fauna,reptile,slither)'),
            array('fal fa-snake' => 'snake(cobra,fauna,reptile,slither)'),
            array('fas fa-spider' => 'spider(arachnid,bug,charlotte,crawl,eight,halloween)'),
            array('far fa-spider' => 'spider(arachnid,bug,charlotte,crawl,eight,halloween)'),
            array('fal fa-spider' => 'spider(arachnid,bug,charlotte,crawl,eight,halloween)'),
            array('fas fa-spider-black-widow' => 'spider-black-widow(alert,arachnid,bug,charlotte,crawl,danger,dangerous,deadly,eight,error,halloween)'),
            array('far fa-spider-black-widow' => 'spider-black-widow(alert,arachnid,bug,charlotte,crawl,danger,dangerous,deadly,eight,error,halloween)'),
            array('fal fa-spider-black-widow' => 'spider-black-widow(alert,arachnid,bug,charlotte,crawl,danger,dangerous,deadly,eight,error,halloween)'),
            array('fas fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('far fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('fal fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('fas fa-turtle' => 'turtle(cowabunga,donatello,fauna,leonardo,michaelangelo,raphael,reptile,shell,slow)'),
            array('far fa-turtle' => 'turtle(cowabunga,donatello,fauna,leonardo,michaelangelo,raphael,reptile,shell,slow)'),
            array('fal fa-turtle' => 'turtle(cowabunga,donatello,fauna,leonardo,michaelangelo,raphael,reptile,shell,slow)'),
            array('fas fa-unicorn' => 'unicorn(fantasy,fauna,horn,horse)'),
            array('far fa-unicorn' => 'unicorn(fantasy,fauna,horn,horse)'),
            array('fal fa-unicorn' => 'unicorn(fantasy,fauna,horn,horse)'),
            array('fas fa-whale' => 'whale(fauna,mammal,swimming)'),
            array('far fa-whale' => 'whale(fauna,mammal,swimming)'),
            array('fal fa-whale' => 'whale(fauna,mammal,swimming)'),
        ),
        'Arrows' => array(
            array('fas fa-angle-double-down' => 'angle-double-down(arrows,caret,download,expand)'),
            array('far fa-angle-double-down' => 'angle-double-down(arrows,caret,download,expand)'),
            array('fal fa-angle-double-down' => 'angle-double-down(arrows,caret,download,expand)'),
            array('fas fa-angle-double-left' => 'angle-double-left(arrows,back,caret,laquo,previous,quote)'),
            array('far fa-angle-double-left' => 'angle-double-left(arrows,back,caret,laquo,previous,quote)'),
            array('fal fa-angle-double-left' => 'angle-double-left(arrows,back,caret,laquo,previous,quote)'),
            array('fas fa-angle-double-right' => 'angle-double-right(arrows,caret,forward,more,next,quote,raquo)'),
            array('far fa-angle-double-right' => 'angle-double-right(arrows,caret,forward,more,next,quote,raquo)'),
            array('fal fa-angle-double-right' => 'angle-double-right(arrows,caret,forward,more,next,quote,raquo)'),
            array('fas fa-angle-double-up' => 'angle-double-up(arrows,caret,collapse,upload)'),
            array('far fa-angle-double-up' => 'angle-double-up(arrows,caret,collapse,upload)'),
            array('fal fa-angle-double-up' => 'angle-double-up(arrows,caret,collapse,upload)'),
            array('fas fa-angle-down' => 'angle-down(arrow,caret,download,expand)'),
            array('far fa-angle-down' => 'angle-down(arrow,caret,download,expand)'),
            array('fal fa-angle-down' => 'angle-down(arrow,caret,download,expand)'),
            array('fas fa-angle-left' => 'angle-left(arrow,back,caret,less,previous)'),
            array('far fa-angle-left' => 'angle-left(arrow,back,caret,less,previous)'),
            array('fal fa-angle-left' => 'angle-left(arrow,back,caret,less,previous)'),
            array('fas fa-angle-right' => 'angle-right(arrow,care,forward,more,next)'),
            array('far fa-angle-right' => 'angle-right(arrow,care,forward,more,next)'),
            array('fal fa-angle-right' => 'angle-right(arrow,care,forward,more,next)'),
            array('fas fa-angle-up' => 'angle-up(arrow,caret,collapse,upload)'),
            array('far fa-angle-up' => 'angle-up(arrow,caret,collapse,upload)'),
            array('fal fa-angle-up' => 'angle-up(arrow,caret,collapse,upload)'),
            array('fas fa-arrow-alt-circle-down' => 'arrow-alt-circle-down(arrow-circle-o-down,download)'),
            array('far fa-arrow-alt-circle-down' => 'arrow-alt-circle-down(arrow-circle-o-down,download)'),
            array('fal fa-arrow-alt-circle-down' => 'arrow-alt-circle-down(arrow-circle-o-down,download)'),
            array('fas fa-arrow-alt-circle-left' => 'arrow-alt-circle-left(arrow-circle-o-left,back,previous)'),
            array('far fa-arrow-alt-circle-left' => 'arrow-alt-circle-left(arrow-circle-o-left,back,previous)'),
            array('fal fa-arrow-alt-circle-left' => 'arrow-alt-circle-left(arrow-circle-o-left,back,previous)'),
            array('fas fa-arrow-alt-circle-right' => 'arrow-alt-circle-right(arrow-circle-o-right,forward,next)'),
            array('far fa-arrow-alt-circle-right' => 'arrow-alt-circle-right(arrow-circle-o-right,forward,next)'),
            array('fal fa-arrow-alt-circle-right' => 'arrow-alt-circle-right(arrow-circle-o-right,forward,next)'),
            array('fas fa-arrow-alt-circle-up' => 'arrow-alt-circle-up(arrow-circle-o-up)'),
            array('far fa-arrow-alt-circle-up' => 'arrow-alt-circle-up(arrow-circle-o-up)'),
            array('fal fa-arrow-alt-circle-up' => 'arrow-alt-circle-up(arrow-circle-o-up)'),
            array('fas fa-arrow-alt-down' => 'arrow-alt-down(download)'),
            array('far fa-arrow-alt-down' => 'arrow-alt-down(download)'),
            array('fal fa-arrow-alt-down' => 'arrow-alt-down(download)'),
            array('fas fa-arrow-alt-from-bottom' => 'arrow-alt-from-bottom(download)'),
            array('far fa-arrow-alt-from-bottom' => 'arrow-alt-from-bottom(download)'),
            array('fal fa-arrow-alt-from-bottom' => 'arrow-alt-from-bottom(download)'),
            array('fas fa-arrow-alt-from-left' => 'arrow-alt-from-left(back,previous)'),
            array('far fa-arrow-alt-from-left' => 'arrow-alt-from-left(back,previous)'),
            array('fal fa-arrow-alt-from-left' => 'arrow-alt-from-left(back,previous)'),
            array('fas fa-arrow-alt-from-right' => 'arrow-alt-from-right(forward,next)'),
            array('far fa-arrow-alt-from-right' => 'arrow-alt-from-right(forward,next)'),
            array('fal fa-arrow-alt-from-right' => 'arrow-alt-from-right(forward,next)'),
            array('fas fa-arrow-alt-from-top' => 'arrow-alt-from-top(upload)'),
            array('far fa-arrow-alt-from-top' => 'arrow-alt-from-top(upload)'),
            array('fal fa-arrow-alt-from-top' => 'arrow-alt-from-top(upload)'),
            array('fas fa-arrow-alt-left' => 'arrow-alt-left(back,previous)'),
            array('far fa-arrow-alt-left' => 'arrow-alt-left(back,previous)'),
            array('fal fa-arrow-alt-left' => 'arrow-alt-left(back,previous)'),
            array('fas fa-arrow-alt-right' => 'arrow-alt-right(forward,next)'),
            array('far fa-arrow-alt-right' => 'arrow-alt-right(forward,next)'),
            array('fal fa-arrow-alt-right' => 'arrow-alt-right(forward,next)'),
            array('fas fa-arrow-alt-square-down' => 'arrow-alt-square-down(download)'),
            array('far fa-arrow-alt-square-down' => 'arrow-alt-square-down(download)'),
            array('fal fa-arrow-alt-square-down' => 'arrow-alt-square-down(download)'),
            array('fas fa-arrow-alt-square-left' => 'arrow-alt-square-left(back,previous)'),
            array('far fa-arrow-alt-square-left' => 'arrow-alt-square-left(back,previous)'),
            array('fal fa-arrow-alt-square-left' => 'arrow-alt-square-left(back,previous)'),
            array('fas fa-arrow-alt-square-right' => 'arrow-alt-square-right(forward,next)'),
            array('far fa-arrow-alt-square-right' => 'arrow-alt-square-right(forward,next)'),
            array('fal fa-arrow-alt-square-right' => 'arrow-alt-square-right(forward,next)'),
            array('fas fa-arrow-alt-square-up' => 'arrow-alt-square-up(upload)'),
            array('far fa-arrow-alt-square-up' => 'arrow-alt-square-up(upload)'),
            array('fal fa-arrow-alt-square-up' => 'arrow-alt-square-up(upload)'),
            array('fas fa-arrow-alt-to-bottom' => 'arrow-alt-to-bottom(download)'),
            array('far fa-arrow-alt-to-bottom' => 'arrow-alt-to-bottom(download)'),
            array('fal fa-arrow-alt-to-bottom' => 'arrow-alt-to-bottom(download)'),
            array('fas fa-arrow-alt-to-left' => 'arrow-alt-to-left(back,previous)'),
            array('far fa-arrow-alt-to-left' => 'arrow-alt-to-left(back,previous)'),
            array('fal fa-arrow-alt-to-left' => 'arrow-alt-to-left(back,previous)'),
            array('fas fa-arrow-alt-to-right' => 'arrow-alt-to-right(forward,next)'),
            array('far fa-arrow-alt-to-right' => 'arrow-alt-to-right(forward,next)'),
            array('fal fa-arrow-alt-to-right' => 'arrow-alt-to-right(forward,next)'),
            array('fas fa-arrow-alt-to-top' => 'arrow-alt-to-top(upload)'),
            array('far fa-arrow-alt-to-top' => 'arrow-alt-to-top(upload)'),
            array('fal fa-arrow-alt-to-top' => 'arrow-alt-to-top(upload)'),
            array('fas fa-arrow-alt-up' => 'arrow-alt-up(upload)'),
            array('far fa-arrow-alt-up' => 'arrow-alt-up(upload)'),
            array('fal fa-arrow-alt-up' => 'arrow-alt-up(upload)'),
            array('fas fa-arrow-circle-down' => 'arrow-circle-down(download)'),
            array('far fa-arrow-circle-down' => 'arrow-circle-down(download)'),
            array('fal fa-arrow-circle-down' => 'arrow-circle-down(download)'),
            array('fas fa-arrow-circle-left' => 'arrow-circle-left(back,previous)'),
            array('far fa-arrow-circle-left' => 'arrow-circle-left(back,previous)'),
            array('fal fa-arrow-circle-left' => 'arrow-circle-left(back,previous)'),
            array('fas fa-arrow-circle-right' => 'arrow-circle-right(forward,next)'),
            array('far fa-arrow-circle-right' => 'arrow-circle-right(forward,next)'),
            array('fal fa-arrow-circle-right' => 'arrow-circle-right(forward,next)'),
            array('fas fa-arrow-circle-up' => 'arrow-circle-up(upload)'),
            array('far fa-arrow-circle-up' => 'arrow-circle-up(upload)'),
            array('fal fa-arrow-circle-up' => 'arrow-circle-up(upload)'),
            array('fas fa-arrow-down' => 'arrow-down(download)'),
            array('far fa-arrow-down' => 'arrow-down(download)'),
            array('fal fa-arrow-down' => 'arrow-down(download)'),
            array('fas fa-arrow-from-bottom' => 'arrow-from-bottom(download)'),
            array('far fa-arrow-from-bottom' => 'arrow-from-bottom(download)'),
            array('fal fa-arrow-from-bottom' => 'arrow-from-bottom(download)'),
            array('fas fa-arrow-from-left' => 'arrow-from-left(back,previous)'),
            array('far fa-arrow-from-left' => 'arrow-from-left(back,previous)'),
            array('fal fa-arrow-from-left' => 'arrow-from-left(back,previous)'),
            array('fas fa-arrow-from-right' => 'arrow-from-right(forward,next)'),
            array('far fa-arrow-from-right' => 'arrow-from-right(forward,next)'),
            array('fal fa-arrow-from-right' => 'arrow-from-right(forward,next)'),
            array('fas fa-arrow-from-top' => 'arrow-from-top(upload)'),
            array('far fa-arrow-from-top' => 'arrow-from-top(upload)'),
            array('fal fa-arrow-from-top' => 'arrow-from-top(upload)'),
            array('fas fa-arrow-left' => 'arrow-left(back,previous)'),
            array('far fa-arrow-left' => 'arrow-left(back,previous)'),
            array('fal fa-arrow-left' => 'arrow-left(back,previous)'),
            array('fas fa-arrow-right' => 'arrow-right(forward,next)'),
            array('far fa-arrow-right' => 'arrow-right(forward,next)'),
            array('fal fa-arrow-right' => 'arrow-right(forward,next)'),
            array('fas fa-arrow-square-down' => 'arrow-square-down(download)'),
            array('far fa-arrow-square-down' => 'arrow-square-down(download)'),
            array('fal fa-arrow-square-down' => 'arrow-square-down(download)'),
            array('fas fa-arrow-square-left' => 'arrow-square-left(back,previous)'),
            array('far fa-arrow-square-left' => 'arrow-square-left(back,previous)'),
            array('fal fa-arrow-square-left' => 'arrow-square-left(back,previous)'),
            array('fas fa-arrow-square-right' => 'arrow-square-right(forward,next)'),
            array('far fa-arrow-square-right' => 'arrow-square-right(forward,next)'),
            array('fal fa-arrow-square-right' => 'arrow-square-right(forward,next)'),
            array('fas fa-arrow-square-up' => 'arrow-square-up(upload)'),
            array('far fa-arrow-square-up' => 'arrow-square-up(upload)'),
            array('fal fa-arrow-square-up' => 'arrow-square-up(upload)'),
            array('fas fa-arrow-to-bottom' => 'arrow-to-bottom(download)'),
            array('far fa-arrow-to-bottom' => 'arrow-to-bottom(download)'),
            array('fal fa-arrow-to-bottom' => 'arrow-to-bottom(download)'),
            array('fas fa-arrow-to-left' => 'arrow-to-left(back,previous)'),
            array('far fa-arrow-to-left' => 'arrow-to-left(back,previous)'),
            array('fal fa-arrow-to-left' => 'arrow-to-left(back,previous)'),
            array('fas fa-arrow-to-right' => 'arrow-to-right(forward,next)'),
            array('far fa-arrow-to-right' => 'arrow-to-right(forward,next)'),
            array('fal fa-arrow-to-right' => 'arrow-to-right(forward,next)'),
            array('fas fa-arrow-to-top' => 'arrow-to-top(upload)'),
            array('far fa-arrow-to-top' => 'arrow-to-top(upload)'),
            array('fal fa-arrow-to-top' => 'arrow-to-top(upload)'),
            array('fas fa-arrow-up' => 'arrow-up(forward,upload)'),
            array('far fa-arrow-up' => 'arrow-up(forward,upload)'),
            array('fal fa-arrow-up' => 'arrow-up(forward,upload)'),
            array('fas fa-arrows' => 'arrows(arrow,arrows,bigger,enlarge,expand,fullscreen,move,position,reorder,resize)'),
            array('far fa-arrows' => 'arrows(arrow,arrows,bigger,enlarge,expand,fullscreen,move,position,reorder,resize)'),
            array('fal fa-arrows' => 'arrows(arrow,arrows,bigger,enlarge,expand,fullscreen,move,position,reorder,resize)'),
            array('fas fa-arrows-alt' => 'arrows-alt(arrow,arrows,bigger,enlarge,expand,fullscreen,move,position,reorder,resize)'),
            array('far fa-arrows-alt' => 'arrows-alt(arrow,arrows,bigger,enlarge,expand,fullscreen,move,position,reorder,resize)'),
            array('fal fa-arrows-alt' => 'arrows-alt(arrow,arrows,bigger,enlarge,expand,fullscreen,move,position,reorder,resize)'),
            array('fas fa-arrows-alt-h' => 'arrows-alt-h(arrows-h,expand,horizontal,landscape,resize,wide)'),
            array('far fa-arrows-alt-h' => 'arrows-alt-h(arrows-h,expand,horizontal,landscape,resize,wide)'),
            array('fal fa-arrows-alt-h' => 'arrows-alt-h(arrows-h,expand,horizontal,landscape,resize,wide)'),
            array('fas fa-arrows-alt-v' => 'arrows-alt-v(arrows-v,expand,portrait,resize,tall,vertical)'),
            array('far fa-arrows-alt-v' => 'arrows-alt-v(arrows-v,expand,portrait,resize,tall,vertical)'),
            array('fal fa-arrows-alt-v' => 'arrows-alt-v(arrows-v,expand,portrait,resize,tall,vertical)'),
            array('fas fa-arrows-h' => 'arrows-h(expand,horizontal,landscape,resize,wide)'),
            array('far fa-arrows-h' => 'arrows-h(expand,horizontal,landscape,resize,wide)'),
            array('fal fa-arrows-h' => 'arrows-h(expand,horizontal,landscape,resize,wide)'),
            array('fas fa-arrows-v' => 'arrows-v(expand,portrait,resize,tall,vertical)'),
            array('far fa-arrows-v' => 'arrows-v(expand,portrait,resize,tall,vertical)'),
            array('fal fa-arrows-v' => 'arrows-v(expand,portrait,resize,tall,vertical)'),
            array('fas fa-caret-circle-down' => 'caret-circle-down(arrow,dropdown,expand,menu,more,triangle)'),
            array('far fa-caret-circle-down' => 'caret-circle-down(arrow,dropdown,expand,menu,more,triangle)'),
            array('fal fa-caret-circle-down' => 'caret-circle-down(arrow,dropdown,expand,menu,more,triangle)'),
            array('fas fa-caret-circle-left' => 'caret-circle-left(arrow,back,previous,triangle)'),
            array('far fa-caret-circle-left' => 'caret-circle-left(arrow,back,previous,triangle)'),
            array('fal fa-caret-circle-left' => 'caret-circle-left(arrow,back,previous,triangle)'),
            array('fas fa-caret-circle-right' => 'caret-circle-right(arrow,forward,next,triangle)'),
            array('far fa-caret-circle-right' => 'caret-circle-right(arrow,forward,next,triangle)'),
            array('fal fa-caret-circle-right' => 'caret-circle-right(arrow,forward,next,triangle)'),
            array('fas fa-caret-circle-up' => 'caret-circle-up(arrow,collapse,triangle,upload)'),
            array('far fa-caret-circle-up' => 'caret-circle-up(arrow,collapse,triangle,upload)'),
            array('fal fa-caret-circle-up' => 'caret-circle-up(arrow,collapse,triangle,upload)'),
            array('fas fa-caret-down' => 'caret-down(arrow,dropdown,expand,menu,more,triangle)'),
            array('far fa-caret-down' => 'caret-down(arrow,dropdown,expand,menu,more,triangle)'),
            array('fal fa-caret-down' => 'caret-down(arrow,dropdown,expand,menu,more,triangle)'),
            array('fas fa-caret-left' => 'caret-left(arrow,back,previous,triangle)'),
            array('far fa-caret-left' => 'caret-left(arrow,back,previous,triangle)'),
            array('fal fa-caret-left' => 'caret-left(arrow,back,previous,triangle)'),
            array('fas fa-caret-right' => 'caret-right(arrow,forward,next,triangle)'),
            array('far fa-caret-right' => 'caret-right(arrow,forward,next,triangle)'),
            array('fal fa-caret-right' => 'caret-right(arrow,forward,next,triangle)'),
            array('fas fa-caret-square-down' => 'caret-square-down(arrow,caret-square-o-down,dropdown,expand,menu,more,triangle)'),
            array('far fa-caret-square-down' => 'caret-square-down(arrow,caret-square-o-down,dropdown,expand,menu,more,triangle)'),
            array('fal fa-caret-square-down' => 'caret-square-down(arrow,caret-square-o-down,dropdown,expand,menu,more,triangle)'),
            array('fas fa-caret-square-left' => 'caret-square-left(arrow,back,caret-square-o-left,previous,triangle)'),
            array('far fa-caret-square-left' => 'caret-square-left(arrow,back,caret-square-o-left,previous,triangle)'),
            array('fal fa-caret-square-left' => 'caret-square-left(arrow,back,caret-square-o-left,previous,triangle)'),
            array('fas fa-caret-square-right' => 'caret-square-right(arrow,caret-square-o-right,forward,next,triangle)'),
            array('far fa-caret-square-right' => 'caret-square-right(arrow,caret-square-o-right,forward,next,triangle)'),
            array('fal fa-caret-square-right' => 'caret-square-right(arrow,caret-square-o-right,forward,next,triangle)'),
            array('fas fa-caret-square-up' => 'caret-square-up(arrow,caret-square-o-up,collapse,triangle,upload)'),
            array('far fa-caret-square-up' => 'caret-square-up(arrow,caret-square-o-up,collapse,triangle,upload)'),
            array('fal fa-caret-square-up' => 'caret-square-up(arrow,caret-square-o-up,collapse,triangle,upload)'),
            array('fas fa-caret-up' => 'caret-up(arrow,collapse,triangle)'),
            array('far fa-caret-up' => 'caret-up(arrow,collapse,triangle)'),
            array('fal fa-caret-up' => 'caret-up(arrow,collapse,triangle)'),
            array('fas fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('far fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fal fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fas fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('far fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('fal fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('fas fa-chevron-circle-down' => 'chevron-circle-down(arrow,download,dropdown,menu,more)'),
            array('far fa-chevron-circle-down' => 'chevron-circle-down(arrow,download,dropdown,menu,more)'),
            array('fal fa-chevron-circle-down' => 'chevron-circle-down(arrow,download,dropdown,menu,more)'),
            array('fas fa-chevron-circle-left' => 'chevron-circle-left(arrow,back,previous)'),
            array('far fa-chevron-circle-left' => 'chevron-circle-left(arrow,back,previous)'),
            array('fal fa-chevron-circle-left' => 'chevron-circle-left(arrow,back,previous)'),
            array('fas fa-chevron-circle-right' => 'chevron-circle-right(arrow,forward,next)'),
            array('far fa-chevron-circle-right' => 'chevron-circle-right(arrow,forward,next)'),
            array('fal fa-chevron-circle-right' => 'chevron-circle-right(arrow,forward,next)'),
            array('fas fa-chevron-circle-up' => 'chevron-circle-up(arrow,collapse,upload)'),
            array('far fa-chevron-circle-up' => 'chevron-circle-up(arrow,collapse,upload)'),
            array('fal fa-chevron-circle-up' => 'chevron-circle-up(arrow,collapse,upload)'),
            array('fas fa-chevron-double-down' => 'chevron-double-down(arrow,download,expand)'),
            array('far fa-chevron-double-down' => 'chevron-double-down(arrow,download,expand)'),
            array('fal fa-chevron-double-down' => 'chevron-double-down(arrow,download,expand)'),
            array('fas fa-chevron-double-left' => 'chevron-double-left(arrow,back,bracket,previous)'),
            array('far fa-chevron-double-left' => 'chevron-double-left(arrow,back,bracket,previous)'),
            array('fal fa-chevron-double-left' => 'chevron-double-left(arrow,back,bracket,previous)'),
            array('fas fa-chevron-double-right' => 'chevron-double-right(arrow,bracket,forward,next)'),
            array('far fa-chevron-double-right' => 'chevron-double-right(arrow,bracket,forward,next)'),
            array('fal fa-chevron-double-right' => 'chevron-double-right(arrow,bracket,forward,next)'),
            array('fas fa-chevron-double-up' => 'chevron-double-up(arrow,collapse,upload)'),
            array('far fa-chevron-double-up' => 'chevron-double-up(arrow,collapse,upload)'),
            array('fal fa-chevron-double-up' => 'chevron-double-up(arrow,collapse,upload)'),
            array('fas fa-chevron-down' => 'chevron-down(arrow,download,expand)'),
            array('far fa-chevron-down' => 'chevron-down(arrow,download,expand)'),
            array('fal fa-chevron-down' => 'chevron-down(arrow,download,expand)'),
            array('fas fa-chevron-left' => 'chevron-left(arrow,back,bracket,previous)'),
            array('far fa-chevron-left' => 'chevron-left(arrow,back,bracket,previous)'),
            array('fal fa-chevron-left' => 'chevron-left(arrow,back,bracket,previous)'),
            array('fas fa-chevron-right' => 'chevron-right(arrow,bracket,forward,next)'),
            array('far fa-chevron-right' => 'chevron-right(arrow,bracket,forward,next)'),
            array('fal fa-chevron-right' => 'chevron-right(arrow,bracket,forward,next)'),
            array('fas fa-chevron-square-down' => 'chevron-square-down(arrow,download,dropdown,expand,menu,more)'),
            array('far fa-chevron-square-down' => 'chevron-square-down(arrow,download,dropdown,expand,menu,more)'),
            array('fal fa-chevron-square-down' => 'chevron-square-down(arrow,download,dropdown,expand,menu,more)'),
            array('fas fa-chevron-square-left' => 'chevron-square-left(arrow,back,previous)'),
            array('far fa-chevron-square-left' => 'chevron-square-left(arrow,back,previous)'),
            array('fal fa-chevron-square-left' => 'chevron-square-left(arrow,back,previous)'),
            array('fas fa-chevron-square-right' => 'chevron-square-right(arrow,forward,next)'),
            array('far fa-chevron-square-right' => 'chevron-square-right(arrow,forward,next)'),
            array('fal fa-chevron-square-right' => 'chevron-square-right(arrow,forward,next)'),
            array('fas fa-chevron-square-up' => 'chevron-square-up(arrow,collapse,upload)'),
            array('far fa-chevron-square-up' => 'chevron-square-up(arrow,collapse,upload)'),
            array('fal fa-chevron-square-up' => 'chevron-square-up(arrow,collapse,upload)'),
            array('fas fa-chevron-up' => 'chevron-up(arrow,collapse,upload)'),
            array('far fa-chevron-up' => 'chevron-up(arrow,collapse,upload)'),
            array('fal fa-chevron-up' => 'chevron-up(arrow,collapse,upload)'),
            array('fas fa-cloud-download' => 'cloud-download(download,export,save)'),
            array('far fa-cloud-download' => 'cloud-download(download,export,save)'),
            array('fal fa-cloud-download' => 'cloud-download(download,export,save)'),
            array('fas fa-cloud-download-alt' => 'cloud-download-alt(download,export,save)'),
            array('far fa-cloud-download-alt' => 'cloud-download-alt(download,export,save)'),
            array('fal fa-cloud-download-alt' => 'cloud-download-alt(download,export,save)'),
            array('fas fa-cloud-upload' => 'cloud-upload(import,save,upload)'),
            array('far fa-cloud-upload' => 'cloud-upload(import,save,upload)'),
            array('fal fa-cloud-upload' => 'cloud-upload(import,save,upload)'),
            array('fas fa-cloud-upload-alt' => 'cloud-upload-alt(cloud-upload,import,save,upload)'),
            array('far fa-cloud-upload-alt' => 'cloud-upload-alt(cloud-upload,import,save,upload)'),
            array('fal fa-cloud-upload-alt' => 'cloud-upload-alt(cloud-upload,import,save,upload)'),
            array('fas fa-compress-alt' => 'compress-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress-alt' => 'compress-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress-alt' => 'compress-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-download' => 'download(export,hard drive,save,transfer)'),
            array('far fa-download' => 'download(export,hard drive,save,transfer)'),
            array('fal fa-download' => 'download(export,hard drive,save,transfer)'),
            array('fas fa-exchange' => 'exchange(arrow,arrows,reciprocate,return,swap,transfer)'),
            array('far fa-exchange' => 'exchange(arrow,arrows,reciprocate,return,swap,transfer)'),
            array('fal fa-exchange' => 'exchange(arrow,arrows,reciprocate,return,swap,transfer)'),
            array('fas fa-exchange-alt' => 'exchange-alt(arrow,arrows,exchange,reciprocate,return,swap,transfer)'),
            array('far fa-exchange-alt' => 'exchange-alt(arrow,arrows,exchange,reciprocate,return,swap,transfer)'),
            array('fal fa-exchange-alt' => 'exchange-alt(arrow,arrows,exchange,reciprocate,return,swap,transfer)'),
            array('fas fa-expand-alt' => 'expand-alt(arrow,bigger,enlarge,resize)'),
            array('far fa-expand-alt' => 'expand-alt(arrow,bigger,enlarge,resize)'),
            array('fal fa-expand-alt' => 'expand-alt(arrow,bigger,enlarge,resize)'),
            array('fas fa-expand-arrows' => 'expand-arrows(bigger,enlarge,move,resize)'),
            array('far fa-expand-arrows' => 'expand-arrows(bigger,enlarge,move,resize)'),
            array('fal fa-expand-arrows' => 'expand-arrows(bigger,enlarge,move,resize)'),
            array('fas fa-expand-arrows-alt' => 'expand-arrows-alt(arrows-alt,bigger,enlarge,move,resize)'),
            array('far fa-expand-arrows-alt' => 'expand-arrows-alt(arrows-alt,bigger,enlarge,move,resize)'),
            array('fal fa-expand-arrows-alt' => 'expand-arrows-alt(arrows-alt,bigger,enlarge,move,resize)'),
            array('fas fa-external-link' => 'external-link(new,open,send,share)'),
            array('far fa-external-link' => 'external-link(new,open,send,share)'),
            array('fal fa-external-link' => 'external-link(new,open,send,share)'),
            array('fas fa-external-link-alt' => 'external-link-alt(external-link,new,open,share)'),
            array('far fa-external-link-alt' => 'external-link-alt(external-link,new,open,share)'),
            array('fal fa-external-link-alt' => 'external-link-alt(external-link,new,open,share)'),
            array('fas fa-external-link-square' => 'external-link-square(new,open,send,share)'),
            array('far fa-external-link-square' => 'external-link-square(new,open,send,share)'),
            array('fal fa-external-link-square' => 'external-link-square(new,open,send,share)'),
            array('fas fa-external-link-square-alt' => 'external-link-square-alt(external-link-square,new,open,share)'),
            array('far fa-external-link-square-alt' => 'external-link-square-alt(external-link-square,new,open,share)'),
            array('fal fa-external-link-square-alt' => 'external-link-square-alt(external-link-square,new,open,share)'),
            array('fas fa-hand-point-down' => 'hand-point-down(finger,hand-o-down,point)'),
            array('far fa-hand-point-down' => 'hand-point-down(finger,hand-o-down,point)'),
            array('fal fa-hand-point-down' => 'hand-point-down(finger,hand-o-down,point)'),
            array('fas fa-hand-point-left' => 'hand-point-left(back,finger,hand-o-left,left,point,previous)'),
            array('far fa-hand-point-left' => 'hand-point-left(back,finger,hand-o-left,left,point,previous)'),
            array('fal fa-hand-point-left' => 'hand-point-left(back,finger,hand-o-left,left,point,previous)'),
            array('fas fa-hand-point-right' => 'hand-point-right(finger,forward,hand-o-right,next,point,right)'),
            array('far fa-hand-point-right' => 'hand-point-right(finger,forward,hand-o-right,next,point,right)'),
            array('fal fa-hand-point-right' => 'hand-point-right(finger,forward,hand-o-right,next,point,right)'),
            array('fas fa-hand-point-up' => 'hand-point-up(finger,hand-o-up,point)'),
            array('far fa-hand-point-up' => 'hand-point-up(finger,hand-o-up,point)'),
            array('fal fa-hand-point-up' => 'hand-point-up(finger,hand-o-up,point)'),
            array('fas fa-hand-pointer' => 'hand-pointer(arrow,cursor,select)'),
            array('far fa-hand-pointer' => 'hand-pointer(arrow,cursor,select)'),
            array('fal fa-hand-pointer' => 'hand-pointer(arrow,cursor,select)'),
            array('fas fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('far fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('fal fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('fas fa-inbox-in' => 'inbox-in(archive,desk,email,mail,message)'),
            array('far fa-inbox-in' => 'inbox-in(archive,desk,email,mail,message)'),
            array('fal fa-inbox-in' => 'inbox-in(archive,desk,email,mail,message)'),
            array('fas fa-inbox-out' => 'inbox-out(archive,desk,email,mail,message)'),
            array('far fa-inbox-out' => 'inbox-out(archive,desk,email,mail,message)'),
            array('fal fa-inbox-out' => 'inbox-out(archive,desk,email,mail,message)'),
            array('fas fa-level-down' => 'level-down(arrow)'),
            array('far fa-level-down' => 'level-down(arrow)'),
            array('fal fa-level-down' => 'level-down(arrow)'),
            array('fas fa-level-down-alt' => 'level-down-alt(arrow,level-down)'),
            array('far fa-level-down-alt' => 'level-down-alt(arrow,level-down)'),
            array('fal fa-level-down-alt' => 'level-down-alt(arrow,level-down)'),
            array('fas fa-level-up' => 'level-up(arrow)'),
            array('far fa-level-up' => 'level-up(arrow)'),
            array('fal fa-level-up' => 'level-up(arrow)'),
            array('fas fa-level-up-alt' => 'level-up-alt(arrow,level-up)'),
            array('far fa-level-up-alt' => 'level-up-alt(arrow,level-up)'),
            array('fal fa-level-up-alt' => 'level-up-alt(arrow,level-up)'),
            array('fas fa-location-arrow' => 'location-arrow(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('far fa-location-arrow' => 'location-arrow(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('fal fa-location-arrow' => 'location-arrow(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('fas fa-long-arrow-alt-down' => 'long-arrow-alt-down(download,long-arrow-down)'),
            array('far fa-long-arrow-alt-down' => 'long-arrow-alt-down(download,long-arrow-down)'),
            array('fal fa-long-arrow-alt-down' => 'long-arrow-alt-down(download,long-arrow-down)'),
            array('fas fa-long-arrow-alt-left' => 'long-arrow-alt-left(back,long-arrow-left,previous)'),
            array('far fa-long-arrow-alt-left' => 'long-arrow-alt-left(back,long-arrow-left,previous)'),
            array('fal fa-long-arrow-alt-left' => 'long-arrow-alt-left(back,long-arrow-left,previous)'),
            array('fas fa-long-arrow-alt-right' => 'long-arrow-alt-right(forward,long-arrow-right,next)'),
            array('far fa-long-arrow-alt-right' => 'long-arrow-alt-right(forward,long-arrow-right,next)'),
            array('fal fa-long-arrow-alt-right' => 'long-arrow-alt-right(forward,long-arrow-right,next)'),
            array('fas fa-long-arrow-alt-up' => 'long-arrow-alt-up(long-arrow-up,upload)'),
            array('far fa-long-arrow-alt-up' => 'long-arrow-alt-up(long-arrow-up,upload)'),
            array('fal fa-long-arrow-alt-up' => 'long-arrow-alt-up(long-arrow-up,upload)'),
            array('fas fa-long-arrow-down' => 'long-arrow-down(download,long-arrow-down)'),
            array('far fa-long-arrow-down' => 'long-arrow-down(download,long-arrow-down)'),
            array('fal fa-long-arrow-down' => 'long-arrow-down(download,long-arrow-down)'),
            array('fas fa-long-arrow-left' => 'long-arrow-left(back,long-arrow-left,previous)'),
            array('far fa-long-arrow-left' => 'long-arrow-left(back,long-arrow-left,previous)'),
            array('fal fa-long-arrow-left' => 'long-arrow-left(back,long-arrow-left,previous)'),
            array('fas fa-long-arrow-right' => 'long-arrow-right(forward,long-arrow-right,next)'),
            array('far fa-long-arrow-right' => 'long-arrow-right(forward,long-arrow-right,next)'),
            array('fal fa-long-arrow-right' => 'long-arrow-right(forward,long-arrow-right,next)'),
            array('fas fa-long-arrow-up' => 'long-arrow-up(long-arrow-up,upload)'),
            array('far fa-long-arrow-up' => 'long-arrow-up(long-arrow-up,upload)'),
            array('fal fa-long-arrow-up' => 'long-arrow-up(long-arrow-up,upload)'),
            array('fas fa-mouse-pointer' => 'mouse-pointer(arrow,cursor,select)'),
            array('far fa-mouse-pointer' => 'mouse-pointer(arrow,cursor,select)'),
            array('fal fa-mouse-pointer' => 'mouse-pointer(arrow,cursor,select)'),
            array('fas fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('far fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fal fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fas fa-random' => 'random(arrows,shuffle,sort,swap,switch,transfer)'),
            array('far fa-random' => 'random(arrows,shuffle,sort,swap,switch,transfer)'),
            array('fal fa-random' => 'random(arrows,shuffle,sort,swap,switch,transfer)'),
            array('fas fa-recycle' => 'recycle(Waste,compost,garbage,reuse,trash)'),
            array('far fa-recycle' => 'recycle(Waste,compost,garbage,reuse,trash)'),
            array('fal fa-recycle' => 'recycle(Waste,compost,garbage,reuse,trash)'),
            array('fas fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('far fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fal fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fas fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('far fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fal fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fas fa-repeat' => 'repeat(flip,reload,rewind,switch)'),
            array('far fa-repeat' => 'repeat(flip,reload,rewind,switch)'),
            array('fal fa-repeat' => 'repeat(flip,reload,rewind,switch)'),
            array('fas fa-repeat-1' => 'repeat-1(flip,reload,rewind,switch)'),
            array('far fa-repeat-1' => 'repeat-1(flip,reload,rewind,switch)'),
            array('fal fa-repeat-1' => 'repeat-1(flip,reload,rewind,switch)'),
            array('fas fa-repeat-1-alt' => 'repeat-1-alt(flip,reload,rewind,switch)'),
            array('far fa-repeat-1-alt' => 'repeat-1-alt(flip,reload,rewind,switch)'),
            array('fal fa-repeat-1-alt' => 'repeat-1-alt(flip,reload,rewind,switch)'),
            array('fas fa-repeat-alt' => 'repeat-alt(flip,reload,rewind,switch)'),
            array('far fa-repeat-alt' => 'repeat-alt(flip,reload,rewind,switch)'),
            array('fal fa-repeat-alt' => 'repeat-alt(flip,reload,rewind,switch)'),
            array('fas fa-reply' => 'reply(mail,message,respond)'),
            array('far fa-reply' => 'reply(mail,message,respond)'),
            array('fal fa-reply' => 'reply(mail,message,respond)'),
            array('fas fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('far fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('fal fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('fas fa-retweet' => 'retweet(refresh,reload,share,swap)'),
            array('far fa-retweet' => 'retweet(refresh,reload,share,swap)'),
            array('fal fa-retweet' => 'retweet(refresh,reload,share,swap)'),
            array('fas fa-retweet-alt' => 'retweet-alt(refresh,reload,share,swap)'),
            array('far fa-retweet-alt' => 'retweet-alt(refresh,reload,share,swap)'),
            array('fal fa-retweet-alt' => 'retweet-alt(refresh,reload,share,swap)'),
            array('fas fa-share' => 'share(forward,save,send,social)'),
            array('far fa-share' => 'share(forward,save,send,social)'),
            array('fal fa-share' => 'share(forward,save,send,social)'),
            array('fas fa-share-all' => 'share-all(forward,save,send,social)'),
            array('far fa-share-all' => 'share-all(forward,save,send,social)'),
            array('fal fa-share-all' => 'share-all(forward,save,send,social)'),
            array('fas fa-share-square' => 'share-square(forward,save,send,social)'),
            array('far fa-share-square' => 'share-square(forward,save,send,social)'),
            array('fal fa-share-square' => 'share-square(forward,save,send,social)'),
            array('fas fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('far fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fal fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fas fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('far fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fal fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fas fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('far fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('fal fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('fas fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('far fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('fal fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('fas fa-sort' => 'sort(filter,order)'),
            array('far fa-sort' => 'sort(filter,order)'),
            array('fal fa-sort' => 'sort(filter,order)'),
            array('fas fa-sort-alpha-down' => 'sort-alpha-down(filter,order,sort-alpha-asc)'),
            array('far fa-sort-alpha-down' => 'sort-alpha-down(filter,order,sort-alpha-asc)'),
            array('fal fa-sort-alpha-down' => 'sort-alpha-down(filter,order,sort-alpha-asc)'),
            array('fas fa-sort-alpha-up' => 'sort-alpha-up(filter,order,sort-alpha-desc)'),
            array('far fa-sort-alpha-up' => 'sort-alpha-up(filter,order,sort-alpha-desc)'),
            array('fal fa-sort-alpha-up' => 'sort-alpha-up(filter,order,sort-alpha-desc)'),
            array('fas fa-sort-amount-down' => 'sort-amount-down(filter,order,sort-amount-asc)'),
            array('far fa-sort-amount-down' => 'sort-amount-down(filter,order,sort-amount-asc)'),
            array('fal fa-sort-amount-down' => 'sort-amount-down(filter,order,sort-amount-asc)'),
            array('fas fa-sort-amount-up' => 'sort-amount-up(filter,order,sort-amount-desc)'),
            array('far fa-sort-amount-up' => 'sort-amount-up(filter,order,sort-amount-desc)'),
            array('fal fa-sort-amount-up' => 'sort-amount-up(filter,order,sort-amount-desc)'),
            array('fas fa-sort-down' => 'sort-down(arrow,descending,filter,order,sort-desc)'),
            array('far fa-sort-down' => 'sort-down(arrow,descending,filter,order,sort-desc)'),
            array('fal fa-sort-down' => 'sort-down(arrow,descending,filter,order,sort-desc)'),
            array('fas fa-sort-numeric-down' => 'sort-numeric-down(filter,numbers,order,sort-numeric-asc)'),
            array('far fa-sort-numeric-down' => 'sort-numeric-down(filter,numbers,order,sort-numeric-asc)'),
            array('fal fa-sort-numeric-down' => 'sort-numeric-down(filter,numbers,order,sort-numeric-asc)'),
            array('fas fa-sort-numeric-up' => 'sort-numeric-up(filter,numbers,order,sort-numeric-desc)'),
            array('far fa-sort-numeric-up' => 'sort-numeric-up(filter,numbers,order,sort-numeric-desc)'),
            array('fal fa-sort-numeric-up' => 'sort-numeric-up(filter,numbers,order,sort-numeric-desc)'),
            array('fas fa-sort-up' => 'sort-up(arrow,ascending,filter,order,sort-asc)'),
            array('far fa-sort-up' => 'sort-up(arrow,ascending,filter,order,sort-asc)'),
            array('fal fa-sort-up' => 'sort-up(arrow,ascending,filter,order,sort-asc)'),
            array('fas fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-text-height' => 'text-height(edit,font,format,text,type)'),
            array('far fa-text-height' => 'text-height(edit,font,format,text,type)'),
            array('fal fa-text-height' => 'text-height(edit,font,format,text,type)'),
            array('fas fa-text-width' => 'text-width(edit,font,format,text,type)'),
            array('far fa-text-width' => 'text-width(edit,font,format,text,type)'),
            array('fal fa-text-width' => 'text-width(edit,font,format,text,type)'),
            array('fas fa-triangle' => 'triangle(pyramid,shape)'),
            array('far fa-triangle' => 'triangle(pyramid,shape)'),
            array('fal fa-triangle' => 'triangle(pyramid,shape)'),
            array('fas fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('far fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fal fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fas fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('far fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fal fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fas fa-upload' => 'upload(hard drive,import,publish)'),
            array('far fa-upload' => 'upload(hard drive,import,publish)'),
            array('fal fa-upload' => 'upload(hard drive,import,publish)'),
        ),
        'Audio & Video' => array(
            array('fas fa-audio-description' => 'audio-description(blind,narration,video,visual)'),
            array('far fa-audio-description' => 'audio-description(blind,narration,video,visual)'),
            array('fal fa-audio-description' => 'audio-description(blind,narration,video,visual)'),
            array('fas fa-backward' => 'backward(previous,rewind)'),
            array('far fa-backward' => 'backward(previous,rewind)'),
            array('fal fa-backward' => 'backward(previous,rewind)'),
            array('fas fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('far fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fal fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fas fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('far fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fal fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fas fa-closed-captioning' => 'closed-captioning(cc,deaf,hearing,subtitle,subtitling,text,video)'),
            array('far fa-closed-captioning' => 'closed-captioning(cc,deaf,hearing,subtitle,subtitling,text,video)'),
            array('fal fa-closed-captioning' => 'closed-captioning(cc,deaf,hearing,subtitle,subtitling,text,video)'),
            array('fas fa-compress' => 'compress(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress' => 'compress(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress' => 'compress(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-compress-alt' => 'compress-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress-alt' => 'compress-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress-alt' => 'compress-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-compress-wide' => 'compress-wide(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress-wide' => 'compress-wide(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress-wide' => 'compress-wide(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-eject' => 'eject(abort,cancel,cd,discharge)'),
            array('far fa-eject' => 'eject(abort,cancel,cd,discharge)'),
            array('fal fa-eject' => 'eject(abort,cancel,cd,discharge)'),
            array('fas fa-expand' => 'expand(arrow,bigger,enlarge,resize)'),
            array('far fa-expand' => 'expand(arrow,bigger,enlarge,resize)'),
            array('fal fa-expand' => 'expand(arrow,bigger,enlarge,resize)'),
            array('fas fa-expand-alt' => 'expand-alt(arrow,bigger,enlarge,resize)'),
            array('far fa-expand-alt' => 'expand-alt(arrow,bigger,enlarge,resize)'),
            array('fal fa-expand-alt' => 'expand-alt(arrow,bigger,enlarge,resize)'),
            array('fas fa-expand-arrows' => 'expand-arrows(bigger,enlarge,move,resize)'),
            array('far fa-expand-arrows' => 'expand-arrows(bigger,enlarge,move,resize)'),
            array('fal fa-expand-arrows' => 'expand-arrows(bigger,enlarge,move,resize)'),
            array('fas fa-expand-arrows-alt' => 'expand-arrows-alt(arrows-alt,bigger,enlarge,move,resize)'),
            array('far fa-expand-arrows-alt' => 'expand-arrows-alt(arrows-alt,bigger,enlarge,move,resize)'),
            array('fal fa-expand-arrows-alt' => 'expand-arrows-alt(arrows-alt,bigger,enlarge,move,resize)'),
            array('fas fa-expand-wide' => 'expand-wide(bigger,enlarge,resize)'),
            array('far fa-expand-wide' => 'expand-wide(bigger,enlarge,resize)'),
            array('fal fa-expand-wide' => 'expand-wide(bigger,enlarge,resize)'),
            array('fas fa-fast-backward' => 'fast-backward(beginning,first,previous,rewind,start)'),
            array('far fa-fast-backward' => 'fast-backward(beginning,first,previous,rewind,start)'),
            array('fal fa-fast-backward' => 'fast-backward(beginning,first,previous,rewind,start)'),
            array('fas fa-fast-forward' => 'fast-forward(end,last,next)'),
            array('far fa-fast-forward' => 'fast-forward(end,last,next)'),
            array('fal fa-fast-forward' => 'fast-forward(end,last,next)'),
            array('fas fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('far fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('fal fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('fas fa-file-video' => 'file-video(document,m4v,movie,mp4,play)'),
            array('far fa-file-video' => 'file-video(document,m4v,movie,mp4,play)'),
            array('fal fa-file-video' => 'file-video(document,m4v,movie,mp4,play)'),
            array('fas fa-film' => 'film(cinema,movie,strip,video)'),
            array('far fa-film' => 'film(cinema,movie,strip,video)'),
            array('fal fa-film' => 'film(cinema,movie,strip,video)'),
            array('fas fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('far fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('fal fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('fas fa-forward' => 'forward(forward,next,skip)'),
            array('far fa-forward' => 'forward(forward,next,skip)'),
            array('fal fa-forward' => 'forward(forward,next,skip)'),
            array('fas fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('far fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fal fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fas fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fas fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('far fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fal fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fas fa-pause' => 'pause(hold,wait)'),
            array('far fa-pause' => 'pause(hold,wait)'),
            array('fal fa-pause' => 'pause(hold,wait)'),
            array('fas fa-pause-circle' => 'pause-circle(hold,wait)'),
            array('far fa-pause-circle' => 'pause-circle(hold,wait)'),
            array('fal fa-pause-circle' => 'pause-circle(hold,wait)'),
            array('fas fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('far fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fal fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fas fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('far fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fal fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fas fa-play-circle' => 'play-circle(audio,music,playing,sound,start,video)'),
            array('far fa-play-circle' => 'play-circle(audio,music,playing,sound,start,video)'),
            array('fal fa-play-circle' => 'play-circle(audio,music,playing,sound,start,video)'),
            array('fas fa-podcast' => 'podcast(audio,broadcast,music,sound)'),
            array('far fa-podcast' => 'podcast(audio,broadcast,music,sound)'),
            array('fal fa-podcast' => 'podcast(audio,broadcast,music,sound)'),
            array('fas fa-random' => 'random(arrows,shuffle,sort,swap,switch,transfer)'),
            array('far fa-random' => 'random(arrows,shuffle,sort,swap,switch,transfer)'),
            array('fal fa-random' => 'random(arrows,shuffle,sort,swap,switch,transfer)'),
            array('fas fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('far fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('fal fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('fas fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('far fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('fal fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('fas fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('far fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('fal fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('fas fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('far fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fal fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fas fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('far fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fal fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fas fa-repeat' => 'repeat(flip,reload,rewind,switch)'),
            array('far fa-repeat' => 'repeat(flip,reload,rewind,switch)'),
            array('fal fa-repeat' => 'repeat(flip,reload,rewind,switch)'),
            array('fas fa-repeat-1' => 'repeat-1(flip,reload,rewind,switch)'),
            array('far fa-repeat-1' => 'repeat-1(flip,reload,rewind,switch)'),
            array('fal fa-repeat-1' => 'repeat-1(flip,reload,rewind,switch)'),
            array('fas fa-repeat-1-alt' => 'repeat-1-alt(flip,reload,rewind,switch)'),
            array('far fa-repeat-1-alt' => 'repeat-1-alt(flip,reload,rewind,switch)'),
            array('fal fa-repeat-1-alt' => 'repeat-1-alt(flip,reload,rewind,switch)'),
            array('fas fa-repeat-alt' => 'repeat-alt(flip,reload,rewind,switch)'),
            array('far fa-repeat-alt' => 'repeat-alt(flip,reload,rewind,switch)'),
            array('fal fa-repeat-alt' => 'repeat-alt(flip,reload,rewind,switch)'),
            array('fas fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('far fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('fal fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('fas fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('far fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('fal fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('fas fa-scrubber' => 'scrubber(circle,dot,toggle)'),
            array('far fa-scrubber' => 'scrubber(circle,dot,toggle)'),
            array('fal fa-scrubber' => 'scrubber(circle,dot,toggle)'),
            array('fas fa-step-backward' => 'step-backward(beginning,first,previous,rewind,start)'),
            array('far fa-step-backward' => 'step-backward(beginning,first,previous,rewind,start)'),
            array('fal fa-step-backward' => 'step-backward(beginning,first,previous,rewind,start)'),
            array('fas fa-step-forward' => 'step-forward(end,last,next)'),
            array('far fa-step-forward' => 'step-forward(end,last,next)'),
            array('fal fa-step-forward' => 'step-forward(end,last,next)'),
            array('fas fa-stop' => 'stop(block,box,square)'),
            array('far fa-stop' => 'stop(block,box,square)'),
            array('fal fa-stop' => 'stop(block,box,square)'),
            array('fas fa-stop-circle' => 'stop-circle(block,box,circle,square)'),
            array('far fa-stop-circle' => 'stop-circle(block,box,circle,square)'),
            array('fal fa-stop-circle' => 'stop-circle(block,box,circle,square)'),
            array('fas fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('far fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fal fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fas fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('far fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fal fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fas fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('far fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('fal fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('fas fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('far fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fal fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fas fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('far fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fal fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fas fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('far fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fal fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fas fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('far fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fal fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fas fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('far fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fal fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fas fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('far fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fal fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fab fa-youtube' => 'youtube(film,video,youtube-play,youtube-square)'),
        ),
        'Automotive' => array(
            array('fas fa-air-freshener' => 'air-freshener(car,deodorize,fresh,pine,scent)'),
            array('far fa-air-freshener' => 'air-freshener(car,deodorize,fresh,pine,scent)'),
            array('fal fa-air-freshener' => 'air-freshener(car,deodorize,fresh,pine,scent)'),
            array('fas fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('far fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fal fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fas fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('far fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fal fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fas fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('far fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('fal fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('fas fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-car-alt' => 'car-alt(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car-alt' => 'car-alt(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car-alt' => 'car-alt(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-car-battery' => 'car-battery(auto,electric,mechanic,power)'),
            array('far fa-car-battery' => 'car-battery(auto,electric,mechanic,power)'),
            array('fal fa-car-battery' => 'car-battery(auto,electric,mechanic,power)'),
            array('fas fa-car-bump' => 'car-bump(auto,automobile,off-road,sedan,transportation,vehicle)'),
            array('far fa-car-bump' => 'car-bump(auto,automobile,off-road,sedan,transportation,vehicle)'),
            array('fal fa-car-bump' => 'car-bump(auto,automobile,off-road,sedan,transportation,vehicle)'),
            array('fas fa-car-crash' => 'car-crash(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('far fa-car-crash' => 'car-crash(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fal fa-car-crash' => 'car-crash(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fas fa-car-garage' => 'car-garage(auto,automobile,mechanic,sedan,transportation,vehicle)'),
            array('far fa-car-garage' => 'car-garage(auto,automobile,mechanic,sedan,transportation,vehicle)'),
            array('fal fa-car-garage' => 'car-garage(auto,automobile,mechanic,sedan,transportation,vehicle)'),
            array('fas fa-car-mechanic' => 'car-mechanic(auto,automobile,mechanic,repair,sedan,transportation,vehicle)'),
            array('far fa-car-mechanic' => 'car-mechanic(auto,automobile,mechanic,repair,sedan,transportation,vehicle)'),
            array('fal fa-car-mechanic' => 'car-mechanic(auto,automobile,mechanic,repair,sedan,transportation,vehicle)'),
            array('fas fa-car-side' => 'car-side(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car-side' => 'car-side(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car-side' => 'car-side(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-car-tilt' => 'car-tilt(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('far fa-car-tilt' => 'car-tilt(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fal fa-car-tilt' => 'car-tilt(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fas fa-car-wash' => 'car-wash(auto,automobile,clean,sedan,transportation,vehicle)'),
            array('far fa-car-wash' => 'car-wash(auto,automobile,clean,sedan,transportation,vehicle)'),
            array('fal fa-car-wash' => 'car-wash(auto,automobile,clean,sedan,transportation,vehicle)'),
            array('fas fa-charging-station' => 'charging-station(electric,ev,tesla,vehicle)'),
            array('far fa-charging-station' => 'charging-station(electric,ev,tesla,vehicle)'),
            array('fal fa-charging-station' => 'charging-station(electric,ev,tesla,vehicle)'),
            array('fas fa-engine-warning' => 'engine-warning(alert,automobile,car,mechanic,warning)'),
            array('far fa-engine-warning' => 'engine-warning(alert,automobile,car,mechanic,warning)'),
            array('fal fa-engine-warning' => 'engine-warning(alert,automobile,car,mechanic,warning)'),
            array('fas fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('far fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('fal fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('fas fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('far fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('fal fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('fas fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('far fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fal fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fas fa-oil-can' => 'oil-can(auto,crude,gasoline,grease,lubricate,petroleum)'),
            array('far fa-oil-can' => 'oil-can(auto,crude,gasoline,grease,lubricate,petroleum)'),
            array('fal fa-oil-can' => 'oil-can(auto,crude,gasoline,grease,lubricate,petroleum)'),
            array('fas fa-oil-temp' => 'oil-temp(auto,crude,gasoline,grease,lubricate,overheat,petroleum,temperature)'),
            array('far fa-oil-temp' => 'oil-temp(auto,crude,gasoline,grease,lubricate,overheat,petroleum,temperature)'),
            array('fal fa-oil-temp' => 'oil-temp(auto,crude,gasoline,grease,lubricate,overheat,petroleum,temperature)'),
            array('fas fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('far fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fal fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fas fa-steering-wheel' => 'steering-wheel(auto,car,direction,driving,navigation)'),
            array('far fa-steering-wheel' => 'steering-wheel(auto,car,direction,driving,navigation)'),
            array('fal fa-steering-wheel' => 'steering-wheel(auto,car,direction,driving,navigation)'),
            array('fas fa-tachometer' => 'tachometer(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer' => 'tachometer(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer' => 'tachometer(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-alt' => 'tachometer-alt(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-alt' => 'tachometer-alt(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-alt' => 'tachometer-alt(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-alt-average' => 'tachometer-alt-average(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-alt-average' => 'tachometer-alt-average(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-alt-average' => 'tachometer-alt-average(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-alt-fast' => 'tachometer-alt-fast(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-alt-fast' => 'tachometer-alt-fast(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-alt-fast' => 'tachometer-alt-fast(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-alt-fastest' => 'tachometer-alt-fastest(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-alt-fastest' => 'tachometer-alt-fastest(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-alt-fastest' => 'tachometer-alt-fastest(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-alt-slow' => 'tachometer-alt-slow(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-alt-slow' => 'tachometer-alt-slow(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-alt-slow' => 'tachometer-alt-slow(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-alt-slowest' => 'tachometer-alt-slowest(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-alt-slowest' => 'tachometer-alt-slowest(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-alt-slowest' => 'tachometer-alt-slowest(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-average' => 'tachometer-average(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-average' => 'tachometer-average(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-average' => 'tachometer-average(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-fast' => 'tachometer-fast(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-fast' => 'tachometer-fast(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-fast' => 'tachometer-fast(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-fastest' => 'tachometer-fastest(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-fastest' => 'tachometer-fastest(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-fastest' => 'tachometer-fastest(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-slow' => 'tachometer-slow(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-slow' => 'tachometer-slow(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-slow' => 'tachometer-slow(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-slowest' => 'tachometer-slowest(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-slowest' => 'tachometer-slowest(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-slowest' => 'tachometer-slowest(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('far fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fal fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fas fa-tire' => 'tire(auto,car,rim,rubber,wheel)'),
            array('far fa-tire' => 'tire(auto,car,rim,rubber,wheel)'),
            array('fal fa-tire' => 'tire(auto,car,rim,rubber,wheel)'),
            array('fas fa-tire-flat' => 'tire-flat(auto,car,rim,rubber,wheel)'),
            array('far fa-tire-flat' => 'tire-flat(auto,car,rim,rubber,wheel)'),
            array('fal fa-tire-flat' => 'tire-flat(auto,car,rim,rubber,wheel)'),
            array('fas fa-tire-pressure-warning' => 'tire-pressure-warning(alert,auto,car,flat,rim,rubber,wheel)'),
            array('far fa-tire-pressure-warning' => 'tire-pressure-warning(alert,auto,car,flat,rim,rubber,wheel)'),
            array('fal fa-tire-pressure-warning' => 'tire-pressure-warning(alert,auto,car,flat,rim,rubber,wheel)'),
            array('fas fa-tire-rugged' => 'tire-rugged(auto,car,offroad,rim,rubber,wheel)'),
            array('far fa-tire-rugged' => 'tire-rugged(auto,car,offroad,rim,rubber,wheel)'),
            array('fal fa-tire-rugged' => 'tire-rugged(auto,car,offroad,rim,rubber,wheel)'),
            array('fas fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fas fa-truck-monster' => 'truck-monster(offroad,vehicle,wheel)'),
            array('far fa-truck-monster' => 'truck-monster(offroad,vehicle,wheel)'),
            array('fal fa-truck-monster' => 'truck-monster(offroad,vehicle,wheel)'),
            array('fas fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('far fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('fal fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
        ),
        'Autumn' => array(
            array('fas fa-acorn' => 'acorn(fall,nature,nut,oak,seasonal,seed,squirrel,tree)'),
            array('far fa-acorn' => 'acorn(fall,nature,nut,oak,seasonal,seed,squirrel,tree)'),
            array('fal fa-acorn' => 'acorn(fall,nature,nut,oak,seasonal,seed,squirrel,tree)'),
            array('fas fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('far fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fal fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fas fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('far fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('fal fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('fas fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('far fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('fal fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('fas fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('far fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('fal fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('fas fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('far fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('fal fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('fas fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('far fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('fal fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('fas fa-coffee-togo' => 'coffee-togo(beverage,breakfast,cafe,drink,latte,morning,mug,starbucks,takeout,tea,travel)'),
            array('far fa-coffee-togo' => 'coffee-togo(beverage,breakfast,cafe,drink,latte,morning,mug,starbucks,takeout,tea,travel)'),
            array('fal fa-coffee-togo' => 'coffee-togo(beverage,breakfast,cafe,drink,latte,morning,mug,starbucks,takeout,tea,travel)'),
            array('fas fa-corn' => 'corn(cob,ear,fall,grain,kernel,maize,popcorn)'),
            array('far fa-corn' => 'corn(cob,ear,fall,grain,kernel,maize,popcorn)'),
            array('fal fa-corn' => 'corn(cob,ear,fall,grain,kernel,maize,popcorn)'),
            array('fas fa-drumstick' => 'drumstick(bone,chicken,leg,meat,poultry,turkey)'),
            array('far fa-drumstick' => 'drumstick(bone,chicken,leg,meat,poultry,turkey)'),
            array('fal fa-drumstick' => 'drumstick(bone,chicken,leg,meat,poultry,turkey)'),
            array('fas fa-drumstick-bite' => 'drumstick-bite(bone,chicken,leg,meat,poultry,turkey)'),
            array('far fa-drumstick-bite' => 'drumstick-bite(bone,chicken,leg,meat,poultry,turkey)'),
            array('fal fa-drumstick-bite' => 'drumstick-bite(bone,chicken,leg,meat,poultry,turkey)'),
            array('fas fa-football-ball' => 'football-ball(ball,fall,nfl,pigskin,seasonal)'),
            array('far fa-football-ball' => 'football-ball(ball,fall,nfl,pigskin,seasonal)'),
            array('fal fa-football-ball' => 'football-ball(ball,fall,nfl,pigskin,seasonal)'),
            array('fas fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('far fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fal fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fas fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('far fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('fal fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('fas fa-leaf-maple' => 'leaf-maple(eco,fall,flora,nature,plant,seasonal)'),
            array('far fa-leaf-maple' => 'leaf-maple(eco,fall,flora,nature,plant,seasonal)'),
            array('fal fa-leaf-maple' => 'leaf-maple(eco,fall,flora,nature,plant,seasonal)'),
            array('fas fa-leaf-oak' => 'leaf-oak(eco,fall,flora,nature,plant,seasonal)'),
            array('far fa-leaf-oak' => 'leaf-oak(eco,fall,flora,nature,plant,seasonal)'),
            array('fal fa-leaf-oak' => 'leaf-oak(eco,fall,flora,nature,plant,seasonal)'),
            array('fas fa-mountain' => 'mountain(glacier,hiking,hill,landscape,travel,view)'),
            array('far fa-mountain' => 'mountain(glacier,hiking,hill,landscape,travel,view)'),
            array('fal fa-mountain' => 'mountain(glacier,hiking,hill,landscape,travel,view)'),
            array('fas fa-mountains' => 'mountains(glacier,hiking,hill,landscape,travel,view)'),
            array('far fa-mountains' => 'mountains(glacier,hiking,hill,landscape,travel,view)'),
            array('fal fa-mountains' => 'mountains(glacier,hiking,hill,landscape,travel,view)'),
            array('fas fa-pie' => 'pie(apple,bakery,cake,crust,dessert,pumpkin,tart)'),
            array('far fa-pie' => 'pie(apple,bakery,cake,crust,dessert,pumpkin,tart)'),
            array('fal fa-pie' => 'pie(apple,bakery,cake,crust,dessert,pumpkin,tart)'),
            array('fas fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('far fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('fal fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('fas fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('far fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fal fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fas fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('far fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('fal fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('fas fa-tractor' => 'tractor(agriculture,farm,vehicle)'),
            array('far fa-tractor' => 'tractor(agriculture,farm,vehicle)'),
            array('fal fa-tractor' => 'tractor(agriculture,farm,vehicle)'),
            array('fas fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-trees' => 'trees(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-trees' => 'trees(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-trees' => 'trees(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('far fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('fal fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('fas fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
            array('far fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
            array('fal fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
            array('fas fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('far fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('fal fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('fas fa-wine-bottle' => 'wine-bottle(alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)'),
            array('far fa-wine-bottle' => 'wine-bottle(alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)'),
            array('fal fa-wine-bottle' => 'wine-bottle(alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)'),
        ),
        'Beverage' => array(
            array('fas fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('far fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fal fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fas fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('far fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('fal fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('fas fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('far fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('fal fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('fas fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('far fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fal fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fas fa-coffee-togo' => 'coffee-togo(beverage,breakfast,cafe,drink,latte,morning,mug,starbucks,takeout,tea,travel)'),
            array('far fa-coffee-togo' => 'coffee-togo(beverage,breakfast,cafe,drink,latte,morning,mug,starbucks,takeout,tea,travel)'),
            array('fal fa-coffee-togo' => 'coffee-togo(beverage,breakfast,cafe,drink,latte,morning,mug,starbucks,takeout,tea,travel)'),
            array('fas fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('far fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fal fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fas fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('far fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('fal fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('fas fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('far fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fal fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fas fa-glass' => 'glass(alcohol,beverage,drink,glass,water)'),
            array('far fa-glass' => 'glass(alcohol,beverage,drink,glass,water)'),
            array('fal fa-glass' => 'glass(alcohol,beverage,drink,glass,water)'),
            array('fas fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('far fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('fal fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('fas fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('far fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('fal fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('fas fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('far fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('fal fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('fas fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('far fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('fal fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('fas fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('far fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('fal fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('fas fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('far fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('fal fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('fas fa-wine-bottle' => 'wine-bottle(alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)'),
            array('far fa-wine-bottle' => 'wine-bottle(alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)'),
            array('fal fa-wine-bottle' => 'wine-bottle(alcohol,beverage,cabernet,drink,glass,grapes,merlot,sauvignon)'),
            array('fas fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('far fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fal fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fas fa-wine-glass-alt' => 'wine-glass-alt(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('far fa-wine-glass-alt' => 'wine-glass-alt(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fal fa-wine-glass-alt' => 'wine-glass-alt(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
        ),
        'Buildings' => array(
            array('fas fa-archway' => 'archway(arc,monument,road,street,tunnel)'),
            array('far fa-archway' => 'archway(arc,monument,road,street,tunnel)'),
            array('fal fa-archway' => 'archway(arc,monument,road,street,tunnel)'),
            array('fas fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('far fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fal fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fas fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('far fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('fal fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('fas fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('far fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('fal fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('fas fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('far fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('fal fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('fas fa-city' => 'city(buildings,busy,skyscrapers,urban,windows)'),
            array('far fa-city' => 'city(buildings,busy,skyscrapers,urban,windows)'),
            array('fal fa-city' => 'city(buildings,busy,skyscrapers,urban,windows)'),
            array('fas fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('far fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fal fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fas fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('far fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('fal fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('fas fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('far fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fal fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fas fa-gopuram' => 'gopuram(building,entrance,hinduism,temple,tower)'),
            array('far fa-gopuram' => 'gopuram(building,entrance,hinduism,temple,tower)'),
            array('fal fa-gopuram' => 'gopuram(building,entrance,hinduism,temple,tower)'),
            array('fas fa-home' => 'home(abode,building,house,main)'),
            array('far fa-home' => 'home(abode,building,house,main)'),
            array('fal fa-home' => 'home(abode,building,house,main)'),
            array('fas fa-home-alt' => 'home-alt(abode,building,house,main)'),
            array('far fa-home-alt' => 'home-alt(abode,building,house,main)'),
            array('fal fa-home-alt' => 'home-alt(abode,building,house,main)'),
            array('fas fa-home-lg' => 'home-lg(abode,building,house,main)'),
            array('far fa-home-lg' => 'home-lg(abode,building,house,main)'),
            array('fal fa-home-lg' => 'home-lg(abode,building,house,main)'),
            array('fas fa-home-lg-alt' => 'home-lg-alt(abode,building,house,main)'),
            array('far fa-home-lg-alt' => 'home-lg-alt(abode,building,house,main)'),
            array('fal fa-home-lg-alt' => 'home-lg-alt(abode,building,house,main)'),
            array('fas fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('far fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fal fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fas fa-hospital-alt' => 'hospital-alt(building,emergency room,medical center)'),
            array('far fa-hospital-alt' => 'hospital-alt(building,emergency room,medical center)'),
            array('fal fa-hospital-alt' => 'hospital-alt(building,emergency room,medical center)'),
            array('fas fa-hospital-user' => 'hospital-user(doctor,network,patient,primary care)'),
            array('far fa-hospital-user' => 'hospital-user(doctor,network,patient,primary care)'),
            array('fal fa-hospital-user' => 'hospital-user(doctor,network,patient,primary care)'),
            array('fas fa-hospitals' => 'hospitals(emergency,insurance,network)'),
            array('far fa-hospitals' => 'hospitals(emergency,insurance,network)'),
            array('fal fa-hospitals' => 'hospitals(emergency,insurance,network)'),
            array('fas fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('far fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('fal fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('fas fa-house-damage' => 'house-damage(building,devastation,disaster,home,insurance)'),
            array('far fa-house-damage' => 'house-damage(building,devastation,disaster,home,insurance)'),
            array('fal fa-house-damage' => 'house-damage(building,devastation,disaster,home,insurance)'),
            array('fas fa-house-flood' => 'house-flood(building,devastation,disaster,home,insurance,water)'),
            array('far fa-house-flood' => 'house-flood(building,devastation,disaster,home,insurance,water)'),
            array('fal fa-house-flood' => 'house-flood(building,devastation,disaster,home,insurance,water)'),
            array('fas fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('far fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('fal fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('fas fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-kaaba' => 'kaaba(building,cube,islam,muslim)'),
            array('far fa-kaaba' => 'kaaba(building,cube,islam,muslim)'),
            array('fal fa-kaaba' => 'kaaba(building,cube,islam,muslim)'),
            array('fas fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('far fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fal fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fas fa-landmark-alt' => 'landmark-alt(building,historic,memorable,monument,politics)'),
            array('far fa-landmark-alt' => 'landmark-alt(building,historic,memorable,monument,politics)'),
            array('fal fa-landmark-alt' => 'landmark-alt(building,historic,memorable,monument,politics)'),
            array('fas fa-monument' => 'monument(building,historic,landmark,memorable)'),
            array('far fa-monument' => 'monument(building,historic,landmark,memorable)'),
            array('fal fa-monument' => 'monument(building,historic,landmark,memorable)'),
            array('fas fa-mosque' => 'mosque(building,islam,landmark,muslim)'),
            array('far fa-mosque' => 'mosque(building,islam,landmark,muslim)'),
            array('fal fa-mosque' => 'mosque(building,islam,landmark,muslim)'),
            array('fas fa-place-of-worship' => 'place-of-worship(building,church,holy,mosque,synagogue)'),
            array('far fa-place-of-worship' => 'place-of-worship(building,church,holy,mosque,synagogue)'),
            array('fal fa-place-of-worship' => 'place-of-worship(building,church,holy,mosque,synagogue)'),
            array('fas fa-school' => 'school(building,education,learn,student,teacher)'),
            array('far fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fal fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fas fa-store' => 'store(building,buy,purchase,shopping)'),
            array('far fa-store' => 'store(building,buy,purchase,shopping)'),
            array('fal fa-store' => 'store(building,buy,purchase,shopping)'),
            array('fas fa-store-alt' => 'store-alt(building,buy,purchase,shopping)'),
            array('far fa-store-alt' => 'store-alt(building,buy,purchase,shopping)'),
            array('fal fa-store-alt' => 'store-alt(building,buy,purchase,shopping)'),
            array('fas fa-synagogue' => 'synagogue(building,jewish,judaism,religion,star of david,temple)'),
            array('far fa-synagogue' => 'synagogue(building,jewish,judaism,religion,star of david,temple)'),
            array('fal fa-synagogue' => 'synagogue(building,jewish,judaism,religion,star of david,temple)'),
            array('fas fa-torii-gate' => 'torii-gate(building,shintoism)'),
            array('far fa-torii-gate' => 'torii-gate(building,shintoism)'),
            array('fal fa-torii-gate' => 'torii-gate(building,shintoism)'),
            array('fas fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('far fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('fal fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('fas fa-vihara' => 'vihara(buddhism,buddhist,building,monastery)'),
            array('far fa-vihara' => 'vihara(buddhism,buddhist,building,monastery)'),
            array('fal fa-vihara' => 'vihara(buddhism,buddhist,building,monastery)'),
            array('fas fa-warehouse' => 'warehouse(building,capacity,garage,inventory,storage)'),
            array('far fa-warehouse' => 'warehouse(building,capacity,garage,inventory,storage)'),
            array('fal fa-warehouse' => 'warehouse(building,capacity,garage,inventory,storage)'),
            array('fas fa-warehouse-alt' => 'warehouse-alt(building,capacity,garage,inventory,storage)'),
            array('far fa-warehouse-alt' => 'warehouse-alt(building,capacity,garage,inventory,storage)'),
            array('fal fa-warehouse-alt' => 'warehouse-alt(building,capacity,garage,inventory,storage)'),
        ),
        'Business' => array(
            array('fas fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('far fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('fal fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('fas fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('far fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('fal fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('fas fa-archive' => 'archive(box,package,save,storage)'),
            array('far fa-archive' => 'archive(box,package,save,storage)'),
            array('fal fa-archive' => 'archive(box,package,save,storage)'),
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('far fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fal fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fas fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('far fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fal fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fas fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('far fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fal fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fas fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('far fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fal fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fas fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('far fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fal fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fas fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('far fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fal fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fas fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('far fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fal fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fas fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('far fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fal fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fas fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('far fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fal fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fas fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('far fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fal fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fas fa-business-time' => 'business-time(alarm,briefcase,business socks,clock,flight of the conchords,reminder,wednesday)'),
            array('far fa-business-time' => 'business-time(alarm,briefcase,business socks,clock,flight of the conchords,reminder,wednesday)'),
            array('fal fa-business-time' => 'business-time(alarm,briefcase,business socks,clock,flight of the conchords,reminder,wednesday)'),
            array('fas fa-cabinet-filing' => 'cabinet-filing(archive,files,records,register,storage)'),
            array('far fa-cabinet-filing' => 'cabinet-filing(archive,files,records,register,storage)'),
            array('fal fa-cabinet-filing' => 'cabinet-filing(archive,files,records,register,storage)'),
            array('fas fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('far fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fal fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fas fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('far fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fal fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fas fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('far fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fal fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fas fa-certificate' => 'certificate(badge,star,verified)'),
            array('far fa-certificate' => 'certificate(badge,star,verified)'),
            array('fal fa-certificate' => 'certificate(badge,star,verified)'),
            array('fas fa-chart-area' => 'chart-area(analytics,area,chart,graph)'),
            array('far fa-chart-area' => 'chart-area(analytics,area,chart,graph)'),
            array('fal fa-chart-area' => 'chart-area(analytics,area,chart,graph)'),
            array('fas fa-chart-bar' => 'chart-bar(analytics,bar,chart,graph)'),
            array('far fa-chart-bar' => 'chart-bar(analytics,bar,chart,graph)'),
            array('fal fa-chart-bar' => 'chart-bar(analytics,bar,chart,graph)'),
            array('fas fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('far fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('fal fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('fas fa-chart-line-down' => 'chart-line-down(analytics,chart,dashboard,decline,graph,line,loss)'),
            array('far fa-chart-line-down' => 'chart-line-down(analytics,chart,dashboard,decline,graph,line,loss)'),
            array('fal fa-chart-line-down' => 'chart-line-down(analytics,chart,dashboard,decline,graph,line,loss)'),
            array('fas fa-chart-network' => 'chart-network(activity,analytics,association,dashboard,diagram,distribution,map,network)'),
            array('far fa-chart-network' => 'chart-network(activity,analytics,association,dashboard,diagram,distribution,map,network)'),
            array('fal fa-chart-network' => 'chart-network(activity,analytics,association,dashboard,diagram,distribution,map,network)'),
            array('fas fa-chart-pie' => 'chart-pie(analytics,chart,diagram,graph,pie)'),
            array('far fa-chart-pie' => 'chart-pie(analytics,chart,diagram,graph,pie)'),
            array('fal fa-chart-pie' => 'chart-pie(analytics,chart,diagram,graph,pie)'),
            array('fas fa-chart-pie-alt' => 'chart-pie-alt(analytics,chart,diagram,graph,pie)'),
            array('far fa-chart-pie-alt' => 'chart-pie-alt(analytics,chart,diagram,graph,pie)'),
            array('fal fa-chart-pie-alt' => 'chart-pie-alt(analytics,chart,diagram,graph,pie)'),
            array('fas fa-chart-scatter' => 'chart-scatter(analytics,chart,diagram,graph,plot)'),
            array('far fa-chart-scatter' => 'chart-scatter(analytics,chart,diagram,graph,plot)'),
            array('fal fa-chart-scatter' => 'chart-scatter(analytics,chart,diagram,graph,plot)'),
            array('fas fa-city' => 'city(buildings,busy,skyscrapers,urban,windows)'),
            array('far fa-city' => 'city(buildings,busy,skyscrapers,urban,windows)'),
            array('fal fa-city' => 'city(buildings,busy,skyscrapers,urban,windows)'),
            array('fas fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('far fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fal fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fas fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('far fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fal fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fas fa-columns' => 'columns(browser,dashboard,organize,panes,split)'),
            array('far fa-columns' => 'columns(browser,dashboard,organize,panes,split)'),
            array('fal fa-columns' => 'columns(browser,dashboard,organize,panes,split)'),
            array('fas fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('far fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fal fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fas fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('far fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fal fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fas fa-copyright' => 'copyright(brand,mark,register,trademark)'),
            array('far fa-copyright' => 'copyright(brand,mark,register,trademark)'),
            array('fal fa-copyright' => 'copyright(brand,mark,register,trademark)'),
            array('fas fa-cut' => 'cut(clip,scissors,snip)'),
            array('far fa-cut' => 'cut(clip,scissors,snip)'),
            array('fal fa-cut' => 'cut(clip,scissors,snip)'),
            array('fas fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('far fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fal fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fas fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-envelope-square' => 'envelope-square(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-square' => 'envelope-square(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-square' => 'envelope-square(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('far fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fal fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fas fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('far fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('fal fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-file-chart-line' => 'file-chart-line(analytics,data,document,projection,report)'),
            array('far fa-file-chart-line' => 'file-chart-line(analytics,data,document,projection,report)'),
            array('fal fa-file-chart-line' => 'file-chart-line(analytics,data,document,projection,report)'),
            array('fas fa-file-chart-pie' => 'file-chart-pie(analytics,data,document,projection,report)'),
            array('far fa-file-chart-pie' => 'file-chart-pie(analytics,data,document,projection,report)'),
            array('fal fa-file-chart-pie' => 'file-chart-pie(analytics,data,document,projection,report)'),
            array('fas fa-file-spreadsheet' => 'file-spreadsheet(csv,document,excel,numbers,sheets,xls)'),
            array('far fa-file-spreadsheet' => 'file-spreadsheet(csv,document,excel,numbers,sheets,xls)'),
            array('fal fa-file-spreadsheet' => 'file-spreadsheet(csv,document,excel,numbers,sheets,xls)'),
            array('fas fa-file-user' => 'file-user(account,document,page,personnel,profile,resume)'),
            array('far fa-file-user' => 'file-user(account,document,page,personnel,profile,resume)'),
            array('fal fa-file-user' => 'file-user(account,document,page,personnel,profile,resume)'),
            array('fas fa-folder' => 'folder(archive,directory,document,file)'),
            array('far fa-folder' => 'folder(archive,directory,document,file)'),
            array('fal fa-folder' => 'folder(archive,directory,document,file)'),
            array('fas fa-folder-minus' => 'folder-minus(archive,delete,directory,document,file,negative,remove)'),
            array('far fa-folder-minus' => 'folder-minus(archive,delete,directory,document,file,negative,remove)'),
            array('fal fa-folder-minus' => 'folder-minus(archive,delete,directory,document,file,negative,remove)'),
            array('fas fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('far fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fal fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fas fa-folder-plus' => 'folder-plus(add,archive,create,directory,document,file,new,positive)'),
            array('far fa-folder-plus' => 'folder-plus(add,archive,create,directory,document,file,new,positive)'),
            array('fal fa-folder-plus' => 'folder-plus(add,archive,create,directory,document,file,new,positive)'),
            array('fas fa-folder-times' => 'folder-times(archive,delete,directory,document,file,remove,x)'),
            array('far fa-folder-times' => 'folder-times(archive,delete,directory,document,file,remove,x)'),
            array('fal fa-folder-times' => 'folder-times(archive,delete,directory,document,file,remove,x)'),
            array('fas fa-folder-tree' => 'folder-tree(archive,directory,document,file,search,structure)'),
            array('far fa-folder-tree' => 'folder-tree(archive,directory,document,file,search,structure)'),
            array('fal fa-folder-tree' => 'folder-tree(archive,directory,document,file,search,structure)'),
            array('fas fa-folders' => 'folders(archive,copy,directory,document,duplicate,file)'),
            array('far fa-folders' => 'folders(archive,copy,directory,document,duplicate,file)'),
            array('fal fa-folders' => 'folders(archive,copy,directory,document,duplicate,file)'),
            array('fas fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('far fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fal fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fas fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('far fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fal fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fas fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-keynote' => 'keynote(lecture,panel,seminar,speak,speaker,talk)'),
            array('far fa-keynote' => 'keynote(lecture,panel,seminar,speak,speaker,talk)'),
            array('fal fa-keynote' => 'keynote(lecture,panel,seminar,speak,speaker,talk)'),
            array('fas fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('far fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fal fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fas fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('far fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fal fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fas fa-mind-share' => 'mind-share(brain,brainstorming,meeting,planning)'),
            array('far fa-mind-share' => 'mind-share(brain,brainstorming,meeting,planning)'),
            array('fal fa-mind-share' => 'mind-share(brain,brainstorming,meeting,planning)'),
            array('fas fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('far fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fal fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fas fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('far fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fal fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fas fa-pen' => 'pen(design,edit,update,write)'),
            array('far fa-pen' => 'pen(design,edit,update,write)'),
            array('fal fa-pen' => 'pen(design,edit,update,write)'),
            array('fas fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('far fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fal fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fas fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('far fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fas fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('far fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fas fa-pen-square' => 'pen-square(edit,pencil-square,update,write)'),
            array('far fa-pen-square' => 'pen-square(edit,pencil-square,update,write)'),
            array('fal fa-pen-square' => 'pen-square(edit,pencil-square,update,write)'),
            array('fas fa-pencil' => 'pencil(design,edit,update,write)'),
            array('far fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fal fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fas fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('far fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fal fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fas fa-percent' => 'percent(discount,fraction,proportion,rate,ratio)'),
            array('far fa-percent' => 'percent(discount,fraction,proportion,rate,ratio)'),
            array('fal fa-percent' => 'percent(discount,fraction,proportion,rate,ratio)'),
            array('fas fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-office' => 'phone-office(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone-office' => 'phone-office(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone-office' => 'phone-office(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('far fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fal fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fas fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('far fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fal fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fas fa-podium' => 'podium(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('far fa-podium' => 'podium(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('fal fa-podium' => 'podium(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('fas fa-presentation' => 'presentation(keynote,lecture,panel,powerpoint,ppt,seminar,slides,speak,speaker,talk)'),
            array('far fa-presentation' => 'presentation(keynote,lecture,panel,powerpoint,ppt,seminar,slides,speak,speaker,talk)'),
            array('fal fa-presentation' => 'presentation(keynote,lecture,panel,powerpoint,ppt,seminar,slides,speak,speaker,talk)'),
            array('fas fa-print' => 'print(business,copy,document,office,paper)'),
            array('far fa-print' => 'print(business,copy,document,office,paper)'),
            array('fal fa-print' => 'print(business,copy,document,office,paper)'),
            array('fas fa-print-slash' => 'print-slash(business,copy,document,office,offline,paper)'),
            array('far fa-print-slash' => 'print-slash(business,copy,document,office,offline,paper)'),
            array('fal fa-print-slash' => 'print-slash(business,copy,document,office,offline,paper)'),
            array('fas fa-project-diagram' => 'project-diagram(chart,graph,network,pert)'),
            array('far fa-project-diagram' => 'project-diagram(chart,graph,network,pert)'),
            array('fal fa-project-diagram' => 'project-diagram(chart,graph,network,pert)'),
            array('fas fa-registered' => 'registered(copyright,mark,trademark)'),
            array('far fa-registered' => 'registered(copyright,mark,trademark)'),
            array('fal fa-registered' => 'registered(copyright,mark,trademark)'),
            array('fas fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('far fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fal fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fas fa-shredder' => 'shredder(destroy,document,office,paper,print)'),
            array('far fa-shredder' => 'shredder(destroy,document,office,paper,print)'),
            array('fal fa-shredder' => 'shredder(destroy,document,office,paper,print)'),
            array('fas fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('far fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('fal fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('fas fa-socks' => 'socks(business socks,business time,clothing,feet,flight of the conchords,wednesday)'),
            array('far fa-socks' => 'socks(business socks,business time,clothing,feet,flight of the conchords,wednesday)'),
            array('fal fa-socks' => 'socks(business socks,business time,clothing,feet,flight of the conchords,wednesday)'),
            array('fas fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('far fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('fal fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('fas fa-stream' => 'stream(flow,list,timeline)'),
            array('far fa-stream' => 'stream(flow,list,timeline)'),
            array('fal fa-stream' => 'stream(flow,list,timeline)'),
            array('fas fa-table' => 'table(data,excel,spreadsheet)'),
            array('far fa-table' => 'table(data,excel,spreadsheet)'),
            array('fal fa-table' => 'table(data,excel,spreadsheet)'),
            array('fas fa-tag' => 'tag(discount,label,price,shopping)'),
            array('far fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fal fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fas fa-tags' => 'tags(discount,label,price,shopping)'),
            array('far fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fal fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fas fa-tasks' => 'tasks(checklist,downloading,downloads,loading,progress,project management,settings,to do)'),
            array('far fa-tasks' => 'tasks(checklist,downloading,downloads,loading,progress,project management,settings,to do)'),
            array('fal fa-tasks' => 'tasks(checklist,downloading,downloads,loading,progress,project management,settings,to do)'),
            array('fas fa-tasks-alt' => 'tasks-alt(checklist,downloading,downloads,loading,poll,progress,project management,settings,to do)'),
            array('far fa-tasks-alt' => 'tasks-alt(checklist,downloading,downloads,loading,poll,progress,project management,settings,to do)'),
            array('fal fa-tasks-alt' => 'tasks-alt(checklist,downloading,downloads,loading,poll,progress,project management,settings,to do)'),
            array('fas fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('far fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fal fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fas fa-trademark' => 'trademark(copyright,register,symbol)'),
            array('far fa-trademark' => 'trademark(copyright,register,symbol)'),
            array('fal fa-trademark' => 'trademark(copyright,register,symbol)'),
            array('fas fa-user-chart' => 'user-chart(chart,person,presentation,teacher)'),
            array('far fa-user-chart' => 'user-chart(chart,person,presentation,teacher)'),
            array('fal fa-user-chart' => 'user-chart(chart,person,presentation,teacher)'),
            array('fas fa-wallet' => 'wallet(billfold,cash,currency,money)'),
            array('far fa-wallet' => 'wallet(billfold,cash,currency,money)'),
            array('fal fa-wallet' => 'wallet(billfold,cash,currency,money)'),
        ),
        'Camping' => array(
            array('fas fa-acorn' => 'acorn(fall,nature,nut,oak,seasonal,seed,squirrel,tree)'),
            array('far fa-acorn' => 'acorn(fall,nature,nut,oak,seasonal,seed,squirrel,tree)'),
            array('fal fa-acorn' => 'acorn(fall,nature,nut,oak,seasonal,seed,squirrel,tree)'),
            array('fas fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('far fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('fal fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('fas fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('far fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('fal fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('fas fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('far fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fal fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fas fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('far fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fal fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fas fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('far fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('fal fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('fas fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('far fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('fal fa-campground' => 'campground(camping,fall,outdoors,teepee,tent,tipi)'),
            array('fas fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('far fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fal fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fas fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('far fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fal fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fas fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-smoke' => 'fire-smoke(burn,caliente,flame,fog,heat,hot)'),
            array('far fa-fire-smoke' => 'fire-smoke(burn,caliente,flame,fog,heat,hot)'),
            array('fal fa-fire-smoke' => 'fire-smoke(burn,caliente,flame,fog,heat,hot)'),
            array('fas fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('far fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('fal fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('fas fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('far fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fal fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fas fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('far fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fal fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fas fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marked' => 'map-marked(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marked' => 'map-marked(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marked' => 'map-marked(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marked-alt' => 'map-marked-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marked-alt' => 'map-marked-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marked-alt' => 'map-marked-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('far fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('fal fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('fas fa-mountain' => 'mountain(glacier,hiking,hill,landscape,travel,view)'),
            array('far fa-mountain' => 'mountain(glacier,hiking,hill,landscape,travel,view)'),
            array('fal fa-mountain' => 'mountain(glacier,hiking,hill,landscape,travel,view)'),
            array('fas fa-mountains' => 'mountains(glacier,hiking,hill,landscape,travel,view)'),
            array('far fa-mountains' => 'mountains(glacier,hiking,hill,landscape,travel,view)'),
            array('fal fa-mountains' => 'mountains(glacier,hiking,hill,landscape,travel,view)'),
            array('fas fa-route' => 'route(directions,navigation,travel)'),
            array('far fa-route' => 'route(directions,navigation,travel)'),
            array('fal fa-route' => 'route(directions,navigation,travel)'),
            array('fas fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('far fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fal fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fas fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('far fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('fal fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('fas fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('far fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fal fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fas fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('far fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('fal fa-squirrel' => 'squirrel(animal,chipmunk,mammal,marmot,rat,rodent,tree)'),
            array('fas fa-sunrise' => 'sunrise(dawn,day,daybreak,daylight,daytime,morning,sun up)'),
            array('far fa-sunrise' => 'sunrise(dawn,day,daybreak,daylight,daytime,morning,sun up)'),
            array('fal fa-sunrise' => 'sunrise(dawn,day,daybreak,daylight,daytime,morning,sun up)'),
            array('fas fa-sunset' => 'sunset(dusk,night,nighttime,sun down)'),
            array('far fa-sunset' => 'sunset(dusk,night,nighttime,sun down)'),
            array('fal fa-sunset' => 'sunset(dusk,night,nighttime,sun down)'),
            array('fas fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('far fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fal fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fas fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('far fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fal fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fas fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-trees' => 'trees(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-trees' => 'trees(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-trees' => 'trees(bark,fall,flora,forest,nature,plant,seasonal)'),
        ),
        'Charity' => array(
            array('fas fa-book-heart' => 'book-heart(charity,diary,documentation,donation,health,history,journal,library,read)'),
            array('far fa-book-heart' => 'book-heart(charity,diary,documentation,donation,health,history,journal,library,read)'),
            array('fal fa-book-heart' => 'book-heart(charity,diary,documentation,donation,health,history,journal,library,read)'),
            array('fas fa-box-heart' => 'box-heart(care,donation,package,storage)'),
            array('far fa-box-heart' => 'box-heart(care,donation,package,storage)'),
            array('fal fa-box-heart' => 'box-heart(care,donation,package,storage)'),
            array('fas fa-box-usd' => 'box-usd($,dollar-sign,donation,money,usd)'),
            array('far fa-box-usd' => 'box-usd($,dollar-sign,donation,money,usd)'),
            array('fal fa-box-usd' => 'box-usd($,dollar-sign,donation,money,usd)'),
            array('fas fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('far fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('fal fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('fas fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('far fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('fal fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('fas fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('far fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fal fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fas fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-hand-heart' => 'hand-heart(care,charity,donate,help)'),
            array('far fa-hand-heart' => 'hand-heart(care,charity,donate,help)'),
            array('fal fa-hand-heart' => 'hand-heart(care,charity,donate,help)'),
            array('fas fa-hand-holding-heart' => 'hand-holding-heart(carry,charity,gift,lift,package)'),
            array('far fa-hand-holding-heart' => 'hand-holding-heart(carry,charity,gift,lift,package)'),
            array('fal fa-hand-holding-heart' => 'hand-holding-heart(carry,charity,gift,lift,package)'),
            array('fas fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('far fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('fal fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('fas fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('far fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('fal fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('fas fa-hand-holding-water' => 'hand-holding-water(carry,drought,grow,lift)'),
            array('far fa-hand-holding-water' => 'hand-holding-water(carry,drought,grow,lift)'),
            array('fal fa-hand-holding-water' => 'hand-holding-water(carry,drought,grow,lift)'),
            array('fas fa-hands-heart' => 'hands-heart(carry,gift,help,hold,lift)'),
            array('far fa-hands-heart' => 'hands-heart(carry,gift,help,hold,lift)'),
            array('fal fa-hands-heart' => 'hands-heart(carry,gift,help,hold,lift)'),
            array('fas fa-hands-helping' => 'hands-helping(aid,assistance,handshake,partnership,volunteering)'),
            array('far fa-hands-helping' => 'hands-helping(aid,assistance,handshake,partnership,volunteering)'),
            array('fal fa-hands-helping' => 'hands-helping(aid,assistance,handshake,partnership,volunteering)'),
            array('fas fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('far fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('fal fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('fas fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('far fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fal fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fas fa-handshake-alt' => 'handshake-alt(agreement,greeting,partnership. meeting)'),
            array('far fa-handshake-alt' => 'handshake-alt(agreement,greeting,partnership. meeting)'),
            array('fal fa-handshake-alt' => 'handshake-alt(agreement,greeting,partnership. meeting)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-heart-circle' => 'heart-circle(favorite,like,love)'),
            array('far fa-heart-circle' => 'heart-circle(favorite,like,love)'),
            array('fal fa-heart-circle' => 'heart-circle(favorite,like,love)'),
            array('fas fa-heart-square' => 'heart-square(favorite,like,love)'),
            array('far fa-heart-square' => 'heart-square(favorite,like,love)'),
            array('fal fa-heart-square' => 'heart-square(favorite,like,love)'),
            array('fas fa-home-heart' => 'home-heart(abode,building,charity,house,main)'),
            array('far fa-home-heart' => 'home-heart(abode,building,charity,house,main)'),
            array('fal fa-home-heart' => 'home-heart(abode,building,charity,house,main)'),
            array('fas fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('far fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fal fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fas fa-leaf-heart' => 'leaf-heart(eco,flora,nature,plant,vegan)'),
            array('far fa-leaf-heart' => 'leaf-heart(eco,flora,nature,plant,vegan)'),
            array('fal fa-leaf-heart' => 'leaf-heart(eco,flora,nature,plant,vegan)'),
            array('fas fa-parachute-box' => 'parachute-box(aid,assistance,rescue,supplies)'),
            array('far fa-parachute-box' => 'parachute-box(aid,assistance,rescue,supplies)'),
            array('fal fa-parachute-box' => 'parachute-box(aid,assistance,rescue,supplies)'),
            array('fas fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('far fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('fal fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('fas fa-ribbon' => 'ribbon(badge,cause,lapel,pin)'),
            array('far fa-ribbon' => 'ribbon(badge,cause,lapel,pin)'),
            array('fal fa-ribbon' => 'ribbon(badge,cause,lapel,pin)'),
            array('fas fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('far fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fal fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fas fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('far fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('fal fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('fas fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('far fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('fal fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
        ),
        'Chat' => array(
            array('fas fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt-check' => 'comment-alt-check(accept,agree,bubble,chat,commenting,conversation,feedback,message,note,notification,select,sms,speech,success,synced,texting,tick,todo)'),
            array('far fa-comment-alt-check' => 'comment-alt-check(accept,agree,bubble,chat,commenting,conversation,feedback,message,note,notification,select,sms,speech,success,synced,texting,tick,todo)'),
            array('fal fa-comment-alt-check' => 'comment-alt-check(accept,agree,bubble,chat,commenting,conversation,feedback,message,note,notification,select,sms,speech,success,synced,texting,tick,todo)'),
            array('fas fa-comment-alt-dots' => 'comment-alt-dots(bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)'),
            array('far fa-comment-alt-dots' => 'comment-alt-dots(bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)'),
            array('fal fa-comment-alt-dots' => 'comment-alt-dots(bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)'),
            array('fas fa-comment-alt-edit' => 'comment-alt-edit(bubble,chat,commenting,conversation,edit,feedback,message,note,notification,pen,pencil,sms,speech,texting,update,write)'),
            array('far fa-comment-alt-edit' => 'comment-alt-edit(bubble,chat,commenting,conversation,edit,feedback,message,note,notification,pen,pencil,sms,speech,texting,update,write)'),
            array('fal fa-comment-alt-edit' => 'comment-alt-edit(bubble,chat,commenting,conversation,edit,feedback,message,note,notification,pen,pencil,sms,speech,texting,update,write)'),
            array('fas fa-comment-alt-exclamation' => 'comment-alt-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('far fa-comment-alt-exclamation' => 'comment-alt-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fal fa-comment-alt-exclamation' => 'comment-alt-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fas fa-comment-alt-lines' => 'comment-alt-lines(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-alt-lines' => 'comment-alt-lines(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-alt-lines' => 'comment-alt-lines(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt-medical' => 'comment-alt-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('far fa-comment-alt-medical' => 'comment-alt-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fal fa-comment-alt-medical' => 'comment-alt-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fas fa-comment-alt-minus' => 'comment-alt-minus(bubble,chat,commenting,conversation,delete,feedback,message,negative,note,notification,remove,sms,speech,texting)'),
            array('far fa-comment-alt-minus' => 'comment-alt-minus(bubble,chat,commenting,conversation,delete,feedback,message,negative,note,notification,remove,sms,speech,texting)'),
            array('fal fa-comment-alt-minus' => 'comment-alt-minus(bubble,chat,commenting,conversation,delete,feedback,message,negative,note,notification,remove,sms,speech,texting)'),
            array('fas fa-comment-alt-plus' => 'comment-alt-plus(add,bubble,chat,commenting,conversation,create,feedback,message,new,note,notification,positive,sms,speech,texting)'),
            array('far fa-comment-alt-plus' => 'comment-alt-plus(add,bubble,chat,commenting,conversation,create,feedback,message,new,note,notification,positive,sms,speech,texting)'),
            array('fal fa-comment-alt-plus' => 'comment-alt-plus(add,bubble,chat,commenting,conversation,create,feedback,message,new,note,notification,positive,sms,speech,texting)'),
            array('fas fa-comment-alt-slash' => 'comment-alt-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('far fa-comment-alt-slash' => 'comment-alt-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fal fa-comment-alt-slash' => 'comment-alt-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fas fa-comment-alt-smile' => 'comment-alt-smile(bubble,chat,commenting,conversation,emoji,feedback,happy,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-alt-smile' => 'comment-alt-smile(bubble,chat,commenting,conversation,emoji,feedback,happy,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-alt-smile' => 'comment-alt-smile(bubble,chat,commenting,conversation,emoji,feedback,happy,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt-times' => 'comment-alt-times(archive,bubble,chat,commenting,conversation,delete,feedback,message,note,notification,remove,sms,speech,texting,x)'),
            array('far fa-comment-alt-times' => 'comment-alt-times(archive,bubble,chat,commenting,conversation,delete,feedback,message,note,notification,remove,sms,speech,texting,x)'),
            array('fal fa-comment-alt-times' => 'comment-alt-times(archive,bubble,chat,commenting,conversation,delete,feedback,message,note,notification,remove,sms,speech,texting,x)'),
            array('fas fa-comment-check' => 'comment-check(accept,agree,bubble,chat,commenting,conversation,feedback,message,note,notification,select,sms,speech,success,synced,texting,tick,todo)'),
            array('far fa-comment-check' => 'comment-check(accept,agree,bubble,chat,commenting,conversation,feedback,message,note,notification,select,sms,speech,success,synced,texting,tick,todo)'),
            array('fal fa-comment-check' => 'comment-check(accept,agree,bubble,chat,commenting,conversation,feedback,message,note,notification,select,sms,speech,success,synced,texting,tick,todo)'),
            array('fas fa-comment-dots' => 'comment-dots(bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)'),
            array('far fa-comment-dots' => 'comment-dots(bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)'),
            array('fal fa-comment-dots' => 'comment-dots(bubble,chat,commenting,conversation,feedback,message,more,note,notification,reply,sms,speech,texting)'),
            array('fas fa-comment-edit' => 'comment-edit(bubble,chat,commenting,conversation,edit,feedback,message,note,notification,pen,pencil,sms,speech,texting,update,write)'),
            array('far fa-comment-edit' => 'comment-edit(bubble,chat,commenting,conversation,edit,feedback,message,note,notification,pen,pencil,sms,speech,texting,update,write)'),
            array('fal fa-comment-edit' => 'comment-edit(bubble,chat,commenting,conversation,edit,feedback,message,note,notification,pen,pencil,sms,speech,texting,update,write)'),
            array('fas fa-comment-exclamation' => 'comment-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('far fa-comment-exclamation' => 'comment-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fal fa-comment-exclamation' => 'comment-exclamation(alert,bubble,chat,commenting,conversation,exclaim,feedback,important,message,note,notification,sms,speech,surprise,texting)'),
            array('fas fa-comment-lines' => 'comment-lines(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-lines' => 'comment-lines(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-lines' => 'comment-lines(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-medical' => 'comment-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('far fa-comment-medical' => 'comment-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fal fa-comment-medical' => 'comment-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fas fa-comment-minus' => 'comment-minus(bubble,chat,commenting,conversation,delete,feedback,message,negative,note,notification,remove,sms,speech,texting)'),
            array('far fa-comment-minus' => 'comment-minus(bubble,chat,commenting,conversation,delete,feedback,message,negative,note,notification,remove,sms,speech,texting)'),
            array('fal fa-comment-minus' => 'comment-minus(bubble,chat,commenting,conversation,delete,feedback,message,negative,note,notification,remove,sms,speech,texting)'),
            array('fas fa-comment-plus' => 'comment-plus(add,bubble,chat,commenting,conversation,create,feedback,message,new,note,notification,positive,sms,speech,texting)'),
            array('far fa-comment-plus' => 'comment-plus(add,bubble,chat,commenting,conversation,create,feedback,message,new,note,notification,positive,sms,speech,texting)'),
            array('fal fa-comment-plus' => 'comment-plus(add,bubble,chat,commenting,conversation,create,feedback,message,new,note,notification,positive,sms,speech,texting)'),
            array('fas fa-comment-slash' => 'comment-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('far fa-comment-slash' => 'comment-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fal fa-comment-slash' => 'comment-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fas fa-comment-smile' => 'comment-smile(bubble,chat,commenting,conversation,emoji,feedback,happy,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-smile' => 'comment-smile(bubble,chat,commenting,conversation,emoji,feedback,happy,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-smile' => 'comment-smile(bubble,chat,commenting,conversation,emoji,feedback,happy,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-times' => 'comment-times(archive,bubble,chat,commenting,conversation,delete,feedback,message,note,notification,remove,sms,speech,texting,x)'),
            array('far fa-comment-times' => 'comment-times(archive,bubble,chat,commenting,conversation,delete,feedback,message,note,notification,remove,sms,speech,texting,x)'),
            array('fal fa-comment-times' => 'comment-times(archive,bubble,chat,commenting,conversation,delete,feedback,message,note,notification,remove,sms,speech,texting,x)'),
            array('fas fa-comments' => 'comments(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comments' => 'comments(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comments' => 'comments(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comments-alt' => 'comments-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comments-alt' => 'comments-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comments-alt' => 'comments-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('far fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fal fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fas fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('far fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fal fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fas fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-plus' => 'phone-plus(add,call,earphone,number,positive,support,telephone,voice)'),
            array('far fa-phone-plus' => 'phone-plus(add,call,earphone,number,positive,support,telephone,voice)'),
            array('fal fa-phone-plus' => 'phone-plus(add,call,earphone,number,positive,support,telephone,voice)'),
            array('fas fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('far fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fal fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fas fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('far fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('fal fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('fas fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('far fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fal fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fas fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('far fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fal fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fas fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('far fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fal fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fas fa-smile-plus' => 'smile-plus(add,emoticon,face,happy,new)'),
            array('far fa-smile-plus' => 'smile-plus(add,emoticon,face,happy,new)'),
            array('fal fa-smile-plus' => 'smile-plus(add,emoticon,face,happy,new)'),
            array('fas fa-sms' => 'sms(chat,conversation,message,mobile,notification,phone,sms,texting)'),
            array('far fa-sms' => 'sms(chat,conversation,message,mobile,notification,phone,sms,texting)'),
            array('fal fa-sms' => 'sms(chat,conversation,message,mobile,notification,phone,sms,texting)'),
            array('fas fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('far fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('fal fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('fas fa-video-plus' => 'video-plus(add,create,film,new,positive,record,video)'),
            array('far fa-video-plus' => 'video-plus(add,create,film,new,positive,record,video)'),
            array('fal fa-video-plus' => 'video-plus(add,create,film,new,positive,record,video)'),
            array('fas fa-video-slash' => 'video-slash(add,create,film,new,positive,record,video)'),
            array('far fa-video-slash' => 'video-slash(add,create,film,new,positive,record,video)'),
            array('fal fa-video-slash' => 'video-slash(add,create,film,new,positive,record,video)'),
        ),
        'Chess' => array(
            array('fas fa-chess' => 'chess(board,checkmate,game,strategy,tournament)'),
            array('far fa-chess' => 'chess(board,checkmate,game,strategy,tournament)'),
            array('fal fa-chess' => 'chess(board,checkmate,game,strategy,tournament)'),
            array('fas fa-chess-bishop' => 'chess-bishop(board,checkmate,game,strategy)'),
            array('far fa-chess-bishop' => 'chess-bishop(board,checkmate,game,strategy)'),
            array('fal fa-chess-bishop' => 'chess-bishop(board,checkmate,game,strategy)'),
            array('fas fa-chess-bishop-alt' => 'chess-bishop-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-bishop-alt' => 'chess-bishop-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-bishop-alt' => 'chess-bishop-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-board' => 'chess-board(board,checkmate,game,strategy)'),
            array('far fa-chess-board' => 'chess-board(board,checkmate,game,strategy)'),
            array('fal fa-chess-board' => 'chess-board(board,checkmate,game,strategy)'),
            array('fas fa-chess-clock' => 'chess-clock(board,checkmate,game,strategy,timer,tournament)'),
            array('far fa-chess-clock' => 'chess-clock(board,checkmate,game,strategy,timer,tournament)'),
            array('fal fa-chess-clock' => 'chess-clock(board,checkmate,game,strategy,timer,tournament)'),
            array('fas fa-chess-clock-alt' => 'chess-clock-alt(board,checkmate,game,strategy,timer,tournament)'),
            array('far fa-chess-clock-alt' => 'chess-clock-alt(board,checkmate,game,strategy,timer,tournament)'),
            array('fal fa-chess-clock-alt' => 'chess-clock-alt(board,checkmate,game,strategy,timer,tournament)'),
            array('fas fa-chess-king' => 'chess-king(board,checkmate,game,strategy)'),
            array('far fa-chess-king' => 'chess-king(board,checkmate,game,strategy)'),
            array('fal fa-chess-king' => 'chess-king(board,checkmate,game,strategy)'),
            array('fas fa-chess-king-alt' => 'chess-king-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-king-alt' => 'chess-king-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-king-alt' => 'chess-king-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-knight' => 'chess-knight(board,checkmate,game,horse,strategy)'),
            array('far fa-chess-knight' => 'chess-knight(board,checkmate,game,horse,strategy)'),
            array('fal fa-chess-knight' => 'chess-knight(board,checkmate,game,horse,strategy)'),
            array('fas fa-chess-knight-alt' => 'chess-knight-alt(board,checkmate,game,horse,strategy)'),
            array('far fa-chess-knight-alt' => 'chess-knight-alt(board,checkmate,game,horse,strategy)'),
            array('fal fa-chess-knight-alt' => 'chess-knight-alt(board,checkmate,game,horse,strategy)'),
            array('fas fa-chess-pawn' => 'chess-pawn(board,checkmate,game,strategy)'),
            array('far fa-chess-pawn' => 'chess-pawn(board,checkmate,game,strategy)'),
            array('fal fa-chess-pawn' => 'chess-pawn(board,checkmate,game,strategy)'),
            array('fas fa-chess-pawn-alt' => 'chess-pawn-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-pawn-alt' => 'chess-pawn-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-pawn-alt' => 'chess-pawn-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-queen' => 'chess-queen(board,checkmate,game,strategy)'),
            array('far fa-chess-queen' => 'chess-queen(board,checkmate,game,strategy)'),
            array('fal fa-chess-queen' => 'chess-queen(board,checkmate,game,strategy)'),
            array('fas fa-chess-queen-alt' => 'chess-queen-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-queen-alt' => 'chess-queen-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-queen-alt' => 'chess-queen-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-rook' => 'chess-rook(board,castle,checkmate,game,strategy)'),
            array('far fa-chess-rook' => 'chess-rook(board,castle,checkmate,game,strategy)'),
            array('fal fa-chess-rook' => 'chess-rook(board,castle,checkmate,game,strategy)'),
            array('fas fa-chess-rook-alt' => 'chess-rook-alt(board,castle,checkmate,game,strategy)'),
            array('far fa-chess-rook-alt' => 'chess-rook-alt(board,castle,checkmate,game,strategy)'),
            array('fal fa-chess-rook-alt' => 'chess-rook-alt(board,castle,checkmate,game,strategy)'),
            array('fas fa-square-full' => 'square-full(block,box,shape)'),
            array('far fa-square-full' => 'square-full(block,box,shape)'),
            array('fal fa-square-full' => 'square-full(block,box,shape)'),
        ),
        'Childhood' => array(
            array('fas fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('far fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fal fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fas fa-baby' => 'baby(child,diaper,doll,human,infant,kid,offspring,person,sprout)'),
            array('far fa-baby' => 'baby(child,diaper,doll,human,infant,kid,offspring,person,sprout)'),
            array('fal fa-baby' => 'baby(child,diaper,doll,human,infant,kid,offspring,person,sprout)'),
            array('fas fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('far fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fal fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fas fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('far fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('fal fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('fas fa-baseball' => 'baseball(bat,league,mlb,slugger,softball,sport)'),
            array('far fa-baseball' => 'baseball(bat,league,mlb,slugger,softball,sport)'),
            array('fal fa-baseball' => 'baseball(bat,league,mlb,slugger,softball,sport)'),
            array('fas fa-basketball-hoop' => 'basketball-hoop(backboard,dunk,hoop,nba)'),
            array('far fa-basketball-hoop' => 'basketball-hoop(backboard,dunk,hoop,nba)'),
            array('fal fa-basketball-hoop' => 'basketball-hoop(backboard,dunk,hoop,nba)'),
            array('fas fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('far fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fal fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fas fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('far fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('fal fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('fas fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('far fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fal fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fas fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('far fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fal fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fas fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('far fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('fal fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('fas fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('far fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('fal fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('fas fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('far fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('fal fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('fas fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('far fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('fal fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('fas fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('far fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('fal fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('fas fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('far fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fal fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fas fa-robot' => 'robot(android,automate,computer,cyborg)'),
            array('far fa-robot' => 'robot(android,automate,computer,cyborg)'),
            array('fal fa-robot' => 'robot(android,automate,computer,cyborg)'),
            array('fas fa-school' => 'school(building,education,learn,student,teacher)'),
            array('far fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fal fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fas fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('far fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('fal fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('fas fa-snowman' => 'snowman(decoration,frost,frosty,holiday)'),
            array('far fa-snowman' => 'snowman(decoration,frost,frosty,holiday)'),
            array('fal fa-snowman' => 'snowman(decoration,frost,frosty,holiday)'),
        ),
        'Clothing' => array(
            array('fas fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('far fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fal fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fas fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('far fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fal fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fas fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('far fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('fal fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('fas fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('far fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('fal fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('fas fa-hat-witch' => 'hat-witch(accessory,clothing,halloween,head,holiday,mage,magic,sorceror)'),
            array('far fa-hat-witch' => 'hat-witch(accessory,clothing,halloween,head,holiday,mage,magic,sorceror)'),
            array('fal fa-hat-witch' => 'hat-witch(accessory,clothing,halloween,head,holiday,mage,magic,sorceror)'),
            array('fas fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('far fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fal fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fas fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('far fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('fal fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('fas fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('far fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fal fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fas fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('far fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fal fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fas fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('far fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('fal fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('fas fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('far fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('fal fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('fas fa-socks' => 'socks(business socks,business time,clothing,feet,flight of the conchords,wednesday)'),
            array('far fa-socks' => 'socks(business socks,business time,clothing,feet,flight of the conchords,wednesday)'),
            array('fal fa-socks' => 'socks(business socks,business time,clothing,feet,flight of the conchords,wednesday)'),
            array('fas fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('far fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('fal fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('fas fa-tshirt' => 'tshirt(clothing,fashion,garment,shirt)'),
            array('far fa-tshirt' => 'tshirt(clothing,fashion,garment,shirt)'),
            array('fal fa-tshirt' => 'tshirt(clothing,fashion,garment,shirt)'),
            array('fas fa-user-tie' => 'user-tie(avatar,business,clothing,formal,professional,suit)'),
            array('far fa-user-tie' => 'user-tie(avatar,business,clothing,formal,professional,suit)'),
            array('fal fa-user-tie' => 'user-tie(avatar,business,clothing,formal,professional,suit)'),
        ),
        'Code' => array(
            array('fas fa-archive' => 'archive(box,package,save,storage)'),
            array('far fa-archive' => 'archive(box,package,save,storage)'),
            array('fal fa-archive' => 'archive(box,package,save,storage)'),
            array('fas fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('far fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('fal fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('fas fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('far fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fal fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fas fa-brackets' => 'brackets(code,developer,development,parentheses)'),
            array('far fa-brackets' => 'brackets(code,developer,development,parentheses)'),
            array('fal fa-brackets' => 'brackets(code,developer,development,parentheses)'),
            array('fas fa-brackets-curly' => 'brackets-curly(code,developer,development,parentheses)'),
            array('far fa-brackets-curly' => 'brackets-curly(code,developer,development,parentheses)'),
            array('fal fa-brackets-curly' => 'brackets-curly(code,developer,development,parentheses)'),
            array('fas fa-browser' => 'browser(app,application,desktop,explorer,internet,web,website)'),
            array('far fa-browser' => 'browser(app,application,desktop,explorer,internet,web,website)'),
            array('fal fa-browser' => 'browser(app,application,desktop,explorer,internet,web,website)'),
            array('fas fa-bug' => 'bug(beetle,error,insect,report)'),
            array('far fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fal fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fas fa-code' => 'code(brackets,code,development,html)'),
            array('far fa-code' => 'code(brackets,code,development,html)'),
            array('fal fa-code' => 'code(brackets,code,development,html)'),
            array('fas fa-code-branch' => 'code-branch(branch,code-fork,fork,git,github,rebase,svn,vcs,version)'),
            array('far fa-code-branch' => 'code-branch(branch,code-fork,fork,git,github,rebase,svn,vcs,version)'),
            array('fal fa-code-branch' => 'code-branch(branch,code-fork,fork,git,github,rebase,svn,vcs,version)'),
            array('fas fa-code-commit' => 'code-commit(commit,git,github,hash,rebase,svn,vcs,version)'),
            array('far fa-code-commit' => 'code-commit(commit,git,github,hash,rebase,svn,vcs,version)'),
            array('fal fa-code-commit' => 'code-commit(commit,git,github,hash,rebase,svn,vcs,version)'),
            array('fas fa-code-merge' => 'code-merge(git,github,merge,pr,rebase,svn,vcs,version)'),
            array('far fa-code-merge' => 'code-merge(git,github,merge,pr,rebase,svn,vcs,version)'),
            array('fal fa-code-merge' => 'code-merge(git,github,merge,pr,rebase,svn,vcs,version)'),
            array('fas fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('far fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fal fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-file-code' => 'file-code(css,development,document,html)'),
            array('far fa-file-code' => 'file-code(css,development,document,html)'),
            array('fal fa-file-code' => 'file-code(css,development,document,html)'),
            array('fas fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('far fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('fal fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('fas fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('far fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('fal fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('fas fa-folder' => 'folder(archive,directory,document,file)'),
            array('far fa-folder' => 'folder(archive,directory,document,file)'),
            array('fal fa-folder' => 'folder(archive,directory,document,file)'),
            array('fas fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('far fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fal fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fas fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('far fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fal fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fas fa-laptop-code' => 'laptop-code(computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)'),
            array('far fa-laptop-code' => 'laptop-code(computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)'),
            array('fal fa-laptop-code' => 'laptop-code(computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)'),
            array('fas fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('far fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('fal fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('fas fa-project-diagram' => 'project-diagram(chart,graph,network,pert)'),
            array('far fa-project-diagram' => 'project-diagram(chart,graph,network,pert)'),
            array('fal fa-project-diagram' => 'project-diagram(chart,graph,network,pert)'),
            array('fas fa-qrcode' => 'qrcode(barcode,info,information,scan)'),
            array('far fa-qrcode' => 'qrcode(barcode,info,information,scan)'),
            array('fal fa-qrcode' => 'qrcode(barcode,info,information,scan)'),
            array('fas fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('far fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fal fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fas fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('far fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fal fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fas fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('far fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('fal fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('fas fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('far fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('fal fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('fas fa-stream' => 'stream(flow,list,timeline)'),
            array('far fa-stream' => 'stream(flow,list,timeline)'),
            array('fal fa-stream' => 'stream(flow,list,timeline)'),
            array('fas fa-terminal' => 'terminal(code,command,console,development,prompt)'),
            array('far fa-terminal' => 'terminal(code,command,console,development,prompt)'),
            array('fal fa-terminal' => 'terminal(code,command,console,development,prompt)'),
            array('fas fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('far fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('fal fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('fas fa-window' => 'window(browser,computer,development)'),
            array('far fa-window' => 'window(browser,computer,development)'),
            array('fal fa-window' => 'window(browser,computer,development)'),
            array('fas fa-window-alt' => 'window-alt(browser,computer,development)'),
            array('far fa-window-alt' => 'window-alt(browser,computer,development)'),
            array('fal fa-window-alt' => 'window-alt(browser,computer,development)'),
            array('fas fa-window-close' => 'window-close(browser,cancel,computer,development)'),
            array('far fa-window-close' => 'window-close(browser,cancel,computer,development)'),
            array('fal fa-window-close' => 'window-close(browser,cancel,computer,development)'),
            array('fas fa-window-maximize' => 'window-maximize(browser,computer,development,expand)'),
            array('far fa-window-maximize' => 'window-maximize(browser,computer,development,expand)'),
            array('fal fa-window-maximize' => 'window-maximize(browser,computer,development,expand)'),
            array('fas fa-window-minimize' => 'window-minimize(browser,collapse,computer,development)'),
            array('far fa-window-minimize' => 'window-minimize(browser,collapse,computer,development)'),
            array('fal fa-window-minimize' => 'window-minimize(browser,collapse,computer,development)'),
            array('fas fa-window-restore' => 'window-restore(browser,computer,development)'),
            array('far fa-window-restore' => 'window-restore(browser,computer,development)'),
            array('fal fa-window-restore' => 'window-restore(browser,computer,development)'),
        ),
        'Communication' => array(
            array('fas fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('far fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('fal fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('fas fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('far fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('fal fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('fas fa-american-sign-language-interpreting' => 'american-sign-language-interpreting(asl,deaf,finger,hand,interpret,speak)'),
            array('far fa-american-sign-language-interpreting' => 'american-sign-language-interpreting(asl,deaf,finger,hand,interpret,speak)'),
            array('fal fa-american-sign-language-interpreting' => 'american-sign-language-interpreting(asl,deaf,finger,hand,interpret,speak)'),
            array('fas fa-assistive-listening-systems' => 'assistive-listening-systems(amplify,audio,deaf,ear,headset,hearing,sound)'),
            array('far fa-assistive-listening-systems' => 'assistive-listening-systems(amplify,audio,deaf,ear,headset,hearing,sound)'),
            array('fal fa-assistive-listening-systems' => 'assistive-listening-systems(amplify,audio,deaf,ear,headset,hearing,sound)'),
            array('fas fa-at' => 'at(address,author,e-mail,email,handle)'),
            array('far fa-at' => 'at(address,author,e-mail,email,handle)'),
            array('fal fa-at' => 'at(address,author,e-mail,email,handle)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('far fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fal fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fab fa-bluetooth' => 'bluetooth'),
            array('fab fa-bluetooth-b' => 'bluetooth-b'),
            array('fas fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('far fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fal fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fas fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('far fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fal fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fas fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('far fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('fal fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('fas fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comments' => 'comments(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comments' => 'comments(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comments' => 'comments(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-envelope-square' => 'envelope-square(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-square' => 'envelope-square(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-square' => 'envelope-square(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('far fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('fal fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('fas fa-inbox' => 'inbox(archive,desk,email,mail,message)'),
            array('far fa-inbox' => 'inbox(archive,desk,email,mail,message)'),
            array('fal fa-inbox' => 'inbox(archive,desk,email,mail,message)'),
            array('fas fa-inbox-in' => 'inbox-in(archive,desk,email,mail,message)'),
            array('far fa-inbox-in' => 'inbox-in(archive,desk,email,mail,message)'),
            array('fal fa-inbox-in' => 'inbox-in(archive,desk,email,mail,message)'),
            array('fas fa-inbox-out' => 'inbox-out(archive,desk,email,mail,message)'),
            array('far fa-inbox-out' => 'inbox-out(archive,desk,email,mail,message)'),
            array('fal fa-inbox-out' => 'inbox-out(archive,desk,email,mail,message)'),
            array('fas fa-language' => 'language(dialect,idiom,localize,speech,translate,vernacular)'),
            array('far fa-language' => 'language(dialect,idiom,localize,speech,translate,vernacular)'),
            array('fal fa-language' => 'language(dialect,idiom,localize,speech,translate,vernacular)'),
            array('fas fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fas fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('far fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fal fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fas fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('far fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fal fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fas fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('far fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fal fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fas fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('far fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fal fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fas fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('far fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fal fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fas fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('far fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fal fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fas fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('far fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fal fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fas fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('far fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('fal fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('fas fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('far fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('fal fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('fas fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('far fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('fal fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('fas fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('far fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fal fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fas fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('far fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fal fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fas fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('far fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fal fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
        ),
        'Computers' => array(
            array('fas fa-brackets' => 'brackets(code,developer,development,parentheses)'),
            array('far fa-brackets' => 'brackets(code,developer,development,parentheses)'),
            array('fal fa-brackets' => 'brackets(code,developer,development,parentheses)'),
            array('fas fa-brackets-curly' => 'brackets-curly(code,developer,development,parentheses)'),
            array('far fa-brackets-curly' => 'brackets-curly(code,developer,development,parentheses)'),
            array('fal fa-brackets-curly' => 'brackets-curly(code,developer,development,parentheses)'),
            array('fas fa-database' => 'database(computer,development,directory,memory,storage)'),
            array('far fa-database' => 'database(computer,development,directory,memory,storage)'),
            array('fal fa-database' => 'database(computer,development,directory,memory,storage)'),
            array('fas fa-desktop' => 'desktop(computer,cpu,demo,desktop,device,imac,machine,monitor,pc,screen)'),
            array('far fa-desktop' => 'desktop(computer,cpu,demo,desktop,device,imac,machine,monitor,pc,screen)'),
            array('fal fa-desktop' => 'desktop(computer,cpu,demo,desktop,device,imac,machine,monitor,pc,screen)'),
            array('fas fa-desktop-alt' => 'desktop-alt(apple,computer,cpu,demo,desktop,device,imac,machine,monitor,screen)'),
            array('far fa-desktop-alt' => 'desktop-alt(apple,computer,cpu,demo,desktop,device,imac,machine,monitor,screen)'),
            array('fal fa-desktop-alt' => 'desktop-alt(apple,computer,cpu,demo,desktop,device,imac,machine,monitor,screen)'),
            array('fas fa-download' => 'download(export,hard drive,save,transfer)'),
            array('far fa-download' => 'download(export,hard drive,save,transfer)'),
            array('fal fa-download' => 'download(export,hard drive,save,transfer)'),
            array('fas fa-ethernet' => 'ethernet(cable,cat 5,cat 6,connection,hardware,internet,network,wired)'),
            array('far fa-ethernet' => 'ethernet(cable,cat 5,cat 6,connection,hardware,internet,network,wired)'),
            array('fal fa-ethernet' => 'ethernet(cable,cat 5,cat 6,connection,hardware,internet,network,wired)'),
            array('fas fa-hdd' => 'hdd(cpu,hard drive,harddrive,machine,save,storage)'),
            array('far fa-hdd' => 'hdd(cpu,hard drive,harddrive,machine,save,storage)'),
            array('fal fa-hdd' => 'hdd(cpu,hard drive,harddrive,machine,save,storage)'),
            array('fas fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('far fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fal fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fas fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('far fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fal fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fas fa-laptop' => 'laptop(computer,cpu,dell,demo,device,mac,macbook,machine,pc)'),
            array('far fa-laptop' => 'laptop(computer,cpu,dell,demo,device,mac,macbook,machine,pc)'),
            array('fal fa-laptop' => 'laptop(computer,cpu,dell,demo,device,mac,macbook,machine,pc)'),
            array('fas fa-memory' => 'memory(DIMM,RAM,hardware,storage,technology)'),
            array('far fa-memory' => 'memory(DIMM,RAM,hardware,storage,technology)'),
            array('fal fa-memory' => 'memory(DIMM,RAM,hardware,storage,technology)'),
            array('fas fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('far fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('fal fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('fas fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('far fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fal fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fas fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('far fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fal fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fas fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('far fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fal fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fas fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('far fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fal fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fas fa-plug' => 'plug(connect,electric,online,power)'),
            array('far fa-plug' => 'plug(connect,electric,online,power)'),
            array('fal fa-plug' => 'plug(connect,electric,online,power)'),
            array('fas fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('far fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('fal fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('fas fa-print' => 'print(business,copy,document,office,paper)'),
            array('far fa-print' => 'print(business,copy,document,office,paper)'),
            array('fal fa-print' => 'print(business,copy,document,office,paper)'),
            array('fas fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('far fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('fal fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('fas fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('far fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('fal fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('fas fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('far fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fal fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fas fa-sd-card' => 'sd-card(image,memory,photo,save)'),
            array('far fa-sd-card' => 'sd-card(image,memory,photo,save)'),
            array('fal fa-sd-card' => 'sd-card(image,memory,photo,save)'),
            array('fas fa-server' => 'server(computer,cpu,database,hardware,network)'),
            array('far fa-server' => 'server(computer,cpu,database,hardware,network)'),
            array('fal fa-server' => 'server(computer,cpu,database,hardware,network)'),
            array('fas fa-sim-card' => 'sim-card(hard drive,hardware,portable,storage,technology,tiny)'),
            array('far fa-sim-card' => 'sim-card(hard drive,hardware,portable,storage,technology,tiny)'),
            array('fal fa-sim-card' => 'sim-card(hard drive,hardware,portable,storage,technology,tiny)'),
            array('fas fa-stream' => 'stream(flow,list,timeline)'),
            array('far fa-stream' => 'stream(flow,list,timeline)'),
            array('fal fa-stream' => 'stream(flow,list,timeline)'),
            array('fas fa-tablet' => 'tablet(apple,device,ipad,kindle,screen)'),
            array('far fa-tablet' => 'tablet(apple,device,ipad,kindle,screen)'),
            array('fal fa-tablet' => 'tablet(apple,device,ipad,kindle,screen)'),
            array('fas fa-tablet-alt' => 'tablet-alt(apple,device,ipad,kindle,screen)'),
            array('far fa-tablet-alt' => 'tablet-alt(apple,device,ipad,kindle,screen)'),
            array('fal fa-tablet-alt' => 'tablet-alt(apple,device,ipad,kindle,screen)'),
            array('fas fa-tablet-android' => 'tablet-android(device,kindle,screen)'),
            array('far fa-tablet-android' => 'tablet-android(device,kindle,screen)'),
            array('fal fa-tablet-android' => 'tablet-android(device,kindle,screen)'),
            array('fas fa-tablet-android-alt' => 'tablet-android-alt(device,kindle,screen)'),
            array('far fa-tablet-android-alt' => 'tablet-android-alt(device,kindle,screen)'),
            array('fal fa-tablet-android-alt' => 'tablet-android-alt(device,kindle,screen)'),
            array('fas fa-tv' => 'tv(computer,display,monitor,television)'),
            array('far fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fal fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fas fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('far fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('fal fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('fas fa-upload' => 'upload(hard drive,import,publish)'),
            array('far fa-upload' => 'upload(hard drive,import,publish)'),
            array('fal fa-upload' => 'upload(hard drive,import,publish)'),
            array('fas fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('far fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fal fa-webcam' => 'webcam(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fas fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('far fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
            array('fal fa-webcam-slash' => 'webcam-slash(chat,conference call,facetime,podcast,video,videoconferencing,youtube)'),
        ),
        'Construction' => array(
            array('fas fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('far fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('fal fa-axe' => 'axe(blade,cut,fall,lumberjack,outdoors,sharp,swing,tool,weapon)'),
            array('fas fa-brush' => 'brush(art,bristles,color,handle,paint)'),
            array('far fa-brush' => 'brush(art,bristles,color,handle,paint)'),
            array('fal fa-brush' => 'brush(art,bristles,color,handle,paint)'),
            array('fas fa-drafting-compass' => 'drafting-compass(design,map,mechanical drawing,plot,plotting)'),
            array('far fa-drafting-compass' => 'drafting-compass(design,map,mechanical drawing,plot,plotting)'),
            array('fal fa-drafting-compass' => 'drafting-compass(design,map,mechanical drawing,plot,plotting)'),
            array('fas fa-dumpster' => 'dumpster(alley,bin,commercial,trash,waste)'),
            array('far fa-dumpster' => 'dumpster(alley,bin,commercial,trash,waste)'),
            array('fal fa-dumpster' => 'dumpster(alley,bin,commercial,trash,waste)'),
            array('fas fa-forklift' => 'forklift(archive,inventory,lorry,pallet,shipping,tractor,warehouse)'),
            array('far fa-forklift' => 'forklift(archive,inventory,lorry,pallet,shipping,tractor,warehouse)'),
            array('fal fa-forklift' => 'forklift(archive,inventory,lorry,pallet,shipping,tractor,warehouse)'),
            array('fas fa-hammer' => 'hammer(admin,fix,repair,settings,tool)'),
            array('far fa-hammer' => 'hammer(admin,fix,repair,settings,tool)'),
            array('fal fa-hammer' => 'hammer(admin,fix,repair,settings,tool)'),
            array('fas fa-hard-hat' => 'hard-hat(construction,hardhat,helmet,safety)'),
            array('far fa-hard-hat' => 'hard-hat(construction,hardhat,helmet,safety)'),
            array('fal fa-hard-hat' => 'hard-hat(construction,hardhat,helmet,safety)'),
            array('fas fa-paint-roller' => 'paint-roller(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('far fa-paint-roller' => 'paint-roller(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fal fa-paint-roller' => 'paint-roller(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fas fa-pencil' => 'pencil(design,edit,update,write)'),
            array('far fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fal fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fas fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('far fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fal fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fas fa-pencil-ruler' => 'pencil-ruler(design,draft,draw,pencil)'),
            array('far fa-pencil-ruler' => 'pencil-ruler(design,draft,draw,pencil)'),
            array('fal fa-pencil-ruler' => 'pencil-ruler(design,draft,draw,pencil)'),
            array('fas fa-ruler' => 'ruler(design,draft,length,measure,planning)'),
            array('far fa-ruler' => 'ruler(design,draft,length,measure,planning)'),
            array('fal fa-ruler' => 'ruler(design,draft,length,measure,planning)'),
            array('fas fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('far fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('fal fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('fas fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('far fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('fal fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('fas fa-ruler-triangle' => 'ruler-triangle(design,draft,length,measure,planning)'),
            array('far fa-ruler-triangle' => 'ruler-triangle(design,draft,length,measure,planning)'),
            array('fal fa-ruler-triangle' => 'ruler-triangle(design,draft,length,measure,planning)'),
            array('fas fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('far fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('fal fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('fas fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('far fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fal fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fas fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('far fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fal fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fas fa-toolbox' => 'toolbox(admin,container,fix,repair,settings,tools)'),
            array('far fa-toolbox' => 'toolbox(admin,container,fix,repair,settings,tools)'),
            array('fal fa-toolbox' => 'toolbox(admin,container,fix,repair,settings,tools)'),
            array('fas fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('far fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fal fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fas fa-traffic-cone' => 'traffic-cone(alert,construction,road)'),
            array('far fa-traffic-cone' => 'traffic-cone(alert,construction,road)'),
            array('fal fa-traffic-cone' => 'traffic-cone(alert,construction,road)'),
            array('fas fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('fas fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('far fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('fal fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('fas fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('far fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('fal fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('fas fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('far fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('fal fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
        ),
        'Currency' => array(
            array('fab fa-bitcoin' => 'bitcoin'),
            array('fab fa-btc' => 'btc'),
            array('fas fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('far fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('fal fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('fab fa-ethereum' => 'ethereum'),
            array('fas fa-euro-sign' => 'euro-sign(currency,dollar,exchange,money)'),
            array('far fa-euro-sign' => 'euro-sign(currency,dollar,exchange,money)'),
            array('fal fa-euro-sign' => 'euro-sign(currency,dollar,exchange,money)'),
            array('fab fa-gg' => 'gg'),
            array('fab fa-gg-circle' => 'gg-circle'),
            array('fas fa-hryvnia' => 'hryvnia(currency,money,ukraine,ukrainian)'),
            array('far fa-hryvnia' => 'hryvnia(currency,money,ukraine,ukrainian)'),
            array('fal fa-hryvnia' => 'hryvnia(currency,money,ukraine,ukrainian)'),
            array('fas fa-lira-sign' => 'lira-sign(currency,money,try,turkish)'),
            array('far fa-lira-sign' => 'lira-sign(currency,money,try,turkish)'),
            array('fal fa-lira-sign' => 'lira-sign(currency,money,try,turkish)'),
            array('fas fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-wave' => 'money-bill-wave(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-wave' => 'money-bill-wave(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-wave' => 'money-bill-wave(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-wave-alt' => 'money-bill-wave-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-wave-alt' => 'money-bill-wave-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-wave-alt' => 'money-bill-wave-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fas fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fas fa-pound-sign' => 'pound-sign(currency,gbp,money)'),
            array('far fa-pound-sign' => 'pound-sign(currency,gbp,money)'),
            array('fal fa-pound-sign' => 'pound-sign(currency,gbp,money)'),
            array('fas fa-ruble-sign' => 'ruble-sign(currency,money,rub)'),
            array('far fa-ruble-sign' => 'ruble-sign(currency,money,rub)'),
            array('fal fa-ruble-sign' => 'ruble-sign(currency,money,rub)'),
            array('fas fa-rupee-sign' => 'rupee-sign(currency,indian,inr,money)'),
            array('far fa-rupee-sign' => 'rupee-sign(currency,indian,inr,money)'),
            array('fal fa-rupee-sign' => 'rupee-sign(currency,indian,inr,money)'),
            array('fas fa-sack' => 'sack(bag,burlap,money,santa)'),
            array('far fa-sack' => 'sack(bag,burlap,money,santa)'),
            array('fal fa-sack' => 'sack(bag,burlap,money,santa)'),
            array('fas fa-sack-dollar' => 'sack-dollar(bag,burlap,cash,dollar,money,robber,santa,usd)'),
            array('far fa-sack-dollar' => 'sack-dollar(bag,burlap,cash,dollar,money,robber,santa,usd)'),
            array('fal fa-sack-dollar' => 'sack-dollar(bag,burlap,cash,dollar,money,robber,santa,usd)'),
            array('fas fa-shekel-sign' => 'shekel-sign(currency,ils,money)'),
            array('far fa-shekel-sign' => 'shekel-sign(currency,ils,money)'),
            array('fal fa-shekel-sign' => 'shekel-sign(currency,ils,money)'),
            array('fas fa-tenge' => 'tenge(currency,kazakhstan,money,price)'),
            array('far fa-tenge' => 'tenge(currency,kazakhstan,money,price)'),
            array('fal fa-tenge' => 'tenge(currency,kazakhstan,money,price)'),
            array('fas fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('far fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('fal fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('fas fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('far fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('fal fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('fas fa-won-sign' => 'won-sign(currency,krw,money)'),
            array('far fa-won-sign' => 'won-sign(currency,krw,money)'),
            array('fal fa-won-sign' => 'won-sign(currency,krw,money)'),
            array('fas fa-yen-sign' => 'yen-sign(currency,jpy,money)'),
            array('far fa-yen-sign' => 'yen-sign(currency,jpy,money)'),
            array('fal fa-yen-sign' => 'yen-sign(currency,jpy,money)'),
        ),
        'Date & Time' => array(
            array('fas fa-alarm-clock' => 'alarm-clock(date,late,reminder,sleep,snooze,timer,timestamp,watch)'),
            array('far fa-alarm-clock' => 'alarm-clock(date,late,reminder,sleep,snooze,timer,timestamp,watch)'),
            array('fal fa-alarm-clock' => 'alarm-clock(date,late,reminder,sleep,snooze,timer,timestamp,watch)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('far fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fal fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fas fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('far fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fal fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fas fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('far fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fal fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fas fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('far fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('fal fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('fas fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('far fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('fal fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('fas fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('far fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fal fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fas fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('far fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('fal fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('fas fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('far fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('fal fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('fas fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('far fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('fal fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('fas fa-clock' => 'clock(date,late,schedule,time,timer,timestamp,watch)'),
            array('far fa-clock' => 'clock(date,late,schedule,time,timer,timestamp,watch)'),
            array('fal fa-clock' => 'clock(date,late,schedule,time,timer,timestamp,watch)'),
            array('fas fa-hourglass' => 'hourglass(hour,minute,sand,stopwatch,time)'),
            array('far fa-hourglass' => 'hourglass(hour,minute,sand,stopwatch,time)'),
            array('fal fa-hourglass' => 'hourglass(hour,minute,sand,stopwatch,time)'),
            array('fas fa-hourglass-end' => 'hourglass-end(hour,minute,sand,stopwatch,time)'),
            array('far fa-hourglass-end' => 'hourglass-end(hour,minute,sand,stopwatch,time)'),
            array('fal fa-hourglass-end' => 'hourglass-end(hour,minute,sand,stopwatch,time)'),
            array('fas fa-hourglass-half' => 'hourglass-half(hour,minute,sand,stopwatch,time)'),
            array('far fa-hourglass-half' => 'hourglass-half(hour,minute,sand,stopwatch,time)'),
            array('fal fa-hourglass-half' => 'hourglass-half(hour,minute,sand,stopwatch,time)'),
            array('fas fa-hourglass-start' => 'hourglass-start(hour,minute,sand,stopwatch,time)'),
            array('far fa-hourglass-start' => 'hourglass-start(hour,minute,sand,stopwatch,time)'),
            array('fal fa-hourglass-start' => 'hourglass-start(hour,minute,sand,stopwatch,time)'),
            array('fas fa-stopwatch' => 'stopwatch(clock,reminder,time)'),
            array('far fa-stopwatch' => 'stopwatch(clock,reminder,time)'),
            array('fal fa-stopwatch' => 'stopwatch(clock,reminder,time)'),
            array('fas fa-watch' => 'watch(alert,clock,time,wristwatch)'),
            array('far fa-watch' => 'watch(alert,clock,time,wristwatch)'),
            array('fal fa-watch' => 'watch(alert,clock,time,wristwatch)'),
        ),
        'Design' => array(
            array('fas fa-adjust' => 'adjust(contrast,dark,light,saturation)'),
            array('far fa-adjust' => 'adjust(contrast,dark,light,saturation)'),
            array('fal fa-adjust' => 'adjust(contrast,dark,light,saturation)'),
            array('fas fa-bezier-curve' => 'bezier-curve(curves,illustrator,lines,path,vector)'),
            array('far fa-bezier-curve' => 'bezier-curve(curves,illustrator,lines,path,vector)'),
            array('fal fa-bezier-curve' => 'bezier-curve(curves,illustrator,lines,path,vector)'),
            array('fas fa-brush' => 'brush(art,bristles,color,handle,paint)'),
            array('far fa-brush' => 'brush(art,bristles,color,handle,paint)'),
            array('fal fa-brush' => 'brush(art,bristles,color,handle,paint)'),
            array('fas fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('far fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fal fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fas fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('far fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fal fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fas fa-crop' => 'crop(design,frame,mask,resize,shrink)'),
            array('far fa-crop' => 'crop(design,frame,mask,resize,shrink)'),
            array('fal fa-crop' => 'crop(design,frame,mask,resize,shrink)'),
            array('fas fa-crop-alt' => 'crop-alt(design,frame,mask,resize,shrink)'),
            array('far fa-crop-alt' => 'crop-alt(design,frame,mask,resize,shrink)'),
            array('fal fa-crop-alt' => 'crop-alt(design,frame,mask,resize,shrink)'),
            array('fas fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('far fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('fal fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('fas fa-cut' => 'cut(clip,scissors,snip)'),
            array('far fa-cut' => 'cut(clip,scissors,snip)'),
            array('fal fa-cut' => 'cut(clip,scissors,snip)'),
            array('fas fa-drafting-compass' => 'drafting-compass(design,map,mechanical drawing,plot,plotting)'),
            array('far fa-drafting-compass' => 'drafting-compass(design,map,mechanical drawing,plot,plotting)'),
            array('fal fa-drafting-compass' => 'drafting-compass(design,map,mechanical drawing,plot,plotting)'),
            array('fas fa-draw-circle' => 'draw-circle(anchors,lines,object,render,shape)'),
            array('far fa-draw-circle' => 'draw-circle(anchors,lines,object,render,shape)'),
            array('fal fa-draw-circle' => 'draw-circle(anchors,lines,object,render,shape)'),
            array('fas fa-draw-polygon' => 'draw-polygon(anchors,lines,object,render,shape)'),
            array('far fa-draw-polygon' => 'draw-polygon(anchors,lines,object,render,shape)'),
            array('fal fa-draw-polygon' => 'draw-polygon(anchors,lines,object,render,shape)'),
            array('fas fa-draw-square' => 'draw-square(anchors,lines,object,render,shape)'),
            array('far fa-draw-square' => 'draw-square(anchors,lines,object,render,shape)'),
            array('fal fa-draw-square' => 'draw-square(anchors,lines,object,render,shape)'),
            array('fas fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('far fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fal fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fas fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('far fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fal fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fas fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('far fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fal fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fas fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('far fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fal fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fas fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('far fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fal fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fas fa-fill' => 'fill(bucket,color,paint,paint bucket)'),
            array('far fa-fill' => 'fill(bucket,color,paint,paint bucket)'),
            array('fal fa-fill' => 'fill(bucket,color,paint,paint bucket)'),
            array('fas fa-fill-drip' => 'fill-drip(bucket,color,drop,paint,paint bucket,spill)'),
            array('far fa-fill-drip' => 'fill-drip(bucket,color,drop,paint,paint bucket,spill)'),
            array('fal fa-fill-drip' => 'fill-drip(bucket,color,drop,paint,paint bucket,spill)'),
            array('fas fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('far fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fal fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fas fa-layer-group' => 'layer-group(arrange,develop,layers,map,stack)'),
            array('far fa-layer-group' => 'layer-group(arrange,develop,layers,map,stack)'),
            array('fal fa-layer-group' => 'layer-group(arrange,develop,layers,map,stack)'),
            array('fas fa-layer-minus' => 'layer-minus(arrange,delete,negative,remove,stack)'),
            array('far fa-layer-minus' => 'layer-minus(arrange,delete,negative,remove,stack)'),
            array('fal fa-layer-minus' => 'layer-minus(arrange,delete,negative,remove,stack)'),
            array('fas fa-layer-plus' => 'layer-plus(add,arrange,create,new,positive,stack)'),
            array('far fa-layer-plus' => 'layer-plus(add,arrange,create,new,positive,stack)'),
            array('fal fa-layer-plus' => 'layer-plus(add,arrange,create,new,positive,stack)'),
            array('fas fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('far fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('fal fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('fas fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('far fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fal fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fas fa-object-group' => 'object-group(combine,copy,design,merge,select)'),
            array('far fa-object-group' => 'object-group(combine,copy,design,merge,select)'),
            array('fal fa-object-group' => 'object-group(combine,copy,design,merge,select)'),
            array('fas fa-object-ungroup' => 'object-ungroup(copy,design,merge,select,separate)'),
            array('far fa-object-ungroup' => 'object-ungroup(copy,design,merge,select,separate)'),
            array('fal fa-object-ungroup' => 'object-ungroup(copy,design,merge,select,separate)'),
            array('fas fa-paint-brush' => 'paint-brush(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('far fa-paint-brush' => 'paint-brush(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fal fa-paint-brush' => 'paint-brush(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fas fa-paint-brush-alt' => 'paint-brush-alt(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('far fa-paint-brush-alt' => 'paint-brush-alt(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fal fa-paint-brush-alt' => 'paint-brush-alt(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fas fa-paint-roller' => 'paint-roller(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('far fa-paint-roller' => 'paint-roller(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fal fa-paint-roller' => 'paint-roller(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fas fa-palette' => 'palette(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('far fa-palette' => 'palette(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fal fa-palette' => 'palette(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fas fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('far fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fal fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fas fa-pen' => 'pen(design,edit,update,write)'),
            array('far fa-pen' => 'pen(design,edit,update,write)'),
            array('fal fa-pen' => 'pen(design,edit,update,write)'),
            array('fas fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('far fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fal fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fas fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('far fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fas fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('far fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fas fa-pencil' => 'pencil(design,edit,update,write)'),
            array('far fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fal fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fas fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('far fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fal fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fas fa-pencil-ruler' => 'pencil-ruler(design,draft,draw,pencil)'),
            array('far fa-pencil-ruler' => 'pencil-ruler(design,draft,draw,pencil)'),
            array('fal fa-pencil-ruler' => 'pencil-ruler(design,draft,draw,pencil)'),
            array('fas fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('far fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('fal fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('fas fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('far fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('fal fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('fas fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('far fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('fal fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('fas fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('far fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fal fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fas fa-splotch' => 'splotch(Ink,blob,blotch,glob,stain)'),
            array('far fa-splotch' => 'splotch(Ink,blob,blotch,glob,stain)'),
            array('fal fa-splotch' => 'splotch(Ink,blob,blotch,glob,stain)'),
            array('fas fa-spray-can' => 'spray-can(Paint,aerosol,design,graffiti,tag)'),
            array('far fa-spray-can' => 'spray-can(Paint,aerosol,design,graffiti,tag)'),
            array('fal fa-spray-can' => 'spray-can(Paint,aerosol,design,graffiti,tag)'),
            array('fas fa-stamp' => 'stamp(art,certificate,imprint,rubber,seal)'),
            array('far fa-stamp' => 'stamp(art,certificate,imprint,rubber,seal)'),
            array('fal fa-stamp' => 'stamp(art,certificate,imprint,rubber,seal)'),
            array('fas fa-swatchbook' => 'swatchbook(Pantone,color,design,hue,palette)'),
            array('far fa-swatchbook' => 'swatchbook(Pantone,color,design,hue,palette)'),
            array('fal fa-swatchbook' => 'swatchbook(Pantone,color,design,hue,palette)'),
            array('fas fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('far fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('fal fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('fas fa-tint-slash' => 'tint-slash(color,drop,droplet,raindrop,waterdrop)'),
            array('far fa-tint-slash' => 'tint-slash(color,drop,droplet,raindrop,waterdrop)'),
            array('fal fa-tint-slash' => 'tint-slash(color,drop,droplet,raindrop,waterdrop)'),
            array('fas fa-vector-square' => 'vector-square(anchors,lines,object,render,shape)'),
            array('far fa-vector-square' => 'vector-square(anchors,lines,object,render,shape)'),
            array('fal fa-vector-square' => 'vector-square(anchors,lines,object,render,shape)'),
        ),
        'Editors' => array(
            array('fas fa-align-center' => 'align-center(format,middle,paragraph,text)'),
            array('far fa-align-center' => 'align-center(format,middle,paragraph,text)'),
            array('fal fa-align-center' => 'align-center(format,middle,paragraph,text)'),
            array('fas fa-align-justify' => 'align-justify(format,paragraph,text)'),
            array('far fa-align-justify' => 'align-justify(format,paragraph,text)'),
            array('fal fa-align-justify' => 'align-justify(format,paragraph,text)'),
            array('fas fa-align-left' => 'align-left(format,paragraph,text)'),
            array('far fa-align-left' => 'align-left(format,paragraph,text)'),
            array('fal fa-align-left' => 'align-left(format,paragraph,text)'),
            array('fas fa-align-right' => 'align-right(format,paragraph,text)'),
            array('far fa-align-right' => 'align-right(format,paragraph,text)'),
            array('fal fa-align-right' => 'align-right(format,paragraph,text)'),
            array('fas fa-bold' => 'bold(emphasis,format,text)'),
            array('far fa-bold' => 'bold(emphasis,format,text)'),
            array('fal fa-bold' => 'bold(emphasis,format,text)'),
            array('fas fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('far fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fal fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fas fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('far fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fal fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fas fa-columns' => 'columns(browser,dashboard,organize,panes,split)'),
            array('far fa-columns' => 'columns(browser,dashboard,organize,panes,split)'),
            array('fal fa-columns' => 'columns(browser,dashboard,organize,panes,split)'),
            array('fas fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('far fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fal fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fas fa-cut' => 'cut(clip,scissors,snip)'),
            array('far fa-cut' => 'cut(clip,scissors,snip)'),
            array('fal fa-cut' => 'cut(clip,scissors,snip)'),
            array('fas fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('far fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fal fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fas fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('far fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fal fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-font' => 'font(alphabet,glyph,text,type,typeface)'),
            array('far fa-font' => 'font(alphabet,glyph,text,type,typeface)'),
            array('fal fa-font' => 'font(alphabet,glyph,text,type,typeface)'),
            array('fas fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('far fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fal fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fas fa-h1' => 'h1(format,header,text,title)'),
            array('far fa-h1' => 'h1(format,header,text,title)'),
            array('fal fa-h1' => 'h1(format,header,text,title)'),
            array('fas fa-h2' => 'h2(format,header,text,title)'),
            array('far fa-h2' => 'h2(format,header,text,title)'),
            array('fal fa-h2' => 'h2(format,header,text,title)'),
            array('fas fa-h3' => 'h3(format,header,text,title)'),
            array('far fa-h3' => 'h3(format,header,text,title)'),
            array('fal fa-h3' => 'h3(format,header,text,title)'),
            array('fas fa-heading' => 'heading(format,header,text,title)'),
            array('far fa-heading' => 'heading(format,header,text,title)'),
            array('fal fa-heading' => 'heading(format,header,text,title)'),
            array('fas fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('far fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fal fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fas fa-i-cursor' => 'i-cursor(editing,i-beam,type,writing)'),
            array('far fa-i-cursor' => 'i-cursor(editing,i-beam,type,writing)'),
            array('fal fa-i-cursor' => 'i-cursor(editing,i-beam,type,writing)'),
            array('fas fa-indent' => 'indent(align,justify,paragraph,tab)'),
            array('far fa-indent' => 'indent(align,justify,paragraph,tab)'),
            array('fal fa-indent' => 'indent(align,justify,paragraph,tab)'),
            array('fas fa-italic' => 'italic(edit,emphasis,font,format,text,type)'),
            array('far fa-italic' => 'italic(edit,emphasis,font,format,text,type)'),
            array('fal fa-italic' => 'italic(edit,emphasis,font,format,text,type)'),
            array('fas fa-link' => 'link(attach,attachment,chain,connect)'),
            array('far fa-link' => 'link(attach,attachment,chain,connect)'),
            array('fal fa-link' => 'link(attach,attachment,chain,connect)'),
            array('fas fa-list' => 'list(checklist,completed,done,finished,ol,todo,ul)'),
            array('far fa-list' => 'list(checklist,completed,done,finished,ol,todo,ul)'),
            array('fal fa-list' => 'list(checklist,completed,done,finished,ol,todo,ul)'),
            array('fas fa-list-alt' => 'list-alt(checklist,completed,done,finished,ol,todo,ul)'),
            array('far fa-list-alt' => 'list-alt(checklist,completed,done,finished,ol,todo,ul)'),
            array('fal fa-list-alt' => 'list-alt(checklist,completed,done,finished,ol,todo,ul)'),
            array('fas fa-list-ol' => 'list-ol(checklist,completed,done,finished,numbers,ol,todo,ul)'),
            array('far fa-list-ol' => 'list-ol(checklist,completed,done,finished,numbers,ol,todo,ul)'),
            array('fal fa-list-ol' => 'list-ol(checklist,completed,done,finished,numbers,ol,todo,ul)'),
            array('fas fa-list-ul' => 'list-ul(checklist,completed,done,finished,ol,todo,ul)'),
            array('far fa-list-ul' => 'list-ul(checklist,completed,done,finished,ol,todo,ul)'),
            array('fal fa-list-ul' => 'list-ul(checklist,completed,done,finished,ol,todo,ul)'),
            array('fas fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('far fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fal fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fas fa-outdent' => 'outdent(align,justify,paragraph,tab)'),
            array('far fa-outdent' => 'outdent(align,justify,paragraph,tab)'),
            array('fal fa-outdent' => 'outdent(align,justify,paragraph,tab)'),
            array('fas fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('far fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fal fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fas fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('far fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fal fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fas fa-paragraph' => 'paragraph(edit,format,text,writing)'),
            array('far fa-paragraph' => 'paragraph(edit,format,text,writing)'),
            array('fal fa-paragraph' => 'paragraph(edit,format,text,writing)'),
            array('fas fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('far fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fal fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fas fa-pen' => 'pen(design,edit,update,write)'),
            array('far fa-pen' => 'pen(design,edit,update,write)'),
            array('fal fa-pen' => 'pen(design,edit,update,write)'),
            array('fas fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('far fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fal fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fas fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('far fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fas fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('far fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fas fa-pencil' => 'pencil(design,edit,update,write)'),
            array('far fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fal fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fas fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('far fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fal fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fas fa-print' => 'print(business,copy,document,office,paper)'),
            array('far fa-print' => 'print(business,copy,document,office,paper)'),
            array('fal fa-print' => 'print(business,copy,document,office,paper)'),
            array('fas fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('far fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fal fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fas fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('far fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fal fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fas fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('far fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fal fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fas fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('far fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fal fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fas fa-reply' => 'reply(mail,message,respond)'),
            array('far fa-reply' => 'reply(mail,message,respond)'),
            array('fal fa-reply' => 'reply(mail,message,respond)'),
            array('fas fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('far fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('fal fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('fas fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('far fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fal fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fas fa-share' => 'share(forward,save,send,social)'),
            array('far fa-share' => 'share(forward,save,send,social)'),
            array('fal fa-share' => 'share(forward,save,send,social)'),
            array('fas fa-share-all' => 'share-all(forward,save,send,social)'),
            array('far fa-share-all' => 'share-all(forward,save,send,social)'),
            array('fal fa-share-all' => 'share-all(forward,save,send,social)'),
            array('fas fa-strikethrough' => 'strikethrough(cancel,edit,font,format,text,type)'),
            array('far fa-strikethrough' => 'strikethrough(cancel,edit,font,format,text,type)'),
            array('fal fa-strikethrough' => 'strikethrough(cancel,edit,font,format,text,type)'),
            array('fas fa-subscript' => 'subscript(edit,font,format,text,type)'),
            array('far fa-subscript' => 'subscript(edit,font,format,text,type)'),
            array('fal fa-subscript' => 'subscript(edit,font,format,text,type)'),
            array('fas fa-superscript' => 'superscript(edit,exponential,font,format,text,type)'),
            array('far fa-superscript' => 'superscript(edit,exponential,font,format,text,type)'),
            array('fal fa-superscript' => 'superscript(edit,exponential,font,format,text,type)'),
            array('fas fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-table' => 'table(data,excel,spreadsheet)'),
            array('far fa-table' => 'table(data,excel,spreadsheet)'),
            array('fal fa-table' => 'table(data,excel,spreadsheet)'),
            array('fas fa-tasks' => 'tasks(checklist,downloading,downloads,loading,progress,project management,settings,to do)'),
            array('far fa-tasks' => 'tasks(checklist,downloading,downloads,loading,progress,project management,settings,to do)'),
            array('fal fa-tasks' => 'tasks(checklist,downloading,downloads,loading,progress,project management,settings,to do)'),
            array('fas fa-tasks-alt' => 'tasks-alt(checklist,downloading,downloads,loading,poll,progress,project management,settings,to do)'),
            array('far fa-tasks-alt' => 'tasks-alt(checklist,downloading,downloads,loading,poll,progress,project management,settings,to do)'),
            array('fal fa-tasks-alt' => 'tasks-alt(checklist,downloading,downloads,loading,poll,progress,project management,settings,to do)'),
            array('fas fa-text-height' => 'text-height(edit,font,format,text,type)'),
            array('far fa-text-height' => 'text-height(edit,font,format,text,type)'),
            array('fal fa-text-height' => 'text-height(edit,font,format,text,type)'),
            array('fas fa-text-width' => 'text-width(edit,font,format,text,type)'),
            array('far fa-text-width' => 'text-width(edit,font,format,text,type)'),
            array('fal fa-text-width' => 'text-width(edit,font,format,text,type)'),
            array('fas fa-th' => 'th(blocks,boxes,grid,squares)'),
            array('far fa-th' => 'th(blocks,boxes,grid,squares)'),
            array('fal fa-th' => 'th(blocks,boxes,grid,squares)'),
            array('fas fa-th-large' => 'th-large(blocks,boxes,grid,squares)'),
            array('far fa-th-large' => 'th-large(blocks,boxes,grid,squares)'),
            array('fal fa-th-large' => 'th-large(blocks,boxes,grid,squares)'),
            array('fas fa-th-list' => 'th-list(checklist,completed,done,finished,ol,todo,ul)'),
            array('far fa-th-list' => 'th-list(checklist,completed,done,finished,ol,todo,ul)'),
            array('fal fa-th-list' => 'th-list(checklist,completed,done,finished,ol,todo,ul)'),
            array('fas fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('far fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fal fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fas fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('far fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('fal fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('fas fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('far fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('fal fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('fas fa-trash-restore' => 'trash-restore(back,control z,oops,undo)'),
            array('far fa-trash-restore' => 'trash-restore(back,control z,oops,undo)'),
            array('fal fa-trash-restore' => 'trash-restore(back,control z,oops,undo)'),
            array('fas fa-trash-restore-alt' => 'trash-restore-alt(back,control z,oops,undo)'),
            array('far fa-trash-restore-alt' => 'trash-restore-alt(back,control z,oops,undo)'),
            array('fal fa-trash-restore-alt' => 'trash-restore-alt(back,control z,oops,undo)'),
            array('fas fa-underline' => 'underline(edit,emphasis,format,text,writing)'),
            array('far fa-underline' => 'underline(edit,emphasis,format,text,writing)'),
            array('fal fa-underline' => 'underline(edit,emphasis,format,text,writing)'),
            array('fas fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('far fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fal fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fas fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('far fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fal fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fas fa-unlink' => 'unlink(attachment,chain,chain-broken,remove)'),
            array('far fa-unlink' => 'unlink(attachment,chain,chain-broken,remove)'),
            array('fal fa-unlink' => 'unlink(attachment,chain,chain-broken,remove)'),
            array('fas fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('far fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('fal fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
        ),
        'Education' => array(
            array('fas fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('far fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fal fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fas fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('far fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fal fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fas fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('far fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('fal fa-backpack' => 'backpack(bag,book,carry,hiking,school,travel)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('far fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('fal fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('fas fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('far fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fal fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fas fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('far fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fal fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fas fa-book-alt' => 'book-alt(diary,documentation,journal,library,read)'),
            array('far fa-book-alt' => 'book-alt(diary,documentation,journal,library,read)'),
            array('fal fa-book-alt' => 'book-alt(diary,documentation,journal,library,read)'),
            array('fas fa-book-open' => 'book-open(flyer,library,notebook,open book,pamphlet,reading)'),
            array('far fa-book-open' => 'book-open(flyer,library,notebook,open book,pamphlet,reading)'),
            array('fal fa-book-open' => 'book-open(flyer,library,notebook,open book,pamphlet,reading)'),
            array('fas fa-book-reader' => 'book-reader(flyer,library,notebook,open book,pamphlet,reading)'),
            array('far fa-book-reader' => 'book-reader(flyer,library,notebook,open book,pamphlet,reading)'),
            array('fal fa-book-reader' => 'book-reader(flyer,library,notebook,open book,pamphlet,reading)'),
            array('fas fa-books' => 'books(diary,documentation,journal,library,read)'),
            array('far fa-books' => 'books(diary,documentation,journal,library,read)'),
            array('fal fa-books' => 'books(diary,documentation,journal,library,read)'),
            array('fas fa-bus-school' => 'bus-school(education,school,transportation,vehicle)'),
            array('far fa-bus-school' => 'bus-school(education,school,transportation,vehicle)'),
            array('fal fa-bus-school' => 'bus-school(education,school,transportation,vehicle)'),
            array('fas fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('far fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('fal fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('fas fa-chalkboard-teacher' => 'chalkboard-teacher(blackboard,instructor,learning,professor,school,whiteboard,writing)'),
            array('far fa-chalkboard-teacher' => 'chalkboard-teacher(blackboard,instructor,learning,professor,school,whiteboard,writing)'),
            array('fal fa-chalkboard-teacher' => 'chalkboard-teacher(blackboard,instructor,learning,professor,school,whiteboard,writing)'),
            array('fas fa-diploma' => 'diploma(award,certificate,college,education,graduate,graduation,university)'),
            array('far fa-diploma' => 'diploma(award,certificate,college,education,graduate,graduation,university)'),
            array('fal fa-diploma' => 'diploma(award,certificate,college,education,graduate,graduation,university)'),
            array('fas fa-file-certificate' => 'file-certificate(award,diploma,document,license)'),
            array('far fa-file-certificate' => 'file-certificate(award,diploma,document,license)'),
            array('fal fa-file-certificate' => 'file-certificate(award,diploma,document,license)'),
            array('fas fa-glasses-alt' => 'glasses-alt(hipster,nerd,reading,sight,spectacles,vision)'),
            array('far fa-glasses-alt' => 'glasses-alt(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fal fa-glasses-alt' => 'glasses-alt(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fas fa-globe-stand' => 'globe-stand(earth,geography,global,localize,location,map,travel,world)'),
            array('far fa-globe-stand' => 'globe-stand(earth,geography,global,localize,location,map,travel,world)'),
            array('fal fa-globe-stand' => 'globe-stand(earth,geography,global,localize,location,map,travel,world)'),
            array('fas fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('far fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fal fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fas fa-laptop-code' => 'laptop-code(computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)'),
            array('far fa-laptop-code' => 'laptop-code(computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)'),
            array('fal fa-laptop-code' => 'laptop-code(computer,cpu,dell,demo,develop,device,mac,macbook,machine,pc)'),
            array('fas fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('far fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('fal fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('fas fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('far fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fal fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fas fa-pencil-paintbrush' => 'pencil-paintbrush(art,design,paint,pencil,write)'),
            array('far fa-pencil-paintbrush' => 'pencil-paintbrush(art,design,paint,pencil,write)'),
            array('fal fa-pencil-paintbrush' => 'pencil-paintbrush(art,design,paint,pencil,write)'),
            array('fas fa-ruler-triangle' => 'ruler-triangle(design,draft,length,measure,planning)'),
            array('far fa-ruler-triangle' => 'ruler-triangle(design,draft,length,measure,planning)'),
            array('fal fa-ruler-triangle' => 'ruler-triangle(design,draft,length,measure,planning)'),
            array('fas fa-school' => 'school(building,education,learn,student,teacher)'),
            array('far fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fal fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fas fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('far fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('fal fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('fas fa-theater-masks' => 'theater-masks(comedy,perform,theatre,tragedy)'),
            array('far fa-theater-masks' => 'theater-masks(comedy,perform,theatre,tragedy)'),
            array('fal fa-theater-masks' => 'theater-masks(comedy,perform,theatre,tragedy)'),
            array('fas fa-user-graduate' => 'user-graduate(cap,clothing,commencement,gown,graduation,person,student)'),
            array('far fa-user-graduate' => 'user-graduate(cap,clothing,commencement,gown,graduation,person,student)'),
            array('fal fa-user-graduate' => 'user-graduate(cap,clothing,commencement,gown,graduation,person,student)'),
            array('fas fa-users-class' => 'users-class(chalkboard,group,presentation,students,teachers,team)'),
            array('far fa-users-class' => 'users-class(chalkboard,group,presentation,students,teachers,team)'),
            array('fal fa-users-class' => 'users-class(chalkboard,group,presentation,students,teachers,team)'),
        ),
        'Emoji' => array(
            array('fas fa-angry' => 'angry(disapprove,emoticon,face,mad,upset)'),
            array('far fa-angry' => 'angry(disapprove,emoticon,face,mad,upset)'),
            array('fal fa-angry' => 'angry(disapprove,emoticon,face,mad,upset)'),
            array('fas fa-dizzy' => 'dizzy(dazed,dead,disapprove,emoticon,face)'),
            array('far fa-dizzy' => 'dizzy(dazed,dead,disapprove,emoticon,face)'),
            array('fal fa-dizzy' => 'dizzy(dazed,dead,disapprove,emoticon,face)'),
            array('fas fa-flushed' => 'flushed(embarrassed,emoticon,face)'),
            array('far fa-flushed' => 'flushed(embarrassed,emoticon,face)'),
            array('fal fa-flushed' => 'flushed(embarrassed,emoticon,face)'),
            array('fas fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('far fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fal fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fas fa-frown-open' => 'frown-open(disapprove,emoticon,face,rating,sad)'),
            array('far fa-frown-open' => 'frown-open(disapprove,emoticon,face,rating,sad)'),
            array('fal fa-frown-open' => 'frown-open(disapprove,emoticon,face,rating,sad)'),
            array('fas fa-grimace' => 'grimace(cringe,emoticon,face,teeth)'),
            array('far fa-grimace' => 'grimace(cringe,emoticon,face,teeth)'),
            array('fal fa-grimace' => 'grimace(cringe,emoticon,face,teeth)'),
            array('fas fa-grin' => 'grin(emoticon,face,laugh,smile)'),
            array('far fa-grin' => 'grin(emoticon,face,laugh,smile)'),
            array('fal fa-grin' => 'grin(emoticon,face,laugh,smile)'),
            array('fas fa-grin-alt' => 'grin-alt(emoticon,face,laugh,smile)'),
            array('far fa-grin-alt' => 'grin-alt(emoticon,face,laugh,smile)'),
            array('fal fa-grin-alt' => 'grin-alt(emoticon,face,laugh,smile)'),
            array('fas fa-grin-beam' => 'grin-beam(emoticon,face,laugh,smile)'),
            array('far fa-grin-beam' => 'grin-beam(emoticon,face,laugh,smile)'),
            array('fal fa-grin-beam' => 'grin-beam(emoticon,face,laugh,smile)'),
            array('fas fa-grin-beam-sweat' => 'grin-beam-sweat(embarass,emoticon,face,smile)'),
            array('far fa-grin-beam-sweat' => 'grin-beam-sweat(embarass,emoticon,face,smile)'),
            array('fal fa-grin-beam-sweat' => 'grin-beam-sweat(embarass,emoticon,face,smile)'),
            array('fas fa-grin-hearts' => 'grin-hearts(emoticon,face,love,smile)'),
            array('far fa-grin-hearts' => 'grin-hearts(emoticon,face,love,smile)'),
            array('fal fa-grin-hearts' => 'grin-hearts(emoticon,face,love,smile)'),
            array('fas fa-grin-squint' => 'grin-squint(emoticon,face,laugh,smile)'),
            array('far fa-grin-squint' => 'grin-squint(emoticon,face,laugh,smile)'),
            array('fal fa-grin-squint' => 'grin-squint(emoticon,face,laugh,smile)'),
            array('fas fa-grin-squint-tears' => 'grin-squint-tears(emoticon,face,happy,smile)'),
            array('far fa-grin-squint-tears' => 'grin-squint-tears(emoticon,face,happy,smile)'),
            array('fal fa-grin-squint-tears' => 'grin-squint-tears(emoticon,face,happy,smile)'),
            array('fas fa-grin-stars' => 'grin-stars(emoticon,face,star-struck)'),
            array('far fa-grin-stars' => 'grin-stars(emoticon,face,star-struck)'),
            array('fal fa-grin-stars' => 'grin-stars(emoticon,face,star-struck)'),
            array('fas fa-grin-tears' => 'grin-tears(LOL,emoticon,face)'),
            array('far fa-grin-tears' => 'grin-tears(LOL,emoticon,face)'),
            array('fal fa-grin-tears' => 'grin-tears(LOL,emoticon,face)'),
            array('fas fa-grin-tongue' => 'grin-tongue(LOL,emoticon,face)'),
            array('far fa-grin-tongue' => 'grin-tongue(LOL,emoticon,face)'),
            array('fal fa-grin-tongue' => 'grin-tongue(LOL,emoticon,face)'),
            array('fas fa-grin-tongue-squint' => 'grin-tongue-squint(LOL,emoticon,face)'),
            array('far fa-grin-tongue-squint' => 'grin-tongue-squint(LOL,emoticon,face)'),
            array('fal fa-grin-tongue-squint' => 'grin-tongue-squint(LOL,emoticon,face)'),
            array('fas fa-grin-tongue-wink' => 'grin-tongue-wink(LOL,emoticon,face)'),
            array('far fa-grin-tongue-wink' => 'grin-tongue-wink(LOL,emoticon,face)'),
            array('fal fa-grin-tongue-wink' => 'grin-tongue-wink(LOL,emoticon,face)'),
            array('fas fa-grin-wink' => 'grin-wink(emoticon,face,flirt,laugh,smile)'),
            array('far fa-grin-wink' => 'grin-wink(emoticon,face,flirt,laugh,smile)'),
            array('fal fa-grin-wink' => 'grin-wink(emoticon,face,flirt,laugh,smile)'),
            array('fas fa-kiss' => 'kiss(beso,emoticon,face,love,smooch)'),
            array('far fa-kiss' => 'kiss(beso,emoticon,face,love,smooch)'),
            array('fal fa-kiss' => 'kiss(beso,emoticon,face,love,smooch)'),
            array('fas fa-kiss-beam' => 'kiss-beam(beso,emoticon,face,love,smooch)'),
            array('far fa-kiss-beam' => 'kiss-beam(beso,emoticon,face,love,smooch)'),
            array('fal fa-kiss-beam' => 'kiss-beam(beso,emoticon,face,love,smooch)'),
            array('fas fa-kiss-wink-heart' => 'kiss-wink-heart(beso,emoticon,face,love,smooch)'),
            array('far fa-kiss-wink-heart' => 'kiss-wink-heart(beso,emoticon,face,love,smooch)'),
            array('fal fa-kiss-wink-heart' => 'kiss-wink-heart(beso,emoticon,face,love,smooch)'),
            array('fas fa-laugh' => 'laugh(LOL,emoticon,face,laugh,smile)'),
            array('far fa-laugh' => 'laugh(LOL,emoticon,face,laugh,smile)'),
            array('fal fa-laugh' => 'laugh(LOL,emoticon,face,laugh,smile)'),
            array('fas fa-laugh-beam' => 'laugh-beam(LOL,emoticon,face,happy,smile)'),
            array('far fa-laugh-beam' => 'laugh-beam(LOL,emoticon,face,happy,smile)'),
            array('fal fa-laugh-beam' => 'laugh-beam(LOL,emoticon,face,happy,smile)'),
            array('fas fa-laugh-squint' => 'laugh-squint(LOL,emoticon,face,happy,smile)'),
            array('far fa-laugh-squint' => 'laugh-squint(LOL,emoticon,face,happy,smile)'),
            array('fal fa-laugh-squint' => 'laugh-squint(LOL,emoticon,face,happy,smile)'),
            array('fas fa-laugh-wink' => 'laugh-wink(LOL,emoticon,face,happy,smile)'),
            array('far fa-laugh-wink' => 'laugh-wink(LOL,emoticon,face,happy,smile)'),
            array('fal fa-laugh-wink' => 'laugh-wink(LOL,emoticon,face,happy,smile)'),
            array('fas fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('far fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fal fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fas fa-meh-blank' => 'meh-blank(emoticon,face,neutral,rating)'),
            array('far fa-meh-blank' => 'meh-blank(emoticon,face,neutral,rating)'),
            array('fal fa-meh-blank' => 'meh-blank(emoticon,face,neutral,rating)'),
            array('fas fa-meh-rolling-eyes' => 'meh-rolling-eyes(emoticon,face,neutral,rating)'),
            array('far fa-meh-rolling-eyes' => 'meh-rolling-eyes(emoticon,face,neutral,rating)'),
            array('fal fa-meh-rolling-eyes' => 'meh-rolling-eyes(emoticon,face,neutral,rating)'),
            array('fas fa-sad-cry' => 'sad-cry(emoticon,face,tear,tears)'),
            array('far fa-sad-cry' => 'sad-cry(emoticon,face,tear,tears)'),
            array('fal fa-sad-cry' => 'sad-cry(emoticon,face,tear,tears)'),
            array('fas fa-sad-tear' => 'sad-tear(emoticon,face,tear,tears)'),
            array('far fa-sad-tear' => 'sad-tear(emoticon,face,tear,tears)'),
            array('fal fa-sad-tear' => 'sad-tear(emoticon,face,tear,tears)'),
            array('fas fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('far fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fal fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fas fa-smile-beam' => 'smile-beam(emoticon,face,happy,positive)'),
            array('far fa-smile-beam' => 'smile-beam(emoticon,face,happy,positive)'),
            array('fal fa-smile-beam' => 'smile-beam(emoticon,face,happy,positive)'),
            array('fas fa-smile-wink' => 'smile-wink(emoticon,face,happy,hint,joke)'),
            array('far fa-smile-wink' => 'smile-wink(emoticon,face,happy,hint,joke)'),
            array('fal fa-smile-wink' => 'smile-wink(emoticon,face,happy,hint,joke)'),
            array('fas fa-surprise' => 'surprise(emoticon,face,shocked)'),
            array('far fa-surprise' => 'surprise(emoticon,face,shocked)'),
            array('fal fa-surprise' => 'surprise(emoticon,face,shocked)'),
            array('fas fa-tired' => 'tired(angry,emoticon,face,grumpy,upset)'),
            array('far fa-tired' => 'tired(angry,emoticon,face,grumpy,upset)'),
            array('fal fa-tired' => 'tired(angry,emoticon,face,grumpy,upset)'),
        ),
        'Energy' => array(
            array('fas fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-battery-bolt' => 'battery-bolt(charge,power,status)'),
            array('far fa-battery-bolt' => 'battery-bolt(charge,power,status)'),
            array('fal fa-battery-bolt' => 'battery-bolt(charge,power,status)'),
            array('fas fa-battery-empty' => 'battery-empty(charge,dead,power,status)'),
            array('far fa-battery-empty' => 'battery-empty(charge,dead,power,status)'),
            array('fal fa-battery-empty' => 'battery-empty(charge,dead,power,status)'),
            array('fas fa-battery-full' => 'battery-full(charge,power,status)'),
            array('far fa-battery-full' => 'battery-full(charge,power,status)'),
            array('fal fa-battery-full' => 'battery-full(charge,power,status)'),
            array('fas fa-battery-half' => 'battery-half(charge,power,status)'),
            array('far fa-battery-half' => 'battery-half(charge,power,status)'),
            array('fal fa-battery-half' => 'battery-half(charge,power,status)'),
            array('fas fa-battery-quarter' => 'battery-quarter(charge,low,power,status)'),
            array('far fa-battery-quarter' => 'battery-quarter(charge,low,power,status)'),
            array('fal fa-battery-quarter' => 'battery-quarter(charge,low,power,status)'),
            array('fas fa-battery-slash' => 'battery-slash(charge,dead,power,status)'),
            array('far fa-battery-slash' => 'battery-slash(charge,dead,power,status)'),
            array('fal fa-battery-slash' => 'battery-slash(charge,dead,power,status)'),
            array('fas fa-battery-three-quarters' => 'battery-three-quarters(charge,power,status)'),
            array('far fa-battery-three-quarters' => 'battery-three-quarters(charge,power,status)'),
            array('fal fa-battery-three-quarters' => 'battery-three-quarters(charge,power,status)'),
            array('fas fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('far fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fal fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fas fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('far fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fal fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fas fa-burrito' => 'burrito(beans,breakfast,chimichanga,mexican,salsa,taco,tortilla)'),
            array('far fa-burrito' => 'burrito(beans,breakfast,chimichanga,mexican,salsa,taco,tortilla)'),
            array('fal fa-burrito' => 'burrito(beans,breakfast,chimichanga,mexican,salsa,taco,tortilla)'),
            array('fas fa-charging-station' => 'charging-station(electric,ev,tesla,vehicle)'),
            array('far fa-charging-station' => 'charging-station(electric,ev,tesla,vehicle)'),
            array('fal fa-charging-station' => 'charging-station(electric,ev,tesla,vehicle)'),
            array('fas fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('far fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('fal fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('fas fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('far fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('fal fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('fas fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('far fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fal fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fas fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('far fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fal fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fas fa-plug' => 'plug(connect,electric,online,power)'),
            array('far fa-plug' => 'plug(connect,electric,online,power)'),
            array('fal fa-plug' => 'plug(connect,electric,online,power)'),
            array('fas fa-poop' => 'poop(crap,poop,shit,smile,turd)'),
            array('far fa-poop' => 'poop(crap,poop,shit,smile,turd)'),
            array('fal fa-poop' => 'poop(crap,poop,shit,smile,turd)'),
            array('fas fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('far fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('fal fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('fas fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('far fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fal fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fas fa-solar-panel' => 'solar-panel(clean,eco-friendly,energy,green,sun)'),
            array('far fa-solar-panel' => 'solar-panel(clean,eco-friendly,energy,green,sun)'),
            array('fal fa-solar-panel' => 'solar-panel(clean,eco-friendly,energy,green,sun)'),
            array('fas fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('far fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fal fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fas fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('far fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('fal fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('fas fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('far fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('fal fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
        ),
        'Files' => array(
            array('fas fa-archive' => 'archive(box,package,save,storage)'),
            array('far fa-archive' => 'archive(box,package,save,storage)'),
            array('fal fa-archive' => 'archive(box,package,save,storage)'),
            array('fas fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('far fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fal fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fas fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('far fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fal fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fas fa-cut' => 'cut(clip,scissors,snip)'),
            array('far fa-cut' => 'cut(clip,scissors,snip)'),
            array('fal fa-cut' => 'cut(clip,scissors,snip)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-file-archive' => 'file-archive(.zip,bundle,compress,compression,download,zip)'),
            array('far fa-file-archive' => 'file-archive(.zip,bundle,compress,compression,download,zip)'),
            array('fal fa-file-archive' => 'file-archive(.zip,bundle,compress,compression,download,zip)'),
            array('fas fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('far fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('fal fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('fas fa-file-check' => 'file-check(accept,agree,confirm,document,done,ok,select,success,synced,tick,todo)'),
            array('far fa-file-check' => 'file-check(accept,agree,confirm,document,done,ok,select,success,synced,tick,todo)'),
            array('fal fa-file-check' => 'file-check(accept,agree,confirm,document,done,ok,select,success,synced,tick,todo)'),
            array('fas fa-file-code' => 'file-code(css,development,document,html)'),
            array('far fa-file-code' => 'file-code(css,development,document,html)'),
            array('fal fa-file-code' => 'file-code(css,development,document,html)'),
            array('fas fa-file-edit' => 'file-edit(edit,pen,pencil,update,write)'),
            array('far fa-file-edit' => 'file-edit(edit,pen,pencil,update,write)'),
            array('fal fa-file-edit' => 'file-edit(edit,pen,pencil,update,write)'),
            array('fas fa-file-excel' => 'file-excel(csv,document,numbers,spreadsheets,table)'),
            array('far fa-file-excel' => 'file-excel(csv,document,numbers,spreadsheets,table)'),
            array('fal fa-file-excel' => 'file-excel(csv,document,numbers,spreadsheets,table)'),
            array('fas fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('far fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('fal fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('fas fa-file-image' => 'file-image(document,image,jpg,photo,png)'),
            array('far fa-file-image' => 'file-image(document,image,jpg,photo,png)'),
            array('fal fa-file-image' => 'file-image(document,image,jpg,photo,png)'),
            array('fas fa-file-minus' => 'file-minus(delete,document,negative,remove)'),
            array('far fa-file-minus' => 'file-minus(delete,document,negative,remove)'),
            array('fal fa-file-minus' => 'file-minus(delete,document,negative,remove)'),
            array('fas fa-file-pdf' => 'file-pdf(acrobat,document,preview,save)'),
            array('far fa-file-pdf' => 'file-pdf(acrobat,document,preview,save)'),
            array('fal fa-file-pdf' => 'file-pdf(acrobat,document,preview,save)'),
            array('fas fa-file-plus' => 'file-plus(add,create,document,medical,new,positive)'),
            array('far fa-file-plus' => 'file-plus(add,create,document,medical,new,positive)'),
            array('fal fa-file-plus' => 'file-plus(add,create,document,medical,new,positive)'),
            array('fas fa-file-powerpoint' => 'file-powerpoint(display,document,keynote,presentation)'),
            array('far fa-file-powerpoint' => 'file-powerpoint(display,document,keynote,presentation)'),
            array('fal fa-file-powerpoint' => 'file-powerpoint(display,document,keynote,presentation)'),
            array('fas fa-file-times' => 'file-times(archive,delete,document,remove,x)'),
            array('far fa-file-times' => 'file-times(archive,delete,document,remove,x)'),
            array('fal fa-file-times' => 'file-times(archive,delete,document,remove,x)'),
            array('fas fa-file-video' => 'file-video(document,m4v,movie,mp4,play)'),
            array('far fa-file-video' => 'file-video(document,m4v,movie,mp4,play)'),
            array('fal fa-file-video' => 'file-video(document,m4v,movie,mp4,play)'),
            array('fas fa-file-word' => 'file-word(document,edit,page,text,writing)'),
            array('far fa-file-word' => 'file-word(document,edit,page,text,writing)'),
            array('fal fa-file-word' => 'file-word(document,edit,page,text,writing)'),
            array('fas fa-folder' => 'folder(archive,directory,document,file)'),
            array('far fa-folder' => 'folder(archive,directory,document,file)'),
            array('fal fa-folder' => 'folder(archive,directory,document,file)'),
            array('fas fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('far fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fal fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fas fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('far fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fal fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fas fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('far fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fal fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fas fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('far fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('fal fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
        ),
        'Finance' => array(
            array('fas fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('far fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('fal fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('fas fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('far fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fal fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fas fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('far fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fal fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fas fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('far fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fal fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fas fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('far fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fal fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fas fa-cash-register' => 'cash-register(buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)'),
            array('far fa-cash-register' => 'cash-register(buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)'),
            array('fal fa-cash-register' => 'cash-register(buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)'),
            array('fas fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('far fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('fal fa-chart-line' => 'chart-line(activity,analytics,chart,dashboard,gain,graph,increase,line)'),
            array('fas fa-chart-line-down' => 'chart-line-down(analytics,chart,dashboard,decline,graph,line,loss)'),
            array('far fa-chart-line-down' => 'chart-line-down(analytics,chart,dashboard,decline,graph,line,loss)'),
            array('fal fa-chart-line-down' => 'chart-line-down(analytics,chart,dashboard,decline,graph,line,loss)'),
            array('fas fa-chart-pie' => 'chart-pie(analytics,chart,diagram,graph,pie)'),
            array('far fa-chart-pie' => 'chart-pie(analytics,chart,diagram,graph,pie)'),
            array('fal fa-chart-pie' => 'chart-pie(analytics,chart,diagram,graph,pie)'),
            array('fas fa-chart-pie-alt' => 'chart-pie-alt(analytics,chart,diagram,graph,pie)'),
            array('far fa-chart-pie-alt' => 'chart-pie-alt(analytics,chart,diagram,graph,pie)'),
            array('fal fa-chart-pie-alt' => 'chart-pie-alt(analytics,chart,diagram,graph,pie)'),
            array('fas fa-coins' => 'coins(currency,dime,financial,gold,money,penny)'),
            array('far fa-coins' => 'coins(currency,dime,financial,gold,money,penny)'),
            array('fal fa-coins' => 'coins(currency,dime,financial,gold,money,penny)'),
            array('fas fa-comment-alt-dollar' => 'comment-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comment-alt-dollar' => 'comment-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comment-alt-dollar' => 'comment-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-comment-dollar' => 'comment-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comment-dollar' => 'comment-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comment-dollar' => 'comment-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-comments-alt-dollar' => 'comments-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comments-alt-dollar' => 'comments-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comments-alt-dollar' => 'comments-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-comments-dollar' => 'comments-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comments-dollar' => 'comments-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comments-dollar' => 'comments-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-credit-card' => 'credit-card(buy,checkout,credit-card-alt,debit,money,payment,purchase)'),
            array('far fa-credit-card' => 'credit-card(buy,checkout,credit-card-alt,debit,money,payment,purchase)'),
            array('fal fa-credit-card' => 'credit-card(buy,checkout,credit-card-alt,debit,money,payment,purchase)'),
            array('fas fa-credit-card-blank' => 'credit-card-blank(buy,checkout,debit,money,payment,purchase)'),
            array('far fa-credit-card-blank' => 'credit-card-blank(buy,checkout,debit,money,payment,purchase)'),
            array('fal fa-credit-card-blank' => 'credit-card-blank(buy,checkout,debit,money,payment,purchase)'),
            array('fas fa-credit-card-front' => 'credit-card-front(buy,checkout,chip,debit,money,payment,purchase)'),
            array('far fa-credit-card-front' => 'credit-card-front(buy,checkout,chip,debit,money,payment,purchase)'),
            array('fal fa-credit-card-front' => 'credit-card-front(buy,checkout,chip,debit,money,payment,purchase)'),
            array('fas fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('far fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('fal fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('fas fa-file-chart-line' => 'file-chart-line(analytics,data,document,projection,report)'),
            array('far fa-file-chart-line' => 'file-chart-line(analytics,data,document,projection,report)'),
            array('fal fa-file-chart-line' => 'file-chart-line(analytics,data,document,projection,report)'),
            array('fas fa-file-chart-pie' => 'file-chart-pie(analytics,data,document,projection,report)'),
            array('far fa-file-chart-pie' => 'file-chart-pie(analytics,data,document,projection,report)'),
            array('fal fa-file-chart-pie' => 'file-chart-pie(analytics,data,document,projection,report)'),
            array('fas fa-file-invoice' => 'file-invoice(account,bill,charge,document,payment,receipt)'),
            array('far fa-file-invoice' => 'file-invoice(account,bill,charge,document,payment,receipt)'),
            array('fal fa-file-invoice' => 'file-invoice(account,bill,charge,document,payment,receipt)'),
            array('fas fa-file-invoice-dollar' => 'file-invoice-dollar($,account,bill,charge,document,dollar-sign,money,payment,receipt,usd)'),
            array('far fa-file-invoice-dollar' => 'file-invoice-dollar($,account,bill,charge,document,dollar-sign,money,payment,receipt,usd)'),
            array('fal fa-file-invoice-dollar' => 'file-invoice-dollar($,account,bill,charge,document,dollar-sign,money,payment,receipt,usd)'),
            array('fas fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('far fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('fal fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('fas fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('far fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('fal fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('fas fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('far fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fal fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fas fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-wave' => 'money-bill-wave(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-wave' => 'money-bill-wave(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-wave' => 'money-bill-wave(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-wave-alt' => 'money-bill-wave-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-wave-alt' => 'money-bill-wave-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-wave-alt' => 'money-bill-wave-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fas fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fas fa-percentage' => 'percentage(discount,fraction,proportion,rate,ratio)'),
            array('far fa-percentage' => 'percentage(discount,fraction,proportion,rate,ratio)'),
            array('fal fa-percentage' => 'percentage(discount,fraction,proportion,rate,ratio)'),
            array('fas fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('far fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('fal fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('fas fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('far fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fal fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fas fa-sack' => 'sack(bag,burlap,money,santa)'),
            array('far fa-sack' => 'sack(bag,burlap,money,santa)'),
            array('fal fa-sack' => 'sack(bag,burlap,money,santa)'),
            array('fas fa-sack-dollar' => 'sack-dollar(bag,burlap,cash,dollar,money,robber,santa,usd)'),
            array('far fa-sack-dollar' => 'sack-dollar(bag,burlap,cash,dollar,money,robber,santa,usd)'),
            array('fal fa-sack-dollar' => 'sack-dollar(bag,burlap,cash,dollar,money,robber,santa,usd)'),
            array('fas fa-stamp' => 'stamp(art,certificate,imprint,rubber,seal)'),
            array('far fa-stamp' => 'stamp(art,certificate,imprint,rubber,seal)'),
            array('fal fa-stamp' => 'stamp(art,certificate,imprint,rubber,seal)'),
            array('fas fa-tally' => 'tally(count,hash,numbers)'),
            array('far fa-tally' => 'tally(count,hash,numbers)'),
            array('fal fa-tally' => 'tally(count,hash,numbers)'),
            array('fas fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('far fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fal fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fas fa-wallet' => 'wallet(billfold,cash,currency,money)'),
            array('far fa-wallet' => 'wallet(billfold,cash,currency,money)'),
            array('fal fa-wallet' => 'wallet(billfold,cash,currency,money)'),
        ),
        'Fitness' => array(
            array('fas fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('far fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fal fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fas fa-book-heart' => 'book-heart(charity,diary,documentation,donation,health,history,journal,library,read)'),
            array('far fa-book-heart' => 'book-heart(charity,diary,documentation,donation,health,history,journal,library,read)'),
            array('fal fa-book-heart' => 'book-heart(charity,diary,documentation,donation,health,history,journal,library,read)'),
            array('fas fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('far fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fal fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fas fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-heart-rate' => 'heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('far fa-heart-rate' => 'heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fal fa-heart-rate' => 'heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fas fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('far fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fal fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fas fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('far fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fal fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fas fa-monitor-heart-rate' => 'monitor-heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('far fa-monitor-heart-rate' => 'monitor-heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fal fa-monitor-heart-rate' => 'monitor-heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fas fa-running' => 'running(exercise,health,jog,person,run,sport,sprint)'),
            array('far fa-running' => 'running(exercise,health,jog,person,run,sport,sprint)'),
            array('fal fa-running' => 'running(exercise,health,jog,person,run,sport,sprint)'),
            array('fas fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('far fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('fal fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('fas fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('far fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fal fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fas fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('far fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fal fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fas fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('far fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fal fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fas fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('far fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fal fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fas fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('far fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fal fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fas fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('far fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('fal fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('fas fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('far fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fal fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fas fa-walking' => 'walking(exercise,health,pedometer,person,steps)'),
            array('far fa-walking' => 'walking(exercise,health,pedometer,person,steps)'),
            array('fal fa-walking' => 'walking(exercise,health,pedometer,person,steps)'),
            array('fas fa-watch-fitness' => 'watch-fitness(Fitbit,alert,apple watch,clock,pedometer,time,wristwatch)'),
            array('far fa-watch-fitness' => 'watch-fitness(Fitbit,alert,apple watch,clock,pedometer,time,wristwatch)'),
            array('fal fa-watch-fitness' => 'watch-fitness(Fitbit,alert,apple watch,clock,pedometer,time,wristwatch)'),
        ),
        'Food' => array(
            array('fas fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('far fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fal fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fas fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('far fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('fal fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('fas fa-bacon' => 'bacon(blt,breakfast,ham,lard,meat,pancetta,pork,rasher)'),
            array('far fa-bacon' => 'bacon(blt,breakfast,ham,lard,meat,pancetta,pork,rasher)'),
            array('fal fa-bacon' => 'bacon(blt,breakfast,ham,lard,meat,pancetta,pork,rasher)'),
            array('fas fa-bone' => 'bone(calcium,dog,skeletal,skeleton,tibia)'),
            array('far fa-bone' => 'bone(calcium,dog,skeletal,skeleton,tibia)'),
            array('fal fa-bone' => 'bone(calcium,dog,skeletal,skeleton,tibia)'),
            array('fas fa-bread-loaf' => 'bread-loaf(bake,bakery,baking,dough,flour,gluten,grain,sandwich,sourdough,toast,wheat,yeast)'),
            array('far fa-bread-loaf' => 'bread-loaf(bake,bakery,baking,dough,flour,gluten,grain,sandwich,sourdough,toast,wheat,yeast)'),
            array('fal fa-bread-loaf' => 'bread-loaf(bake,bakery,baking,dough,flour,gluten,grain,sandwich,sourdough,toast,wheat,yeast)'),
            array('fas fa-bread-slice' => 'bread-slice(bake,bakery,baking,dough,flour,gluten,grain,sandwich,sourdough,toast,wheat,yeast)'),
            array('far fa-bread-slice' => 'bread-slice(bake,bakery,baking,dough,flour,gluten,grain,sandwich,sourdough,toast,wheat,yeast)'),
            array('fal fa-bread-slice' => 'bread-slice(bake,bakery,baking,dough,flour,gluten,grain,sandwich,sourdough,toast,wheat,yeast)'),
            array('fas fa-burrito' => 'burrito(beans,breakfast,chimichanga,mexican,salsa,taco,tortilla)'),
            array('far fa-burrito' => 'burrito(beans,breakfast,chimichanga,mexican,salsa,taco,tortilla)'),
            array('fal fa-burrito' => 'burrito(beans,breakfast,chimichanga,mexican,salsa,taco,tortilla)'),
            array('fas fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('far fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('fal fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('fas fa-candy-corn' => 'candy-corn(halloween,holiday,sugar,triangles)'),
            array('far fa-candy-corn' => 'candy-corn(halloween,holiday,sugar,triangles)'),
            array('fal fa-candy-corn' => 'candy-corn(halloween,holiday,sugar,triangles)'),
            array('fas fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('far fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fal fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fas fa-cheese' => 'cheese(cheddar,curd,gouda,melt,parmesan,sandwich,swiss,wedge)'),
            array('far fa-cheese' => 'cheese(cheddar,curd,gouda,melt,parmesan,sandwich,swiss,wedge)'),
            array('fal fa-cheese' => 'cheese(cheddar,curd,gouda,melt,parmesan,sandwich,swiss,wedge)'),
            array('fas fa-cheese-swiss' => 'cheese-swiss(cheddar,curd,gouda,melt,parmesan,sandwich,swiss,wedge)'),
            array('far fa-cheese-swiss' => 'cheese-swiss(cheddar,curd,gouda,melt,parmesan,sandwich,swiss,wedge)'),
            array('fal fa-cheese-swiss' => 'cheese-swiss(cheddar,curd,gouda,melt,parmesan,sandwich,swiss,wedge)'),
            array('fas fa-cheeseburger' => 'cheeseburger(bacon,beef,burger,burger king,fast food,grill,ground beef,hamburger,mcdonalds,sandwich,slider,wendys,white castle)'),
            array('far fa-cheeseburger' => 'cheeseburger(bacon,beef,burger,burger king,fast food,grill,ground beef,hamburger,mcdonalds,sandwich,slider,wendys,white castle)'),
            array('fal fa-cheeseburger' => 'cheeseburger(bacon,beef,burger,burger king,fast food,grill,ground beef,hamburger,mcdonalds,sandwich,slider,wendys,white castle)'),
            array('fas fa-cloud-meatball' => 'cloud-meatball(FLDSMDFR,food,spaghetti,storm)'),
            array('far fa-cloud-meatball' => 'cloud-meatball(FLDSMDFR,food,spaghetti,storm)'),
            array('fal fa-cloud-meatball' => 'cloud-meatball(FLDSMDFR,food,spaghetti,storm)'),
            array('fas fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('far fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('fal fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('fas fa-corn' => 'corn(cob,ear,fall,grain,kernel,maize,popcorn)'),
            array('far fa-corn' => 'corn(cob,ear,fall,grain,kernel,maize,popcorn)'),
            array('fal fa-corn' => 'corn(cob,ear,fall,grain,kernel,maize,popcorn)'),
            array('fas fa-croissant' => 'croissant(bakery,breakfast,brioche,butter,crescent,dough,gluten,pastry,roll)'),
            array('far fa-croissant' => 'croissant(bakery,breakfast,brioche,butter,crescent,dough,gluten,pastry,roll)'),
            array('fal fa-croissant' => 'croissant(bakery,breakfast,brioche,butter,crescent,dough,gluten,pastry,roll)'),
            array('fas fa-drumstick' => 'drumstick(bone,chicken,leg,meat,poultry,turkey)'),
            array('far fa-drumstick' => 'drumstick(bone,chicken,leg,meat,poultry,turkey)'),
            array('fal fa-drumstick' => 'drumstick(bone,chicken,leg,meat,poultry,turkey)'),
            array('fas fa-drumstick-bite' => 'drumstick-bite(bone,chicken,leg,meat,poultry,turkey)'),
            array('far fa-drumstick-bite' => 'drumstick-bite(bone,chicken,leg,meat,poultry,turkey)'),
            array('fal fa-drumstick-bite' => 'drumstick-bite(bone,chicken,leg,meat,poultry,turkey)'),
            array('fas fa-egg' => 'egg(breakfast,chicken,easter,shell,yolk)'),
            array('far fa-egg' => 'egg(breakfast,chicken,easter,shell,yolk)'),
            array('fal fa-egg' => 'egg(breakfast,chicken,easter,shell,yolk)'),
            array('fas fa-egg-fried' => 'egg-fried(breakfast,chicken,yolk)'),
            array('far fa-egg-fried' => 'egg-fried(breakfast,chicken,yolk)'),
            array('fal fa-egg-fried' => 'egg-fried(breakfast,chicken,yolk)'),
            array('fas fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('far fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('fal fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('fas fa-fish-cooked' => 'fish-cooked(grilled,health,salmon,seafood,tuna)'),
            array('far fa-fish-cooked' => 'fish-cooked(grilled,health,salmon,seafood,tuna)'),
            array('fal fa-fish-cooked' => 'fish-cooked(grilled,health,salmon,seafood,tuna)'),
            array('fas fa-french-fries' => 'french-fries(chips,fast food,fried,ketchup,potato,poutine)'),
            array('far fa-french-fries' => 'french-fries(chips,fast food,fried,ketchup,potato,poutine)'),
            array('fal fa-french-fries' => 'french-fries(chips,fast food,fried,ketchup,potato,poutine)'),
            array('fas fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('far fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('fal fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('fas fa-hamburger' => 'hamburger(bacon,beef,burger,burger king,cheeseburger,fast food,grill,ground beef,mcdonalds,sandwich)'),
            array('far fa-hamburger' => 'hamburger(bacon,beef,burger,burger king,cheeseburger,fast food,grill,ground beef,mcdonalds,sandwich)'),
            array('fal fa-hamburger' => 'hamburger(bacon,beef,burger,burger king,cheeseburger,fast food,grill,ground beef,mcdonalds,sandwich)'),
            array('fas fa-hotdog' => 'hotdog(bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)'),
            array('far fa-hotdog' => 'hotdog(bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)'),
            array('fal fa-hotdog' => 'hotdog(bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)'),
            array('fas fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('far fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('fal fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('fas fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('far fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fal fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fas fa-meat' => 'meat(beef,ham,mutton,pork,veal)'),
            array('far fa-meat' => 'meat(beef,ham,mutton,pork,veal)'),
            array('fal fa-meat' => 'meat(beef,ham,mutton,pork,veal)'),
            array('fas fa-pepper-hot' => 'pepper-hot(buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)'),
            array('far fa-pepper-hot' => 'pepper-hot(buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)'),
            array('fal fa-pepper-hot' => 'pepper-hot(buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)'),
            array('fas fa-pie' => 'pie(apple,bakery,cake,crust,dessert,pumpkin,tart)'),
            array('far fa-pie' => 'pie(apple,bakery,cake,crust,dessert,pumpkin,tart)'),
            array('fal fa-pie' => 'pie(apple,bakery,cake,crust,dessert,pumpkin,tart)'),
            array('fas fa-pizza' => 'pizza(cheese,chicago,italian,mozzarella,new york,pepperoni,pie,slice,teenage mutant ninja turtles,tomato)'),
            array('far fa-pizza' => 'pizza(cheese,chicago,italian,mozzarella,new york,pepperoni,pie,slice,teenage mutant ninja turtles,tomato)'),
            array('fal fa-pizza' => 'pizza(cheese,chicago,italian,mozzarella,new york,pepperoni,pie,slice,teenage mutant ninja turtles,tomato)'),
            array('fas fa-pizza-slice' => 'pizza-slice(cheese,chicago,italian,mozzarella,new york,pepperoni,pie,slice,teenage mutant ninja turtles,tomato)'),
            array('far fa-pizza-slice' => 'pizza-slice(cheese,chicago,italian,mozzarella,new york,pepperoni,pie,slice,teenage mutant ninja turtles,tomato)'),
            array('fal fa-pizza-slice' => 'pizza-slice(cheese,chicago,italian,mozzarella,new york,pepperoni,pie,slice,teenage mutant ninja turtles,tomato)'),
            array('fas fa-popcorn' => 'popcorn(bucket,butter,corn,junk food,kernels,movie,snack,theater)'),
            array('far fa-popcorn' => 'popcorn(bucket,butter,corn,junk food,kernels,movie,snack,theater)'),
            array('fal fa-popcorn' => 'popcorn(bucket,butter,corn,junk food,kernels,movie,snack,theater)'),
            array('fas fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('far fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('fal fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('fas fa-salad' => 'salad(bowl,health,lettuce,spinach,vegan,vegetable,vegetarian)'),
            array('far fa-salad' => 'salad(bowl,health,lettuce,spinach,vegan,vegetable,vegetarian)'),
            array('fal fa-salad' => 'salad(bowl,health,lettuce,spinach,vegan,vegetable,vegetarian)'),
            array('fas fa-sandwich' => 'sandwich(bread,deli,grilled cheese,toast)'),
            array('far fa-sandwich' => 'sandwich(bread,deli,grilled cheese,toast)'),
            array('fal fa-sandwich' => 'sandwich(bread,deli,grilled cheese,toast)'),
            array('fas fa-sausage' => 'sausage(bratwurst,breakfast,chorizo,frankfurt,frankfurter,hot dog,hotdog,kielbasa,kosher,pepperoni,polish,vienna,weiner)'),
            array('far fa-sausage' => 'sausage(bratwurst,breakfast,chorizo,frankfurt,frankfurter,hot dog,hotdog,kielbasa,kosher,pepperoni,polish,vienna,weiner)'),
            array('fal fa-sausage' => 'sausage(bratwurst,breakfast,chorizo,frankfurt,frankfurter,hot dog,hotdog,kielbasa,kosher,pepperoni,polish,vienna,weiner)'),
            array('fas fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('far fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fal fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fas fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('far fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('fal fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('fas fa-soup' => 'soup(bisque,bouillon,bowl,broth,chicken,chowder,gazpacho,ramen,stew)'),
            array('far fa-soup' => 'soup(bisque,bouillon,bowl,broth,chicken,chowder,gazpacho,ramen,stew)'),
            array('fal fa-soup' => 'soup(bisque,bouillon,bowl,broth,chicken,chowder,gazpacho,ramen,stew)'),
            array('fas fa-steak' => 'steak(beef,grill,meat,sirloin)'),
            array('far fa-steak' => 'steak(beef,grill,meat,sirloin)'),
            array('fal fa-steak' => 'steak(beef,grill,meat,sirloin)'),
            array('fas fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('far fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('fal fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('fas fa-taco' => 'taco(corn,maize,mexican,salsa,tortilla)'),
            array('far fa-taco' => 'taco(corn,maize,mexican,salsa,tortilla)'),
            array('fal fa-taco' => 'taco(corn,maize,mexican,salsa,tortilla)'),
            array('fas fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('far fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('fal fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('fas fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
            array('far fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
            array('fal fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
        ),
        'Fruits & Vegetables' => array(
            array('fas fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('far fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fal fa-apple-alt' => 'apple-alt(fall,fruit,fuji,macintosh,orchard,seasonal,vegan)'),
            array('fas fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('far fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('fal fa-apple-crate' => 'apple-crate(bushel,container,fall,fruit,fuji,macintosh,orchard,peck,seasonal)'),
            array('fas fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('far fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fal fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fas fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('far fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fal fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fas fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('far fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fal fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fas fa-pepper-hot' => 'pepper-hot(buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)'),
            array('far fa-pepper-hot' => 'pepper-hot(buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)'),
            array('fal fa-pepper-hot' => 'pepper-hot(buffalo wings,capsicum,chili,chilli,habanero,jalapeno,mexican,spicy,tabasco,vegetable)'),
            array('fas fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('far fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('fal fa-pumpkin' => 'pumpkin(autumn,gourd,halloween,harvest,squash,thanksgiving,vegetable)'),
            array('fas fa-salad' => 'salad(bowl,health,lettuce,spinach,vegan,vegetable,vegetarian)'),
            array('far fa-salad' => 'salad(bowl,health,lettuce,spinach,vegan,vegetable,vegetarian)'),
            array('fal fa-salad' => 'salad(bowl,health,lettuce,spinach,vegan,vegetable,vegetarian)'),
            array('fas fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('far fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fal fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fas fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
            array('far fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
            array('fal fa-wheat' => 'wheat(argriculture,fall,farming,grain,seasonal)'),
        ),
        'Games' => array(
            array('fas fa-chess' => 'chess(board,checkmate,game,strategy,tournament)'),
            array('far fa-chess' => 'chess(board,checkmate,game,strategy,tournament)'),
            array('fal fa-chess' => 'chess(board,checkmate,game,strategy,tournament)'),
            array('fas fa-chess-bishop' => 'chess-bishop(board,checkmate,game,strategy)'),
            array('far fa-chess-bishop' => 'chess-bishop(board,checkmate,game,strategy)'),
            array('fal fa-chess-bishop' => 'chess-bishop(board,checkmate,game,strategy)'),
            array('fas fa-chess-bishop-alt' => 'chess-bishop-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-bishop-alt' => 'chess-bishop-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-bishop-alt' => 'chess-bishop-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-board' => 'chess-board(board,checkmate,game,strategy)'),
            array('far fa-chess-board' => 'chess-board(board,checkmate,game,strategy)'),
            array('fal fa-chess-board' => 'chess-board(board,checkmate,game,strategy)'),
            array('fas fa-chess-clock' => 'chess-clock(board,checkmate,game,strategy,timer,tournament)'),
            array('far fa-chess-clock' => 'chess-clock(board,checkmate,game,strategy,timer,tournament)'),
            array('fal fa-chess-clock' => 'chess-clock(board,checkmate,game,strategy,timer,tournament)'),
            array('fas fa-chess-clock-alt' => 'chess-clock-alt(board,checkmate,game,strategy,timer,tournament)'),
            array('far fa-chess-clock-alt' => 'chess-clock-alt(board,checkmate,game,strategy,timer,tournament)'),
            array('fal fa-chess-clock-alt' => 'chess-clock-alt(board,checkmate,game,strategy,timer,tournament)'),
            array('fas fa-chess-king' => 'chess-king(board,checkmate,game,strategy)'),
            array('far fa-chess-king' => 'chess-king(board,checkmate,game,strategy)'),
            array('fal fa-chess-king' => 'chess-king(board,checkmate,game,strategy)'),
            array('fas fa-chess-king-alt' => 'chess-king-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-king-alt' => 'chess-king-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-king-alt' => 'chess-king-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-knight' => 'chess-knight(board,checkmate,game,horse,strategy)'),
            array('far fa-chess-knight' => 'chess-knight(board,checkmate,game,horse,strategy)'),
            array('fal fa-chess-knight' => 'chess-knight(board,checkmate,game,horse,strategy)'),
            array('fas fa-chess-knight-alt' => 'chess-knight-alt(board,checkmate,game,horse,strategy)'),
            array('far fa-chess-knight-alt' => 'chess-knight-alt(board,checkmate,game,horse,strategy)'),
            array('fal fa-chess-knight-alt' => 'chess-knight-alt(board,checkmate,game,horse,strategy)'),
            array('fas fa-chess-pawn' => 'chess-pawn(board,checkmate,game,strategy)'),
            array('far fa-chess-pawn' => 'chess-pawn(board,checkmate,game,strategy)'),
            array('fal fa-chess-pawn' => 'chess-pawn(board,checkmate,game,strategy)'),
            array('fas fa-chess-pawn-alt' => 'chess-pawn-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-pawn-alt' => 'chess-pawn-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-pawn-alt' => 'chess-pawn-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-queen' => 'chess-queen(board,checkmate,game,strategy)'),
            array('far fa-chess-queen' => 'chess-queen(board,checkmate,game,strategy)'),
            array('fal fa-chess-queen' => 'chess-queen(board,checkmate,game,strategy)'),
            array('fas fa-chess-queen-alt' => 'chess-queen-alt(board,checkmate,game,strategy)'),
            array('far fa-chess-queen-alt' => 'chess-queen-alt(board,checkmate,game,strategy)'),
            array('fal fa-chess-queen-alt' => 'chess-queen-alt(board,checkmate,game,strategy)'),
            array('fas fa-chess-rook' => 'chess-rook(board,castle,checkmate,game,strategy)'),
            array('far fa-chess-rook' => 'chess-rook(board,castle,checkmate,game,strategy)'),
            array('fal fa-chess-rook' => 'chess-rook(board,castle,checkmate,game,strategy)'),
            array('fas fa-chess-rook-alt' => 'chess-rook-alt(board,castle,checkmate,game,strategy)'),
            array('far fa-chess-rook-alt' => 'chess-rook-alt(board,castle,checkmate,game,strategy)'),
            array('fal fa-chess-rook-alt' => 'chess-rook-alt(board,castle,checkmate,game,strategy)'),
            array('fas fa-club' => 'club(card,game,poker,suit)'),
            array('far fa-club' => 'club(card,game,poker,suit)'),
            array('fal fa-club' => 'club(card,game,poker,suit)'),
            array('fas fa-diamond' => 'diamond(cards,gem,gemstone,poker,suit)'),
            array('far fa-diamond' => 'diamond(cards,gem,gemstone,poker,suit)'),
            array('fal fa-diamond' => 'diamond(cards,gem,gemstone,poker,suit)'),
            array('fas fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('far fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('fal fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('fas fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('far fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('fal fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('fas fa-dice-four' => 'dice-four(chance,gambling,game,roll)'),
            array('far fa-dice-four' => 'dice-four(chance,gambling,game,roll)'),
            array('fal fa-dice-four' => 'dice-four(chance,gambling,game,roll)'),
            array('fas fa-dice-one' => 'dice-one(chance,gambling,game,roll)'),
            array('far fa-dice-one' => 'dice-one(chance,gambling,game,roll)'),
            array('fal fa-dice-one' => 'dice-one(chance,gambling,game,roll)'),
            array('fas fa-dice-six' => 'dice-six(chance,gambling,game,roll)'),
            array('far fa-dice-six' => 'dice-six(chance,gambling,game,roll)'),
            array('fal fa-dice-six' => 'dice-six(chance,gambling,game,roll)'),
            array('fas fa-dice-three' => 'dice-three(chance,gambling,game,roll)'),
            array('far fa-dice-three' => 'dice-three(chance,gambling,game,roll)'),
            array('fal fa-dice-three' => 'dice-three(chance,gambling,game,roll)'),
            array('fas fa-dice-two' => 'dice-two(chance,gambling,game,roll)'),
            array('far fa-dice-two' => 'dice-two(chance,gambling,game,roll)'),
            array('fal fa-dice-two' => 'dice-two(chance,gambling,game,roll)'),
            array('fas fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('far fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('fal fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('fas fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('far fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('fal fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('fas fa-ghost' => 'ghost(apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)'),
            array('far fa-ghost' => 'ghost(apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)'),
            array('fal fa-ghost' => 'ghost(apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)'),
            array('fas fa-headset' => 'headset(audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)'),
            array('far fa-headset' => 'headset(audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)'),
            array('fal fa-headset' => 'headset(audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fab fa-nintendo-switch' => 'nintendo-switch'),
            array('fab fa-playstation' => 'playstation'),
            array('fas fa-puzzle-piece' => 'puzzle-piece(add-on,addon,game,section)'),
            array('far fa-puzzle-piece' => 'puzzle-piece(add-on,addon,game,section)'),
            array('fal fa-puzzle-piece' => 'puzzle-piece(add-on,addon,game,section)'),
            array('fas fa-spade' => 'spade(card,game,poker,suit)'),
            array('far fa-spade' => 'spade(card,game,poker,suit)'),
            array('fal fa-spade' => 'spade(card,game,poker,suit)'),
            array('fab fa-steam' => 'steam'),
            array('fab fa-steam-square' => 'steam-square'),
            array('fab fa-steam-symbol' => 'steam-symbol'),
            array('fab fa-twitch' => 'twitch'),
            array('fab fa-xbox' => 'xbox'),
        ),
        'Tabletop Gaming' => array(
            array('fab fa-acquisitions-incorporated' => 'acquisitions-incorporated(Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)'),
            array('fas fa-axe-battle' => 'axe-battle(Dungeons & Dragons,barbarian,d&d,dnd,fantasy,gimli,lumberjack,melee attack)'),
            array('far fa-axe-battle' => 'axe-battle(Dungeons & Dragons,barbarian,d&d,dnd,fantasy,gimli,lumberjack,melee attack)'),
            array('fal fa-axe-battle' => 'axe-battle(Dungeons & Dragons,barbarian,d&d,dnd,fantasy,gimli,lumberjack,melee attack)'),
            array('fas fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('far fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('fal fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('fas fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('far fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fal fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fas fa-bow-arrow' => 'bow-arrow(Dungeons & Dragons,archery,d&d,dnd,fantasy,legolas,ranged attack,ranger,weapon)'),
            array('far fa-bow-arrow' => 'bow-arrow(Dungeons & Dragons,archery,d&d,dnd,fantasy,legolas,ranged attack,ranger,weapon)'),
            array('fal fa-bow-arrow' => 'bow-arrow(Dungeons & Dragons,archery,d&d,dnd,fantasy,legolas,ranged attack,ranger,weapon)'),
            array('fas fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('far fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('fal fa-campfire' => 'campfire(Dungeons & Dragons,caliente,campaign,camping,d&d,dnd,fall,fire,flame,gathering,heat,hot,meeting,outdoors,seasonal,tent,wilderness)'),
            array('fab fa-critical-role' => 'critical-role(Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)'),
            array('fab fa-d-and-d' => 'd-and-d'),
            array('fab fa-d-and-d-beyond' => 'd-and-d-beyond(Dungeons & Dragons,d&d,dnd,fantasy,gaming,tabletop)'),
            array('fas fa-dagger' => 'dagger(Dungeons & Dragons,blade,d&d,dnd,fantasy,melee attack,rogue,sting,weapon)'),
            array('far fa-dagger' => 'dagger(Dungeons & Dragons,blade,d&d,dnd,fantasy,melee attack,rogue,sting,weapon)'),
            array('fal fa-dagger' => 'dagger(Dungeons & Dragons,blade,d&d,dnd,fantasy,melee attack,rogue,sting,weapon)'),
            array('fas fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dragon' => 'dragon(Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)'),
            array('far fa-dragon' => 'dragon(Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)'),
            array('fal fa-dragon' => 'dragon(Dungeons & Dragons,d&d,dnd,fantasy,fire,lizard,serpent)'),
            array('fas fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('far fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fal fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fas fa-eye-evil' => 'eye-evil(Dungeons & Dragons,d&d,dnd,fantasy,sauron,see,seen,show,sight)'),
            array('far fa-eye-evil' => 'eye-evil(Dungeons & Dragons,d&d,dnd,fantasy,sauron,see,seen,show,sight)'),
            array('fal fa-eye-evil' => 'eye-evil(Dungeons & Dragons,d&d,dnd,fantasy,sauron,see,seen,show,sight)'),
            array('fab fa-fantasy-flight-games' => 'fantasy-flight-games(Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)'),
            array('fas fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('far fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('fal fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('fas fa-flame' => 'flame(Dungeons & Dragons,caliente,d&d,dnd,fantasy,heat,hot)'),
            array('far fa-flame' => 'flame(Dungeons & Dragons,caliente,d&d,dnd,fantasy,heat,hot)'),
            array('fal fa-flame' => 'flame(Dungeons & Dragons,caliente,d&d,dnd,fantasy,heat,hot)'),
            array('fas fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('far fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fal fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fas fa-hammer-war' => 'hammer-war(Dungeons & Dragons,cleric,d&d,dnd,dwarf,fantasy,melee attack,weapon)'),
            array('far fa-hammer-war' => 'hammer-war(Dungeons & Dragons,cleric,d&d,dnd,dwarf,fantasy,melee attack,weapon)'),
            array('fal fa-hammer-war' => 'hammer-war(Dungeons & Dragons,cleric,d&d,dnd,dwarf,fantasy,melee attack,weapon)'),
            array('fas fa-hand-holding-magic' => 'hand-holding-magic(Dungeons & Dragons,carry,cast,d&d,dnd,fantasy,lift,mage,spell,witch,wizard)'),
            array('far fa-hand-holding-magic' => 'hand-holding-magic(Dungeons & Dragons,carry,cast,d&d,dnd,fantasy,lift,mage,spell,witch,wizard)'),
            array('fal fa-hand-holding-magic' => 'hand-holding-magic(Dungeons & Dragons,carry,cast,d&d,dnd,fantasy,lift,mage,spell,witch,wizard)'),
            array('fas fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('far fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fal fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fas fa-helmet-battle' => 'helmet-battle(Dungeons & Dragons,armor,clothing,d&d,dnd,fantasy,hat,knight,paladin)'),
            array('far fa-helmet-battle' => 'helmet-battle(Dungeons & Dragons,armor,clothing,d&d,dnd,fantasy,hat,knight,paladin)'),
            array('fal fa-helmet-battle' => 'helmet-battle(Dungeons & Dragons,armor,clothing,d&d,dnd,fantasy,hat,knight,paladin)'),
            array('fas fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('far fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('fal fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('fas fa-mace' => 'mace(Dungeons & Dragons,d&d,dnd,fantasy,melee attack,weapon,windu)'),
            array('far fa-mace' => 'mace(Dungeons & Dragons,d&d,dnd,fantasy,melee attack,weapon,windu)'),
            array('fal fa-mace' => 'mace(Dungeons & Dragons,d&d,dnd,fantasy,melee attack,weapon,windu)'),
            array('fas fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('far fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('fal fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('fas fa-paw-claws' => 'paw-claws(Dungeons & Dragons,animal,beast,d&d,dnd,fantasy,lion,pet,print)'),
            array('far fa-paw-claws' => 'paw-claws(Dungeons & Dragons,animal,beast,d&d,dnd,fantasy,lion,pet,print)'),
            array('fal fa-paw-claws' => 'paw-claws(Dungeons & Dragons,animal,beast,d&d,dnd,fantasy,lion,pet,print)'),
            array('fab fa-penny-arcade' => 'penny-arcade(Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,pax,tabletop)'),
            array('fas fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('far fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('fal fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('fas fa-scroll' => 'scroll(Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)'),
            array('far fa-scroll' => 'scroll(Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)'),
            array('fal fa-scroll' => 'scroll(Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)'),
            array('fas fa-scroll-old' => 'scroll-old(Dungeons & Dragons,ancient,announcement,d&d,dnd,fantasy,paper,relic,script,worn)'),
            array('far fa-scroll-old' => 'scroll-old(Dungeons & Dragons,ancient,announcement,d&d,dnd,fantasy,paper,relic,script,worn)'),
            array('fal fa-scroll-old' => 'scroll-old(Dungeons & Dragons,ancient,announcement,d&d,dnd,fantasy,paper,relic,script,worn)'),
            array('fas fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('far fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('fal fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('fas fa-shield-cross' => 'shield-cross(Dungeons & Dragons,block,crusader,d&d,defend,dnd,fantasy,security,templar)'),
            array('far fa-shield-cross' => 'shield-cross(Dungeons & Dragons,block,crusader,d&d,defend,dnd,fantasy,security,templar)'),
            array('fal fa-shield-cross' => 'shield-cross(Dungeons & Dragons,block,crusader,d&d,defend,dnd,fantasy,security,templar)'),
            array('fas fa-sickle' => 'sickle(blade,d&d,dnd,dungeons & dragons,fantasy,weapon)'),
            array('far fa-sickle' => 'sickle(blade,d&d,dnd,dungeons & dragons,fantasy,weapon)'),
            array('fal fa-sickle' => 'sickle(blade,d&d,dnd,dungeons & dragons,fantasy,weapon)'),
            array('fas fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('far fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fal fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fas fa-staff' => 'staff(Dungeons & Dragons,d&d,dnd,fantasy,mage,stick,weapon)'),
            array('far fa-staff' => 'staff(Dungeons & Dragons,d&d,dnd,fantasy,mage,stick,weapon)'),
            array('fal fa-staff' => 'staff(Dungeons & Dragons,d&d,dnd,fantasy,mage,stick,weapon)'),
            array('fas fa-sword' => 'sword(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('far fa-sword' => 'sword(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fal fa-sword' => 'sword(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fas fa-swords' => 'swords(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('far fa-swords' => 'swords(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fal fa-swords' => 'swords(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fas fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('far fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fal fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fas fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('far fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('fal fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('fas fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('far fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('fal fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('fab fa-wizards-of-the-coast' => 'wizards-of-the-coast(Dungeons & Dragons,d&d,dnd,fantasy,game,gaming,tabletop)'),
        ),
        'Genders' => array(
            array('fas fa-genderless' => 'genderless(androgynous,asexual,sexless)'),
            array('far fa-genderless' => 'genderless(androgynous,asexual,sexless)'),
            array('fal fa-genderless' => 'genderless(androgynous,asexual,sexless)'),
            array('fas fa-mars' => 'mars(male)'),
            array('far fa-mars' => 'mars(male)'),
            array('fal fa-mars' => 'mars(male)'),
            array('fas fa-mars-double' => 'mars-double'),
            array('far fa-mars-double' => 'mars-double'),
            array('fal fa-mars-double' => 'mars-double'),
            array('fas fa-mars-stroke' => 'mars-stroke'),
            array('far fa-mars-stroke' => 'mars-stroke'),
            array('fal fa-mars-stroke' => 'mars-stroke'),
            array('fas fa-mars-stroke-h' => 'mars-stroke-h'),
            array('far fa-mars-stroke-h' => 'mars-stroke-h'),
            array('fal fa-mars-stroke-h' => 'mars-stroke-h'),
            array('fas fa-mars-stroke-v' => 'mars-stroke-v'),
            array('far fa-mars-stroke-v' => 'mars-stroke-v'),
            array('fal fa-mars-stroke-v' => 'mars-stroke-v'),
            array('fas fa-mercury' => 'mercury(transgender)'),
            array('far fa-mercury' => 'mercury(transgender)'),
            array('fal fa-mercury' => 'mercury(transgender)'),
            array('fas fa-neuter' => 'neuter'),
            array('far fa-neuter' => 'neuter'),
            array('fal fa-neuter' => 'neuter'),
            array('fas fa-transgender' => 'transgender(intersex)'),
            array('far fa-transgender' => 'transgender(intersex)'),
            array('fal fa-transgender' => 'transgender(intersex)'),
            array('fas fa-transgender-alt' => 'transgender-alt(intersex)'),
            array('far fa-transgender-alt' => 'transgender-alt(intersex)'),
            array('fal fa-transgender-alt' => 'transgender-alt(intersex)'),
            array('fas fa-venus' => 'venus(female)'),
            array('far fa-venus' => 'venus(female)'),
            array('fal fa-venus' => 'venus(female)'),
            array('fas fa-venus-double' => 'venus-double(female)'),
            array('far fa-venus-double' => 'venus-double(female)'),
            array('fal fa-venus-double' => 'venus-double(female)'),
            array('fas fa-venus-mars' => 'venus-mars(Gender)'),
            array('far fa-venus-mars' => 'venus-mars(Gender)'),
            array('fal fa-venus-mars' => 'venus-mars(Gender)'),
        ),
        'Halloween' => array(
            array('fas fa-bat' => 'bat(animal,batman,bruce wayne,flying,gotham,halloween,mammal,vampire,wings)'),
            array('far fa-bat' => 'bat(animal,batman,bruce wayne,flying,gotham,halloween,mammal,vampire,wings)'),
            array('fal fa-bat' => 'bat(animal,batman,bruce wayne,flying,gotham,halloween,mammal,vampire,wings)'),
            array('fas fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('far fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('fal fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('fas fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('far fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fal fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fas fa-broom' => 'broom(clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)'),
            array('far fa-broom' => 'broom(clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)'),
            array('fal fa-broom' => 'broom(clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)'),
            array('fas fa-candle-holder' => 'candle-holder(fire,flame,halloween,holiday,hot,light,lit,wick)'),
            array('far fa-candle-holder' => 'candle-holder(fire,flame,halloween,holiday,hot,light,lit,wick)'),
            array('fal fa-candle-holder' => 'candle-holder(fire,flame,halloween,holiday,hot,light,lit,wick)'),
            array('fas fa-candy-corn' => 'candy-corn(halloween,holiday,sugar,triangles)'),
            array('far fa-candy-corn' => 'candy-corn(halloween,holiday,sugar,triangles)'),
            array('fal fa-candy-corn' => 'candy-corn(halloween,holiday,sugar,triangles)'),
            array('fas fa-cat' => 'cat(feline,halloween,holiday,kitten,kitty,meow,pet)'),
            array('far fa-cat' => 'cat(feline,halloween,holiday,kitten,kitty,meow,pet)'),
            array('fal fa-cat' => 'cat(feline,halloween,holiday,kitten,kitty,meow,pet)'),
            array('fas fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('far fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fal fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fas fa-claw-marks' => 'claw-marks(attack,damage,halloween,rip,scratch,snikt,tear,torn,wolverine)'),
            array('far fa-claw-marks' => 'claw-marks(attack,damage,halloween,rip,scratch,snikt,tear,torn,wolverine)'),
            array('fal fa-claw-marks' => 'claw-marks(attack,damage,halloween,rip,scratch,snikt,tear,torn,wolverine)'),
            array('fas fa-cloud-moon' => 'cloud-moon(crescent,evening,lunar,night,partly cloudy,sky)'),
            array('far fa-cloud-moon' => 'cloud-moon(crescent,evening,lunar,night,partly cloudy,sky)'),
            array('fal fa-cloud-moon' => 'cloud-moon(crescent,evening,lunar,night,partly cloudy,sky)'),
            array('fas fa-coffin' => 'coffin(box,burial,casket,cemetery,death,eulogy,funeral,halloween,vampire)'),
            array('far fa-coffin' => 'coffin(box,burial,casket,cemetery,death,eulogy,funeral,halloween,vampire)'),
            array('fal fa-coffin' => 'coffin(box,burial,casket,cemetery,death,eulogy,funeral,halloween,vampire)'),
            array('fas fa-crow' => 'crow(bird,bullfrog,fauna,halloween,holiday,toad)'),
            array('far fa-crow' => 'crow(bird,bullfrog,fauna,halloween,holiday,toad)'),
            array('fal fa-crow' => 'crow(bird,bullfrog,fauna,halloween,holiday,toad)'),
            array('fas fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('far fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('fal fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('fas fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('far fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fal fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fas fa-ghost' => 'ghost(apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)'),
            array('far fa-ghost' => 'ghost(apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)'),
            array('fal fa-ghost' => 'ghost(apparition,blinky,clyde,floating,halloween,holiday,inky,pinky,spirit)'),
            array('fas fa-hat-witch' => 'hat-witch(accessory,clothing,halloween,head,holiday,mage,magic,sorceror)'),
            array('far fa-hat-witch' => 'hat-witch(accessory,clothing,halloween,head,holiday,mage,magic,sorceror)'),
            array('fal fa-hat-witch' => 'hat-witch(accessory,clothing,halloween,head,holiday,mage,magic,sorceror)'),
            array('fas fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('far fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fal fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fas fa-hockey-mask' => 'hockey-mask(clothing,friday,halloween,ice,jason,nhl,protection,sport,thirteenth)'),
            array('far fa-hockey-mask' => 'hockey-mask(clothing,friday,halloween,ice,jason,nhl,protection,sport,thirteenth)'),
            array('fal fa-hockey-mask' => 'hockey-mask(clothing,friday,halloween,ice,jason,nhl,protection,sport,thirteenth)'),
            array('fas fa-jack-o-lantern' => 'jack-o-lantern(carve,face,halloween,lantern,pumpkin,smile)'),
            array('far fa-jack-o-lantern' => 'jack-o-lantern(carve,face,halloween,lantern,pumpkin,smile)'),
            array('fal fa-jack-o-lantern' => 'jack-o-lantern(carve,face,halloween,lantern,pumpkin,smile)'),
            array('fas fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('far fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('fal fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('fas fa-knife-kitchen' => 'knife-kitchen(chef,cut,halloween,sharp,slice,tool)'),
            array('far fa-knife-kitchen' => 'knife-kitchen(chef,cut,halloween,sharp,slice,tool)'),
            array('fal fa-knife-kitchen' => 'knife-kitchen(chef,cut,halloween,sharp,slice,tool)'),
            array('fas fa-mask' => 'mask(carnivale,costume,disguise,halloween,secret,super hero)'),
            array('far fa-mask' => 'mask(carnivale,costume,disguise,halloween,secret,super hero)'),
            array('fal fa-mask' => 'mask(carnivale,costume,disguise,halloween,secret,super hero)'),
            array('fas fa-scarecrow' => 'scarecrow(bird,crow,farm,field,halloween,strawman)'),
            array('far fa-scarecrow' => 'scarecrow(bird,crow,farm,field,halloween,strawman)'),
            array('fal fa-scarecrow' => 'scarecrow(bird,crow,farm,field,halloween,strawman)'),
            array('fas fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('far fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('fal fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('fas fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('far fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fal fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fas fa-spider' => 'spider(arachnid,bug,charlotte,crawl,eight,halloween)'),
            array('far fa-spider' => 'spider(arachnid,bug,charlotte,crawl,eight,halloween)'),
            array('fal fa-spider' => 'spider(arachnid,bug,charlotte,crawl,eight,halloween)'),
            array('fas fa-spider-black-widow' => 'spider-black-widow(alert,arachnid,bug,charlotte,crawl,danger,dangerous,deadly,eight,error,halloween)'),
            array('far fa-spider-black-widow' => 'spider-black-widow(alert,arachnid,bug,charlotte,crawl,danger,dangerous,deadly,eight,error,halloween)'),
            array('fal fa-spider-black-widow' => 'spider-black-widow(alert,arachnid,bug,charlotte,crawl,danger,dangerous,deadly,eight,error,halloween)'),
            array('fas fa-spider-web' => 'spider-web(cobweb,gossamer,halloween)'),
            array('far fa-spider-web' => 'spider-web(cobweb,gossamer,halloween)'),
            array('fal fa-spider-web' => 'spider-web(cobweb,gossamer,halloween)'),
            array('fas fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('far fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fal fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fas fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('far fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fal fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fas fa-tombstone' => 'tombstone(cemetery,cross,dead,death,delete,grave,halloween,holiday,remove)'),
            array('far fa-tombstone' => 'tombstone(cemetery,cross,dead,death,delete,grave,halloween,holiday,remove)'),
            array('fal fa-tombstone' => 'tombstone(cemetery,cross,dead,death,delete,grave,halloween,holiday,remove)'),
            array('fas fa-tombstone-alt' => 'tombstone-alt(cemetery,cross,dead,death,delete,grave,halloween,holiday,remove)'),
            array('far fa-tombstone-alt' => 'tombstone-alt(cemetery,cross,dead,death,delete,grave,halloween,holiday,remove)'),
            array('fal fa-tombstone-alt' => 'tombstone-alt(cemetery,cross,dead,death,delete,grave,halloween,holiday,remove)'),
            array('fas fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('far fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('fal fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('fas fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('far fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('fal fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
        ),
        'Hands' => array(
            array('fas fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('far fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('fal fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('fas fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('far fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('fal fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('fas fa-hand-heart' => 'hand-heart(care,charity,donate,help)'),
            array('far fa-hand-heart' => 'hand-heart(care,charity,donate,help)'),
            array('fal fa-hand-heart' => 'hand-heart(care,charity,donate,help)'),
            array('fas fa-hand-holding' => 'hand-holding(carry,lift)'),
            array('far fa-hand-holding' => 'hand-holding(carry,lift)'),
            array('fal fa-hand-holding' => 'hand-holding(carry,lift)'),
            array('fas fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('far fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('fal fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('fas fa-hand-holding-heart' => 'hand-holding-heart(carry,charity,gift,lift,package)'),
            array('far fa-hand-holding-heart' => 'hand-holding-heart(carry,charity,gift,lift,package)'),
            array('fal fa-hand-holding-heart' => 'hand-holding-heart(carry,charity,gift,lift,package)'),
            array('fas fa-hand-holding-magic' => 'hand-holding-magic(Dungeons & Dragons,carry,cast,d&d,dnd,fantasy,lift,mage,spell,witch,wizard)'),
            array('far fa-hand-holding-magic' => 'hand-holding-magic(Dungeons & Dragons,carry,cast,d&d,dnd,fantasy,lift,mage,spell,witch,wizard)'),
            array('fal fa-hand-holding-magic' => 'hand-holding-magic(Dungeons & Dragons,carry,cast,d&d,dnd,fantasy,lift,mage,spell,witch,wizard)'),
            array('fas fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('far fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('fal fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('fas fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('far fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('fal fa-hand-holding-usd' => 'hand-holding-usd($,carry,dollar sign,donation,giving,lift,money,price)'),
            array('fas fa-hand-holding-water' => 'hand-holding-water(carry,drought,grow,lift)'),
            array('far fa-hand-holding-water' => 'hand-holding-water(carry,drought,grow,lift)'),
            array('fal fa-hand-holding-water' => 'hand-holding-water(carry,drought,grow,lift)'),
            array('fas fa-hand-lizard' => 'hand-lizard(game,roshambo)'),
            array('far fa-hand-lizard' => 'hand-lizard(game,roshambo)'),
            array('fal fa-hand-lizard' => 'hand-lizard(game,roshambo)'),
            array('fas fa-hand-middle-finger' => 'hand-middle-finger(flip the bird,gesture,hate,rude)'),
            array('far fa-hand-middle-finger' => 'hand-middle-finger(flip the bird,gesture,hate,rude)'),
            array('fal fa-hand-middle-finger' => 'hand-middle-finger(flip the bird,gesture,hate,rude)'),
            array('fas fa-hand-paper' => 'hand-paper(game,halt,roshambo,stop)'),
            array('far fa-hand-paper' => 'hand-paper(game,halt,roshambo,stop)'),
            array('fal fa-hand-paper' => 'hand-paper(game,halt,roshambo,stop)'),
            array('fas fa-hand-peace' => 'hand-peace(rest,truce)'),
            array('far fa-hand-peace' => 'hand-peace(rest,truce)'),
            array('fal fa-hand-peace' => 'hand-peace(rest,truce)'),
            array('fas fa-hand-point-down' => 'hand-point-down(finger,hand-o-down,point)'),
            array('far fa-hand-point-down' => 'hand-point-down(finger,hand-o-down,point)'),
            array('fal fa-hand-point-down' => 'hand-point-down(finger,hand-o-down,point)'),
            array('fas fa-hand-point-left' => 'hand-point-left(back,finger,hand-o-left,left,point,previous)'),
            array('far fa-hand-point-left' => 'hand-point-left(back,finger,hand-o-left,left,point,previous)'),
            array('fal fa-hand-point-left' => 'hand-point-left(back,finger,hand-o-left,left,point,previous)'),
            array('fas fa-hand-point-right' => 'hand-point-right(finger,forward,hand-o-right,next,point,right)'),
            array('far fa-hand-point-right' => 'hand-point-right(finger,forward,hand-o-right,next,point,right)'),
            array('fal fa-hand-point-right' => 'hand-point-right(finger,forward,hand-o-right,next,point,right)'),
            array('fas fa-hand-point-up' => 'hand-point-up(finger,hand-o-up,point)'),
            array('far fa-hand-point-up' => 'hand-point-up(finger,hand-o-up,point)'),
            array('fal fa-hand-point-up' => 'hand-point-up(finger,hand-o-up,point)'),
            array('fas fa-hand-pointer' => 'hand-pointer(arrow,cursor,select)'),
            array('far fa-hand-pointer' => 'hand-pointer(arrow,cursor,select)'),
            array('fal fa-hand-pointer' => 'hand-pointer(arrow,cursor,select)'),
            array('fas fa-hand-receiving' => 'hand-receiving(carry,gift,handling,package,shipping)'),
            array('far fa-hand-receiving' => 'hand-receiving(carry,gift,handling,package,shipping)'),
            array('fal fa-hand-receiving' => 'hand-receiving(carry,gift,handling,package,shipping)'),
            array('fas fa-hand-rock' => 'hand-rock(fist,game,roshambo)'),
            array('far fa-hand-rock' => 'hand-rock(fist,game,roshambo)'),
            array('fal fa-hand-rock' => 'hand-rock(fist,game,roshambo)'),
            array('fas fa-hand-scissors' => 'hand-scissors(cut,game,roshambo)'),
            array('far fa-hand-scissors' => 'hand-scissors(cut,game,roshambo)'),
            array('fal fa-hand-scissors' => 'hand-scissors(cut,game,roshambo)'),
            array('fas fa-hand-spock' => 'hand-spock(live long,prosper,salute,star trek,vulcan)'),
            array('far fa-hand-spock' => 'hand-spock(live long,prosper,salute,star trek,vulcan)'),
            array('fal fa-hand-spock' => 'hand-spock(live long,prosper,salute,star trek,vulcan)'),
            array('fas fa-hands' => 'hands(carry,hold,lift)'),
            array('far fa-hands' => 'hands(carry,hold,lift)'),
            array('fal fa-hands' => 'hands(carry,hold,lift)'),
            array('fas fa-hands-heart' => 'hands-heart(carry,gift,help,hold,lift)'),
            array('far fa-hands-heart' => 'hands-heart(carry,gift,help,hold,lift)'),
            array('fal fa-hands-heart' => 'hands-heart(carry,gift,help,hold,lift)'),
            array('fas fa-hands-helping' => 'hands-helping(aid,assistance,handshake,partnership,volunteering)'),
            array('far fa-hands-helping' => 'hands-helping(aid,assistance,handshake,partnership,volunteering)'),
            array('fal fa-hands-helping' => 'hands-helping(aid,assistance,handshake,partnership,volunteering)'),
            array('fas fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('far fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('fal fa-hands-usd' => 'hands-usd($,carry,dollar sign,donation,giving,hold,money,price,usd)'),
            array('fas fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('far fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fal fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fas fa-handshake-alt' => 'handshake-alt(agreement,greeting,partnership. meeting)'),
            array('far fa-handshake-alt' => 'handshake-alt(agreement,greeting,partnership. meeting)'),
            array('fal fa-handshake-alt' => 'handshake-alt(agreement,greeting,partnership. meeting)'),
            array('fas fa-praying-hands' => 'praying-hands(kneel,preach,religion,worship)'),
            array('far fa-praying-hands' => 'praying-hands(kneel,preach,religion,worship)'),
            array('fal fa-praying-hands' => 'praying-hands(kneel,preach,religion,worship)'),
            array('fas fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('far fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fal fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fas fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('far fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fal fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
        ),
        'Health' => array(
            array('fab fa-accessible-icon' => 'accessible-icon(accessibility,handicap,person,wheelchair,wheelchair-alt)'),
            array('fas fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('far fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fal fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fas fa-h-square' => 'h-square(directions,emergency,hospital,hotel,map)'),
            array('far fa-h-square' => 'h-square(directions,emergency,hospital,hotel,map)'),
            array('fal fa-h-square' => 'h-square(directions,emergency,hospital,hotel,map)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('far fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fal fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fas fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('far fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fal fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fas fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('far fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('fal fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('fas fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('far fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fas fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-stethoscope' => 'stethoscope(diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('far fa-stethoscope' => 'stethoscope(diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fal fa-stethoscope' => 'stethoscope(diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fas fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('far fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('fal fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('fas fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('far fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fal fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
        ),
        'Holiday' => array(
            array('fas fa-angel' => 'angel(christmas,decoration,halo,holiday,holy,michael landon,wings,xmas)'),
            array('far fa-angel' => 'angel(christmas,decoration,halo,holiday,holy,michael landon,wings,xmas)'),
            array('fal fa-angel' => 'angel(christmas,decoration,halo,holiday,holy,michael landon,wings,xmas)'),
            array('fas fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('far fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fal fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fas fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('far fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('fal fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('fas fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('far fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fal fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fas fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('far fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('fal fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('fas fa-deer' => 'deer(animal,antlers,blitzen,comet,cupid,dancer,dasher,donner,fauna,mammal,prancer,reindeer,vixen)'),
            array('far fa-deer' => 'deer(animal,antlers,blitzen,comet,cupid,dancer,dasher,donner,fauna,mammal,prancer,reindeer,vixen)'),
            array('fal fa-deer' => 'deer(animal,antlers,blitzen,comet,cupid,dancer,dasher,donner,fauna,mammal,prancer,reindeer,vixen)'),
            array('fas fa-deer-rudolph' => 'deer-rudolph(animal,antlers,fauna,mammal,reindeer)'),
            array('far fa-deer-rudolph' => 'deer-rudolph(animal,antlers,fauna,mammal,reindeer)'),
            array('fal fa-deer-rudolph' => 'deer-rudolph(animal,antlers,fauna,mammal,reindeer)'),
            array('fas fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('far fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('fal fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('fas fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('far fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fal fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fas fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('far fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('fal fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('fas fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('far fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('fal fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('fas fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('far fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('fal fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('fas fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('far fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('fal fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('fas fa-holly-berry' => 'holly-berry(catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)'),
            array('far fa-holly-berry' => 'holly-berry(catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)'),
            array('fal fa-holly-berry' => 'holly-berry(catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)'),
            array('fas fa-lights-holiday' => 'lights-holiday(bulb,christmas,decoration,holiday,string,xmas)'),
            array('far fa-lights-holiday' => 'lights-holiday(bulb,christmas,decoration,holiday,string,xmas)'),
            array('fal fa-lights-holiday' => 'lights-holiday(bulb,christmas,decoration,holiday,string,xmas)'),
            array('fas fa-mistletoe' => 'mistletoe(awkward,christmas,decoration,flora,holiday,kiss,plant,tradition,trap,xmas)'),
            array('far fa-mistletoe' => 'mistletoe(awkward,christmas,decoration,flora,holiday,kiss,plant,tradition,trap,xmas)'),
            array('fal fa-mistletoe' => 'mistletoe(awkward,christmas,decoration,flora,holiday,kiss,plant,tradition,trap,xmas)'),
            array('fas fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('far fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('fal fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('fas fa-narwhal' => 'narwhal(animal,fauna,holiday,ivory,mammal,tusk,unicorn,whale)'),
            array('far fa-narwhal' => 'narwhal(animal,fauna,holiday,ivory,mammal,tusk,unicorn,whale)'),
            array('fal fa-narwhal' => 'narwhal(animal,fauna,holiday,ivory,mammal,tusk,unicorn,whale)'),
            array('fas fa-ornament' => 'ornament(christmas,decoration,holiday,xmas)'),
            array('far fa-ornament' => 'ornament(christmas,decoration,holiday,xmas)'),
            array('fal fa-ornament' => 'ornament(christmas,decoration,holiday,xmas)'),
            array('fas fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('far fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fal fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fas fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('far fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('fal fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('fas fa-snowman' => 'snowman(decoration,frost,frosty,holiday)'),
            array('far fa-snowman' => 'snowman(decoration,frost,frosty,holiday)'),
            array('fal fa-snowman' => 'snowman(decoration,frost,frosty,holiday)'),
            array('fas fa-star-christmas' => 'star-christmas(bethlehem,christmas,holiday,north,xmas)'),
            array('far fa-star-christmas' => 'star-christmas(bethlehem,christmas,holiday,north,xmas)'),
            array('fal fa-star-christmas' => 'star-christmas(bethlehem,christmas,holiday,north,xmas)'),
            array('fas fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('far fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('fal fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('fas fa-tree-christmas' => 'tree-christmas(christmas,decorated,decorations,flora,holiday,lights,plant,star,xmas)'),
            array('far fa-tree-christmas' => 'tree-christmas(christmas,decorated,decorations,flora,holiday,lights,plant,star,xmas)'),
            array('fal fa-tree-christmas' => 'tree-christmas(christmas,decorated,decorations,flora,holiday,lights,plant,star,xmas)'),
            array('fas fa-tree-decorated' => 'tree-decorated(christmas,decorations,flora,holiday,lights,plant,xmas)'),
            array('far fa-tree-decorated' => 'tree-decorated(christmas,decorations,flora,holiday,lights,plant,xmas)'),
            array('fal fa-tree-decorated' => 'tree-decorated(christmas,decorations,flora,holiday,lights,plant,xmas)'),
            array('fas fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('far fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('fal fa-turkey' => 'turkey(bird,chicken,meal,meat,poultry,seasonal,thanksgiving)'),
            array('fas fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('far fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('fal fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
        ),
        'Hotel' => array(
            array('fas fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('far fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fal fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fas fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('far fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fal fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fas fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('far fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fal fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fas fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('far fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fal fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fas fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-car-garage' => 'car-garage(auto,automobile,mechanic,sedan,transportation,vehicle)'),
            array('far fa-car-garage' => 'car-garage(auto,automobile,mechanic,sedan,transportation,vehicle)'),
            array('fal fa-car-garage' => 'car-garage(auto,automobile,mechanic,sedan,transportation,vehicle)'),
            array('fas fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('far fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('fal fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('fas fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('far fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fal fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fas fa-concierge-bell' => 'concierge-bell(attention,hotel,receptionist,service,support)'),
            array('far fa-concierge-bell' => 'concierge-bell(attention,hotel,receptionist,service,support)'),
            array('fal fa-concierge-bell' => 'concierge-bell(attention,hotel,receptionist,service,support)'),
            array('fas fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('far fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('fal fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('fas fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('far fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('fal fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('fas fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('far fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fal fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fas fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('far fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fal fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fas fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('far fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('fal fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('fas fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('far fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fal fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fas fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-hot-tub' => 'hot-tub(bath,jacuzzi,massage,sauna,spa)'),
            array('far fa-hot-tub' => 'hot-tub(bath,jacuzzi,massage,sauna,spa)'),
            array('fal fa-hot-tub' => 'hot-tub(bath,jacuzzi,massage,sauna,spa)'),
            array('fas fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('far fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('fal fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('fas fa-infinity' => 'infinity(eternity,forever,math)'),
            array('far fa-infinity' => 'infinity(eternity,forever,math)'),
            array('fal fa-infinity' => 'infinity(eternity,forever,math)'),
            array('fas fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('far fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fal fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fas fa-luggage-cart' => 'luggage-cart(bag,baggage,suitcase,travel)'),
            array('far fa-luggage-cart' => 'luggage-cart(bag,baggage,suitcase,travel)'),
            array('fal fa-luggage-cart' => 'luggage-cart(bag,baggage,suitcase,travel)'),
            array('fas fa-paw-alt' => 'paw-alt(animal,cat,dog,pet,print)'),
            array('far fa-paw-alt' => 'paw-alt(animal,cat,dog,pet,print)'),
            array('fal fa-paw-alt' => 'paw-alt(animal,cat,dog,pet,print)'),
            array('fas fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('far fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fal fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fas fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('far fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fal fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fas fa-smoking' => 'smoking(cancer,cigarette,nicotine,smoking status,tobacco)'),
            array('far fa-smoking' => 'smoking(cancer,cigarette,nicotine,smoking status,tobacco)'),
            array('fal fa-smoking' => 'smoking(cancer,cigarette,nicotine,smoking status,tobacco)'),
            array('fas fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('far fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('fal fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('fas fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('far fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fal fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fas fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('far fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('fal fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('fas fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('far fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fal fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fas fa-suitcase-rolling' => 'suitcase-rolling(baggage,luggage,move,suitcase,travel,trip)'),
            array('far fa-suitcase-rolling' => 'suitcase-rolling(baggage,luggage,move,suitcase,travel,trip)'),
            array('fal fa-suitcase-rolling' => 'suitcase-rolling(baggage,luggage,move,suitcase,travel,trip)'),
            array('fas fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('far fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fal fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fas fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('far fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('fal fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('fas fa-tv' => 'tv(computer,display,monitor,television)'),
            array('far fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fal fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fas fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('far fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('fal fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('fas fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('far fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('fal fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('fas fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('far fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fal fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fas fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('far fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fal fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fas fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('far fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fal fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fas fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('far fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fal fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fas fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
            array('far fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
            array('fal fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
        ),
        'Household' => array(
            array('fas fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('far fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fal fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fas fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('far fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fal fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fas fa-blanket' => 'blanket(bed,cover,cozy,sleep,warm)'),
            array('far fa-blanket' => 'blanket(bed,cover,cozy,sleep,warm)'),
            array('fal fa-blanket' => 'blanket(bed,cover,cozy,sleep,warm)'),
            array('fas fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('far fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('fal fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('fas fa-books' => 'books(diary,documentation,journal,library,read)'),
            array('far fa-books' => 'books(diary,documentation,journal,library,read)'),
            array('fal fa-books' => 'books(diary,documentation,journal,library,read)'),
            array('fas fa-chair' => 'chair(furniture,seat,sit)'),
            array('far fa-chair' => 'chair(furniture,seat,sit)'),
            array('fal fa-chair' => 'chair(furniture,seat,sit)'),
            array('fas fa-chair-office' => 'chair-office(ergonomic,furniture,seat)'),
            array('far fa-chair-office' => 'chair-office(ergonomic,furniture,seat)'),
            array('fal fa-chair-office' => 'chair-office(ergonomic,furniture,seat)'),
            array('fas fa-couch' => 'couch(chair,cushion,furniture,relax,sofa)'),
            array('far fa-couch' => 'couch(chair,cushion,furniture,relax,sofa)'),
            array('fal fa-couch' => 'couch(chair,cushion,furniture,relax,sofa)'),
            array('fas fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('far fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fal fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fas fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('far fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fal fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fas fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('far fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fal fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fas fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('far fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fal fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fas fa-lamp' => 'lamp(bright,furniture,light)'),
            array('far fa-lamp' => 'lamp(bright,furniture,light)'),
            array('fal fa-lamp' => 'lamp(bright,furniture,light)'),
            array('fas fa-loveseat' => 'loveseat(chair,couch,cushion,furniture,relax,sofa)'),
            array('far fa-loveseat' => 'loveseat(chair,couch,cushion,furniture,relax,sofa)'),
            array('fal fa-loveseat' => 'loveseat(chair,couch,cushion,furniture,relax,sofa)'),
            array('fas fa-mailbox' => 'mailbox(archive,envelope,letter,post office,postal,postcard,send,stamp,usps)'),
            array('far fa-mailbox' => 'mailbox(archive,envelope,letter,post office,postal,postcard,send,stamp,usps)'),
            array('fal fa-mailbox' => 'mailbox(archive,envelope,letter,post office,postal,postcard,send,stamp,usps)'),
            array('fas fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('far fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fal fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fas fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('far fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fal fa-toilet-paper' => 'toilet-paper(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fas fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('far fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fal fa-toilet-paper-alt' => 'toilet-paper-alt(bathroom,halloween,holiday,lavatory,prank,restroom,roll)'),
            array('fas fa-tv' => 'tv(computer,display,monitor,television)'),
            array('far fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fal fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fas fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('far fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('fal fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
        ),
        'Images' => array(
            array('fas fa-adjust' => 'adjust(contrast,dark,light,saturation)'),
            array('far fa-adjust' => 'adjust(contrast,dark,light,saturation)'),
            array('fal fa-adjust' => 'adjust(contrast,dark,light,saturation)'),
            array('fas fa-bolt' => 'bolt(electricity,lightning,weather,zap)'),
            array('far fa-bolt' => 'bolt(electricity,lightning,weather,zap)'),
            array('fal fa-bolt' => 'bolt(electricity,lightning,weather,zap)'),
            array('fas fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('far fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('fal fa-chalkboard' => 'chalkboard(blackboard,learning,school,teaching,whiteboard,writing)'),
            array('fas fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('far fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fal fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fas fa-compress' => 'compress(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress' => 'compress(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress' => 'compress(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress-arrows-alt' => 'compress-arrows-alt(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-compress-wide' => 'compress-wide(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('far fa-compress-wide' => 'compress-wide(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fal fa-compress-wide' => 'compress-wide(collapse,fullscreen,minimize,move,resize,shrink,smaller)'),
            array('fas fa-expand' => 'expand(arrow,bigger,enlarge,resize)'),
            array('far fa-expand' => 'expand(arrow,bigger,enlarge,resize)'),
            array('fal fa-expand' => 'expand(arrow,bigger,enlarge,resize)'),
            array('fas fa-expand-wide' => 'expand-wide(bigger,enlarge,resize)'),
            array('far fa-expand-wide' => 'expand-wide(bigger,enlarge,resize)'),
            array('fal fa-expand-wide' => 'expand-wide(bigger,enlarge,resize)'),
            array('fas fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('far fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fal fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fas fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('far fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fal fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fas fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('far fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fal fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fas fa-file-image' => 'file-image(document,image,jpg,photo,png)'),
            array('far fa-file-image' => 'file-image(document,image,jpg,photo,png)'),
            array('fal fa-file-image' => 'file-image(document,image,jpg,photo,png)'),
            array('fas fa-film' => 'film(cinema,movie,strip,video)'),
            array('far fa-film' => 'film(cinema,movie,strip,video)'),
            array('fal fa-film' => 'film(cinema,movie,strip,video)'),
            array('fas fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('far fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('fal fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('fas fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('far fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('fal fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('fas fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('far fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('fal fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('fas fa-image' => 'image(album,landscape,photo,picture)'),
            array('far fa-image' => 'image(album,landscape,photo,picture)'),
            array('fal fa-image' => 'image(album,landscape,photo,picture)'),
            array('fas fa-images' => 'images(album,landscape,photo,picture)'),
            array('far fa-images' => 'images(album,landscape,photo,picture)'),
            array('fal fa-images' => 'images(album,landscape,photo,picture)'),
            array('fas fa-portrait' => 'portrait(id,image,photo,picture,selfie)'),
            array('far fa-portrait' => 'portrait(id,image,photo,picture,selfie)'),
            array('fal fa-portrait' => 'portrait(id,image,photo,picture,selfie)'),
            array('fas fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('far fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('fal fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('fas fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('far fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('fal fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('fas fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('far fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('fal fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('fas fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('fas fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('far fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('fal fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
        ),
        'Interfaces' => array(
            array('fas fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('far fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fal fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('far fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fal fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fas fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('far fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('fal fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('fas fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('far fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('fal fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('fas fa-bars' => 'bars(checklist,drag,hamburger,list,menu,nav,navigation,ol,reorder,settings,todo,ul)'),
            array('far fa-bars' => 'bars(checklist,drag,hamburger,list,menu,nav,navigation,ol,reorder,settings,todo,ul)'),
            array('fal fa-bars' => 'bars(checklist,drag,hamburger,list,menu,nav,navigation,ol,reorder,settings,todo,ul)'),
            array('fas fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('far fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fal fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('far fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fal fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fas fa-blog' => 'blog(journal,log,online,personal,post,web 2.0,wordpress,writing)'),
            array('far fa-blog' => 'blog(journal,log,online,personal,post,web 2.0,wordpress,writing)'),
            array('fal fa-blog' => 'blog(journal,log,online,personal,post,web 2.0,wordpress,writing)'),
            array('fas fa-bug' => 'bug(beetle,error,insect,report)'),
            array('far fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fal fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fas fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('far fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fal fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fas fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('far fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fal fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fas fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('far fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fal fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fas fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('far fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fal fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fas fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('far fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fal fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fas fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('far fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('fal fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('fas fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('far fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('fal fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('fas fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('far fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fal fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fas fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('far fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('fal fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('fas fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('far fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('fal fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('fas fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('far fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('fal fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('fas fa-certificate' => 'certificate(badge,star,verified)'),
            array('far fa-certificate' => 'certificate(badge,star,verified)'),
            array('fal fa-certificate' => 'certificate(badge,star,verified)'),
            array('fas fa-check' => 'check(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo,yes)'),
            array('far fa-check' => 'check(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo,yes)'),
            array('fal fa-check' => 'check(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo,yes)'),
            array('fas fa-check-circle' => 'check-circle(accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('far fa-check-circle' => 'check-circle(accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('fal fa-check-circle' => 'check-circle(accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('fas fa-check-double' => 'check-double(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)'),
            array('far fa-check-double' => 'check-double(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)'),
            array('fal fa-check-double' => 'check-double(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)'),
            array('fas fa-check-square' => 'check-square(accept,agree,checkmark,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('far fa-check-square' => 'check-square(accept,agree,checkmark,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('fal fa-check-square' => 'check-square(accept,agree,checkmark,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('fas fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('far fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fal fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fas fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('far fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fal fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fas fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('far fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fal fa-clone' => 'clone(arrange,copy,duplicate,paste)'),
            array('fas fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('far fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fal fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fas fa-cloud-download' => 'cloud-download(download,export,save)'),
            array('far fa-cloud-download' => 'cloud-download(download,export,save)'),
            array('fal fa-cloud-download' => 'cloud-download(download,export,save)'),
            array('fas fa-cloud-download-alt' => 'cloud-download-alt(download,export,save)'),
            array('far fa-cloud-download-alt' => 'cloud-download-alt(download,export,save)'),
            array('fal fa-cloud-download-alt' => 'cloud-download-alt(download,export,save)'),
            array('fas fa-cloud-upload' => 'cloud-upload(import,save,upload)'),
            array('far fa-cloud-upload' => 'cloud-upload(import,save,upload)'),
            array('fal fa-cloud-upload' => 'cloud-upload(import,save,upload)'),
            array('fas fa-cloud-upload-alt' => 'cloud-upload-alt(cloud-upload,import,save,upload)'),
            array('far fa-cloud-upload-alt' => 'cloud-upload-alt(cloud-upload,import,save,upload)'),
            array('fal fa-cloud-upload-alt' => 'cloud-upload-alt(cloud-upload,import,save,upload)'),
            array('fas fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('far fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fal fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fas fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('far fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('fal fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('fas fa-cogs' => 'cogs(gears,mechanical,settings,sprocket,wheel)'),
            array('far fa-cogs' => 'cogs(gears,mechanical,settings,sprocket,wheel)'),
            array('fal fa-cogs' => 'cogs(gears,mechanical,settings,sprocket,wheel)'),
            array('fas fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('far fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fal fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fas fa-cut' => 'cut(clip,scissors,snip)'),
            array('far fa-cut' => 'cut(clip,scissors,snip)'),
            array('fal fa-cut' => 'cut(clip,scissors,snip)'),
            array('fas fa-database' => 'database(computer,development,directory,memory,storage)'),
            array('far fa-database' => 'database(computer,development,directory,memory,storage)'),
            array('fal fa-database' => 'database(computer,development,directory,memory,storage)'),
            array('fas fa-dot-circle' => 'dot-circle(bullseye,notification,target)'),
            array('far fa-dot-circle' => 'dot-circle(bullseye,notification,target)'),
            array('fal fa-dot-circle' => 'dot-circle(bullseye,notification,target)'),
            array('fas fa-download' => 'download(export,hard drive,save,transfer)'),
            array('far fa-download' => 'download(export,hard drive,save,transfer)'),
            array('fal fa-download' => 'download(export,hard drive,save,transfer)'),
            array('fas fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('far fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fal fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fas fa-ellipsis-h' => 'ellipsis-h(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('far fa-ellipsis-h' => 'ellipsis-h(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fal fa-ellipsis-h' => 'ellipsis-h(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fas fa-ellipsis-h-alt' => 'ellipsis-h-alt(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('far fa-ellipsis-h-alt' => 'ellipsis-h-alt(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fal fa-ellipsis-h-alt' => 'ellipsis-h-alt(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fas fa-ellipsis-v' => 'ellipsis-v(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('far fa-ellipsis-v' => 'ellipsis-v(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fal fa-ellipsis-v' => 'ellipsis-v(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fas fa-ellipsis-v-alt' => 'ellipsis-v-alt(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('far fa-ellipsis-v-alt' => 'ellipsis-v-alt(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fal fa-ellipsis-v-alt' => 'ellipsis-v-alt(dots,drag,kebab,list,menu,nav,navigation,ol,reorder,settings,ul)'),
            array('fas fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('far fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fal fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fas fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-external-link' => 'external-link(new,open,send,share)'),
            array('far fa-external-link' => 'external-link(new,open,send,share)'),
            array('fal fa-external-link' => 'external-link(new,open,send,share)'),
            array('fas fa-external-link-alt' => 'external-link-alt(external-link,new,open,share)'),
            array('far fa-external-link-alt' => 'external-link-alt(external-link,new,open,share)'),
            array('fal fa-external-link-alt' => 'external-link-alt(external-link,new,open,share)'),
            array('fas fa-external-link-square' => 'external-link-square(new,open,send,share)'),
            array('far fa-external-link-square' => 'external-link-square(new,open,send,share)'),
            array('fal fa-external-link-square' => 'external-link-square(new,open,send,share)'),
            array('fas fa-external-link-square-alt' => 'external-link-square-alt(external-link-square,new,open,share)'),
            array('far fa-external-link-square-alt' => 'external-link-square-alt(external-link-square,new,open,share)'),
            array('fal fa-external-link-square-alt' => 'external-link-square-alt(external-link-square,new,open,share)'),
            array('fas fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('far fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fal fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fas fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('far fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fal fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-file-download' => 'file-download(document,export,save)'),
            array('far fa-file-download' => 'file-download(document,export,save)'),
            array('fal fa-file-download' => 'file-download(document,export,save)'),
            array('fas fa-file-export' => 'file-export(download,save)'),
            array('far fa-file-export' => 'file-export(download,save)'),
            array('fal fa-file-export' => 'file-export(download,save)'),
            array('fas fa-file-import' => 'file-import(copy,document,send,upload)'),
            array('far fa-file-import' => 'file-import(copy,document,send,upload)'),
            array('fal fa-file-import' => 'file-import(copy,document,send,upload)'),
            array('fas fa-file-upload' => 'file-upload(document,import,page,save)'),
            array('far fa-file-upload' => 'file-upload(document,import,page,save)'),
            array('fal fa-file-upload' => 'file-upload(document,import,page,save)'),
            array('fas fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('far fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('fal fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('fas fa-fingerprint' => 'fingerprint(human,id,identification,lock,smudge,touch,unique,unlock)'),
            array('far fa-fingerprint' => 'fingerprint(human,id,identification,lock,smudge,touch,unique,unlock)'),
            array('fal fa-fingerprint' => 'fingerprint(human,id,identification,lock,smudge,touch,unique,unlock)'),
            array('fas fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('far fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('fal fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('fas fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('far fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('fal fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('fas fa-folder' => 'folder(archive,directory,document,file)'),
            array('far fa-folder' => 'folder(archive,directory,document,file)'),
            array('fal fa-folder' => 'folder(archive,directory,document,file)'),
            array('fas fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('far fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fal fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fas fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('far fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fal fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fas fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('far fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fal fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fas fa-grip-horizontal' => 'grip-horizontal(affordance,drag,drop,grab,handle)'),
            array('far fa-grip-horizontal' => 'grip-horizontal(affordance,drag,drop,grab,handle)'),
            array('fal fa-grip-horizontal' => 'grip-horizontal(affordance,drag,drop,grab,handle)'),
            array('fas fa-grip-lines' => 'grip-lines(affordance,drag,drop,grab,handle)'),
            array('far fa-grip-lines' => 'grip-lines(affordance,drag,drop,grab,handle)'),
            array('fal fa-grip-lines' => 'grip-lines(affordance,drag,drop,grab,handle)'),
            array('fas fa-grip-lines-vertical' => 'grip-lines-vertical(affordance,drag,drop,grab,handle)'),
            array('far fa-grip-lines-vertical' => 'grip-lines-vertical(affordance,drag,drop,grab,handle)'),
            array('fal fa-grip-lines-vertical' => 'grip-lines-vertical(affordance,drag,drop,grab,handle)'),
            array('fas fa-grip-vertical' => 'grip-vertical(affordance,drag,drop,grab,handle)'),
            array('far fa-grip-vertical' => 'grip-vertical(affordance,drag,drop,grab,handle)'),
            array('fal fa-grip-vertical' => 'grip-vertical(affordance,drag,drop,grab,handle)'),
            array('fas fa-hashtag' => 'hashtag(Twitter,instagram,pound,social media,tag)'),
            array('far fa-hashtag' => 'hashtag(Twitter,instagram,pound,social media,tag)'),
            array('fal fa-hashtag' => 'hashtag(Twitter,instagram,pound,social media,tag)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('far fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('fal fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('fas fa-home' => 'home(abode,building,house,main)'),
            array('far fa-home' => 'home(abode,building,house,main)'),
            array('fal fa-home' => 'home(abode,building,house,main)'),
            array('fas fa-i-cursor' => 'i-cursor(editing,i-beam,type,writing)'),
            array('far fa-i-cursor' => 'i-cursor(editing,i-beam,type,writing)'),
            array('fal fa-i-cursor' => 'i-cursor(editing,i-beam,type,writing)'),
            array('fas fa-info' => 'info(details,help,information,more,support)'),
            array('far fa-info' => 'info(details,help,information,more,support)'),
            array('fal fa-info' => 'info(details,help,information,more,support)'),
            array('fas fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('far fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('fal fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('fas fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('far fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('fal fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('fas fa-language' => 'language(dialect,idiom,localize,speech,translate,vernacular)'),
            array('far fa-language' => 'language(dialect,idiom,localize,speech,translate,vernacular)'),
            array('fal fa-language' => 'language(dialect,idiom,localize,speech,translate,vernacular)'),
            array('fas fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('far fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('fal fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('fas fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('far fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fal fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fas fa-medal' => 'medal(award,ribbon,star,trophy)'),
            array('far fa-medal' => 'medal(award,ribbon,star,trophy)'),
            array('fal fa-medal' => 'medal(award,ribbon,star,trophy)'),
            array('fas fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('far fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fal fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fas fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fas fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('far fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('fal fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('fas fa-minus-circle' => 'minus-circle(delete,hide,negative,remove,shape,trash)'),
            array('far fa-minus-circle' => 'minus-circle(delete,hide,negative,remove,shape,trash)'),
            array('fal fa-minus-circle' => 'minus-circle(delete,hide,negative,remove,shape,trash)'),
            array('fas fa-minus-hexagon' => 'minus-hexagon(delete,hide,negative,remove,shape,trash)'),
            array('far fa-minus-hexagon' => 'minus-hexagon(delete,hide,negative,remove,shape,trash)'),
            array('fal fa-minus-hexagon' => 'minus-hexagon(delete,hide,negative,remove,shape,trash)'),
            array('fas fa-minus-octagon' => 'minus-octagon(delete,hide,negative,remove,shape,trash)'),
            array('far fa-minus-octagon' => 'minus-octagon(delete,hide,negative,remove,shape,trash)'),
            array('fal fa-minus-octagon' => 'minus-octagon(delete,hide,negative,remove,shape,trash)'),
            array('fas fa-minus-square' => 'minus-square(collapse,delete,hide,minify,negative,remove,shape,trash)'),
            array('far fa-minus-square' => 'minus-square(collapse,delete,hide,minify,negative,remove,shape,trash)'),
            array('fal fa-minus-square' => 'minus-square(collapse,delete,hide,minify,negative,remove,shape,trash)'),
            array('fas fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('far fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fal fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fas fa-pen' => 'pen(design,edit,update,write)'),
            array('far fa-pen' => 'pen(design,edit,update,write)'),
            array('fal fa-pen' => 'pen(design,edit,update,write)'),
            array('fas fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('far fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fal fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fas fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('far fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fas fa-pencil' => 'pencil(design,edit,update,write)'),
            array('far fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fal fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fas fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('far fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fal fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fas fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('far fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fal fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-circle' => 'plus-circle(add,create,expand,new,positive,shape)'),
            array('far fa-plus-circle' => 'plus-circle(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-circle' => 'plus-circle(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-hexagon' => 'plus-hexagon(add,create,expand,new,positive,shape)'),
            array('far fa-plus-hexagon' => 'plus-hexagon(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-hexagon' => 'plus-hexagon(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-octagon' => 'plus-octagon(add,create,expand,new,positive,shape)'),
            array('far fa-plus-octagon' => 'plus-octagon(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-octagon' => 'plus-octagon(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('far fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fas fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('far fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('fal fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('fas fa-qrcode' => 'qrcode(barcode,info,information,scan)'),
            array('far fa-qrcode' => 'qrcode(barcode,info,information,scan)'),
            array('fal fa-qrcode' => 'qrcode(barcode,info,information,scan)'),
            array('fas fa-question' => 'question(help,information,support,unknown)'),
            array('far fa-question' => 'question(help,information,support,unknown)'),
            array('fal fa-question' => 'question(help,information,support,unknown)'),
            array('fas fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('far fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('fal fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('fas fa-question-square' => 'question-square(help,information,support,unknown)'),
            array('far fa-question-square' => 'question-square(help,information,support,unknown)'),
            array('fal fa-question-square' => 'question-square(help,information,support,unknown)'),
            array('fas fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('far fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fal fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fas fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('far fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fal fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fas fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('far fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fal fa-redo' => 'redo(forward,refresh,reload,repeat)'),
            array('fas fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('far fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fal fa-redo-alt' => 'redo-alt(forward,refresh,reload,repeat)'),
            array('fas fa-reply' => 'reply(mail,message,respond)'),
            array('far fa-reply' => 'reply(mail,message,respond)'),
            array('fal fa-reply' => 'reply(mail,message,respond)'),
            array('fas fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('far fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('fal fa-reply-all' => 'reply-all(mail,message,respond)'),
            array('fas fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('far fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('fal fa-rss' => 'rss(blog,feed,journal,news,writing)'),
            array('fas fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('far fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('fal fa-rss-square' => 'rss-square(blog,feed,journal,news,writing)'),
            array('fas fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('far fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fal fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fas fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('far fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fal fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fas fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('far fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fal fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fas fa-search-minus' => 'search-minus(minify,negative,smaller,zoom,zoom out)'),
            array('far fa-search-minus' => 'search-minus(minify,negative,smaller,zoom,zoom out)'),
            array('fal fa-search-minus' => 'search-minus(minify,negative,smaller,zoom,zoom out)'),
            array('fas fa-search-plus' => 'search-plus(bigger,enlarge,magnify,positive,zoom,zoom in)'),
            array('far fa-search-plus' => 'search-plus(bigger,enlarge,magnify,positive,zoom,zoom in)'),
            array('fal fa-search-plus' => 'search-plus(bigger,enlarge,magnify,positive,zoom,zoom in)'),
            array('fas fa-share' => 'share(forward,save,send,social)'),
            array('far fa-share' => 'share(forward,save,send,social)'),
            array('fal fa-share' => 'share(forward,save,send,social)'),
            array('fas fa-share-all' => 'share-all(forward,save,send,social)'),
            array('far fa-share-all' => 'share-all(forward,save,send,social)'),
            array('fal fa-share-all' => 'share-all(forward,save,send,social)'),
            array('fas fa-share-alt' => 'share-alt(forward,save,send,social)'),
            array('far fa-share-alt' => 'share-alt(forward,save,send,social)'),
            array('fal fa-share-alt' => 'share-alt(forward,save,send,social)'),
            array('fas fa-share-alt-square' => 'share-alt-square(forward,save,send,social)'),
            array('far fa-share-alt-square' => 'share-alt-square(forward,save,send,social)'),
            array('fal fa-share-alt-square' => 'share-alt-square(forward,save,send,social)'),
            array('fas fa-share-square' => 'share-square(forward,save,send,social)'),
            array('far fa-share-square' => 'share-square(forward,save,send,social)'),
            array('fal fa-share-square' => 'share-square(forward,save,send,social)'),
            array('fas fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('far fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fal fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fas fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('far fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fal fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fas fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('far fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fal fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fas fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('far fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fal fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fas fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('far fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('fal fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('fas fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('far fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('fal fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('fas fa-signal' => 'signal(bars,graph,online,reception,status)'),
            array('far fa-signal' => 'signal(bars,graph,online,reception,status)'),
            array('fal fa-signal' => 'signal(bars,graph,online,reception,status)'),
            array('fas fa-signal-1' => 'signal-1(bars,graph,online,reception,status)'),
            array('far fa-signal-1' => 'signal-1(bars,graph,online,reception,status)'),
            array('fal fa-signal-1' => 'signal-1(bars,graph,online,reception,status)'),
            array('fas fa-signal-2' => 'signal-2(bars,graph,online,reception,status)'),
            array('far fa-signal-2' => 'signal-2(bars,graph,online,reception,status)'),
            array('fal fa-signal-2' => 'signal-2(bars,graph,online,reception,status)'),
            array('fas fa-signal-3' => 'signal-3(bars,graph,online,reception,status)'),
            array('far fa-signal-3' => 'signal-3(bars,graph,online,reception,status)'),
            array('fal fa-signal-3' => 'signal-3(bars,graph,online,reception,status)'),
            array('fas fa-signal-4' => 'signal-4(bars,graph,online,reception,status)'),
            array('far fa-signal-4' => 'signal-4(bars,graph,online,reception,status)'),
            array('fal fa-signal-4' => 'signal-4(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt' => 'signal-alt(bars,graph,online,reception,status)'),
            array('far fa-signal-alt' => 'signal-alt(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt' => 'signal-alt(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-1' => 'signal-alt-1(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-1' => 'signal-alt-1(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-1' => 'signal-alt-1(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-2' => 'signal-alt-2(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-2' => 'signal-alt-2(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-2' => 'signal-alt-2(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-3' => 'signal-alt-3(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-3' => 'signal-alt-3(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-3' => 'signal-alt-3(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-slash' => 'signal-alt-slash(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-slash' => 'signal-alt-slash(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-slash' => 'signal-alt-slash(bars,graph,online,reception,status)'),
            array('fas fa-signal-slash' => 'signal-slash(bars,graph,online,reception,status)'),
            array('far fa-signal-slash' => 'signal-slash(bars,graph,online,reception,status)'),
            array('fal fa-signal-slash' => 'signal-slash(bars,graph,online,reception,status)'),
            array('fas fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('far fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('fal fa-sitemap' => 'sitemap(directory,hierarchy,ia,information architecture,organization)'),
            array('fas fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('fas fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('far fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fal fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fas fa-sort' => 'sort(filter,order)'),
            array('far fa-sort' => 'sort(filter,order)'),
            array('fal fa-sort' => 'sort(filter,order)'),
            array('fas fa-sort-alpha-down' => 'sort-alpha-down(filter,order,sort-alpha-asc)'),
            array('far fa-sort-alpha-down' => 'sort-alpha-down(filter,order,sort-alpha-asc)'),
            array('fal fa-sort-alpha-down' => 'sort-alpha-down(filter,order,sort-alpha-asc)'),
            array('fas fa-sort-alpha-up' => 'sort-alpha-up(filter,order,sort-alpha-desc)'),
            array('far fa-sort-alpha-up' => 'sort-alpha-up(filter,order,sort-alpha-desc)'),
            array('fal fa-sort-alpha-up' => 'sort-alpha-up(filter,order,sort-alpha-desc)'),
            array('fas fa-sort-amount-down' => 'sort-amount-down(filter,order,sort-amount-asc)'),
            array('far fa-sort-amount-down' => 'sort-amount-down(filter,order,sort-amount-asc)'),
            array('fal fa-sort-amount-down' => 'sort-amount-down(filter,order,sort-amount-asc)'),
            array('fas fa-sort-amount-up' => 'sort-amount-up(filter,order,sort-amount-desc)'),
            array('far fa-sort-amount-up' => 'sort-amount-up(filter,order,sort-amount-desc)'),
            array('fal fa-sort-amount-up' => 'sort-amount-up(filter,order,sort-amount-desc)'),
            array('fas fa-sort-down' => 'sort-down(arrow,descending,filter,order,sort-desc)'),
            array('far fa-sort-down' => 'sort-down(arrow,descending,filter,order,sort-desc)'),
            array('fal fa-sort-down' => 'sort-down(arrow,descending,filter,order,sort-desc)'),
            array('fas fa-sort-numeric-down' => 'sort-numeric-down(filter,numbers,order,sort-numeric-asc)'),
            array('far fa-sort-numeric-down' => 'sort-numeric-down(filter,numbers,order,sort-numeric-asc)'),
            array('fal fa-sort-numeric-down' => 'sort-numeric-down(filter,numbers,order,sort-numeric-asc)'),
            array('fas fa-sort-numeric-up' => 'sort-numeric-up(filter,numbers,order,sort-numeric-desc)'),
            array('far fa-sort-numeric-up' => 'sort-numeric-up(filter,numbers,order,sort-numeric-desc)'),
            array('fal fa-sort-numeric-up' => 'sort-numeric-up(filter,numbers,order,sort-numeric-desc)'),
            array('fas fa-sort-up' => 'sort-up(arrow,ascending,filter,order,sort-asc)'),
            array('far fa-sort-up' => 'sort-up(arrow,ascending,filter,order,sort-asc)'),
            array('fal fa-sort-up' => 'sort-up(arrow,ascending,filter,order,sort-asc)'),
            array('fas fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('far fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fal fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fas fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('far fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('fal fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('fas fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('far fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fal fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fas fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('far fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fal fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fas fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('far fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fal fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fas fa-times' => 'times(close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('far fa-times' => 'times(close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fal fa-times' => 'times(close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fas fa-times-circle' => 'times-circle(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('far fa-times-circle' => 'times-circle(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fal fa-times-circle' => 'times-circle(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fas fa-times-hexagon' => 'times-hexagon(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('far fa-times-hexagon' => 'times-hexagon(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fal fa-times-hexagon' => 'times-hexagon(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fas fa-times-octagon' => 'times-octagon(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('far fa-times-octagon' => 'times-octagon(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fal fa-times-octagon' => 'times-octagon(close,cross,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fas fa-times-square' => 'times-square(close,cross,incorrect,notice,notification,notify,problem,window,wrong)'),
            array('far fa-times-square' => 'times-square(close,cross,incorrect,notice,notification,notify,problem,window,wrong)'),
            array('fal fa-times-square' => 'times-square(close,cross,incorrect,notice,notification,notify,problem,window,wrong)'),
            array('fas fa-toggle-off' => 'toggle-off(switch)'),
            array('far fa-toggle-off' => 'toggle-off(switch)'),
            array('fal fa-toggle-off' => 'toggle-off(switch)'),
            array('fas fa-toggle-on' => 'toggle-on(switch)'),
            array('far fa-toggle-on' => 'toggle-on(switch)'),
            array('fal fa-toggle-on' => 'toggle-on(switch)'),
            array('fas fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('far fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fal fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fas fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('far fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('fal fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('fas fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('far fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('fal fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('fas fa-trash-restore' => 'trash-restore(back,control z,oops,undo)'),
            array('far fa-trash-restore' => 'trash-restore(back,control z,oops,undo)'),
            array('fal fa-trash-restore' => 'trash-restore(back,control z,oops,undo)'),
            array('fas fa-trash-restore-alt' => 'trash-restore-alt(back,control z,oops,undo)'),
            array('far fa-trash-restore-alt' => 'trash-restore-alt(back,control z,oops,undo)'),
            array('fal fa-trash-restore-alt' => 'trash-restore-alt(back,control z,oops,undo)'),
            array('fas fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('far fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fal fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fas fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('far fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('fal fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('fas fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('far fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fal fa-undo' => 'undo(back,control z,exchange,oops,return,rotate,swap)'),
            array('fas fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('far fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fal fa-undo-alt' => 'undo-alt(back,control z,exchange,oops,return,swap)'),
            array('fas fa-upload' => 'upload(hard drive,import,publish)'),
            array('far fa-upload' => 'upload(hard drive,import,publish)'),
            array('fal fa-upload' => 'upload(hard drive,import,publish)'),
            array('fas fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('far fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('fas fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('far fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fal fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fas fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('far fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fal fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fas fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('far fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fal fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fas fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('far fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fal fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fas fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('far fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fal fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fas fa-wifi-1' => 'wifi-1(connection,hotspot,internet,network,weak,wireless)'),
            array('far fa-wifi-1' => 'wifi-1(connection,hotspot,internet,network,weak,wireless)'),
            array('fal fa-wifi-1' => 'wifi-1(connection,hotspot,internet,network,weak,wireless)'),
            array('fas fa-wifi-2' => 'wifi-2(average,connection,hotspot,internet,network,wireless)'),
            array('far fa-wifi-2' => 'wifi-2(average,connection,hotspot,internet,network,wireless)'),
            array('fal fa-wifi-2' => 'wifi-2(average,connection,hotspot,internet,network,wireless)'),
            array('fas fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
            array('far fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
            array('fal fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
            array('fas fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('far fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('fal fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
        ),
        'Logistics' => array(
            array('fas fa-barcode-alt' => 'barcode-alt(info,laser,price,scan,upc)'),
            array('far fa-barcode-alt' => 'barcode-alt(info,laser,price,scan,upc)'),
            array('fal fa-barcode-alt' => 'barcode-alt(info,laser,price,scan,upc)'),
            array('fas fa-barcode-read' => 'barcode-read(info,laser,price,scan,upc)'),
            array('far fa-barcode-read' => 'barcode-read(info,laser,price,scan,upc)'),
            array('fal fa-barcode-read' => 'barcode-read(info,laser,price,scan,upc)'),
            array('fas fa-barcode-scan' => 'barcode-scan(info,laser,price,scan,upc)'),
            array('far fa-barcode-scan' => 'barcode-scan(info,laser,price,scan,upc)'),
            array('fal fa-barcode-scan' => 'barcode-scan(info,laser,price,scan,upc)'),
            array('fas fa-box' => 'box(archive,container,package,storage)'),
            array('far fa-box' => 'box(archive,container,package,storage)'),
            array('fal fa-box' => 'box(archive,container,package,storage)'),
            array('fas fa-box-check' => 'box-check(accept,agree,confirm,correct,done,ok,package,select,success,tick,todo,yes)'),
            array('far fa-box-check' => 'box-check(accept,agree,confirm,correct,done,ok,package,select,success,tick,todo,yes)'),
            array('fal fa-box-check' => 'box-check(accept,agree,confirm,correct,done,ok,package,select,success,tick,todo,yes)'),
            array('fas fa-boxes' => 'boxes(archives,inventory,storage,warehouse)'),
            array('far fa-boxes' => 'boxes(archives,inventory,storage,warehouse)'),
            array('fal fa-boxes' => 'boxes(archives,inventory,storage,warehouse)'),
            array('fas fa-clipboard-check' => 'clipboard-check(accept,agree,confirm,done,ok,select,success,tick,todo,yes)'),
            array('far fa-clipboard-check' => 'clipboard-check(accept,agree,confirm,done,ok,select,success,tick,todo,yes)'),
            array('fal fa-clipboard-check' => 'clipboard-check(accept,agree,confirm,done,ok,select,success,tick,todo,yes)'),
            array('fas fa-clipboard-list' => 'clipboard-list(checklist,completed,done,finished,intinerary,ol,schedule,tick,todo,ul)'),
            array('far fa-clipboard-list' => 'clipboard-list(checklist,completed,done,finished,intinerary,ol,schedule,tick,todo,ul)'),
            array('fal fa-clipboard-list' => 'clipboard-list(checklist,completed,done,finished,intinerary,ol,schedule,tick,todo,ul)'),
            array('fas fa-conveyor-belt' => 'conveyor-belt(carousel,inventory,manufacture,packaging,shipping)'),
            array('far fa-conveyor-belt' => 'conveyor-belt(carousel,inventory,manufacture,packaging,shipping)'),
            array('fal fa-conveyor-belt' => 'conveyor-belt(carousel,inventory,manufacture,packaging,shipping)'),
            array('fas fa-conveyor-belt-alt' => 'conveyor-belt-alt(carousel,inventory,manufacture,packaging,shipping)'),
            array('far fa-conveyor-belt-alt' => 'conveyor-belt-alt(carousel,inventory,manufacture,packaging,shipping)'),
            array('fal fa-conveyor-belt-alt' => 'conveyor-belt-alt(carousel,inventory,manufacture,packaging,shipping)'),
            array('fas fa-dolly' => 'dolly(carry,shipping,transport)'),
            array('far fa-dolly' => 'dolly(carry,shipping,transport)'),
            array('fal fa-dolly' => 'dolly(carry,shipping,transport)'),
            array('fas fa-dolly-empty' => 'dolly-empty(carry,inventory,shipping,transport)'),
            array('far fa-dolly-empty' => 'dolly-empty(carry,inventory,shipping,transport)'),
            array('fal fa-dolly-empty' => 'dolly-empty(carry,inventory,shipping,transport)'),
            array('fas fa-dolly-flatbed' => 'dolly-flatbed(carry,inventory,shipping,transport)'),
            array('far fa-dolly-flatbed' => 'dolly-flatbed(carry,inventory,shipping,transport)'),
            array('fal fa-dolly-flatbed' => 'dolly-flatbed(carry,inventory,shipping,transport)'),
            array('fas fa-dolly-flatbed-alt' => 'dolly-flatbed-alt(carry,inventory,shipping,transport)'),
            array('far fa-dolly-flatbed-alt' => 'dolly-flatbed-alt(carry,inventory,shipping,transport)'),
            array('fal fa-dolly-flatbed-alt' => 'dolly-flatbed-alt(carry,inventory,shipping,transport)'),
            array('fas fa-dolly-flatbed-empty' => 'dolly-flatbed-empty(carry,inventory,shipping,transport)'),
            array('far fa-dolly-flatbed-empty' => 'dolly-flatbed-empty(carry,inventory,shipping,transport)'),
            array('fal fa-dolly-flatbed-empty' => 'dolly-flatbed-empty(carry,inventory,shipping,transport)'),
            array('fas fa-forklift' => 'forklift(archive,inventory,lorry,pallet,shipping,tractor,warehouse)'),
            array('far fa-forklift' => 'forklift(archive,inventory,lorry,pallet,shipping,tractor,warehouse)'),
            array('fal fa-forklift' => 'forklift(archive,inventory,lorry,pallet,shipping,tractor,warehouse)'),
            array('fas fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('far fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('fal fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('fas fa-hand-receiving' => 'hand-receiving(carry,gift,handling,package,shipping)'),
            array('far fa-hand-receiving' => 'hand-receiving(carry,gift,handling,package,shipping)'),
            array('fal fa-hand-receiving' => 'hand-receiving(carry,gift,handling,package,shipping)'),
            array('fas fa-hard-hat' => 'hard-hat(construction,hardhat,helmet,safety)'),
            array('far fa-hard-hat' => 'hard-hat(construction,hardhat,helmet,safety)'),
            array('fal fa-hard-hat' => 'hard-hat(construction,hardhat,helmet,safety)'),
            array('fas fa-inventory' => 'inventory(archive,box,shipping,warehouse)'),
            array('far fa-inventory' => 'inventory(archive,box,shipping,warehouse)'),
            array('fal fa-inventory' => 'inventory(archive,box,shipping,warehouse)'),
            array('fas fa-pallet' => 'pallet(archive,box,inventory,shipping,warehouse)'),
            array('far fa-pallet' => 'pallet(archive,box,inventory,shipping,warehouse)'),
            array('fal fa-pallet' => 'pallet(archive,box,inventory,shipping,warehouse)'),
            array('fas fa-pallet-alt' => 'pallet-alt(archive,box,inventory,shipping,warehouse)'),
            array('far fa-pallet-alt' => 'pallet-alt(archive,box,inventory,shipping,warehouse)'),
            array('fal fa-pallet-alt' => 'pallet-alt(archive,box,inventory,shipping,warehouse)'),
            array('fas fa-scanner' => 'scanner(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('far fa-scanner' => 'scanner(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('fal fa-scanner' => 'scanner(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('fas fa-scanner-keyboard' => 'scanner-keyboard(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('far fa-scanner-keyboard' => 'scanner-keyboard(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('fal fa-scanner-keyboard' => 'scanner-keyboard(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('fas fa-scanner-touchscreen' => 'scanner-touchscreen(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('far fa-scanner-touchscreen' => 'scanner-touchscreen(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('fal fa-scanner-touchscreen' => 'scanner-touchscreen(barcode,checkout,gun,inventory,price,upc,warehouse)'),
            array('fas fa-shipping-fast' => 'shipping-fast(express,fedex,mail,overnight,package,ups)'),
            array('far fa-shipping-fast' => 'shipping-fast(express,fedex,mail,overnight,package,ups)'),
            array('fal fa-shipping-fast' => 'shipping-fast(express,fedex,mail,overnight,package,ups)'),
            array('fas fa-shipping-timed' => 'shipping-timed(express,fedex,mail,overnight,package,ups)'),
            array('far fa-shipping-timed' => 'shipping-timed(express,fedex,mail,overnight,package,ups)'),
            array('fal fa-shipping-timed' => 'shipping-timed(express,fedex,mail,overnight,package,ups)'),
            array('fas fa-tablet-rugged' => 'tablet-rugged(device,durable,protection,screen,tough)'),
            array('far fa-tablet-rugged' => 'tablet-rugged(device,durable,protection,screen,tough)'),
            array('fal fa-tablet-rugged' => 'tablet-rugged(device,durable,protection,screen,tough)'),
            array('fas fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fas fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('far fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('fal fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('fas fa-warehouse' => 'warehouse(building,capacity,garage,inventory,storage)'),
            array('far fa-warehouse' => 'warehouse(building,capacity,garage,inventory,storage)'),
            array('fal fa-warehouse' => 'warehouse(building,capacity,garage,inventory,storage)'),
            array('fas fa-warehouse-alt' => 'warehouse-alt(building,capacity,garage,inventory,storage)'),
            array('far fa-warehouse-alt' => 'warehouse-alt(building,capacity,garage,inventory,storage)'),
            array('fal fa-warehouse-alt' => 'warehouse-alt(building,capacity,garage,inventory,storage)'),
        ),
        'Maps' => array(
            array('fas fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('far fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fal fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fas fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('far fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fal fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fas fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('far fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fal fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fas fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('far fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fal fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fas fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('far fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fal fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fas fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('far fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fal fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('far fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fal fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fas fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('far fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fal fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fas fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('far fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fal fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fas fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('far fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fal fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fas fa-blind' => 'blind(cane,disability,person,sight)'),
            array('far fa-blind' => 'blind(cane,disability,person,sight)'),
            array('fal fa-blind' => 'blind(cane,disability,person,sight)'),
            array('fas fa-bomb' => 'bomb(error,explode,fuse,grenade,warning)'),
            array('far fa-bomb' => 'bomb(error,explode,fuse,grenade,warning)'),
            array('fal fa-bomb' => 'bomb(error,explode,fuse,grenade,warning)'),
            array('fas fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('far fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fal fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fas fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('far fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fal fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fas fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('far fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fal fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fas fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('far fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fal fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fas fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('far fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fal fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fas fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('far fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('fal fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('fas fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('far fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('fal fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('fas fa-directions' => 'directions(map,navigation,sign,turn)'),
            array('far fa-directions' => 'directions(map,navigation,sign,turn)'),
            array('fal fa-directions' => 'directions(map,navigation,sign,turn)'),
            array('fas fa-do-not-enter' => 'do-not-enter(closed,traffic,warning)'),
            array('far fa-do-not-enter' => 'do-not-enter(closed,traffic,warning)'),
            array('fal fa-do-not-enter' => 'do-not-enter(closed,traffic,warning)'),
            array('fas fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('far fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('fal fa-dollar-sign' => 'dollar-sign($,cost,dollar-sign,money,price,usd)'),
            array('fas fa-draw-circle' => 'draw-circle(anchors,lines,object,render,shape)'),
            array('far fa-draw-circle' => 'draw-circle(anchors,lines,object,render,shape)'),
            array('fal fa-draw-circle' => 'draw-circle(anchors,lines,object,render,shape)'),
            array('fas fa-draw-polygon' => 'draw-polygon(anchors,lines,object,render,shape)'),
            array('far fa-draw-polygon' => 'draw-polygon(anchors,lines,object,render,shape)'),
            array('fal fa-draw-polygon' => 'draw-polygon(anchors,lines,object,render,shape)'),
            array('fas fa-draw-square' => 'draw-square(anchors,lines,object,render,shape)'),
            array('far fa-draw-square' => 'draw-square(anchors,lines,object,render,shape)'),
            array('fal fa-draw-square' => 'draw-square(anchors,lines,object,render,shape)'),
            array('fas fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('far fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fal fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fas fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('far fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fal fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fas fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('far fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('fal fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('fas fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('far fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('fal fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('fas fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('far fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('fal fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('fas fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('far fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('fal fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('fas fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('far fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fal fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fas fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('far fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('fal fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('fas fa-gavel' => 'gavel(hammer,judge,law,lawyer,opinion)'),
            array('far fa-gavel' => 'gavel(hammer,judge,law,lawyer,opinion)'),
            array('fal fa-gavel' => 'gavel(hammer,judge,law,lawyer,opinion)'),
            array('fas fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('far fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fal fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fas fa-h-square' => 'h-square(directions,emergency,hospital,hotel,map)'),
            array('far fa-h-square' => 'h-square(directions,emergency,hospital,hotel,map)'),
            array('fal fa-h-square' => 'h-square(directions,emergency,hospital,hotel,map)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('far fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fal fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fas fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('far fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('fal fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('fas fa-home' => 'home(abode,building,house,main)'),
            array('far fa-home' => 'home(abode,building,house,main)'),
            array('fal fa-home' => 'home(abode,building,house,main)'),
            array('fas fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('far fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fal fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fas fa-image' => 'image(album,landscape,photo,picture)'),
            array('far fa-image' => 'image(album,landscape,photo,picture)'),
            array('fal fa-image' => 'image(album,landscape,photo,picture)'),
            array('fas fa-images' => 'images(album,landscape,photo,picture)'),
            array('far fa-images' => 'images(album,landscape,photo,picture)'),
            array('fal fa-images' => 'images(album,landscape,photo,picture)'),
            array('fas fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-info' => 'info(details,help,information,more,support)'),
            array('far fa-info' => 'info(details,help,information,more,support)'),
            array('fal fa-info' => 'info(details,help,information,more,support)'),
            array('fas fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('far fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('fal fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('fas fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('far fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('fal fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('fas fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('far fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fal fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fas fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('far fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fal fa-landmark' => 'landmark(building,historic,memorable,monument,politics)'),
            array('fas fa-layer-group' => 'layer-group(arrange,develop,layers,map,stack)'),
            array('far fa-layer-group' => 'layer-group(arrange,develop,layers,map,stack)'),
            array('fal fa-layer-group' => 'layer-group(arrange,develop,layers,map,stack)'),
            array('fas fa-layer-minus' => 'layer-minus(arrange,delete,negative,remove,stack)'),
            array('far fa-layer-minus' => 'layer-minus(arrange,delete,negative,remove,stack)'),
            array('fal fa-layer-minus' => 'layer-minus(arrange,delete,negative,remove,stack)'),
            array('fas fa-layer-plus' => 'layer-plus(add,arrange,create,new,positive,stack)'),
            array('far fa-layer-plus' => 'layer-plus(add,arrange,create,new,positive,stack)'),
            array('fal fa-layer-plus' => 'layer-plus(add,arrange,create,new,positive,stack)'),
            array('fas fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('far fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fal fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fas fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('far fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fal fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fas fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('far fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('fal fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('fas fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('far fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fal fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fas fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('far fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fal fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fas fa-location-arrow' => 'location-arrow(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('far fa-location-arrow' => 'location-arrow(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('fal fa-location-arrow' => 'location-arrow(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('fas fa-location-circle' => 'location-circle(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('far fa-location-circle' => 'location-circle(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('fal fa-location-circle' => 'location-circle(address,compass,coordinate,direction,gps,map,navigation,place)'),
            array('fas fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('far fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fal fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fas fa-low-vision' => 'low-vision(blind,eye,sight)'),
            array('far fa-low-vision' => 'low-vision(blind,eye,sight)'),
            array('fal fa-low-vision' => 'low-vision(blind,eye,sight)'),
            array('fas fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('far fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('fal fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('fas fa-male' => 'male(human,man,person,profile,user)'),
            array('far fa-male' => 'male(human,man,person,profile,user)'),
            array('fal fa-male' => 'male(human,man,person,profile,user)'),
            array('fas fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-alt-slash' => 'map-marker-alt-slash(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker-alt-slash' => 'map-marker-alt-slash(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker-alt-slash' => 'map-marker-alt-slash(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-check' => 'map-marker-check(agree,coordinates,destination,location,map,navigation,pin,place,select,success,tick,todo)'),
            array('far fa-map-marker-check' => 'map-marker-check(agree,coordinates,destination,location,map,navigation,pin,place,select,success,tick,todo)'),
            array('fal fa-map-marker-check' => 'map-marker-check(agree,coordinates,destination,location,map,navigation,pin,place,select,success,tick,todo)'),
            array('fas fa-map-marker-edit' => 'map-marker-edit(agree,coordinates,destination,edit,location,map,navigation,pen,pencil,pin,place,update,write)'),
            array('far fa-map-marker-edit' => 'map-marker-edit(agree,coordinates,destination,edit,location,map,navigation,pen,pencil,pin,place,update,write)'),
            array('fal fa-map-marker-edit' => 'map-marker-edit(agree,coordinates,destination,edit,location,map,navigation,pen,pencil,pin,place,update,write)'),
            array('fas fa-map-marker-exclamation' => 'map-marker-exclamation(agree,alert,coordinates,destination,important,location,map,navigation,pin,place)'),
            array('far fa-map-marker-exclamation' => 'map-marker-exclamation(agree,alert,coordinates,destination,important,location,map,navigation,pin,place)'),
            array('fal fa-map-marker-exclamation' => 'map-marker-exclamation(agree,alert,coordinates,destination,important,location,map,navigation,pin,place)'),
            array('fas fa-map-marker-minus' => 'map-marker-minus(agree,coordinates,delete,destination,location,map,navigation,negative,pin,place,remove)'),
            array('far fa-map-marker-minus' => 'map-marker-minus(agree,coordinates,delete,destination,location,map,navigation,negative,pin,place,remove)'),
            array('fal fa-map-marker-minus' => 'map-marker-minus(agree,coordinates,delete,destination,location,map,navigation,negative,pin,place,remove)'),
            array('fas fa-map-marker-plus' => 'map-marker-plus(add,agree,coordinates,create,destination,location,map,navigation,new,pin,place,positive)'),
            array('far fa-map-marker-plus' => 'map-marker-plus(add,agree,coordinates,create,destination,location,map,navigation,new,pin,place,positive)'),
            array('fal fa-map-marker-plus' => 'map-marker-plus(add,agree,coordinates,create,destination,location,map,navigation,new,pin,place,positive)'),
            array('fas fa-map-marker-question' => 'map-marker-question(agree,coordinates,destination,help,info,location,map,navigation,pin,place,support)'),
            array('far fa-map-marker-question' => 'map-marker-question(agree,coordinates,destination,help,info,location,map,navigation,pin,place,support)'),
            array('fal fa-map-marker-question' => 'map-marker-question(agree,coordinates,destination,help,info,location,map,navigation,pin,place,support)'),
            array('fas fa-map-marker-slash' => 'map-marker-slash(agree,cancel,coordinates,destination,location,map,missing,navigation,pin,place)'),
            array('far fa-map-marker-slash' => 'map-marker-slash(agree,cancel,coordinates,destination,location,map,missing,navigation,pin,place)'),
            array('fal fa-map-marker-slash' => 'map-marker-slash(agree,cancel,coordinates,destination,location,map,missing,navigation,pin,place)'),
            array('fas fa-map-marker-smile' => 'map-marker-smile(agree,coordinates,destination,emoji,happy,location,map,navigation,pin,place,success)'),
            array('far fa-map-marker-smile' => 'map-marker-smile(agree,coordinates,destination,emoji,happy,location,map,navigation,pin,place,success)'),
            array('fal fa-map-marker-smile' => 'map-marker-smile(agree,coordinates,destination,emoji,happy,location,map,navigation,pin,place,success)'),
            array('fas fa-map-marker-times' => 'map-marker-times(agree,archive,coordinates,delete,destination,location,map,navigation,pin,place,remove,x)'),
            array('far fa-map-marker-times' => 'map-marker-times(agree,archive,coordinates,delete,destination,location,map,navigation,pin,place,remove,x)'),
            array('fal fa-map-marker-times' => 'map-marker-times(agree,archive,coordinates,delete,destination,location,map,navigation,pin,place,remove,x)'),
            array('fas fa-map-pin' => 'map-pin(address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)'),
            array('far fa-map-pin' => 'map-pin(address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)'),
            array('fal fa-map-pin' => 'map-pin(address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)'),
            array('fas fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('far fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('fal fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('fas fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('far fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('fal fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('fas fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('far fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fal fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fas fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('far fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fal fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fas fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('far fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('fal fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('fas fa-parking' => 'parking(auto,car,garage,meter)'),
            array('far fa-parking' => 'parking(auto,car,garage,meter)'),
            array('fal fa-parking' => 'parking(auto,car,garage,meter)'),
            array('fas fa-parking-circle' => 'parking-circle(auto,car,garage,meter)'),
            array('far fa-parking-circle' => 'parking-circle(auto,car,garage,meter)'),
            array('fal fa-parking-circle' => 'parking-circle(auto,car,garage,meter)'),
            array('fas fa-parking-circle-slash' => 'parking-circle-slash(auto,car,garage,meter)'),
            array('far fa-parking-circle-slash' => 'parking-circle-slash(auto,car,garage,meter)'),
            array('fal fa-parking-circle-slash' => 'parking-circle-slash(auto,car,garage,meter)'),
            array('fas fa-parking-slash' => 'parking-slash(auto,car,garage,meter)'),
            array('far fa-parking-slash' => 'parking-slash(auto,car,garage,meter)'),
            array('fal fa-parking-slash' => 'parking-slash(auto,car,garage,meter)'),
            array('fas fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('far fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('fal fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('fas fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone-square' => 'phone-square(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('far fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fal fa-phone-volume' => 'phone-volume(call,earphone,number,sound,support,telephone,voice,volume-control-phone)'),
            array('fas fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('far fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fal fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fas fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('far fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('fal fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('fas fa-plug' => 'plug(connect,electric,online,power)'),
            array('far fa-plug' => 'plug(connect,electric,online,power)'),
            array('fal fa-plug' => 'plug(connect,electric,online,power)'),
            array('fas fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('far fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fal fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('far fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fas fa-print' => 'print(business,copy,document,office,paper)'),
            array('far fa-print' => 'print(business,copy,document,office,paper)'),
            array('fal fa-print' => 'print(business,copy,document,office,paper)'),
            array('fas fa-recycle' => 'recycle(Waste,compost,garbage,reuse,trash)'),
            array('far fa-recycle' => 'recycle(Waste,compost,garbage,reuse,trash)'),
            array('fal fa-recycle' => 'recycle(Waste,compost,garbage,reuse,trash)'),
            array('fas fa-restroom' => 'restroom(bathroom,john,loo,potty,washroom,waste,wc)'),
            array('far fa-restroom' => 'restroom(bathroom,john,loo,potty,washroom,waste,wc)'),
            array('fal fa-restroom' => 'restroom(bathroom,john,loo,potty,washroom,waste,wc)'),
            array('fas fa-road' => 'road(highway,map,pavement,route,street,travel)'),
            array('far fa-road' => 'road(highway,map,pavement,route,street,travel)'),
            array('fal fa-road' => 'road(highway,map,pavement,route,street,travel)'),
            array('fas fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('far fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fal fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fas fa-route' => 'route(directions,navigation,travel)'),
            array('far fa-route' => 'route(directions,navigation,travel)'),
            array('fal fa-route' => 'route(directions,navigation,travel)'),
            array('fas fa-route-highway' => 'route-highway(directions,highway,interstate,navigation,sign,travel)'),
            array('far fa-route-highway' => 'route-highway(directions,highway,interstate,navigation,sign,travel)'),
            array('fal fa-route-highway' => 'route-highway(directions,highway,interstate,navigation,sign,travel)'),
            array('fas fa-route-interstate' => 'route-interstate(directions,highway,interstate,navigation,sign,travel)'),
            array('far fa-route-interstate' => 'route-interstate(directions,highway,interstate,navigation,sign,travel)'),
            array('fal fa-route-interstate' => 'route-interstate(directions,highway,interstate,navigation,sign,travel)'),
            array('fas fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('far fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fal fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fas fa-search-minus' => 'search-minus(minify,negative,smaller,zoom,zoom out)'),
            array('far fa-search-minus' => 'search-minus(minify,negative,smaller,zoom,zoom out)'),
            array('fal fa-search-minus' => 'search-minus(minify,negative,smaller,zoom,zoom out)'),
            array('fas fa-search-plus' => 'search-plus(bigger,enlarge,magnify,positive,zoom,zoom in)'),
            array('far fa-search-plus' => 'search-plus(bigger,enlarge,magnify,positive,zoom,zoom in)'),
            array('fal fa-search-plus' => 'search-plus(bigger,enlarge,magnify,positive,zoom,zoom in)'),
            array('fas fa-ship' => 'ship(boat,sea,water)'),
            array('far fa-ship' => 'ship(boat,sea,water)'),
            array('fal fa-ship' => 'ship(boat,sea,water)'),
            array('fas fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('far fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('fal fa-shoe-prints' => 'shoe-prints(feet,footprints,steps,walk)'),
            array('fas fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('far fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fal fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fas fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('far fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fal fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fas fa-street-view' => 'street-view(directions,location,map,navigation)'),
            array('far fa-street-view' => 'street-view(directions,location,map,navigation)'),
            array('fal fa-street-view' => 'street-view(directions,location,map,navigation)'),
            array('fas fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('far fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('fal fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('fas fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('far fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fal fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fas fa-tag' => 'tag(discount,label,price,shopping)'),
            array('far fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fal fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fas fa-tags' => 'tags(discount,label,price,shopping)'),
            array('far fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fal fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fas fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('far fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fal fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fas fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('far fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fal fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fas fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('far fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('fal fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('fas fa-ticket-alt' => 'ticket-alt(movie,pass,support,ticket)'),
            array('far fa-ticket-alt' => 'ticket-alt(movie,pass,support,ticket)'),
            array('fal fa-ticket-alt' => 'ticket-alt(movie,pass,support,ticket)'),
            array('fas fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('far fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('fal fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('fas fa-traffic-cone' => 'traffic-cone(alert,construction,road)'),
            array('far fa-traffic-cone' => 'traffic-cone(alert,construction,road)'),
            array('fal fa-traffic-cone' => 'traffic-cone(alert,construction,road)'),
            array('fas fa-traffic-light' => 'traffic-light(direction,road,signal,travel)'),
            array('far fa-traffic-light' => 'traffic-light(direction,road,signal,travel)'),
            array('fal fa-traffic-light' => 'traffic-light(direction,road,signal,travel)'),
            array('fas fa-traffic-light-go' => 'traffic-light-go(direction,green,road,signal,travel)'),
            array('far fa-traffic-light-go' => 'traffic-light-go(direction,green,road,signal,travel)'),
            array('fal fa-traffic-light-go' => 'traffic-light-go(direction,green,road,signal,travel)'),
            array('fas fa-traffic-light-slow' => 'traffic-light-slow(direction,road,signal,travel,yellow)'),
            array('far fa-traffic-light-slow' => 'traffic-light-slow(direction,road,signal,travel,yellow)'),
            array('fal fa-traffic-light-slow' => 'traffic-light-slow(direction,road,signal,travel,yellow)'),
            array('fas fa-traffic-light-stop' => 'traffic-light-stop(direction,red,road,signal,travel)'),
            array('far fa-traffic-light-stop' => 'traffic-light-stop(direction,red,road,signal,travel)'),
            array('fal fa-traffic-light-stop' => 'traffic-light-stop(direction,red,road,signal,travel)'),
            array('fas fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('far fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('fal fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('fas fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('far fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fal fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fas fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('far fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fal fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fas fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('far fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('fal fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('fas fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fas fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('far fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('fal fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('fas fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('far fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('fal fa-tty' => 'tty(communication,deaf,telephone,teletypewriter,text)'),
            array('fas fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('far fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('fal fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('fas fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('far fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('fal fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('fas fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('far fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('fal fa-usd-circle' => 'usd-circle($,currency,dollar-sign,money,price,usd)'),
            array('fas fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('far fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('fal fa-usd-square' => 'usd-square($,dollar-sign,money,price,usd)'),
            array('fas fa-utensil-fork' => 'utensil-fork(cutlery,dining,food,fork,silverware)'),
            array('far fa-utensil-fork' => 'utensil-fork(cutlery,dining,food,fork,silverware)'),
            array('fal fa-utensil-fork' => 'utensil-fork(cutlery,dining,food,fork,silverware)'),
            array('fas fa-utensil-knife' => 'utensil-knife(cut,cutlery,dining,silverware,tool)'),
            array('far fa-utensil-knife' => 'utensil-knife(cut,cutlery,dining,silverware,tool)'),
            array('fal fa-utensil-knife' => 'utensil-knife(cut,cutlery,dining,silverware,tool)'),
            array('fas fa-utensil-spoon' => 'utensil-spoon(cutlery,dining,scoop,silverware,spoon)'),
            array('far fa-utensil-spoon' => 'utensil-spoon(cutlery,dining,scoop,silverware,spoon)'),
            array('fal fa-utensil-spoon' => 'utensil-spoon(cutlery,dining,scoop,silverware,spoon)'),
            array('fas fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('far fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fal fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fas fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('far fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fal fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fas fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('far fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fal fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fas fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('far fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fal fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fas fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('far fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fal fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fas fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('far fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('fal fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
        ),
        'Maritime' => array(
            array('fas fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('far fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fal fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fas fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('far fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fal fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fas fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('far fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fal fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fas fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('far fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('fal fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('fas fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('far fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('fal fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('fas fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('far fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('fal fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('fas fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('far fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('fal fa-duck' => 'duck(bath,bird,fauna,quack,rubber)'),
            array('fas fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('far fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fal fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fas fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('far fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('fal fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('fas fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('far fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('fal fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('fas fa-ship' => 'ship(boat,sea,water)'),
            array('far fa-ship' => 'ship(boat,sea,water)'),
            array('fal fa-ship' => 'ship(boat,sea,water)'),
            array('fas fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('far fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fal fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fas fa-stars' => 'stars(galaxy,magic,night)'),
            array('far fa-stars' => 'stars(galaxy,magic,night)'),
            array('fal fa-stars' => 'stars(galaxy,magic,night)'),
            array('fas fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('far fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fal fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fas fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('far fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fal fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fas fa-turtle' => 'turtle(cowabunga,donatello,fauna,leonardo,michaelangelo,raphael,reptile,shell,slow)'),
            array('far fa-turtle' => 'turtle(cowabunga,donatello,fauna,leonardo,michaelangelo,raphael,reptile,shell,slow)'),
            array('fal fa-turtle' => 'turtle(cowabunga,donatello,fauna,leonardo,michaelangelo,raphael,reptile,shell,slow)'),
            array('fas fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('far fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('fal fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('fas fa-water-lower' => 'water-lower(flood,lake,liquid,ocean,recede,sea,swim,wet)'),
            array('far fa-water-lower' => 'water-lower(flood,lake,liquid,ocean,recede,sea,swim,wet)'),
            array('fal fa-water-lower' => 'water-lower(flood,lake,liquid,ocean,recede,sea,swim,wet)'),
            array('fas fa-water-rise' => 'water-rise(flood,lake,liquid,ocean,sea,swim,wet)'),
            array('far fa-water-rise' => 'water-rise(flood,lake,liquid,ocean,sea,swim,wet)'),
            array('fal fa-water-rise' => 'water-rise(flood,lake,liquid,ocean,sea,swim,wet)'),
            array('fas fa-whale' => 'whale(fauna,mammal,swimming)'),
            array('far fa-whale' => 'whale(fauna,mammal,swimming)'),
            array('fal fa-whale' => 'whale(fauna,mammal,swimming)'),
            array('fas fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('far fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('fal fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('fas fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
            array('far fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
            array('fal fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
        ),
        'Marketing' => array(
            array('fas fa-ad' => 'ad(advertisement,media,newspaper,promotion,publicity)'),
            array('far fa-ad' => 'ad(advertisement,media,newspaper,promotion,publicity)'),
            array('fal fa-ad' => 'ad(advertisement,media,newspaper,promotion,publicity)'),
            array('fas fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('far fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('fal fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('far fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fal fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fas fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('far fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fal fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fas fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('far fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fal fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fas fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('far fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fal fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fas fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('far fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fal fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fas fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('far fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('fal fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('fas fa-bullseye-pointer' => 'bullseye-pointer(archery,goal,objective,target)'),
            array('far fa-bullseye-pointer' => 'bullseye-pointer(archery,goal,objective,target)'),
            array('fal fa-bullseye-pointer' => 'bullseye-pointer(archery,goal,objective,target)'),
            array('fas fa-comment-alt-dollar' => 'comment-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comment-alt-dollar' => 'comment-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comment-alt-dollar' => 'comment-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-comment-dollar' => 'comment-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comment-dollar' => 'comment-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comment-dollar' => 'comment-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-comments-alt-dollar' => 'comments-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comments-alt-dollar' => 'comments-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comments-alt-dollar' => 'comments-alt-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-comments-dollar' => 'comments-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('far fa-comments-dollar' => 'comments-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fal fa-comments-dollar' => 'comments-dollar(bubble,chat,commenting,conversation,feedback,message,money,note,notification,pay,sms,speech,spend,texting,transfer)'),
            array('fas fa-envelope-open-dollar' => 'envelope-open-dollar(e-mail,email,letter,mail,message,money,notification,pay,transfer)'),
            array('far fa-envelope-open-dollar' => 'envelope-open-dollar(e-mail,email,letter,mail,message,money,notification,pay,transfer)'),
            array('fal fa-envelope-open-dollar' => 'envelope-open-dollar(e-mail,email,letter,mail,message,money,notification,pay,transfer)'),
            array('fas fa-envelope-open-text' => 'envelope-open-text(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-open-text' => 'envelope-open-text(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-open-text' => 'envelope-open-text(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-funnel-dollar' => 'funnel-dollar(filter,money,options,separate,sort)'),
            array('far fa-funnel-dollar' => 'funnel-dollar(filter,money,options,separate,sort)'),
            array('fal fa-funnel-dollar' => 'funnel-dollar(filter,money,options,separate,sort)'),
            array('fas fa-gift-card' => 'gift-card(christmas,generosity,giving,holiday,money,party,present,wrapped,xmas)'),
            array('far fa-gift-card' => 'gift-card(christmas,generosity,giving,holiday,money,party,present,wrapped,xmas)'),
            array('fal fa-gift-card' => 'gift-card(christmas,generosity,giving,holiday,money,party,present,wrapped,xmas)'),
            array('fas fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('far fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fal fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fas fa-lightbulb-dollar' => 'lightbulb-dollar(energy,idea,inspiration,light,money)'),
            array('far fa-lightbulb-dollar' => 'lightbulb-dollar(energy,idea,inspiration,light,money)'),
            array('fal fa-lightbulb-dollar' => 'lightbulb-dollar(energy,idea,inspiration,light,money)'),
            array('fas fa-lightbulb-exclamation' => 'lightbulb-exclamation(alert,energy,idea,inspiration,light)'),
            array('far fa-lightbulb-exclamation' => 'lightbulb-exclamation(alert,energy,idea,inspiration,light)'),
            array('fal fa-lightbulb-exclamation' => 'lightbulb-exclamation(alert,energy,idea,inspiration,light)'),
            array('fas fa-lightbulb-on' => 'lightbulb-on(energy,idea,inspiration,light,shine)'),
            array('far fa-lightbulb-on' => 'lightbulb-on(energy,idea,inspiration,light,shine)'),
            array('fal fa-lightbulb-on' => 'lightbulb-on(energy,idea,inspiration,light,shine)'),
            array('fas fa-lightbulb-slash' => 'lightbulb-slash(dark,light,off)'),
            array('far fa-lightbulb-slash' => 'lightbulb-slash(dark,light,off)'),
            array('fal fa-lightbulb-slash' => 'lightbulb-slash(dark,light,off)'),
            array('fas fa-mail-bulk' => 'mail-bulk(archive,envelope,letter,post office,postal,postcard,send,stamp,usps)'),
            array('far fa-mail-bulk' => 'mail-bulk(archive,envelope,letter,post office,postal,postcard,send,stamp,usps)'),
            array('fal fa-mail-bulk' => 'mail-bulk(archive,envelope,letter,post office,postal,postcard,send,stamp,usps)'),
            array('fas fa-megaphone' => 'megaphone(announcement,broadcast,bullhorn,louder,share)'),
            array('far fa-megaphone' => 'megaphone(announcement,broadcast,bullhorn,louder,share)'),
            array('fal fa-megaphone' => 'megaphone(announcement,broadcast,bullhorn,louder,share)'),
            array('fas fa-poll' => 'poll(results,survey,trend,vote,voting)'),
            array('far fa-poll' => 'poll(results,survey,trend,vote,voting)'),
            array('fal fa-poll' => 'poll(results,survey,trend,vote,voting)'),
            array('fas fa-poll-h' => 'poll-h(results,survey,trend,vote,voting)'),
            array('far fa-poll-h' => 'poll-h(results,survey,trend,vote,voting)'),
            array('fal fa-poll-h' => 'poll-h(results,survey,trend,vote,voting)'),
            array('fas fa-search-dollar' => 'search-dollar(bigger,enlarge,find,magnify,money,preview,zoom)'),
            array('far fa-search-dollar' => 'search-dollar(bigger,enlarge,find,magnify,money,preview,zoom)'),
            array('fal fa-search-dollar' => 'search-dollar(bigger,enlarge,find,magnify,money,preview,zoom)'),
            array('fas fa-search-location' => 'search-location(bigger,enlarge,find,magnify,preview,zoom)'),
            array('far fa-search-location' => 'search-location(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fal fa-search-location' => 'search-location(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fas fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('far fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('fal fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('fas fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('far fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('fal fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
        ),
        'Mathematics' => array(
            array('fas fa-abacus' => 'abacus(addition,ancient,arithmetic,calculator,counting,hexadecimal,math,subtraction)'),
            array('far fa-abacus' => 'abacus(addition,ancient,arithmetic,calculator,counting,hexadecimal,math,subtraction)'),
            array('fal fa-abacus' => 'abacus(addition,ancient,arithmetic,calculator,counting,hexadecimal,math,subtraction)'),
            array('fas fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('far fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fal fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fas fa-calculator-alt' => 'calculator-alt(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('far fa-calculator-alt' => 'calculator-alt(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fal fa-calculator-alt' => 'calculator-alt(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fas fa-divide' => 'divide(arithmetic,calculus,division,math)'),
            array('far fa-divide' => 'divide(arithmetic,calculus,division,math)'),
            array('fal fa-divide' => 'divide(arithmetic,calculus,division,math)'),
            array('fas fa-empty-set' => 'empty-set(math,theory)'),
            array('far fa-empty-set' => 'empty-set(math,theory)'),
            array('fal fa-empty-set' => 'empty-set(math,theory)'),
            array('fas fa-equals' => 'equals(arithmetic,even,match,math)'),
            array('far fa-equals' => 'equals(arithmetic,even,match,math)'),
            array('fal fa-equals' => 'equals(arithmetic,even,match,math)'),
            array('fas fa-function' => 'function(math,mathematics)'),
            array('far fa-function' => 'function(math,mathematics)'),
            array('fal fa-function' => 'function(math,mathematics)'),
            array('fas fa-greater-than' => 'greater-than(arithmetic,compare,math)'),
            array('far fa-greater-than' => 'greater-than(arithmetic,compare,math)'),
            array('fal fa-greater-than' => 'greater-than(arithmetic,compare,math)'),
            array('fas fa-greater-than-equal' => 'greater-than-equal(arithmetic,compare,math)'),
            array('far fa-greater-than-equal' => 'greater-than-equal(arithmetic,compare,math)'),
            array('fal fa-greater-than-equal' => 'greater-than-equal(arithmetic,compare,math)'),
            array('fas fa-infinity' => 'infinity(eternity,forever,math)'),
            array('far fa-infinity' => 'infinity(eternity,forever,math)'),
            array('fal fa-infinity' => 'infinity(eternity,forever,math)'),
            array('fas fa-integral' => 'integral(calculus,equation,function,math)'),
            array('far fa-integral' => 'integral(calculus,equation,function,math)'),
            array('fal fa-integral' => 'integral(calculus,equation,function,math)'),
            array('fas fa-intersection' => 'intersection(calculus,equation,function,math)'),
            array('far fa-intersection' => 'intersection(calculus,equation,function,math)'),
            array('fal fa-intersection' => 'intersection(calculus,equation,function,math)'),
            array('fas fa-lambda' => 'lambda(calculus,equation,function,math)'),
            array('far fa-lambda' => 'lambda(calculus,equation,function,math)'),
            array('fal fa-lambda' => 'lambda(calculus,equation,function,math)'),
            array('fas fa-less-than' => 'less-than(arithmetic,compare,math)'),
            array('far fa-less-than' => 'less-than(arithmetic,compare,math)'),
            array('fal fa-less-than' => 'less-than(arithmetic,compare,math)'),
            array('fas fa-less-than-equal' => 'less-than-equal(arithmetic,compare,math)'),
            array('far fa-less-than-equal' => 'less-than-equal(arithmetic,compare,math)'),
            array('fal fa-less-than-equal' => 'less-than-equal(arithmetic,compare,math)'),
            array('fas fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('far fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('fal fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('fas fa-not-equal' => 'not-equal(arithmetic,compare,math)'),
            array('far fa-not-equal' => 'not-equal(arithmetic,compare,math)'),
            array('fal fa-not-equal' => 'not-equal(arithmetic,compare,math)'),
            array('fas fa-omega' => 'omega(alphabet,greek,math)'),
            array('far fa-omega' => 'omega(alphabet,greek,math)'),
            array('fal fa-omega' => 'omega(alphabet,greek,math)'),
            array('fas fa-percentage' => 'percentage(discount,fraction,proportion,rate,ratio)'),
            array('far fa-percentage' => 'percentage(discount,fraction,proportion,rate,ratio)'),
            array('fal fa-percentage' => 'percentage(discount,fraction,proportion,rate,ratio)'),
            array('fas fa-pi' => 'pi(alphabet,circumference,diameter,greek,math,mathematics)'),
            array('far fa-pi' => 'pi(alphabet,circumference,diameter,greek,math,mathematics)'),
            array('fal fa-pi' => 'pi(alphabet,circumference,diameter,greek,math,mathematics)'),
            array('fas fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('far fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fal fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fas fa-sigma' => 'sigma(alphabet,greek,math,summation)'),
            array('far fa-sigma' => 'sigma(alphabet,greek,math,summation)'),
            array('fal fa-sigma' => 'sigma(alphabet,greek,math,summation)'),
            array('fas fa-square-root' => 'square-root(arithmetic,calculus,division,math)'),
            array('far fa-square-root' => 'square-root(arithmetic,calculus,division,math)'),
            array('fal fa-square-root' => 'square-root(arithmetic,calculus,division,math)'),
            array('fas fa-square-root-alt' => 'square-root-alt(arithmetic,calculus,division,math)'),
            array('far fa-square-root-alt' => 'square-root-alt(arithmetic,calculus,division,math)'),
            array('fal fa-square-root-alt' => 'square-root-alt(arithmetic,calculus,division,math)'),
            array('fas fa-subscript' => 'subscript(edit,font,format,text,type)'),
            array('far fa-subscript' => 'subscript(edit,font,format,text,type)'),
            array('fal fa-subscript' => 'subscript(edit,font,format,text,type)'),
            array('fas fa-superscript' => 'superscript(edit,exponential,font,format,text,type)'),
            array('far fa-superscript' => 'superscript(edit,exponential,font,format,text,type)'),
            array('fal fa-superscript' => 'superscript(edit,exponential,font,format,text,type)'),
            array('fas fa-tally' => 'tally(count,hash,numbers)'),
            array('far fa-tally' => 'tally(count,hash,numbers)'),
            array('fal fa-tally' => 'tally(count,hash,numbers)'),
            array('fas fa-theta' => 'theta(alphabet,greek,math)'),
            array('far fa-theta' => 'theta(alphabet,greek,math)'),
            array('fal fa-theta' => 'theta(alphabet,greek,math)'),
            array('fas fa-tilde' => 'tilde(accent,symbol,text,type)'),
            array('far fa-tilde' => 'tilde(accent,symbol,text,type)'),
            array('fal fa-tilde' => 'tilde(accent,symbol,text,type)'),
            array('fas fa-times' => 'times(close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('far fa-times' => 'times(close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fal fa-times' => 'times(close,cross,error,exit,incorrect,notice,notification,notify,problem,wrong,x)'),
            array('fas fa-union' => 'union(calculus,equation,function,math)'),
            array('far fa-union' => 'union(calculus,equation,function,math)'),
            array('fal fa-union' => 'union(calculus,equation,function,math)'),
            array('fas fa-value-absolute' => 'value-absolute(Math)'),
            array('far fa-value-absolute' => 'value-absolute(Math)'),
            array('fal fa-value-absolute' => 'value-absolute(Math)'),
        ),
        'Medical' => array(
            array('fas fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('far fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('fal fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('fas fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('far fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fal fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fas fa-band-aid' => 'band-aid(bandage,boo boo,first aid,ouch)'),
            array('far fa-band-aid' => 'band-aid(bandage,boo boo,first aid,ouch)'),
            array('fal fa-band-aid' => 'band-aid(bandage,boo boo,first aid,ouch)'),
            array('fas fa-biohazard' => 'biohazard(danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)'),
            array('far fa-biohazard' => 'biohazard(danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)'),
            array('fal fa-biohazard' => 'biohazard(danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)'),
            array('fas fa-bone' => 'bone(calcium,dog,skeletal,skeleton,tibia)'),
            array('far fa-bone' => 'bone(calcium,dog,skeletal,skeleton,tibia)'),
            array('fal fa-bone' => 'bone(calcium,dog,skeletal,skeleton,tibia)'),
            array('fas fa-bone-break' => 'bone-break(broken,calcium,dog,fracture,skeletal,skeleton,tibia)'),
            array('far fa-bone-break' => 'bone-break(broken,calcium,dog,fracture,skeletal,skeleton,tibia)'),
            array('fal fa-bone-break' => 'bone-break(broken,calcium,dog,fracture,skeletal,skeleton,tibia)'),
            array('fas fa-bong' => 'bong(aparatus,cannabis,marijuana,pipe,smoke,smoking)'),
            array('far fa-bong' => 'bong(aparatus,cannabis,marijuana,pipe,smoke,smoking)'),
            array('fal fa-bong' => 'bong(aparatus,cannabis,marijuana,pipe,smoke,smoking)'),
            array('fas fa-book-medical' => 'book-medical(diary,documentation,health,history,journal,library,read,record)'),
            array('far fa-book-medical' => 'book-medical(diary,documentation,health,history,journal,library,read,record)'),
            array('fal fa-book-medical' => 'book-medical(diary,documentation,health,history,journal,library,read,record)'),
            array('fas fa-book-user' => 'book-user(address,biography,diary,documentation,journal,library,read)'),
            array('far fa-book-user' => 'book-user(address,biography,diary,documentation,journal,library,read)'),
            array('fal fa-book-user' => 'book-user(address,biography,diary,documentation,journal,library,read)'),
            array('fas fa-books-medical' => 'books-medical(add,diary,documentation,health,journal,library,read,records)'),
            array('far fa-books-medical' => 'books-medical(add,diary,documentation,health,journal,library,read,records)'),
            array('fal fa-books-medical' => 'books-medical(add,diary,documentation,health,journal,library,read,records)'),
            array('fas fa-brain' => 'brain(cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)'),
            array('far fa-brain' => 'brain(cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)'),
            array('fal fa-brain' => 'brain(cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)'),
            array('fas fa-briefcase-medical' => 'briefcase-medical(doctor,emt,first aid,health)'),
            array('far fa-briefcase-medical' => 'briefcase-medical(doctor,emt,first aid,health)'),
            array('fal fa-briefcase-medical' => 'briefcase-medical(doctor,emt,first aid,health)'),
            array('fas fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('far fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fal fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fas fa-cannabis' => 'cannabis(bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)'),
            array('far fa-cannabis' => 'cannabis(bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)'),
            array('fal fa-cannabis' => 'cannabis(bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)'),
            array('fas fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('far fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('fal fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('fas fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('far fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fal fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fas fa-clipboard-prescription' => 'clipboard-prescription(copy,history,medical,notes,paste,record)'),
            array('far fa-clipboard-prescription' => 'clipboard-prescription(copy,history,medical,notes,paste,record)'),
            array('fal fa-clipboard-prescription' => 'clipboard-prescription(copy,history,medical,notes,paste,record)'),
            array('fas fa-clipboard-user' => 'clipboard-user(attendance,record,roster,staff)'),
            array('far fa-clipboard-user' => 'clipboard-user(attendance,record,roster,staff)'),
            array('fal fa-clipboard-user' => 'clipboard-user(attendance,record,roster,staff)'),
            array('fas fa-comment-alt-medical' => 'comment-alt-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('far fa-comment-alt-medical' => 'comment-alt-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fal fa-comment-alt-medical' => 'comment-alt-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fas fa-comment-medical' => 'comment-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('far fa-comment-medical' => 'comment-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fal fa-comment-medical' => 'comment-medical(advice,bubble,chat,commenting,conversation,diagnose,feedback,message,note,notification,prescription,sms,speech,texting)'),
            array('fas fa-crutch' => 'crutch(cane,injury,mobility,wheelchair)'),
            array('far fa-crutch' => 'crutch(cane,injury,mobility,wheelchair)'),
            array('fal fa-crutch' => 'crutch(cane,injury,mobility,wheelchair)'),
            array('fas fa-crutches' => 'crutches(cane,injury,mobility,wheelchair)'),
            array('far fa-crutches' => 'crutches(cane,injury,mobility,wheelchair)'),
            array('fal fa-crutches' => 'crutches(cane,injury,mobility,wheelchair)'),
            array('fas fa-diagnoses' => 'diagnoses(analyze,detect,diagnosis,examine,medicine)'),
            array('far fa-diagnoses' => 'diagnoses(analyze,detect,diagnosis,examine,medicine)'),
            array('fal fa-diagnoses' => 'diagnoses(analyze,detect,diagnosis,examine,medicine)'),
            array('fas fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('far fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('fal fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('fas fa-dna' => 'dna(double helix,genetic,helix,molecule,protein)'),
            array('far fa-dna' => 'dna(double helix,genetic,helix,molecule,protein)'),
            array('fal fa-dna' => 'dna(double helix,genetic,helix,molecule,protein)'),
            array('fas fa-ear' => 'ear(head,hearing,listen,lobe)'),
            array('far fa-ear' => 'ear(head,hearing,listen,lobe)'),
            array('fal fa-ear' => 'ear(head,hearing,listen,lobe)'),
            array('fas fa-file-medical' => 'file-medical(document,health,history,prescription,record)'),
            array('far fa-file-medical' => 'file-medical(document,health,history,prescription,record)'),
            array('fal fa-file-medical' => 'file-medical(document,health,history,prescription,record)'),
            array('fas fa-file-medical-alt' => 'file-medical-alt(document,health,history,prescription,record)'),
            array('far fa-file-medical-alt' => 'file-medical-alt(document,health,history,prescription,record)'),
            array('fal fa-file-medical-alt' => 'file-medical-alt(document,health,history,prescription,record)'),
            array('fas fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('far fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('fal fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('fas fa-files-medical' => 'files-medical(document,health,history,prescription,record)'),
            array('far fa-files-medical' => 'files-medical(document,health,history,prescription,record)'),
            array('fal fa-files-medical' => 'files-medical(document,health,history,prescription,record)'),
            array('fas fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('far fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('fal fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('fas fa-head-side-brain' => 'head-side-brain(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('far fa-head-side-brain' => 'head-side-brain(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('fal fa-head-side-brain' => 'head-side-brain(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('fas fa-head-side-medical' => 'head-side-medical(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('far fa-head-side-medical' => 'head-side-medical(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('fal fa-head-side-medical' => 'head-side-medical(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-heart-rate' => 'heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('far fa-heart-rate' => 'heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fal fa-heart-rate' => 'heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fas fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('far fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fal fa-heartbeat' => 'heartbeat(ekg,electrocardiogram,health,lifeline,vital signs)'),
            array('fas fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('far fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fal fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fas fa-hospital-alt' => 'hospital-alt(building,emergency room,medical center)'),
            array('far fa-hospital-alt' => 'hospital-alt(building,emergency room,medical center)'),
            array('fal fa-hospital-alt' => 'hospital-alt(building,emergency room,medical center)'),
            array('fas fa-hospital-symbol' => 'hospital-symbol(clinic,emergency,map)'),
            array('far fa-hospital-symbol' => 'hospital-symbol(clinic,emergency,map)'),
            array('fal fa-hospital-symbol' => 'hospital-symbol(clinic,emergency,map)'),
            array('fas fa-hospital-user' => 'hospital-user(doctor,network,patient,primary care)'),
            array('far fa-hospital-user' => 'hospital-user(doctor,network,patient,primary care)'),
            array('fal fa-hospital-user' => 'hospital-user(doctor,network,patient,primary care)'),
            array('fas fa-hospitals' => 'hospitals(emergency,insurance,network)'),
            array('far fa-hospitals' => 'hospitals(emergency,insurance,network)'),
            array('fal fa-hospitals' => 'hospitals(emergency,insurance,network)'),
            array('fas fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('far fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('fal fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('fas fa-inhaler' => 'inhaler(asthma,cough,lungs,nebulizer,vaporizer)'),
            array('far fa-inhaler' => 'inhaler(asthma,cough,lungs,nebulizer,vaporizer)'),
            array('fal fa-inhaler' => 'inhaler(asthma,cough,lungs,nebulizer,vaporizer)'),
            array('fas fa-joint' => 'joint(blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)'),
            array('far fa-joint' => 'joint(blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)'),
            array('fal fa-joint' => 'joint(blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)'),
            array('fas fa-kidneys' => 'kidneys(blood,body,organ,surgery,urine)'),
            array('far fa-kidneys' => 'kidneys(blood,body,organ,surgery,urine)'),
            array('fal fa-kidneys' => 'kidneys(blood,body,organ,surgery,urine)'),
            array('fas fa-laptop-medical' => 'laptop-medical(computer,device,ehr,electronic health records,history)'),
            array('far fa-laptop-medical' => 'laptop-medical(computer,device,ehr,electronic health records,history)'),
            array('fal fa-laptop-medical' => 'laptop-medical(computer,device,ehr,electronic health records,history)'),
            array('fas fa-lips' => 'lips(fashion,kiss,lipstick,mouth,smile)'),
            array('far fa-lips' => 'lips(fashion,kiss,lipstick,mouth,smile)'),
            array('fal fa-lips' => 'lips(fashion,kiss,lipstick,mouth,smile)'),
            array('fas fa-lungs' => 'lungs(air,breath,organ,respiratory)'),
            array('far fa-lungs' => 'lungs(air,breath,organ,respiratory)'),
            array('fal fa-lungs' => 'lungs(air,breath,organ,respiratory)'),
            array('fas fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('far fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('fal fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('fas fa-monitor-heart-rate' => 'monitor-heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('far fa-monitor-heart-rate' => 'monitor-heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fal fa-monitor-heart-rate' => 'monitor-heart-rate(EKG,electrocardiogram,health,life,vital)'),
            array('fas fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('far fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('fal fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('fas fa-notes-medical' => 'notes-medical(clipboard,doctor,ehr,health,history,records)'),
            array('far fa-notes-medical' => 'notes-medical(clipboard,doctor,ehr,health,history,records)'),
            array('fal fa-notes-medical' => 'notes-medical(clipboard,doctor,ehr,health,history,records)'),
            array('fas fa-pager' => 'pager(beeper,cellphone,communication)'),
            array('far fa-pager' => 'pager(beeper,cellphone,communication)'),
            array('fal fa-pager' => 'pager(beeper,cellphone,communication)'),
            array('fas fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('far fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('fal fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('fas fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('far fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fal fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fas fa-poop' => 'poop(crap,poop,shit,smile,turd)'),
            array('far fa-poop' => 'poop(crap,poop,shit,smile,turd)'),
            array('fal fa-poop' => 'poop(crap,poop,shit,smile,turd)'),
            array('fas fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-prescription-bottle-alt' => 'prescription-bottle-alt(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription-bottle-alt' => 'prescription-bottle-alt(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription-bottle-alt' => 'prescription-bottle-alt(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-procedures' => 'procedures(EKG,bed,electrocardiogram,health,hospital,life,patient,vital)'),
            array('far fa-procedures' => 'procedures(EKG,bed,electrocardiogram,health,hospital,life,patient,vital)'),
            array('fal fa-procedures' => 'procedures(EKG,bed,electrocardiogram,health,hospital,life,patient,vital)'),
            array('fas fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-scalpel' => 'scalpel(blade,cut,doctor,knife,surgeon,surgery)'),
            array('far fa-scalpel' => 'scalpel(blade,cut,doctor,knife,surgeon,surgery)'),
            array('fal fa-scalpel' => 'scalpel(blade,cut,doctor,knife,surgeon,surgery)'),
            array('fas fa-scalpel-path' => 'scalpel-path(blade,cut,doctor,knife,surgeon,surgery)'),
            array('far fa-scalpel-path' => 'scalpel-path(blade,cut,doctor,knife,surgeon,surgery)'),
            array('fal fa-scalpel-path' => 'scalpel-path(blade,cut,doctor,knife,surgeon,surgery)'),
            array('fas fa-skeleton' => 'skeleton(bones,skeletal,vertebrate,x-ray)'),
            array('far fa-skeleton' => 'skeleton(bones,skeletal,vertebrate,x-ray)'),
            array('fal fa-skeleton' => 'skeleton(bones,skeletal,vertebrate,x-ray)'),
            array('fas fa-smoking' => 'smoking(cancer,cigarette,nicotine,smoking status,tobacco)'),
            array('far fa-smoking' => 'smoking(cancer,cigarette,nicotine,smoking status,tobacco)'),
            array('fal fa-smoking' => 'smoking(cancer,cigarette,nicotine,smoking status,tobacco)'),
            array('fas fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('far fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('fal fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('fas fa-star-of-life' => 'star-of-life(doctor,emt,first aid,health,medical)'),
            array('far fa-star-of-life' => 'star-of-life(doctor,emt,first aid,health,medical)'),
            array('fal fa-star-of-life' => 'star-of-life(doctor,emt,first aid,health,medical)'),
            array('fas fa-stethoscope' => 'stethoscope(diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('far fa-stethoscope' => 'stethoscope(diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fal fa-stethoscope' => 'stethoscope(diagnosis,doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fas fa-stomach' => 'stomach(abdomen,belly,food,gut,hungry,intestine,organ,tummy)'),
            array('far fa-stomach' => 'stomach(abdomen,belly,food,gut,hungry,intestine,organ,tummy)'),
            array('fal fa-stomach' => 'stomach(abdomen,belly,food,gut,hungry,intestine,organ,tummy)'),
            array('fas fa-stretcher' => 'stretcher(ambulance,bed,emergency,er,patient)'),
            array('far fa-stretcher' => 'stretcher(ambulance,bed,emergency,er,patient)'),
            array('fal fa-stretcher' => 'stretcher(ambulance,bed,emergency,er,patient)'),
            array('fas fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('far fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('fal fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('fas fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('far fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('fal fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('fas fa-teeth' => 'teeth(bite,dental,dentist,gums,mouth,smile,tooth)'),
            array('far fa-teeth' => 'teeth(bite,dental,dentist,gums,mouth,smile,tooth)'),
            array('fal fa-teeth' => 'teeth(bite,dental,dentist,gums,mouth,smile,tooth)'),
            array('fas fa-teeth-open' => 'teeth-open(dental,dentist,gums bite,mouth,smile,tooth)'),
            array('far fa-teeth-open' => 'teeth-open(dental,dentist,gums bite,mouth,smile,tooth)'),
            array('fal fa-teeth-open' => 'teeth-open(dental,dentist,gums bite,mouth,smile,tooth)'),
            array('fas fa-thermometer' => 'thermometer(mercury,status,temperature)'),
            array('far fa-thermometer' => 'thermometer(mercury,status,temperature)'),
            array('fal fa-thermometer' => 'thermometer(mercury,status,temperature)'),
            array('fas fa-tooth' => 'tooth(bicuspid,dental,dentist,molar,mouth,teeth)'),
            array('far fa-tooth' => 'tooth(bicuspid,dental,dentist,molar,mouth,teeth)'),
            array('fal fa-tooth' => 'tooth(bicuspid,dental,dentist,molar,mouth,teeth)'),
            array('fas fa-toothbrush' => 'toothbrush(bicuspid,dental,dentist,molar,mouth,teeth)'),
            array('far fa-toothbrush' => 'toothbrush(bicuspid,dental,dentist,molar,mouth,teeth)'),
            array('fal fa-toothbrush' => 'toothbrush(bicuspid,dental,dentist,molar,mouth,teeth)'),
            array('fas fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('far fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('fal fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('fas fa-user-md-chat' => 'user-md-chat(advice,comment,diagnosis,opinion,prescription)'),
            array('far fa-user-md-chat' => 'user-md-chat(advice,comment,diagnosis,opinion,prescription)'),
            array('fal fa-user-md-chat' => 'user-md-chat(advice,comment,diagnosis,opinion,prescription)'),
            array('fas fa-user-nurse' => 'user-nurse(doctor,midwife,practitioner,surgeon)'),
            array('far fa-user-nurse' => 'user-nurse(doctor,midwife,practitioner,surgeon)'),
            array('fal fa-user-nurse' => 'user-nurse(doctor,midwife,practitioner,surgeon)'),
            array('fas fa-users-medical' => 'users-medical(group,patients,physician,team)'),
            array('far fa-users-medical' => 'users-medical(group,patients,physician,team)'),
            array('fal fa-users-medical' => 'users-medical(group,patients,physician,team)'),
            array('fas fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('far fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('fal fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('fas fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
            array('far fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
            array('fal fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
            array('fas fa-walker' => 'walker(accessibility,assistance,wheelchair)'),
            array('far fa-walker' => 'walker(accessibility,assistance,wheelchair)'),
            array('fal fa-walker' => 'walker(accessibility,assistance,wheelchair)'),
            array('fas fa-watch-fitness' => 'watch-fitness(Fitbit,alert,apple watch,clock,pedometer,time,wristwatch)'),
            array('far fa-watch-fitness' => 'watch-fitness(Fitbit,alert,apple watch,clock,pedometer,time,wristwatch)'),
            array('fal fa-watch-fitness' => 'watch-fitness(Fitbit,alert,apple watch,clock,pedometer,time,wristwatch)'),
            array('fas fa-weight' => 'weight(health,measurement,scale,weight)'),
            array('far fa-weight' => 'weight(health,measurement,scale,weight)'),
            array('fal fa-weight' => 'weight(health,measurement,scale,weight)'),
            array('fas fa-x-ray' => 'x-ray(health,medical,radiological images,radiology,skeleton)'),
            array('far fa-x-ray' => 'x-ray(health,medical,radiological images,radiology,skeleton)'),
            array('fal fa-x-ray' => 'x-ray(health,medical,radiological images,radiology,skeleton)'),
        ),
        'Moving' => array(
            array('fas fa-archive' => 'archive(box,package,save,storage)'),
            array('far fa-archive' => 'archive(box,package,save,storage)'),
            array('fal fa-archive' => 'archive(box,package,save,storage)'),
            array('fas fa-blanket' => 'blanket(bed,cover,cozy,sleep,warm)'),
            array('far fa-blanket' => 'blanket(bed,cover,cozy,sleep,warm)'),
            array('fal fa-blanket' => 'blanket(bed,cover,cozy,sleep,warm)'),
            array('fas fa-box-alt' => 'box-alt(archive,container,package,storage)'),
            array('far fa-box-alt' => 'box-alt(archive,container,package,storage)'),
            array('fal fa-box-alt' => 'box-alt(archive,container,package,storage)'),
            array('fas fa-box-fragile' => 'box-fragile(broken,careful,glass,package)'),
            array('far fa-box-fragile' => 'box-fragile(broken,careful,glass,package)'),
            array('fal fa-box-fragile' => 'box-fragile(broken,careful,glass,package)'),
            array('fas fa-box-full' => 'box-full(attic,package,packed,storage)'),
            array('far fa-box-full' => 'box-full(attic,package,packed,storage)'),
            array('fal fa-box-full' => 'box-full(attic,package,packed,storage)'),
            array('fas fa-box-open' => 'box-open(archive,container,package,storage,unpack)'),
            array('far fa-box-open' => 'box-open(archive,container,package,storage,unpack)'),
            array('fal fa-box-open' => 'box-open(archive,container,package,storage,unpack)'),
            array('fas fa-box-up' => 'box-up(archive,container,package,shipping,storage)'),
            array('far fa-box-up' => 'box-up(archive,container,package,shipping,storage)'),
            array('fal fa-box-up' => 'box-up(archive,container,package,shipping,storage)'),
            array('fas fa-boxes-alt' => 'boxes-alt(archives,inventory,storage,warehouse)'),
            array('far fa-boxes-alt' => 'boxes-alt(archives,inventory,storage,warehouse)'),
            array('fal fa-boxes-alt' => 'boxes-alt(archives,inventory,storage,warehouse)'),
            array('fas fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('far fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('fal fa-container-storage' => 'container-storage(archive,box,inventory,shipping,warehouse)'),
            array('fas fa-couch' => 'couch(chair,cushion,furniture,relax,sofa)'),
            array('far fa-couch' => 'couch(chair,cushion,furniture,relax,sofa)'),
            array('fal fa-couch' => 'couch(chair,cushion,furniture,relax,sofa)'),
            array('fas fa-dolly' => 'dolly(carry,shipping,transport)'),
            array('far fa-dolly' => 'dolly(carry,shipping,transport)'),
            array('fal fa-dolly' => 'dolly(carry,shipping,transport)'),
            array('fas fa-dolly-empty' => 'dolly-empty(carry,inventory,shipping,transport)'),
            array('far fa-dolly-empty' => 'dolly-empty(carry,inventory,shipping,transport)'),
            array('fal fa-dolly-empty' => 'dolly-empty(carry,inventory,shipping,transport)'),
            array('fas fa-fragile' => 'fragile(break,broken,delicate,glass)'),
            array('far fa-fragile' => 'fragile(break,broken,delicate,glass)'),
            array('fal fa-fragile' => 'fragile(break,broken,delicate,glass)'),
            array('fas fa-lamp' => 'lamp(bright,furniture,light)'),
            array('far fa-lamp' => 'lamp(bright,furniture,light)'),
            array('fal fa-lamp' => 'lamp(bright,furniture,light)'),
            array('fas fa-loveseat' => 'loveseat(chair,couch,cushion,furniture,relax,sofa)'),
            array('far fa-loveseat' => 'loveseat(chair,couch,cushion,furniture,relax,sofa)'),
            array('fal fa-loveseat' => 'loveseat(chair,couch,cushion,furniture,relax,sofa)'),
            array('fas fa-people-carry' => 'people-carry(box,carry,fragile,help,movers,package)'),
            array('far fa-people-carry' => 'people-carry(box,carry,fragile,help,movers,package)'),
            array('fal fa-people-carry' => 'people-carry(box,carry,fragile,help,movers,package)'),
            array('fas fa-person-carry' => 'person-carry(human,lift,mover,person,transport)'),
            array('far fa-person-carry' => 'person-carry(human,lift,mover,person,transport)'),
            array('fal fa-person-carry' => 'person-carry(human,lift,mover,person,transport)'),
            array('fas fa-person-dolly' => 'person-dolly(human,lift,mover,person,transport)'),
            array('far fa-person-dolly' => 'person-dolly(human,lift,mover,person,transport)'),
            array('fal fa-person-dolly' => 'person-dolly(human,lift,mover,person,transport)'),
            array('fas fa-person-dolly-empty' => 'person-dolly-empty(human,lift,mover,person,transport)'),
            array('far fa-person-dolly-empty' => 'person-dolly-empty(human,lift,mover,person,transport)'),
            array('fal fa-person-dolly-empty' => 'person-dolly-empty(human,lift,mover,person,transport)'),
            array('fas fa-ramp-loading' => 'ramp-loading(inventory,moving,shipping,storage,warehouse)'),
            array('far fa-ramp-loading' => 'ramp-loading(inventory,moving,shipping,storage,warehouse)'),
            array('fal fa-ramp-loading' => 'ramp-loading(inventory,moving,shipping,storage,warehouse)'),
            array('fas fa-route' => 'route(directions,navigation,travel)'),
            array('far fa-route' => 'route(directions,navigation,travel)'),
            array('fal fa-route' => 'route(directions,navigation,travel)'),
            array('fas fa-sign' => 'sign(directions,real estate,signage,wayfinding)'),
            array('far fa-sign' => 'sign(directions,real estate,signage,wayfinding)'),
            array('fal fa-sign' => 'sign(directions,real estate,signage,wayfinding)'),
            array('fas fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('far fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fal fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fas fa-tape' => 'tape(design,package,sticky)'),
            array('far fa-tape' => 'tape(design,package,sticky)'),
            array('fal fa-tape' => 'tape(design,package,sticky)'),
            array('fas fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('fas fa-truck-couch' => 'truck-couch(cargo,delivery,moving,rental,shipping,vehicle)'),
            array('far fa-truck-couch' => 'truck-couch(cargo,delivery,moving,rental,shipping,vehicle)'),
            array('fal fa-truck-couch' => 'truck-couch(cargo,delivery,moving,rental,shipping,vehicle)'),
            array('fas fa-truck-loading' => 'truck-loading(box,cargo,delivery,inventory,moving,rental,vehicle)'),
            array('far fa-truck-loading' => 'truck-loading(box,cargo,delivery,inventory,moving,rental,vehicle)'),
            array('fal fa-truck-loading' => 'truck-loading(box,cargo,delivery,inventory,moving,rental,vehicle)'),
            array('fas fa-truck-moving' => 'truck-moving(cargo,inventory,rental,vehicle)'),
            array('far fa-truck-moving' => 'truck-moving(cargo,inventory,rental,vehicle)'),
            array('fal fa-truck-moving' => 'truck-moving(cargo,inventory,rental,vehicle)'),
            array('fas fa-truck-ramp' => 'truck-ramp(box,cargo,delivery,inventory,moving,rental,vehicle)'),
            array('far fa-truck-ramp' => 'truck-ramp(box,cargo,delivery,inventory,moving,rental,vehicle)'),
            array('fal fa-truck-ramp' => 'truck-ramp(box,cargo,delivery,inventory,moving,rental,vehicle)'),
            array('fas fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('far fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fal fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
        ),
        'Music' => array(
            array('fas fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('far fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fal fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fas fa-drum' => 'drum(instrument,music,percussion,snare,sound)'),
            array('far fa-drum' => 'drum(instrument,music,percussion,snare,sound)'),
            array('fal fa-drum' => 'drum(instrument,music,percussion,snare,sound)'),
            array('fas fa-drum-steelpan' => 'drum-steelpan(calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)'),
            array('far fa-drum-steelpan' => 'drum-steelpan(calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)'),
            array('fal fa-drum-steelpan' => 'drum-steelpan(calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)'),
            array('fas fa-ear' => 'ear(head,hearing,listen,lobe)'),
            array('far fa-ear' => 'ear(head,hearing,listen,lobe)'),
            array('fal fa-ear' => 'ear(head,hearing,listen,lobe)'),
            array('fas fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('far fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('fal fa-file-audio' => 'file-audio(document,mp3,music,page,play,sound)'),
            array('fas fa-guitar' => 'guitar(acoustic,instrument,music,rock,rock and roll,song,strings)'),
            array('far fa-guitar' => 'guitar(acoustic,instrument,music,rock,rock and roll,song,strings)'),
            array('fal fa-guitar' => 'guitar(acoustic,instrument,music,rock,rock and roll,song,strings)'),
            array('fas fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('far fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fal fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fas fa-headphones-alt' => 'headphones-alt(audio,listen,music,sound,speaker)'),
            array('far fa-headphones-alt' => 'headphones-alt(audio,listen,music,sound,speaker)'),
            array('fal fa-headphones-alt' => 'headphones-alt(audio,listen,music,sound,speaker)'),
            array('fas fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('far fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('fal fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('fas fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('far fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fal fa-music' => 'music(lyrics,melody,note,sing,sound)'),
            array('fab fa-napster' => 'napster'),
            array('fas fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('far fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fal fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fas fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-h' => 'sliders-h(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-h-square' => 'sliders-h-square(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-v' => 'sliders-v(adjust,settings,sliders,toggle)'),
            array('fas fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('far fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('fal fa-sliders-v-square' => 'sliders-v-square(adjust,settings,sliders,toggle)'),
            array('fab fa-soundcloud' => 'soundcloud'),
            array('fab fa-spotify' => 'spotify'),
            array('fas fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('far fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fal fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fas fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('far fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fal fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fas fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('far fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fal fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fas fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('far fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fal fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fas fa-whistle' => 'whistle(alert,single,sound,toot)'),
            array('far fa-whistle' => 'whistle(alert,single,sound,toot)'),
            array('fal fa-whistle' => 'whistle(alert,single,sound,toot)'),
        ),
        'Objects' => array(
            array('fas fa-alarm-clock' => 'alarm-clock(date,late,reminder,sleep,snooze,timer,timestamp,watch)'),
            array('far fa-alarm-clock' => 'alarm-clock(date,late,reminder,sleep,snooze,timer,timestamp,watch)'),
            array('fal fa-alarm-clock' => 'alarm-clock(date,late,reminder,sleep,snooze,timer,timestamp,watch)'),
            array('fas fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('far fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fal fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fas fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('far fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fal fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fas fa-archive' => 'archive(box,package,save,storage)'),
            array('far fa-archive' => 'archive(box,package,save,storage)'),
            array('fal fa-archive' => 'archive(box,package,save,storage)'),
            array('fas fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('far fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fal fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fas fa-axe-battle' => 'axe-battle(Dungeons & Dragons,barbarian,d&d,dnd,fantasy,gimli,lumberjack,melee attack)'),
            array('far fa-axe-battle' => 'axe-battle(Dungeons & Dragons,barbarian,d&d,dnd,fantasy,gimli,lumberjack,melee attack)'),
            array('fal fa-axe-battle' => 'axe-battle(Dungeons & Dragons,barbarian,d&d,dnd,fantasy,gimli,lumberjack,melee attack)'),
            array('fas fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('far fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fal fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fas fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('far fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fal fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fas fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-ball-pile' => 'ball-pile(balance,cannon,group,pyramid,snowball)'),
            array('far fa-ball-pile' => 'ball-pile(balance,cannon,group,pyramid,snowball)'),
            array('fal fa-ball-pile' => 'ball-pile(balance,cannon,group,pyramid,snowball)'),
            array('fas fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('far fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fal fa-bath' => 'bath(clean,shower,tub,wash)'),
            array('fas fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('far fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fal fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fas fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('far fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fal fa-beer' => 'beer(alcohol,ale,bar,beverage,brewery,drink,lager,liquor,mug,stein)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('far fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fal fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fas fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('far fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fal fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fas fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('far fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fal fa-binoculars' => 'binoculars(glasses,magnify,scenic,spyglass,view)'),
            array('fas fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('far fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fal fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fas fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('far fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('fal fa-blender' => 'blender(cocktail,milkshake,mixer,puree,smoothie)'),
            array('fas fa-bomb' => 'bomb(error,explode,fuse,grenade,warning)'),
            array('far fa-bomb' => 'bomb(error,explode,fuse,grenade,warning)'),
            array('fal fa-bomb' => 'bomb(error,explode,fuse,grenade,warning)'),
            array('fas fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('far fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fal fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fas fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('far fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('fal fa-book-dead' => 'book-dead(Dungeons & Dragons,crossbones,d&d,dark arts,death,dnd,documentation,evil,fantasy,halloween,holiday,necronomicon,read,skull,spell)'),
            array('fas fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('far fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fal fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fas fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('far fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fal fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fas fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('far fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fal fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fas fa-bow-arrow' => 'bow-arrow(Dungeons & Dragons,archery,d&d,dnd,fantasy,legolas,ranged attack,ranger,weapon)'),
            array('far fa-bow-arrow' => 'bow-arrow(Dungeons & Dragons,archery,d&d,dnd,fantasy,legolas,ranged attack,ranger,weapon)'),
            array('fal fa-bow-arrow' => 'bow-arrow(Dungeons & Dragons,archery,d&d,dnd,fantasy,legolas,ranged attack,ranger,weapon)'),
            array('fas fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('far fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fal fa-briefcase' => 'briefcase(bag,business,luggage,office,work)'),
            array('fas fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('far fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fal fa-broadcast-tower' => 'broadcast-tower(airwaves,antenna,radio,reception,waves)'),
            array('fas fa-bug' => 'bug(beetle,error,insect,report)'),
            array('far fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fal fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fas fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('far fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fal fa-building' => 'building(apartment,business,city,company,office,work)'),
            array('fas fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('far fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fal fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fas fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('far fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fal fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fas fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('far fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fal fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fas fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('far fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fal fa-calculator' => 'calculator(abacus,addition,arithmetic,counting,math,multiplication,subtraction)'),
            array('fas fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('far fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fal fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fas fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('far fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fal fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fas fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('far fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('fal fa-candy-cane' => 'candy-cane(candy,christmas,holiday,mint,peppermint,striped,xmas)'),
            array('fas fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('far fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fal fa-carrot' => 'carrot(bugs bunny,orange,vegan,vegetable)'),
            array('fas fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('far fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('fal fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('fas fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('far fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('fal fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('fas fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('far fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fal fa-clipboard' => 'clipboard(copy,notes,paste,record)'),
            array('fas fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('far fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fal fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fas fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('far fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fal fa-coffee' => 'coffee(beverage,breakfast,cafe,drink,fall,morning,mug,seasonal,tea)'),
            array('fas fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('far fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('fal fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('fas fa-cogs' => 'cogs(gears,mechanical,settings,sprocket,wheel)'),
            array('far fa-cogs' => 'cogs(gears,mechanical,settings,sprocket,wheel)'),
            array('fal fa-cogs' => 'cogs(gears,mechanical,settings,sprocket,wheel)'),
            array('fas fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('far fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fal fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fas fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('far fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('fal fa-cookie' => 'cookie(baked good,chips,chocolate,eat,snack,sweet,treat)'),
            array('fas fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('far fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('fal fa-cookie-bite' => 'cookie-bite(baked good,bitten,chips,chocolate,eat,snack,sweet,treat)'),
            array('fas fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('far fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fal fa-copy' => 'copy(clone,duplicate,file,files-o,paper,paste)'),
            array('fas fa-cube' => 'cube(3d,block,dice,package,square,tesseract)'),
            array('far fa-cube' => 'cube(3d,block,dice,package,square,tesseract)'),
            array('fal fa-cube' => 'cube(3d,block,dice,package,square,tesseract)'),
            array('fas fa-cubes' => 'cubes(3d,block,dice,package,pyramid,square,stack,tesseract)'),
            array('far fa-cubes' => 'cubes(3d,block,dice,package,pyramid,square,stack,tesseract)'),
            array('fal fa-cubes' => 'cubes(3d,block,dice,package,pyramid,square,stack,tesseract)'),
            array('fas fa-cut' => 'cut(clip,scissors,snip)'),
            array('far fa-cut' => 'cut(clip,scissors,snip)'),
            array('fal fa-cut' => 'cut(clip,scissors,snip)'),
            array('fas fa-dagger' => 'dagger(Dungeons & Dragons,blade,d&d,dnd,fantasy,melee attack,rogue,sting,weapon)'),
            array('far fa-dagger' => 'dagger(Dungeons & Dragons,blade,d&d,dnd,fantasy,melee attack,rogue,sting,weapon)'),
            array('fal fa-dagger' => 'dagger(Dungeons & Dragons,blade,d&d,dnd,fantasy,melee attack,rogue,sting,weapon)'),
            array('fas fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('far fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('fal fa-dice' => 'dice(chance,gambling,game,roll)'),
            array('fas fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d10' => 'dice-d10(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d12' => 'dice-d12(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d20' => 'dice-d20(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d4' => 'dice-d4(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d6' => 'dice-d6(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('far fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fal fa-dice-d8' => 'dice-d8(Dungeons & Dragons,chance,d&d,dnd,fantasy,gambling,game,roll)'),
            array('fas fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('far fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('fal fa-dice-five' => 'dice-five(chance,gambling,game,roll)'),
            array('fas fa-dice-four' => 'dice-four(chance,gambling,game,roll)'),
            array('far fa-dice-four' => 'dice-four(chance,gambling,game,roll)'),
            array('fal fa-dice-four' => 'dice-four(chance,gambling,game,roll)'),
            array('fas fa-dice-one' => 'dice-one(chance,gambling,game,roll)'),
            array('far fa-dice-one' => 'dice-one(chance,gambling,game,roll)'),
            array('fal fa-dice-one' => 'dice-one(chance,gambling,game,roll)'),
            array('fas fa-dice-six' => 'dice-six(chance,gambling,game,roll)'),
            array('far fa-dice-six' => 'dice-six(chance,gambling,game,roll)'),
            array('fal fa-dice-six' => 'dice-six(chance,gambling,game,roll)'),
            array('fas fa-dice-three' => 'dice-three(chance,gambling,game,roll)'),
            array('far fa-dice-three' => 'dice-three(chance,gambling,game,roll)'),
            array('fal fa-dice-three' => 'dice-three(chance,gambling,game,roll)'),
            array('fas fa-dice-two' => 'dice-two(chance,gambling,game,roll)'),
            array('far fa-dice-two' => 'dice-two(chance,gambling,game,roll)'),
            array('fal fa-dice-two' => 'dice-two(chance,gambling,game,roll)'),
            array('fas fa-digital-tachograph' => 'digital-tachograph(data,distance,speed,tachometer)'),
            array('far fa-digital-tachograph' => 'digital-tachograph(data,distance,speed,tachometer)'),
            array('fal fa-digital-tachograph' => 'digital-tachograph(data,distance,speed,tachometer)'),
            array('fas fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('far fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fal fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fas fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('far fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fal fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fas fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('far fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('fal fa-dreidel' => 'dreidel(clay,hanukkah,holiday,jewish,judaism,toy)'),
            array('fas fa-drum' => 'drum(instrument,music,percussion,snare,sound)'),
            array('far fa-drum' => 'drum(instrument,music,percussion,snare,sound)'),
            array('fal fa-drum' => 'drum(instrument,music,percussion,snare,sound)'),
            array('fas fa-drum-steelpan' => 'drum-steelpan(calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)'),
            array('far fa-drum-steelpan' => 'drum-steelpan(calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)'),
            array('fal fa-drum-steelpan' => 'drum-steelpan(calypso,instrument,music,percussion,reggae,snare,sound,steel,tropical)'),
            array('fas fa-ear-muffs' => 'ear-muffs(accessory,clothing,cold,head,puffy,soft,winter)'),
            array('far fa-ear-muffs' => 'ear-muffs(accessory,clothing,cold,head,puffy,soft,winter)'),
            array('fal fa-ear-muffs' => 'ear-muffs(accessory,clothing,cold,head,puffy,soft,winter)'),
            array('fas fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('far fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fal fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fas fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('far fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fal fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fas fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('far fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fal fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fas fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('far fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('fal fa-fax' => 'fax(business,communicate,copy,facsimile,send)'),
            array('fas fa-feather' => 'feather(bird,light,plucked,quill,write)'),
            array('far fa-feather' => 'feather(bird,light,plucked,quill,write)'),
            array('fal fa-feather' => 'feather(bird,light,plucked,quill,write)'),
            array('fas fa-feather-alt' => 'feather-alt(bird,light,plucked,quill,write)'),
            array('far fa-feather-alt' => 'feather-alt(bird,light,plucked,quill,write)'),
            array('fal fa-feather-alt' => 'feather-alt(bird,light,plucked,quill,write)'),
            array('fas fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('far fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('fal fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('far fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('fal fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('fas fa-film' => 'film(cinema,movie,strip,video)'),
            array('far fa-film' => 'film(cinema,movie,strip,video)'),
            array('fal fa-film' => 'film(cinema,movie,strip,video)'),
            array('fas fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('far fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('fal fa-film-alt' => 'film-alt(cinema,movie,strip,video)'),
            array('fas fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('far fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('fal fa-fire-extinguisher' => 'fire-extinguisher(burn,caliente,fire fighter,flame,heat,hot,rescue)'),
            array('fas fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('far fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fal fa-fireplace' => 'fireplace(caliente,flame,hearth,heat,holiday,mantle,toasty,warmth)'),
            array('fas fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('far fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('fal fa-flag' => 'flag(country,notice,notification,notify,pole,report,symbol)'),
            array('fas fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('far fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('fal fa-flag-checkered' => 'flag-checkered(notice,notification,notify,pole,racing,report,symbol)'),
            array('fas fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('far fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fal fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fas fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('far fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fal fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fas fa-futbol' => 'futbol(ball,football,mls,soccer)'),
            array('far fa-futbol' => 'futbol(ball,football,mls,soccer)'),
            array('fal fa-futbol' => 'futbol(ball,football,mls,soccer)'),
            array('fas fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('far fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('fal fa-gamepad' => 'gamepad(controller,d-pad,joystick,video)'),
            array('fas fa-gavel' => 'gavel(hammer,judge,law,lawyer,opinion)'),
            array('far fa-gavel' => 'gavel(hammer,judge,law,lawyer,opinion)'),
            array('fal fa-gavel' => 'gavel(hammer,judge,law,lawyer,opinion)'),
            array('fas fa-gem' => 'gem(diamond,jewelry,sapphire,stone,treasure)'),
            array('far fa-gem' => 'gem(diamond,jewelry,sapphire,stone,treasure)'),
            array('fal fa-gem' => 'gem(diamond,jewelry,sapphire,stone,treasure)'),
            array('fas fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('far fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('fal fa-gingerbread-man' => 'gingerbread-man(cookie,decoration,frosting,holiday)'),
            array('fas fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('far fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('fal fa-glass-champagne' => 'glass-champagne(alcohol,bar,beverage,celebration,champagne,drink,holiday,party)'),
            array('fas fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('far fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('fal fa-glass-cheers' => 'glass-cheers(alcohol,bar,beverage,celebration,champagne,clink,drink,holiday,new year\'s eve,party,toast)'),
            array('fas fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('far fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('fal fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('fas fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('far fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('fal fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('fas fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('far fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fal fa-glasses' => 'glasses(hipster,nerd,reading,sight,spectacles,vision)'),
            array('fas fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('far fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('fal fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('fas fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('far fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fal fa-graduation-cap' => 'graduation-cap(ceremony,college,graduate,learning,school,student)'),
            array('fas fa-guitar' => 'guitar(acoustic,instrument,music,rock,rock and roll,song,strings)'),
            array('far fa-guitar' => 'guitar(acoustic,instrument,music,rock,rock and roll,song,strings)'),
            array('fal fa-guitar' => 'guitar(acoustic,instrument,music,rock,rock and roll,song,strings)'),
            array('fas fa-hammer-war' => 'hammer-war(Dungeons & Dragons,cleric,d&d,dnd,dwarf,fantasy,melee attack,weapon)'),
            array('far fa-hammer-war' => 'hammer-war(Dungeons & Dragons,cleric,d&d,dnd,dwarf,fantasy,melee attack,weapon)'),
            array('fal fa-hammer-war' => 'hammer-war(Dungeons & Dragons,cleric,d&d,dnd,dwarf,fantasy,melee attack,weapon)'),
            array('fas fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('far fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('fal fa-hat-santa' => 'hat-santa(accessory,christmas,claus,clothing,head,holiday,santa,xmas)'),
            array('fas fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('far fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('fal fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('fas fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('far fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fal fa-hat-wizard' => 'hat-wizard(Dungeons & Dragons,accessory,buckle,clothing,d&d,dnd,fantasy,halloween,head,holiday,mage,magic,pointy,witch)'),
            array('fas fa-hdd' => 'hdd(cpu,hard drive,harddrive,machine,save,storage)'),
            array('far fa-hdd' => 'hdd(cpu,hard drive,harddrive,machine,save,storage)'),
            array('fal fa-hdd' => 'hdd(cpu,hard drive,harddrive,machine,save,storage)'),
            array('fas fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('far fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fal fa-headphones' => 'headphones(audio,listen,music,sound,speaker)'),
            array('fas fa-headphones-alt' => 'headphones-alt(audio,listen,music,sound,speaker)'),
            array('far fa-headphones-alt' => 'headphones-alt(audio,listen,music,sound,speaker)'),
            array('fal fa-headphones-alt' => 'headphones-alt(audio,listen,music,sound,speaker)'),
            array('fas fa-headset' => 'headset(audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)'),
            array('far fa-headset' => 'headset(audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)'),
            array('fal fa-headset' => 'headset(audio,gamer,gaming,listen,live chat,microphone,shot caller,sound,support,telemarketer)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-heart-broken' => 'heart-broken(breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)'),
            array('far fa-heart-broken' => 'heart-broken(breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)'),
            array('fal fa-heart-broken' => 'heart-broken(breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)'),
            array('fas fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('far fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('fal fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('fas fa-helmet-battle' => 'helmet-battle(Dungeons & Dragons,armor,clothing,d&d,dnd,fantasy,hat,knight,paladin)'),
            array('far fa-helmet-battle' => 'helmet-battle(Dungeons & Dragons,armor,clothing,d&d,dnd,fantasy,hat,knight,paladin)'),
            array('fal fa-helmet-battle' => 'helmet-battle(Dungeons & Dragons,armor,clothing,d&d,dnd,fantasy,hat,knight,paladin)'),
            array('fas fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('far fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fal fa-highlighter' => 'highlighter(edit,marker,sharpie,update,write)'),
            array('fas fa-holly-berry' => 'holly-berry(catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)'),
            array('far fa-holly-berry' => 'holly-berry(catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)'),
            array('fal fa-holly-berry' => 'holly-berry(catwoman,christmas,decoration,flora,halle,holiday,ororo munroe,plant,storm,xmas)'),
            array('fas fa-home' => 'home(abode,building,house,main)'),
            array('far fa-home' => 'home(abode,building,house,main)'),
            array('fal fa-home' => 'home(abode,building,house,main)'),
            array('fas fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('far fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('fal fa-hood-cloak' => 'hood-cloak(Dungeons & Dragons,clothing,d&d,dnd,fantasy,hat,rogue,stealth)'),
            array('fas fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('far fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fal fa-hospital' => 'hospital(building,emergency room,medical center)'),
            array('fas fa-hourglass' => 'hourglass(hour,minute,sand,stopwatch,time)'),
            array('far fa-hourglass' => 'hourglass(hour,minute,sand,stopwatch,time)'),
            array('fal fa-hourglass' => 'hourglass(hour,minute,sand,stopwatch,time)'),
            array('fas fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('far fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fal fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fas fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('far fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('fal fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('fas fa-image' => 'image(album,landscape,photo,picture)'),
            array('far fa-image' => 'image(album,landscape,photo,picture)'),
            array('fal fa-image' => 'image(album,landscape,photo,picture)'),
            array('fas fa-images' => 'images(album,landscape,photo,picture)'),
            array('far fa-images' => 'images(album,landscape,photo,picture)'),
            array('fal fa-images' => 'images(album,landscape,photo,picture)'),
            array('fas fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry' => 'industry(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('far fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fal fa-industry-alt' => 'industry-alt(building,factory,industrial,manufacturing,mill,warehouse)'),
            array('fas fa-jack-o-lantern' => 'jack-o-lantern(carve,face,halloween,lantern,pumpkin,smile)'),
            array('far fa-jack-o-lantern' => 'jack-o-lantern(carve,face,halloween,lantern,pumpkin,smile)'),
            array('fal fa-jack-o-lantern' => 'jack-o-lantern(carve,face,halloween,lantern,pumpkin,smile)'),
            array('fas fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('far fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fal fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fas fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('far fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fal fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fas fa-laptop' => 'laptop(computer,cpu,dell,demo,device,mac,macbook,machine,pc)'),
            array('far fa-laptop' => 'laptop(computer,cpu,dell,demo,device,mac,macbook,machine,pc)'),
            array('fal fa-laptop' => 'laptop(computer,cpu,dell,demo,device,mac,macbook,machine,pc)'),
            array('fas fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('far fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fal fa-leaf' => 'leaf(eco,flora,nature,plant,vegan)'),
            array('fas fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('far fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fal fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fas fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('far fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('fal fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('fas fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('far fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fal fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fas fa-lights-holiday' => 'lights-holiday(bulb,christmas,decoration,holiday,string,xmas)'),
            array('far fa-lights-holiday' => 'lights-holiday(bulb,christmas,decoration,holiday,string,xmas)'),
            array('fal fa-lights-holiday' => 'lights-holiday(bulb,christmas,decoration,holiday,string,xmas)'),
            array('fas fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('fas fa-mace' => 'mace(Dungeons & Dragons,d&d,dnd,fantasy,melee attack,weapon,windu)'),
            array('far fa-mace' => 'mace(Dungeons & Dragons,d&d,dnd,fantasy,melee attack,weapon,windu)'),
            array('fal fa-mace' => 'mace(Dungeons & Dragons,d&d,dnd,fantasy,melee attack,weapon,windu)'),
            array('fas fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('far fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('fal fa-magic' => 'magic(autocomplete,automatic,mage,magic,spell,wand,witch,wizard)'),
            array('fas fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('far fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('fal fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('fas fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('far fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('fal fa-mandolin' => 'mandolin(Dungeons & Dragons,bard,d&d,dnd,fantasy,guitar,instrument,lute,music,song,strings)'),
            array('fas fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-pin' => 'map-pin(address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)'),
            array('far fa-map-pin' => 'map-pin(address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)'),
            array('fal fa-map-pin' => 'map-pin(address,agree,coordinates,destination,gps,localize,location,map,marker,navigation,pin,place,position,travel)'),
            array('fas fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('far fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('fal fa-map-signs' => 'map-signs(directions,directory,map,signage,wayfinding)'),
            array('fas fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('far fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fal fa-marker' => 'marker(design,edit,sharpie,update,write)'),
            array('fas fa-medal' => 'medal(award,ribbon,star,trophy)'),
            array('far fa-medal' => 'medal(award,ribbon,star,trophy)'),
            array('fal fa-medal' => 'medal(award,ribbon,star,trophy)'),
            array('fas fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('far fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('fal fa-medkit' => 'medkit(first aid,firstaid,health,help,support)'),
            array('fas fa-memory' => 'memory(DIMM,RAM,hardware,storage,technology)'),
            array('far fa-memory' => 'memory(DIMM,RAM,hardware,storage,technology)'),
            array('fal fa-memory' => 'memory(DIMM,RAM,hardware,storage,technology)'),
            array('fas fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('far fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('fal fa-microchip' => 'microchip(cpu,hardware,processor,technology)'),
            array('fas fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('far fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fal fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fas fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('far fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fal fa-mobile' => 'mobile(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fas fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('far fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fal fa-mobile-alt' => 'mobile-alt(apple,call,cell phone,cellphone,device,iphone,number,screen,telephone)'),
            array('fas fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('far fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fal fa-mobile-android' => 'mobile-android(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fas fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('far fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fal fa-mobile-android-alt' => 'mobile-android-alt(android,call,cell phone,cellphone,device,number,screen,telephone,text)'),
            array('fas fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill' => 'money-bill(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('far fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fal fa-money-bill-alt' => 'money-bill-alt(buy,cash,checkout,money,payment,price,purchase)'),
            array('fas fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fas fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fas fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('far fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('fal fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('fas fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('far fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fal fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fas fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('far fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('fal fa-mug-hot' => 'mug-hot(caliente,cocoa,coffee,cup,drink,holiday,hot chocolate,steam,tea,warmth)'),
            array('fas fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('far fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('fal fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('fas fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('far fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('fal fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('fas fa-ornament' => 'ornament(christmas,decoration,holiday,xmas)'),
            array('far fa-ornament' => 'ornament(christmas,decoration,holiday,xmas)'),
            array('fal fa-ornament' => 'ornament(christmas,decoration,holiday,xmas)'),
            array('fas fa-paint-brush' => 'paint-brush(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('far fa-paint-brush' => 'paint-brush(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fal fa-paint-brush' => 'paint-brush(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fas fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('far fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fal fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fas fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('far fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fal fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fas fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('far fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fal fa-paste' => 'paste(clipboard,copy,document,paper)'),
            array('fas fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('far fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('fal fa-paw' => 'paw(animal,cat,dog,pet,print)'),
            array('fas fa-pen' => 'pen(design,edit,update,write)'),
            array('far fa-pen' => 'pen(design,edit,update,write)'),
            array('fal fa-pen' => 'pen(design,edit,update,write)'),
            array('fas fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('far fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fal fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fas fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('far fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-fancy' => 'pen-fancy(design,edit,fountain pen,update,write)'),
            array('fas fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('far fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fal fa-pen-nib' => 'pen-nib(design,edit,fountain pen,update,write)'),
            array('fas fa-pencil' => 'pencil(design,edit,update,write)'),
            array('far fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fal fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fas fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('far fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fal fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fas fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fas fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('far fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fal fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fas fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('far fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('fal fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('fas fa-plug' => 'plug(connect,electric,online,power)'),
            array('far fa-plug' => 'plug(connect,electric,online,power)'),
            array('fal fa-plug' => 'plug(connect,electric,online,power)'),
            array('fas fa-print' => 'print(business,copy,document,office,paper)'),
            array('far fa-print' => 'print(business,copy,document,office,paper)'),
            array('fal fa-print' => 'print(business,copy,document,office,paper)'),
            array('fas fa-puzzle-piece' => 'puzzle-piece(add-on,addon,game,section)'),
            array('far fa-puzzle-piece' => 'puzzle-piece(add-on,addon,game,section)'),
            array('fal fa-puzzle-piece' => 'puzzle-piece(add-on,addon,game,section)'),
            array('fas fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('far fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('fal fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('fas fa-road' => 'road(highway,map,pavement,route,street,travel)'),
            array('far fa-road' => 'road(highway,map,pavement,route,street,travel)'),
            array('fal fa-road' => 'road(highway,map,pavement,route,street,travel)'),
            array('fas fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('far fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fal fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fas fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('far fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('fal fa-ruler-combined' => 'ruler-combined(design,draft,length,measure,planning)'),
            array('fas fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('far fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('fal fa-ruler-horizontal' => 'ruler-horizontal(design,draft,length,measure,planning)'),
            array('fas fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('far fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('fal fa-ruler-vertical' => 'ruler-vertical(design,draft,length,measure,planning)'),
            array('fas fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('far fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fal fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fas fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('far fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('fal fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('fas fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('far fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('fal fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('fas fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('far fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fal fa-save' => 'save(disk,download,floppy,floppy-o)'),
            array('fas fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('far fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('fal fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('fas fa-school' => 'school(building,education,learn,student,teacher)'),
            array('far fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fal fa-school' => 'school(building,education,learn,student,teacher)'),
            array('fas fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('far fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fal fa-screwdriver' => 'screwdriver(admin,fix,mechanic,repair,settings,tool)'),
            array('fas fa-scroll' => 'scroll(Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)'),
            array('far fa-scroll' => 'scroll(Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)'),
            array('fal fa-scroll' => 'scroll(Dungeons & Dragons,announcement,d&d,dnd,fantasy,paper,script)'),
            array('fas fa-scroll-old' => 'scroll-old(Dungeons & Dragons,ancient,announcement,d&d,dnd,fantasy,paper,relic,script,worn)'),
            array('far fa-scroll-old' => 'scroll-old(Dungeons & Dragons,ancient,announcement,d&d,dnd,fantasy,paper,relic,script,worn)'),
            array('fal fa-scroll-old' => 'scroll-old(Dungeons & Dragons,ancient,announcement,d&d,dnd,fantasy,paper,relic,script,worn)'),
            array('fas fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('far fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('fal fa-scythe' => 'scythe(Dungeons & Dragons,blade,d&d,death,dnd,fantasy,grim reaper,weapon)'),
            array('fas fa-sd-card' => 'sd-card(image,memory,photo,save)'),
            array('far fa-sd-card' => 'sd-card(image,memory,photo,save)'),
            array('fal fa-sd-card' => 'sd-card(image,memory,photo,save)'),
            array('fas fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('far fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fal fa-search' => 'search(bigger,enlarge,find,magnify,preview,zoom)'),
            array('fas fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('far fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fal fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fas fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('far fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fal fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fas fa-shield-cross' => 'shield-cross(Dungeons & Dragons,block,crusader,d&d,defend,dnd,fantasy,security,templar)'),
            array('far fa-shield-cross' => 'shield-cross(Dungeons & Dragons,block,crusader,d&d,defend,dnd,fantasy,security,templar)'),
            array('fal fa-shield-cross' => 'shield-cross(Dungeons & Dragons,block,crusader,d&d,defend,dnd,fantasy,security,templar)'),
            array('fas fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shovel-snow' => 'shovel-snow(construction,dig,excavate,plow,tool,trench)'),
            array('far fa-shovel-snow' => 'shovel-snow(construction,dig,excavate,plow,tool,trench)'),
            array('fal fa-shovel-snow' => 'shovel-snow(construction,dig,excavate,plow,tool,trench)'),
            array('fas fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('far fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fal fa-shower' => 'shower(bath,clean,faucet,water)'),
            array('fas fa-sim-card' => 'sim-card(hard drive,hardware,portable,storage,technology,tiny)'),
            array('far fa-sim-card' => 'sim-card(hard drive,hardware,portable,storage,technology,tiny)'),
            array('fal fa-sim-card' => 'sim-card(hard drive,hardware,portable,storage,technology,tiny)'),
            array('fas fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('far fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fal fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fas fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('far fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('fal fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('fas fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('far fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fal fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fas fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('far fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fal fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fas fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('far fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fal fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fas fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('far fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('fal fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('fas fa-staff' => 'staff(Dungeons & Dragons,d&d,dnd,fantasy,mage,stick,weapon)'),
            array('far fa-staff' => 'staff(Dungeons & Dragons,d&d,dnd,fantasy,mage,stick,weapon)'),
            array('fal fa-staff' => 'staff(Dungeons & Dragons,d&d,dnd,fantasy,mage,stick,weapon)'),
            array('fas fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('far fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fal fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fas fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('far fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('fal fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('fas fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('far fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('fal fa-stocking' => 'stocking(christmas,clothing,decoration,gift,holiday,present,sock,tradition,xmas)'),
            array('fas fa-stopwatch' => 'stopwatch(clock,reminder,time)'),
            array('far fa-stopwatch' => 'stopwatch(clock,reminder,time)'),
            array('fal fa-stopwatch' => 'stopwatch(clock,reminder,time)'),
            array('fas fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('far fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('fal fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('fas fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('far fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('fal fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('fas fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('far fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fal fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fas fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('far fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fal fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fas fa-sword' => 'sword(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('far fa-sword' => 'sword(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fal fa-sword' => 'sword(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fas fa-swords' => 'swords(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('far fa-swords' => 'swords(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fal fa-swords' => 'swords(Dungeons & Dragons,blade,d&d,dnd,fantasy,fight,sharp,weapon)'),
            array('fas fa-tablet' => 'tablet(apple,device,ipad,kindle,screen)'),
            array('far fa-tablet' => 'tablet(apple,device,ipad,kindle,screen)'),
            array('fal fa-tablet' => 'tablet(apple,device,ipad,kindle,screen)'),
            array('fas fa-tablet-alt' => 'tablet-alt(apple,device,ipad,kindle,screen)'),
            array('far fa-tablet-alt' => 'tablet-alt(apple,device,ipad,kindle,screen)'),
            array('fal fa-tablet-alt' => 'tablet-alt(apple,device,ipad,kindle,screen)'),
            array('fas fa-tablet-android' => 'tablet-android(device,kindle,screen)'),
            array('far fa-tablet-android' => 'tablet-android(device,kindle,screen)'),
            array('fal fa-tablet-android' => 'tablet-android(device,kindle,screen)'),
            array('fas fa-tablet-android-alt' => 'tablet-android-alt(device,kindle,screen)'),
            array('far fa-tablet-android-alt' => 'tablet-android-alt(device,kindle,screen)'),
            array('fal fa-tablet-android-alt' => 'tablet-android-alt(device,kindle,screen)'),
            array('fas fa-tachometer' => 'tachometer(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer' => 'tachometer(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer' => 'tachometer(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tachometer-alt' => 'tachometer-alt(dashboard,fast,odometer,speed,speedometer)'),
            array('far fa-tachometer-alt' => 'tachometer-alt(dashboard,fast,odometer,speed,speedometer)'),
            array('fal fa-tachometer-alt' => 'tachometer-alt(dashboard,fast,odometer,speed,speedometer)'),
            array('fas fa-tag' => 'tag(discount,label,price,shopping)'),
            array('far fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fal fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fas fa-tags' => 'tags(discount,label,price,shopping)'),
            array('far fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fal fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fas fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('far fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fal fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fas fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('far fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fal fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fas fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('far fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('fal fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('fas fa-ticket-alt' => 'ticket-alt(movie,pass,support,ticket)'),
            array('far fa-ticket-alt' => 'ticket-alt(movie,pass,support,ticket)'),
            array('fal fa-ticket-alt' => 'ticket-alt(movie,pass,support,ticket)'),
            array('fas fa-toilet' => 'toilet(bathroom,flush,john,loo,pee,plumbing,poop,porcelain,potty,restroom,throne,washroom,waste,wc)'),
            array('far fa-toilet' => 'toilet(bathroom,flush,john,loo,pee,plumbing,poop,porcelain,potty,restroom,throne,washroom,waste,wc)'),
            array('fal fa-toilet' => 'toilet(bathroom,flush,john,loo,pee,plumbing,poop,porcelain,potty,restroom,throne,washroom,waste,wc)'),
            array('fas fa-toolbox' => 'toolbox(admin,container,fix,repair,settings,tools)'),
            array('far fa-toolbox' => 'toolbox(admin,container,fix,repair,settings,tools)'),
            array('fal fa-toolbox' => 'toolbox(admin,container,fix,repair,settings,tools)'),
            array('fas fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('far fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fal fa-tools' => 'tools(admin,fix,repair,screwdriver,settings,tools,wrench)'),
            array('fas fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('far fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('fal fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('fas fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('far fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fal fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fas fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('far fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('fal fa-trash' => 'trash(delete,garbage,hide,remove)'),
            array('fas fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('far fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('fal fa-trash-alt' => 'trash-alt(delete,garbage,hide,remove,trash-o)'),
            array('fas fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('far fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fal fa-treasure-chest' => 'treasure-chest(Dungeons & Dragons,booty,d&d,dnd,fantasy,gold,hidden,loot,reward,trap)'),
            array('fas fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree' => 'tree(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-tree-christmas' => 'tree-christmas(christmas,decorated,decorations,flora,holiday,lights,plant,star,xmas)'),
            array('far fa-tree-christmas' => 'tree-christmas(christmas,decorated,decorations,flora,holiday,lights,plant,star,xmas)'),
            array('fal fa-tree-christmas' => 'tree-christmas(christmas,decorated,decorations,flora,holiday,lights,plant,star,xmas)'),
            array('fas fa-tree-decorated' => 'tree-decorated(christmas,decorations,flora,holiday,lights,plant,xmas)'),
            array('far fa-tree-decorated' => 'tree-decorated(christmas,decorations,flora,holiday,lights,plant,xmas)'),
            array('fal fa-tree-decorated' => 'tree-decorated(christmas,decorations,flora,holiday,lights,plant,xmas)'),
            array('fas fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('far fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fal fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fas fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('far fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('fal fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('fas fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fas fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('far fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('fal fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('fas fa-tv' => 'tv(computer,display,monitor,television)'),
            array('far fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fal fa-tv' => 'tv(computer,display,monitor,television)'),
            array('fas fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('far fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('fal fa-tv-retro' => 'tv-retro(computer,display,monitor,television)'),
            array('fas fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('far fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('fal fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('fas fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('far fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('fal fa-university' => 'university(bank,building,college,higher education - students,institution)'),
            array('fas fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('far fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('fal fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('fas fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('far fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('fal fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('fas fa-utensil-fork' => 'utensil-fork(cutlery,dining,food,fork,silverware)'),
            array('far fa-utensil-fork' => 'utensil-fork(cutlery,dining,food,fork,silverware)'),
            array('fal fa-utensil-fork' => 'utensil-fork(cutlery,dining,food,fork,silverware)'),
            array('fas fa-utensil-knife' => 'utensil-knife(cut,cutlery,dining,silverware,tool)'),
            array('far fa-utensil-knife' => 'utensil-knife(cut,cutlery,dining,silverware,tool)'),
            array('fal fa-utensil-knife' => 'utensil-knife(cut,cutlery,dining,silverware,tool)'),
            array('fas fa-utensil-spoon' => 'utensil-spoon(cutlery,dining,scoop,silverware,spoon)'),
            array('far fa-utensil-spoon' => 'utensil-spoon(cutlery,dining,scoop,silverware,spoon)'),
            array('fal fa-utensil-spoon' => 'utensil-spoon(cutlery,dining,scoop,silverware,spoon)'),
            array('fas fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('far fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fal fa-utensils' => 'utensils(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fas fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('far fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fal fa-utensils-alt' => 'utensils-alt(cutlery,dining,dinner,eat,food,fork,knife,restaurant)'),
            array('fas fa-wallet' => 'wallet(billfold,cash,currency,money)'),
            array('far fa-wallet' => 'wallet(billfold,cash,currency,money)'),
            array('fal fa-wallet' => 'wallet(billfold,cash,currency,money)'),
            array('fas fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('far fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('fal fa-wand' => 'wand(Dungeons & Dragons,d&d,dnd,fantasy,halloween,holiday,magic,weapon)'),
            array('fas fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('far fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('fal fa-wand-magic' => 'wand-magic(autocomplete,automatic,fantasy,halloween,holiday,magic,weapon,witch,wizard)'),
            array('fas fa-watch' => 'watch(alert,clock,time,wristwatch)'),
            array('far fa-watch' => 'watch(alert,clock,time,wristwatch)'),
            array('fal fa-watch' => 'watch(alert,clock,time,wristwatch)'),
            array('fas fa-weight' => 'weight(health,measurement,scale,weight)'),
            array('far fa-weight' => 'weight(health,measurement,scale,weight)'),
            array('fal fa-weight' => 'weight(health,measurement,scale,weight)'),
            array('fas fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('far fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fal fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fas fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('far fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fal fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fas fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('far fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('fal fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('fas fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('far fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
            array('fal fa-wrench' => 'wrench(construction,fix,mechanic,plumbing,settings,spanner,tool,update)'),
        ),
        'Payments & Shopping' => array(
            array('fab fa-alipay' => 'alipay'),
            array('fab fa-amazon-pay' => 'amazon-pay'),
            array('fab fa-apple-pay' => 'apple-pay'),
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('far fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fal fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fab fa-bitcoin' => 'bitcoin'),
            array('fas fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('far fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fal fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fab fa-btc' => 'btc'),
            array('fas fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('far fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fal fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fas fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera-alt' => 'camera-alt(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera-retro' => 'camera-retro(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('far fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fal fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fas fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('far fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('fal fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('fab fa-cc-amazon-pay' => 'cc-amazon-pay'),
            array('fab fa-cc-amex' => 'cc-amex(amex)'),
            array('fab fa-cc-apple-pay' => 'cc-apple-pay'),
            array('fab fa-cc-diners-club' => 'cc-diners-club'),
            array('fab fa-cc-discover' => 'cc-discover'),
            array('fab fa-cc-jcb' => 'cc-jcb'),
            array('fab fa-cc-mastercard' => 'cc-mastercard'),
            array('fab fa-cc-paypal' => 'cc-paypal'),
            array('fab fa-cc-stripe' => 'cc-stripe'),
            array('fab fa-cc-visa' => 'cc-visa'),
            array('fas fa-certificate' => 'certificate(badge,star,verified)'),
            array('far fa-certificate' => 'certificate(badge,star,verified)'),
            array('fal fa-certificate' => 'certificate(badge,star,verified)'),
            array('fas fa-credit-card' => 'credit-card(buy,checkout,credit-card-alt,debit,money,payment,purchase)'),
            array('far fa-credit-card' => 'credit-card(buy,checkout,credit-card-alt,debit,money,payment,purchase)'),
            array('fal fa-credit-card' => 'credit-card(buy,checkout,credit-card-alt,debit,money,payment,purchase)'),
            array('fas fa-credit-card-blank' => 'credit-card-blank(buy,checkout,debit,money,payment,purchase)'),
            array('far fa-credit-card-blank' => 'credit-card-blank(buy,checkout,debit,money,payment,purchase)'),
            array('fal fa-credit-card-blank' => 'credit-card-blank(buy,checkout,debit,money,payment,purchase)'),
            array('fas fa-credit-card-front' => 'credit-card-front(buy,checkout,chip,debit,money,payment,purchase)'),
            array('far fa-credit-card-front' => 'credit-card-front(buy,checkout,chip,debit,money,payment,purchase)'),
            array('fal fa-credit-card-front' => 'credit-card-front(buy,checkout,chip,debit,money,payment,purchase)'),
            array('fab fa-ethereum' => 'ethereum'),
            array('fas fa-gem' => 'gem(diamond,jewelry,sapphire,stone,treasure)'),
            array('far fa-gem' => 'gem(diamond,jewelry,sapphire,stone,treasure)'),
            array('fal fa-gem' => 'gem(diamond,jewelry,sapphire,stone,treasure)'),
            array('fas fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fab fa-google-wallet' => 'google-wallet'),
            array('fas fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('far fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fal fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('far fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fal fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fas fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check' => 'money-check(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fas fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('far fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fal fa-money-check-alt' => 'money-check-alt(bank check,buy,checkout,cheque,money,payment,price,purchase)'),
            array('fab fa-paypal' => 'paypal'),
            array('fas fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('far fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fal fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fas fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('far fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fal fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fas fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('far fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('fal fa-star-exclamation' => 'star-exclamation(achievement,alert,award,favorite,night,rating,score)'),
            array('fab fa-stripe' => 'stripe'),
            array('fab fa-stripe-s' => 'stripe-s'),
            array('fas fa-tag' => 'tag(discount,label,price,shopping)'),
            array('far fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fal fa-tag' => 'tag(discount,label,price,shopping)'),
            array('fas fa-tags' => 'tags(discount,label,price,shopping)'),
            array('far fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fal fa-tags' => 'tags(discount,label,price,shopping)'),
            array('fas fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('far fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fal fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fas fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('far fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fal fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fas fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('far fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fal fa-trophy' => 'trophy(achievement,award,cup,game,winner)'),
            array('fas fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('far fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
            array('fal fa-trophy-alt' => 'trophy-alt(achievement,award,cup,game,star,winner)'),
        ),
        'Pharmacy' => array(
            array('fas fa-band-aid' => 'band-aid(bandage,boo boo,first aid,ouch)'),
            array('far fa-band-aid' => 'band-aid(bandage,boo boo,first aid,ouch)'),
            array('fal fa-band-aid' => 'band-aid(bandage,boo boo,first aid,ouch)'),
            array('fas fa-book-medical' => 'book-medical(diary,documentation,health,history,journal,library,read,record)'),
            array('far fa-book-medical' => 'book-medical(diary,documentation,health,history,journal,library,read,record)'),
            array('fal fa-book-medical' => 'book-medical(diary,documentation,health,history,journal,library,read,record)'),
            array('fas fa-cannabis' => 'cannabis(bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)'),
            array('far fa-cannabis' => 'cannabis(bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)'),
            array('fal fa-cannabis' => 'cannabis(bud,chronic,drugs,endica,endo,ganja,marijuana,mary jane,pot,reefer,sativa,spliff,weed,whacky-tabacky)'),
            array('fas fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('far fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('fal fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('fas fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('far fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fal fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fas fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('far fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fal fa-clinic-medical' => 'clinic-medical(doctor,general practitioner,hospital,infirmary,medicine,office,outpatient)'),
            array('fas fa-clipboard-prescription' => 'clipboard-prescription(copy,history,medical,notes,paste,record)'),
            array('far fa-clipboard-prescription' => 'clipboard-prescription(copy,history,medical,notes,paste,record)'),
            array('fal fa-clipboard-prescription' => 'clipboard-prescription(copy,history,medical,notes,paste,record)'),
            array('fas fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('far fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('fal fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('fas fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('far fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fal fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fas fa-file-medical' => 'file-medical(document,health,history,prescription,record)'),
            array('far fa-file-medical' => 'file-medical(document,health,history,prescription,record)'),
            array('fal fa-file-medical' => 'file-medical(document,health,history,prescription,record)'),
            array('fas fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('far fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('fal fa-file-prescription' => 'file-prescription(document,drugs,medical,medicine,rx)'),
            array('fas fa-files-medical' => 'files-medical(document,health,history,prescription,record)'),
            array('far fa-files-medical' => 'files-medical(document,health,history,prescription,record)'),
            array('fal fa-files-medical' => 'files-medical(document,health,history,prescription,record)'),
            array('fas fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('far fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('fal fa-first-aid' => 'first-aid(emergency,emt,health,medical,rescue)'),
            array('fas fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('far fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fal fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fas fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('far fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fal fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fas fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('far fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('fal fa-history' => 'history(Rewind,clock,reverse,time,time machine)'),
            array('fas fa-inhaler' => 'inhaler(asthma,cough,lungs,nebulizer,vaporizer)'),
            array('far fa-inhaler' => 'inhaler(asthma,cough,lungs,nebulizer,vaporizer)'),
            array('fal fa-inhaler' => 'inhaler(asthma,cough,lungs,nebulizer,vaporizer)'),
            array('fas fa-joint' => 'joint(blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)'),
            array('far fa-joint' => 'joint(blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)'),
            array('fal fa-joint' => 'joint(blunt,cannabis,doobie,drugs,marijuana,roach,smoke,smoking,spliff)'),
            array('fas fa-laptop-medical' => 'laptop-medical(computer,device,ehr,electronic health records,history)'),
            array('far fa-laptop-medical' => 'laptop-medical(computer,device,ehr,electronic health records,history)'),
            array('fal fa-laptop-medical' => 'laptop-medical(computer,device,ehr,electronic health records,history)'),
            array('fas fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('far fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('fal fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('fas fa-notes-medical' => 'notes-medical(clipboard,doctor,ehr,health,history,records)'),
            array('far fa-notes-medical' => 'notes-medical(clipboard,doctor,ehr,health,history,records)'),
            array('fal fa-notes-medical' => 'notes-medical(clipboard,doctor,ehr,health,history,records)'),
            array('fas fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('far fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('fal fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('fas fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription' => 'prescription(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-prescription-bottle-alt' => 'prescription-bottle-alt(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription-bottle-alt' => 'prescription-bottle-alt(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription-bottle-alt' => 'prescription-bottle-alt(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('far fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fal fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fas fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('far fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fal fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fas fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('far fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('fal fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('fas fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('far fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('fal fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('fas fa-thermometer' => 'thermometer(mercury,status,temperature)'),
            array('far fa-thermometer' => 'thermometer(mercury,status,temperature)'),
            array('fal fa-thermometer' => 'thermometer(mercury,status,temperature)'),
            array('fas fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('far fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('fal fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('fas fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
            array('far fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
            array('fal fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
        ),
        'Political' => array(
            array('fas fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('far fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fal fa-award' => 'award(honor,praise,prize,recognition,ribbon,trophy)'),
            array('fas fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('far fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fal fa-balance-scale' => 'balance-scale(balanced,justice,legal,measure,weight)'),
            array('fas fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-left' => 'balance-scale-left(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('far fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fal fa-balance-scale-right' => 'balance-scale-right(justice,legal,measure,unbalanced,weight)'),
            array('fas fa-ballot' => 'ballot(checklist,choice,election,vote,voting)'),
            array('far fa-ballot' => 'ballot(checklist,choice,election,vote,voting)'),
            array('fal fa-ballot' => 'ballot(checklist,choice,election,vote,voting)'),
            array('fas fa-ballot-check' => 'ballot-check(checklist,choice,completed,done,election,finished,select,success,tick,vote,voting)'),
            array('far fa-ballot-check' => 'ballot-check(checklist,choice,completed,done,election,finished,select,success,tick,vote,voting)'),
            array('fal fa-ballot-check' => 'ballot-check(checklist,choice,completed,done,election,finished,select,success,tick,vote,voting)'),
            array('fas fa-booth-curtain' => 'booth-curtain(changing room,election,vote,voting,voting booth)'),
            array('far fa-booth-curtain' => 'booth-curtain(changing room,election,vote,voting,voting booth)'),
            array('fal fa-booth-curtain' => 'booth-curtain(changing room,election,vote,voting,voting booth)'),
            array('fas fa-box-ballot' => 'box-ballot(election,politics,vote,voting)'),
            array('far fa-box-ballot' => 'box-ballot(election,politics,vote,voting)'),
            array('fal fa-box-ballot' => 'box-ballot(election,politics,vote,voting)'),
            array('fas fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('far fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fal fa-bullhorn' => 'bullhorn(announcement,broadcast,louder,megaphone,share)'),
            array('fas fa-calendar-star' => 'calendar-star(calendar,date,event,favorite,important,schedule,time,when)'),
            array('far fa-calendar-star' => 'calendar-star(calendar,date,event,favorite,important,schedule,time,when)'),
            array('fal fa-calendar-star' => 'calendar-star(calendar,date,event,favorite,important,schedule,time,when)'),
            array('fas fa-check-double' => 'check-double(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)'),
            array('far fa-check-double' => 'check-double(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)'),
            array('fal fa-check-double' => 'check-double(accept,agree,checkmark,confirm,correct,done,notice,notification,notify,ok,select,success,tick,todo)'),
            array('fas fa-clipboard-list-check' => 'clipboard-list-check(checklist,completed,done,election,finished,intinerary,ol,schedule,tick,todo,ul,vote,voting)'),
            array('far fa-clipboard-list-check' => 'clipboard-list-check(checklist,completed,done,election,finished,intinerary,ol,schedule,tick,todo,ul,vote,voting)'),
            array('fal fa-clipboard-list-check' => 'clipboard-list-check(checklist,completed,done,election,finished,intinerary,ol,schedule,tick,todo,ul,vote,voting)'),
            array('fas fa-democrat' => 'democrat(american,democratic party,donkey,election,left,left-wing,liberal,politics,usa)'),
            array('far fa-democrat' => 'democrat(american,democratic party,donkey,election,left,left-wing,liberal,politics,usa)'),
            array('fal fa-democrat' => 'democrat(american,democratic party,donkey,election,left,left-wing,liberal,politics,usa)'),
            array('fas fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('far fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('fal fa-donate' => 'donate(contribute,generosity,gift,give)'),
            array('fas fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('far fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fal fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fas fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('far fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('fal fa-fist-raised' => 'fist-raised(Dungeons & Dragons,d&d,dnd,fantasy,hand,ki,monk,resist,strength,unarmed combat)'),
            array('fas fa-flag-alt' => 'flag-alt(country,notice,notification,notify,pole,report,symbol)'),
            array('far fa-flag-alt' => 'flag-alt(country,notice,notification,notify,pole,report,symbol)'),
            array('fal fa-flag-alt' => 'flag-alt(country,notice,notification,notify,pole,report,symbol)'),
            array('fas fa-flag-usa' => 'flag-usa(betsy ross,country,old glory,stars,stripes,symbol)'),
            array('far fa-flag-usa' => 'flag-usa(betsy ross,country,old glory,stars,stripes,symbol)'),
            array('fal fa-flag-usa' => 'flag-usa(betsy ross,country,old glory,stars,stripes,symbol)'),
            array('fas fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('far fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fal fa-handshake' => 'handshake(agreement,greeting,meeting,partnership)'),
            array('fas fa-landmark-alt' => 'landmark-alt(building,historic,memorable,monument,politics)'),
            array('far fa-landmark-alt' => 'landmark-alt(building,historic,memorable,monument,politics)'),
            array('fal fa-landmark-alt' => 'landmark-alt(building,historic,memorable,monument,politics)'),
            array('fas fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('far fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('fal fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('fas fa-person-sign' => 'person-sign(advocate,human,information,person,protest,protester,volunteer)'),
            array('far fa-person-sign' => 'person-sign(advocate,human,information,person,protest,protester,volunteer)'),
            array('fal fa-person-sign' => 'person-sign(advocate,human,information,person,protest,protester,volunteer)'),
            array('fas fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('far fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('fal fa-piggy-bank' => 'piggy-bank(bank,save,savings)'),
            array('fas fa-podium' => 'podium(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('far fa-podium' => 'podium(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('fal fa-podium' => 'podium(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('fas fa-podium-star' => 'podium-star(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('far fa-podium-star' => 'podium-star(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('fal fa-podium-star' => 'podium-star(debate,election,keynote,lecture,panel,politics,seminar,speak,speaker,speech,talk)'),
            array('fas fa-poll-people' => 'poll-people(candidates,election,people,person,results,survey,trend,vote,voting)'),
            array('far fa-poll-people' => 'poll-people(candidates,election,people,person,results,survey,trend,vote,voting)'),
            array('fal fa-poll-people' => 'poll-people(candidates,election,people,person,results,survey,trend,vote,voting)'),
            array('fas fa-republican' => 'republican(american,conservative,election,elephant,politics,republican party,right,right-wing,usa)'),
            array('far fa-republican' => 'republican(american,conservative,election,elephant,politics,republican party,right,right-wing,usa)'),
            array('fal fa-republican' => 'republican(american,conservative,election,elephant,politics,republican party,right,right-wing,usa)'),
            array('fas fa-tally' => 'tally(count,hash,numbers)'),
            array('far fa-tally' => 'tally(count,hash,numbers)'),
            array('fal fa-tally' => 'tally(count,hash,numbers)'),
            array('fas fa-vote-nay' => 'vote-nay(cast,election,negative,no,politics,reject,voting)'),
            array('far fa-vote-nay' => 'vote-nay(cast,election,negative,no,politics,reject,voting)'),
            array('fal fa-vote-nay' => 'vote-nay(cast,election,negative,no,politics,reject,voting)'),
            array('fas fa-vote-yea' => 'vote-yea(accept,cast,election,politics,positive,yes)'),
            array('far fa-vote-yea' => 'vote-yea(accept,cast,election,politics,positive,yes)'),
            array('fal fa-vote-yea' => 'vote-yea(accept,cast,election,politics,positive,yes)'),
        ),
        'Religion' => array(
            array('fas fa-ankh' => 'ankh(amulet,copper,coptic christianity,copts,crux ansata,egypt,venus)'),
            array('far fa-ankh' => 'ankh(amulet,copper,coptic christianity,copts,crux ansata,egypt,venus)'),
            array('fal fa-ankh' => 'ankh(amulet,copper,coptic christianity,copts,crux ansata,egypt,venus)'),
            array('fas fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-bible' => 'bible(book,catholicism,christianity,god,holy)'),
            array('far fa-bible' => 'bible(book,catholicism,christianity,god,holy)'),
            array('fal fa-bible' => 'bible(book,catholicism,christianity,god,holy)'),
            array('fas fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('far fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('fal fa-church' => 'church(building,cathedral,chapel,community,religion)'),
            array('fas fa-cross' => 'cross(catholicism,christianity,church,jesus)'),
            array('far fa-cross' => 'cross(catholicism,christianity,church,jesus)'),
            array('fal fa-cross' => 'cross(catholicism,christianity,church,jesus)'),
            array('fas fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('far fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('fal fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('fas fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('far fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fal fa-dove' => 'dove(bird,fauna,flying,peace,war)'),
            array('fas fa-gopuram' => 'gopuram(building,entrance,hinduism,temple,tower)'),
            array('far fa-gopuram' => 'gopuram(building,entrance,hinduism,temple,tower)'),
            array('fal fa-gopuram' => 'gopuram(building,entrance,hinduism,temple,tower)'),
            array('fas fa-hamsa' => 'hamsa(amulet,christianity,islam,jewish,judaism,muslim,protection)'),
            array('far fa-hamsa' => 'hamsa(amulet,christianity,islam,jewish,judaism,muslim,protection)'),
            array('fal fa-hamsa' => 'hamsa(amulet,christianity,islam,jewish,judaism,muslim,protection)'),
            array('fas fa-hanukiah' => 'hanukiah(candle,hanukkah,jewish,judaism,light)'),
            array('far fa-hanukiah' => 'hanukiah(candle,hanukkah,jewish,judaism,light)'),
            array('fal fa-hanukiah' => 'hanukiah(candle,hanukkah,jewish,judaism,light)'),
            array('fas fa-haykal' => 'haykal(bahai,bahĂ¡\'Ă­,star)'),
            array('far fa-haykal' => 'haykal(bahai,bahĂ¡\'Ă­,star)'),
            array('fal fa-haykal' => 'haykal(bahai,bahĂ¡\'Ă­,star)'),
            array('fas fa-jedi' => 'jedi(crest,force,sith,skywalker,star wars,yoda)'),
            array('far fa-jedi' => 'jedi(crest,force,sith,skywalker,star wars,yoda)'),
            array('fal fa-jedi' => 'jedi(crest,force,sith,skywalker,star wars,yoda)'),
            array('fas fa-journal-whills' => 'journal-whills(book,force,jedi,sith,star wars,yoda)'),
            array('far fa-journal-whills' => 'journal-whills(book,force,jedi,sith,star wars,yoda)'),
            array('fal fa-journal-whills' => 'journal-whills(book,force,jedi,sith,star wars,yoda)'),
            array('fas fa-kaaba' => 'kaaba(building,cube,islam,muslim)'),
            array('far fa-kaaba' => 'kaaba(building,cube,islam,muslim)'),
            array('fal fa-kaaba' => 'kaaba(building,cube,islam,muslim)'),
            array('fas fa-khanda' => 'khanda(chakkar,sikh,sikhism,sword)'),
            array('far fa-khanda' => 'khanda(chakkar,sikh,sikhism,sword)'),
            array('fal fa-khanda' => 'khanda(chakkar,sikh,sikhism,sword)'),
            array('fas fa-menorah' => 'menorah(candle,hanukkah,jewish,judaism,light)'),
            array('far fa-menorah' => 'menorah(candle,hanukkah,jewish,judaism,light)'),
            array('fal fa-menorah' => 'menorah(candle,hanukkah,jewish,judaism,light)'),
            array('fas fa-mosque' => 'mosque(building,islam,landmark,muslim)'),
            array('far fa-mosque' => 'mosque(building,islam,landmark,muslim)'),
            array('fal fa-mosque' => 'mosque(building,islam,landmark,muslim)'),
            array('fas fa-om' => 'om(buddhism,hinduism,jainism,mantra)'),
            array('far fa-om' => 'om(buddhism,hinduism,jainism,mantra)'),
            array('fal fa-om' => 'om(buddhism,hinduism,jainism,mantra)'),
            array('fas fa-pastafarianism' => 'pastafarianism(agnosticism,atheism,flying spaghetti monster,fsm)'),
            array('far fa-pastafarianism' => 'pastafarianism(agnosticism,atheism,flying spaghetti monster,fsm)'),
            array('fal fa-pastafarianism' => 'pastafarianism(agnosticism,atheism,flying spaghetti monster,fsm)'),
            array('fas fa-peace' => 'peace(serenity,tranquility,truce,war)'),
            array('far fa-peace' => 'peace(serenity,tranquility,truce,war)'),
            array('fal fa-peace' => 'peace(serenity,tranquility,truce,war)'),
            array('fas fa-place-of-worship' => 'place-of-worship(building,church,holy,mosque,synagogue)'),
            array('far fa-place-of-worship' => 'place-of-worship(building,church,holy,mosque,synagogue)'),
            array('fal fa-place-of-worship' => 'place-of-worship(building,church,holy,mosque,synagogue)'),
            array('fas fa-pray' => 'pray(kneel,preach,religion,worship)'),
            array('far fa-pray' => 'pray(kneel,preach,religion,worship)'),
            array('fal fa-pray' => 'pray(kneel,preach,religion,worship)'),
            array('fas fa-praying-hands' => 'praying-hands(kneel,preach,religion,worship)'),
            array('far fa-praying-hands' => 'praying-hands(kneel,preach,religion,worship)'),
            array('fal fa-praying-hands' => 'praying-hands(kneel,preach,religion,worship)'),
            array('fas fa-quran' => 'quran(book,islam,muslim,religion)'),
            array('far fa-quran' => 'quran(book,islam,muslim,religion)'),
            array('fal fa-quran' => 'quran(book,islam,muslim,religion)'),
            array('fas fa-star-and-crescent' => 'star-and-crescent(islam,muslim,religion)'),
            array('far fa-star-and-crescent' => 'star-and-crescent(islam,muslim,religion)'),
            array('fal fa-star-and-crescent' => 'star-and-crescent(islam,muslim,religion)'),
            array('fas fa-star-of-david' => 'star-of-david(jewish,judaism,religion)'),
            array('far fa-star-of-david' => 'star-of-david(jewish,judaism,religion)'),
            array('fal fa-star-of-david' => 'star-of-david(jewish,judaism,religion)'),
            array('fas fa-synagogue' => 'synagogue(building,jewish,judaism,religion,star of david,temple)'),
            array('far fa-synagogue' => 'synagogue(building,jewish,judaism,religion,star of david,temple)'),
            array('fal fa-synagogue' => 'synagogue(building,jewish,judaism,religion,star of david,temple)'),
            array('fas fa-tanakh' => 'tanakh(book,jewish,judaism,religion)'),
            array('far fa-tanakh' => 'tanakh(book,jewish,judaism,religion)'),
            array('fal fa-tanakh' => 'tanakh(book,jewish,judaism,religion)'),
            array('fas fa-torah' => 'torah(book,jewish,judaism,religion)'),
            array('far fa-torah' => 'torah(book,jewish,judaism,religion)'),
            array('fal fa-torah' => 'torah(book,jewish,judaism,religion)'),
            array('fas fa-torii-gate' => 'torii-gate(building,shintoism)'),
            array('far fa-torii-gate' => 'torii-gate(building,shintoism)'),
            array('fal fa-torii-gate' => 'torii-gate(building,shintoism)'),
            array('fas fa-vihara' => 'vihara(buddhism,buddhist,building,monastery)'),
            array('far fa-vihara' => 'vihara(buddhism,buddhist,building,monastery)'),
            array('fal fa-vihara' => 'vihara(buddhism,buddhist,building,monastery)'),
            array('fas fa-yin-yang' => 'yin-yang(daoism,opposites,taoism)'),
            array('far fa-yin-yang' => 'yin-yang(daoism,opposites,taoism)'),
            array('fal fa-yin-yang' => 'yin-yang(daoism,opposites,taoism)'),
        ),
        'Science' => array(
            array('fas fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('far fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('fal fa-analytics' => 'analytics(chart,measure,roi,tracking,trend)'),
            array('fas fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-biohazard' => 'biohazard(danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)'),
            array('far fa-biohazard' => 'biohazard(danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)'),
            array('fal fa-biohazard' => 'biohazard(danger,dangerous,hazmat,medical,radioactive,toxic,waste,zombie)'),
            array('fas fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('far fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fal fa-book-spells' => 'book-spells(Dungeons & Dragons,d&d,dark arts,dnd,documentation,evil,fantasy,halloween,holiday,mage,magic,read,sorcery,voodoo,witch,wizard)'),
            array('fas fa-brain' => 'brain(cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)'),
            array('far fa-brain' => 'brain(cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)'),
            array('fal fa-brain' => 'brain(cerebellum,gray matter,intellect,medulla oblongata,mind,noodle,wit)'),
            array('fas fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('far fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fal fa-burn' => 'burn(caliente,energy,fire,flame,gas,heat,hot)'),
            array('fas fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('far fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('fal fa-capsules' => 'capsules(drugs,medicine,pills,prescription)'),
            array('fas fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('far fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fal fa-cauldron' => 'cauldron(boil,bubble,cooking,halloween,holiday,magic,pot,sorcery,toil,trouble,witch,wizard)'),
            array('fas fa-chart-network' => 'chart-network(activity,analytics,association,dashboard,diagram,distribution,map,network)'),
            array('far fa-chart-network' => 'chart-network(activity,analytics,association,dashboard,diagram,distribution,map,network)'),
            array('fal fa-chart-network' => 'chart-network(activity,analytics,association,dashboard,diagram,distribution,map,network)'),
            array('fas fa-chart-scatter' => 'chart-scatter(analytics,chart,diagram,graph,plot)'),
            array('far fa-chart-scatter' => 'chart-scatter(analytics,chart,diagram,graph,plot)'),
            array('fal fa-chart-scatter' => 'chart-scatter(analytics,chart,diagram,graph,plot)'),
            array('fas fa-clipboard-check' => 'clipboard-check(accept,agree,confirm,done,ok,select,success,tick,todo,yes)'),
            array('far fa-clipboard-check' => 'clipboard-check(accept,agree,confirm,done,ok,select,success,tick,todo,yes)'),
            array('fal fa-clipboard-check' => 'clipboard-check(accept,agree,confirm,done,ok,select,success,tick,todo,yes)'),
            array('fas fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('far fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('fal fa-disease' => 'disease(bacteria,cancer,illness,infection,sickness,virus)'),
            array('fas fa-dna' => 'dna(double helix,genetic,helix,molecule,protein)'),
            array('far fa-dna' => 'dna(double helix,genetic,helix,molecule,protein)'),
            array('fal fa-dna' => 'dna(double helix,genetic,helix,molecule,protein)'),
            array('fas fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('far fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fal fa-eye-dropper' => 'eye-dropper(beaker,clone,color,copy,eyedropper,pipette)'),
            array('fas fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('far fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('fal fa-filter' => 'filter(funnel,options,separate,sort)'),
            array('fas fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire' => 'fire(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('far fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fal fa-fire-alt' => 'fire-alt(burn,caliente,flame,heat,hot,popular)'),
            array('fas fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('far fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fal fa-flask' => 'flask(beaker,experimental,labs,science)'),
            array('fas fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('far fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('fal fa-flask-poison' => 'flask-poison(beverage,container,drink,halloween,health,holiday,power)'),
            array('fas fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('far fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fal fa-flask-potion' => 'flask-potion(Dungeons & Dragons,alert,beaker,beverage,container,d&d,danger,dangerous,deadly,death,dnd,drink,fantasy,halloween,heal,health,holiday,magic,mana,science)'),
            array('fas fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('far fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fal fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fas fa-head-side-brain' => 'head-side-brain(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('far fa-head-side-brain' => 'head-side-brain(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('fal fa-head-side-brain' => 'head-side-brain(diagnosis,face,mental health,profile,psychiatric,psychiatry)'),
            array('fas fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('far fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('fal fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('fas fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('far fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('fal fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('fas fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('far fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('fal fa-magnet' => 'magnet(Attract,lodestone,tool)'),
            array('fas fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('far fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('fal fa-microscope' => 'microscope(electron,lens,optics,science,shrink)'),
            array('fas fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('far fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('fal fa-mortar-pestle' => 'mortar-pestle(crush,culinary,grind,medical,mix,pharmacy,prescription,spices)'),
            array('fas fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('far fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('fal fa-pills' => 'pills(drugs,medicine,prescription,tablets)'),
            array('fas fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('far fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('fal fa-prescription-bottle' => 'prescription-bottle(drugs,medical,medicine,pharmacy,rx)'),
            array('fas fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation' => 'radiation(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('far fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fal fa-radiation-alt' => 'radiation-alt(danger,dangerous,deadly,hazard,nuclear,radioactive,warning)'),
            array('fas fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('far fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fal fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fas fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('far fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fal fa-skull-crossbones' => 'skull-crossbones(Dungeons & Dragons,alert,bones,d&d,danger,dead,deadly,death,dnd,fantasy,halloween,holiday,jolly-roger,pirate,poison,skeleton,warning)'),
            array('fas fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('far fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('fal fa-syringe' => 'syringe(doctor,immunizations,medical,needle)'),
            array('fas fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('far fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('fal fa-tablets' => 'tablets(drugs,medicine,pills,prescription)'),
            array('fas fa-tally' => 'tally(count,hash,numbers)'),
            array('far fa-tally' => 'tally(count,hash,numbers)'),
            array('fal fa-tally' => 'tally(count,hash,numbers)'),
            array('fas fa-temperature-high' => 'temperature-high(cook,mercury,summer,thermometer,warm)'),
            array('far fa-temperature-high' => 'temperature-high(cook,mercury,summer,thermometer,warm)'),
            array('fal fa-temperature-high' => 'temperature-high(cook,mercury,summer,thermometer,warm)'),
            array('fas fa-temperature-low' => 'temperature-low(cold,cool,mercury,thermometer,winter)'),
            array('far fa-temperature-low' => 'temperature-low(cold,cool,mercury,thermometer,winter)'),
            array('fal fa-temperature-low' => 'temperature-low(cold,cool,mercury,thermometer,winter)'),
            array('fas fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('far fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('fal fa-vial' => 'vial(experiment,lab,sample,science,test,test tube)'),
            array('fas fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
            array('far fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
            array('fal fa-vials' => 'vials(experiment,lab,sample,science,test,test tube)'),
        ),
        'Science Fiction' => array(
            array('fas fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-eclipse' => 'eclipse(lunar,moon,shadow,solar,sun)'),
            array('far fa-eclipse' => 'eclipse(lunar,moon,shadow,solar,sun)'),
            array('fal fa-eclipse' => 'eclipse(lunar,moon,shadow,solar,sun)'),
            array('fas fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('far fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('fal fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('fab fa-galactic-republic' => 'galactic-republic(politics,star wars)'),
            array('fab fa-galactic-senate' => 'galactic-senate(star wars)'),
            array('fas fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe' => 'globe(all,coordinates,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-jedi' => 'jedi(crest,force,sith,skywalker,star wars,yoda)'),
            array('far fa-jedi' => 'jedi(crest,force,sith,skywalker,star wars,yoda)'),
            array('fal fa-jedi' => 'jedi(crest,force,sith,skywalker,star wars,yoda)'),
            array('fab fa-jedi-order' => 'jedi-order(star wars)'),
            array('fas fa-journal-whills' => 'journal-whills(book,force,jedi,sith,star wars,yoda)'),
            array('far fa-journal-whills' => 'journal-whills(book,force,jedi,sith,star wars,yoda)'),
            array('fal fa-journal-whills' => 'journal-whills(book,force,jedi,sith,star wars,yoda)'),
            array('fas fa-meteor' => 'meteor(armageddon,asteroid,comet,shooting star,space)'),
            array('far fa-meteor' => 'meteor(armageddon,asteroid,comet,shooting star,space)'),
            array('fal fa-meteor' => 'meteor(armageddon,asteroid,comet,shooting star,space)'),
            array('fas fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('far fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('fal fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('fas fa-moon-stars' => 'moon-stars(clear,crescent,lunar,star)'),
            array('far fa-moon-stars' => 'moon-stars(clear,crescent,lunar,star)'),
            array('fal fa-moon-stars' => 'moon-stars(clear,crescent,lunar,star)'),
            array('fab fa-old-republic' => 'old-republic(politics,star wars)'),
            array('fas fa-robot' => 'robot(android,automate,computer,cyborg)'),
            array('far fa-robot' => 'robot(android,automate,computer,cyborg)'),
            array('fal fa-robot' => 'robot(android,automate,computer,cyborg)'),
            array('fas fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('far fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fal fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fas fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('far fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('fal fa-satellite' => 'satellite(communications,hardware,orbit,space)'),
            array('fas fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('far fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('fal fa-satellite-dish' => 'satellite-dish(SETI,communications,hardware,receiver,saucer,signal)'),
            array('fas fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('far fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('fal fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('fas fa-stars' => 'stars(galaxy,magic,night)'),
            array('far fa-stars' => 'stars(galaxy,magic,night)'),
            array('fal fa-stars' => 'stars(galaxy,magic,night)'),
            array('fas fa-user-astronaut' => 'user-astronaut(avatar,clothing,cosmonaut,nasa,space,suit)'),
            array('far fa-user-astronaut' => 'user-astronaut(avatar,clothing,cosmonaut,nasa,space,suit)'),
            array('fal fa-user-astronaut' => 'user-astronaut(avatar,clothing,cosmonaut,nasa,space,suit)'),
        ),
        'Security' => array(
            array('fas fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('far fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('fal fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('fas fa-bug' => 'bug(beetle,error,insect,report)'),
            array('far fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fal fa-bug' => 'bug(beetle,error,insect,report)'),
            array('fas fa-debug' => 'debug(error,fix,optimize,warning)'),
            array('far fa-debug' => 'debug(error,fix,optimize,warning)'),
            array('fal fa-debug' => 'debug(error,fix,optimize,warning)'),
            array('fas fa-do-not-enter' => 'do-not-enter(closed,traffic,warning)'),
            array('far fa-do-not-enter' => 'do-not-enter(closed,traffic,warning)'),
            array('fal fa-do-not-enter' => 'do-not-enter(closed,traffic,warning)'),
            array('fas fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('far fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fal fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fas fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('far fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fal fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fas fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('far fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fal fa-dungeon' => 'dungeon(Dungeons & Dragons,building,d&d,dnd,door,entrance,fantasy,gate)'),
            array('fas fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('far fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fal fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fas fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('far fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fal fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fas fa-file-certificate' => 'file-certificate(award,diploma,document,license)'),
            array('far fa-file-certificate' => 'file-certificate(award,diploma,document,license)'),
            array('fal fa-file-certificate' => 'file-certificate(award,diploma,document,license)'),
            array('fas fa-file-contract' => 'file-contract(agreement,binding,document,legal,signature)'),
            array('far fa-file-contract' => 'file-contract(agreement,binding,document,legal,signature)'),
            array('fal fa-file-contract' => 'file-contract(agreement,binding,document,legal,signature)'),
            array('fas fa-file-signature' => 'file-signature(John Hancock,contract,document,name)'),
            array('far fa-file-signature' => 'file-signature(John Hancock,contract,document,name)'),
            array('fal fa-file-signature' => 'file-signature(John Hancock,contract,document,name)'),
            array('fas fa-fingerprint' => 'fingerprint(human,id,identification,lock,smudge,touch,unique,unlock)'),
            array('far fa-fingerprint' => 'fingerprint(human,id,identification,lock,smudge,touch,unique,unlock)'),
            array('fal fa-fingerprint' => 'fingerprint(human,id,identification,lock,smudge,touch,unique,unlock)'),
            array('fas fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('far fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('fal fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('fas fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('far fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('fal fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('fas fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('far fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('fal fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('fas fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('far fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fal fa-key' => 'key(lock,password,private,secret,unlock)'),
            array('fas fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('far fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('fal fa-key-skeleton' => 'key-skeleton(halloween,lock,password,private,secret,unlock)'),
            array('fas fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('fas fa-mask' => 'mask(carnivale,costume,disguise,halloween,secret,super hero)'),
            array('far fa-mask' => 'mask(carnivale,costume,disguise,halloween,secret,super hero)'),
            array('fal fa-mask' => 'mask(carnivale,costume,disguise,halloween,secret,super hero)'),
            array('fas fa-passport' => 'passport(document,id,identification,issued,travel)'),
            array('far fa-passport' => 'passport(document,id,identification,issued,travel)'),
            array('fal fa-passport' => 'passport(document,id,identification,issued,travel)'),
            array('fas fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('far fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fal fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fas fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('far fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fal fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fas fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('far fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('fal fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('fas fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('far fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('fal fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('fas fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('far fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('fal fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('fas fa-user-lock' => 'user-lock(admin,lock,person,private,unlock)'),
            array('far fa-user-lock' => 'user-lock(admin,lock,person,private,unlock)'),
            array('fal fa-user-lock' => 'user-lock(admin,lock,person,private,unlock)'),
            array('fas fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('far fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('fal fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('fas fa-user-shield' => 'user-shield(admin,person,private,protect,safe)'),
            array('far fa-user-shield' => 'user-shield(admin,person,private,protect,safe)'),
            array('fal fa-user-shield' => 'user-shield(admin,person,private,protect,safe)'),
            array('fas fa-whistle' => 'whistle(alert,single,sound,toot)'),
            array('far fa-whistle' => 'whistle(alert,single,sound,toot)'),
            array('fal fa-whistle' => 'whistle(alert,single,sound,toot)'),
        ),
        'Shapes' => array(
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('far fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fal fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fas fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('far fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fal fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fas fa-certificate' => 'certificate(badge,star,verified)'),
            array('far fa-certificate' => 'certificate(badge,star,verified)'),
            array('fal fa-certificate' => 'certificate(badge,star,verified)'),
            array('fas fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('far fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fal fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fas fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('far fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fal fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fas fa-club' => 'club(card,game,poker,suit)'),
            array('far fa-club' => 'club(card,game,poker,suit)'),
            array('fal fa-club' => 'club(card,game,poker,suit)'),
            array('fas fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-diamond' => 'diamond(cards,gem,gemstone,poker,suit)'),
            array('far fa-diamond' => 'diamond(cards,gem,gemstone,poker,suit)'),
            array('fal fa-diamond' => 'diamond(cards,gem,gemstone,poker,suit)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-folder' => 'folder(archive,directory,document,file)'),
            array('far fa-folder' => 'folder(archive,directory,document,file)'),
            array('fal fa-folder' => 'folder(archive,directory,document,file)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-heart-broken' => 'heart-broken(breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)'),
            array('far fa-heart-broken' => 'heart-broken(breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)'),
            array('fal fa-heart-broken' => 'heart-broken(breakup,crushed,dislike,dumped,grief,love,lovesick,relationship,sad)'),
            array('fas fa-hexagon' => 'hexagon(geometry,honeycomb,polygon,shape)'),
            array('far fa-hexagon' => 'hexagon(geometry,honeycomb,polygon,shape)'),
            array('fal fa-hexagon' => 'hexagon(geometry,honeycomb,polygon,shape)'),
            array('fas fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-octagon' => 'octagon(shape,stop)'),
            array('far fa-octagon' => 'octagon(shape,stop)'),
            array('fal fa-octagon' => 'octagon(shape,stop)'),
            array('fas fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('far fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fal fa-play' => 'play(audio,music,playing,sound,start,video)'),
            array('fas fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('far fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('fal fa-rectangle-landscape' => 'rectangle-landscape(geometry,shape)'),
            array('fas fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('far fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('fal fa-rectangle-portrait' => 'rectangle-portrait(geometry,shape)'),
            array('fas fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('far fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('fal fa-rectangle-wide' => 'rectangle-wide(geometry,landscape,shape)'),
            array('fas fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('far fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('fal fa-shapes' => 'shapes(blocks,build,circle,square,triangle)'),
            array('fas fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('far fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fal fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fas fa-spade' => 'spade(card,game,poker,suit)'),
            array('far fa-spade' => 'spade(card,game,poker,suit)'),
            array('fal fa-spade' => 'spade(card,game,poker,suit)'),
            array('fas fa-square' => 'square(block,box,shape)'),
            array('far fa-square' => 'square(block,box,shape)'),
            array('fal fa-square' => 'square(block,box,shape)'),
            array('fas fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('far fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fal fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fas fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('far fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('fal fa-ticket' => 'ticket(movie,pass,support,ticket)'),
            array('fas fa-triangle' => 'triangle(pyramid,shape)'),
            array('far fa-triangle' => 'triangle(pyramid,shape)'),
            array('fal fa-triangle' => 'triangle(pyramid,shape)'),
        ),
        'Shopping' => array(
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('far fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fal fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fas fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('far fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fal fa-badge-dollar' => 'badge-dollar(deal,discount,money,save,usd)'),
            array('fas fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('far fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fal fa-badge-percent' => 'badge-percent(deal,discount,money,save,usd)'),
            array('fas fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('far fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('fal fa-barcode' => 'barcode(info,laser,price,scan,upc)'),
            array('fas fa-barcode-alt' => 'barcode-alt(info,laser,price,scan,upc)'),
            array('far fa-barcode-alt' => 'barcode-alt(info,laser,price,scan,upc)'),
            array('fal fa-barcode-alt' => 'barcode-alt(info,laser,price,scan,upc)'),
            array('fas fa-barcode-read' => 'barcode-read(info,laser,price,scan,upc)'),
            array('far fa-barcode-read' => 'barcode-read(info,laser,price,scan,upc)'),
            array('fal fa-barcode-read' => 'barcode-read(info,laser,price,scan,upc)'),
            array('fas fa-barcode-scan' => 'barcode-scan(info,laser,price,scan,upc)'),
            array('far fa-barcode-scan' => 'barcode-scan(info,laser,price,scan,upc)'),
            array('fal fa-barcode-scan' => 'barcode-scan(info,laser,price,scan,upc)'),
            array('fas fa-booth-curtain' => 'booth-curtain(changing room,election,vote,voting,voting booth)'),
            array('far fa-booth-curtain' => 'booth-curtain(changing room,election,vote,voting,voting booth)'),
            array('fal fa-booth-curtain' => 'booth-curtain(changing room,election,vote,voting,voting booth)'),
            array('fas fa-box-full' => 'box-full(attic,package,packed,storage)'),
            array('far fa-box-full' => 'box-full(attic,package,packed,storage)'),
            array('fal fa-box-full' => 'box-full(attic,package,packed,storage)'),
            array('fas fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('far fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fal fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fas fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('far fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('fal fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('fas fa-cash-register' => 'cash-register(buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)'),
            array('far fa-cash-register' => 'cash-register(buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)'),
            array('fal fa-cash-register' => 'cash-register(buy,cha-ching,change,checkout,commerce,leaerboard,machine,pay,payment,purchase,store)'),
            array('fas fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gift' => 'gift(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-gift-card' => 'gift-card(christmas,generosity,giving,holiday,money,party,present,wrapped,xmas)'),
            array('far fa-gift-card' => 'gift-card(christmas,generosity,giving,holiday,money,party,present,wrapped,xmas)'),
            array('fal fa-gift-card' => 'gift-card(christmas,generosity,giving,holiday,money,party,present,wrapped,xmas)'),
            array('fas fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('far fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fal fa-gifts' => 'gifts(christmas,generosity,giving,holiday,party,present,wrapped,xmas)'),
            array('fas fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('far fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('fal fa-hand-holding-box' => 'hand-holding-box(carry,gift,handling,lift,package)'),
            array('fas fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('far fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('fal fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('fas fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('far fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fal fa-receipt' => 'receipt(check,invoice,money,pay,table)'),
            array('fas fa-shipping-fast' => 'shipping-fast(express,fedex,mail,overnight,package,ups)'),
            array('far fa-shipping-fast' => 'shipping-fast(express,fedex,mail,overnight,package,ups)'),
            array('fal fa-shipping-fast' => 'shipping-fast(express,fedex,mail,overnight,package,ups)'),
            array('fas fa-shipping-timed' => 'shipping-timed(express,fedex,mail,overnight,package,ups)'),
            array('far fa-shipping-timed' => 'shipping-timed(express,fedex,mail,overnight,package,ups)'),
            array('fal fa-shipping-timed' => 'shipping-timed(express,fedex,mail,overnight,package,ups)'),
            array('fas fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-bag' => 'shopping-bag(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-basket' => 'shopping-basket(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-store' => 'store(building,buy,purchase,shopping)'),
            array('far fa-store' => 'store(building,buy,purchase,shopping)'),
            array('fal fa-store' => 'store(building,buy,purchase,shopping)'),
            array('fas fa-store-alt' => 'store-alt(building,buy,purchase,shopping)'),
            array('far fa-store-alt' => 'store-alt(building,buy,purchase,shopping)'),
            array('fal fa-store-alt' => 'store-alt(building,buy,purchase,shopping)'),
            array('fas fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fas fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck-container' => 'truck-container(cargo,delivery,shipping,vehicle)'),
            array('fas fa-tshirt' => 'tshirt(clothing,fashion,garment,shirt)'),
            array('far fa-tshirt' => 'tshirt(clothing,fashion,garment,shirt)'),
            array('fal fa-tshirt' => 'tshirt(clothing,fashion,garment,shirt)'),
        ),
        'Social' => array(
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('far fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fal fa-birthday-cake' => 'birthday-cake(anniversary,bakery,candles,celebration,dessert,frosting,holiday,party,pastry)'),
            array('fas fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('far fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fal fa-camera' => 'camera(image,lens,photo,picture,record,shutter,video)'),
            array('fas fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-hashtag' => 'hashtag(Twitter,instagram,pound,social media,tag)'),
            array('far fa-hashtag' => 'hashtag(Twitter,instagram,pound,social media,tag)'),
            array('fal fa-hashtag' => 'hashtag(Twitter,instagram,pound,social media,tag)'),
            array('fas fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('far fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fal fa-heart' => 'heart(favorite,like,love,relationship,valentine)'),
            array('fas fa-image' => 'image(album,landscape,photo,picture)'),
            array('far fa-image' => 'image(album,landscape,photo,picture)'),
            array('fal fa-image' => 'image(album,landscape,photo,picture)'),
            array('fas fa-images' => 'images(album,landscape,photo,picture)'),
            array('far fa-images' => 'images(album,landscape,photo,picture)'),
            array('fal fa-images' => 'images(album,landscape,photo,picture)'),
            array('fas fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-poll' => 'poll(results,survey,trend,vote,voting)'),
            array('far fa-poll' => 'poll(results,survey,trend,vote,voting)'),
            array('fal fa-poll' => 'poll(results,survey,trend,vote,voting)'),
            array('fas fa-poll-h' => 'poll-h(results,survey,trend,vote,voting)'),
            array('far fa-poll-h' => 'poll-h(results,survey,trend,vote,voting)'),
            array('fal fa-poll-h' => 'poll-h(results,survey,trend,vote,voting)'),
            array('fas fa-retweet' => 'retweet(refresh,reload,share,swap)'),
            array('far fa-retweet' => 'retweet(refresh,reload,share,swap)'),
            array('fal fa-retweet' => 'retweet(refresh,reload,share,swap)'),
            array('fas fa-retweet-alt' => 'retweet-alt(refresh,reload,share,swap)'),
            array('far fa-retweet-alt' => 'retweet-alt(refresh,reload,share,swap)'),
            array('fal fa-retweet-alt' => 'retweet-alt(refresh,reload,share,swap)'),
            array('fas fa-share' => 'share(forward,save,send,social)'),
            array('far fa-share' => 'share(forward,save,send,social)'),
            array('fal fa-share' => 'share(forward,save,send,social)'),
            array('fas fa-share-alt' => 'share-alt(forward,save,send,social)'),
            array('far fa-share-alt' => 'share-alt(forward,save,send,social)'),
            array('fal fa-share-alt' => 'share-alt(forward,save,send,social)'),
            array('fas fa-share-square' => 'share-square(forward,save,send,social)'),
            array('far fa-share-square' => 'share-square(forward,save,send,social)'),
            array('fal fa-share-square' => 'share-square(forward,save,send,social)'),
            array('fas fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('far fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fal fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fas fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('far fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fal fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fas fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('far fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fal fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fas fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('far fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fal fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fas fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('far fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('far fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('fal fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('fas fa-user-friends' => 'user-friends(group,people,person,team,users)'),
            array('far fa-user-friends' => 'user-friends(group,people,person,team,users)'),
            array('fal fa-user-friends' => 'user-friends(group,people,person,team,users)'),
            array('fas fa-user-plus' => 'user-plus(add,avatar,positive,sign up,signup,team)'),
            array('far fa-user-plus' => 'user-plus(add,avatar,positive,sign up,signup,team)'),
            array('fal fa-user-plus' => 'user-plus(add,avatar,positive,sign up,signup,team)'),
            array('fas fa-users' => 'users(friends,group,people,persons,profiles,team)'),
            array('far fa-users' => 'users(friends,group,people,persons,profiles,team)'),
            array('fal fa-users' => 'users(friends,group,people,persons,profiles,team)'),
            array('fas fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('far fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('fal fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('fas fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('far fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('fal fa-video' => 'video(camera,film,movie,record,video-camera)'),
        ),
        'Spinners' => array(
            array('fas fa-asterisk' => 'asterisk(annotation,details,reference,star)'),
            array('far fa-asterisk' => 'asterisk(annotation,details,reference,star)'),
            array('fal fa-asterisk' => 'asterisk(annotation,details,reference,star)'),
            array('fas fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom' => 'atom(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('far fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fal fa-atom-alt' => 'atom-alt(atheism,chemistry,ion,nuclear,science)'),
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('far fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('fal fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('fas fa-certificate' => 'certificate(badge,star,verified)'),
            array('far fa-certificate' => 'certificate(badge,star,verified)'),
            array('fal fa-certificate' => 'certificate(badge,star,verified)'),
            array('fas fa-circle-notch' => 'circle-notch(circle-o-notch,diameter,dot,ellipse,round,spinner)'),
            array('far fa-circle-notch' => 'circle-notch(circle-o-notch,diameter,dot,ellipse,round,spinner)'),
            array('fal fa-circle-notch' => 'circle-notch(circle-o-notch,diameter,dot,ellipse,round,spinner)'),
            array('fas fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('far fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('fal fa-cog' => 'cog(gear,mechanical,settings,sprocket,wheel)'),
            array('fas fa-compact-disc' => 'compact-disc(album,bluray,cd,disc,dvd,media,movie,music,record,video,vinyl)'),
            array('far fa-compact-disc' => 'compact-disc(album,bluray,cd,disc,dvd,media,movie,music,record,video,vinyl)'),
            array('fal fa-compact-disc' => 'compact-disc(album,bluray,cd,disc,dvd,media,movie,music,record,video,vinyl)'),
            array('fas fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('far fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fal fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fas fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('far fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('fal fa-crosshairs' => 'crosshairs(aim,bullseye,gpd,picker,position)'),
            array('fas fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('far fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('fal fa-dharmachakra' => 'dharmachakra(buddhism,buddhist,wheel of dharma)'),
            array('fas fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('far fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('fal fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('fas fa-haykal' => 'haykal(bahai,bahĂ¡\'Ă­,star)'),
            array('far fa-haykal' => 'haykal(bahai,bahĂ¡\'Ă­,star)'),
            array('fal fa-haykal' => 'haykal(bahai,bahĂ¡\'Ă­,star)'),
            array('fas fa-hurricane' => 'hurricane(coriolis effect,eye,storm,tropical cyclone,typhoon)'),
            array('far fa-hurricane' => 'hurricane(coriolis effect,eye,storm,tropical cyclone,typhoon)'),
            array('fal fa-hurricane' => 'hurricane(coriolis effect,eye,storm,tropical cyclone,typhoon)'),
            array('fas fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('far fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('fal fa-life-ring' => 'life-ring(coast guard,help,overboard,save,support)'),
            array('fas fa-palette' => 'palette(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('far fa-palette' => 'palette(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fal fa-palette' => 'palette(acrylic,art,brush,color,fill,paint,pigment,watercolor)'),
            array('fas fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('far fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('fal fa-ring' => 'ring(Dungeons & Dragons,Gollum,band,binding,d&d,dnd,engagement,fantasy,gold,jewelry,marriage,precious)'),
            array('fas fa-slash' => 'slash(cancel,close,mute,off,stop,x)'),
            array('far fa-slash' => 'slash(cancel,close,mute,off,stop,x)'),
            array('fal fa-slash' => 'slash(cancel,close,mute,off,stop,x)'),
            array('fas fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('far fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fal fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fas fa-spider-web' => 'spider-web(cobweb,gossamer,halloween)'),
            array('far fa-spider-web' => 'spider-web(cobweb,gossamer,halloween)'),
            array('fal fa-spider-web' => 'spider-web(cobweb,gossamer,halloween)'),
            array('fas fa-spinner' => 'spinner(circle,loading,progress)'),
            array('far fa-spinner' => 'spinner(circle,loading,progress)'),
            array('fal fa-spinner' => 'spinner(circle,loading,progress)'),
            array('fas fa-spinner-third' => 'spinner-third(circle,loading,progress)'),
            array('far fa-spinner-third' => 'spinner-third(circle,loading,progress)'),
            array('fal fa-spinner-third' => 'spinner-third(circle,loading,progress)'),
            array('fas fa-star-christmas' => 'star-christmas(bethlehem,christmas,holiday,north,xmas)'),
            array('far fa-star-christmas' => 'star-christmas(bethlehem,christmas,holiday,north,xmas)'),
            array('fal fa-star-christmas' => 'star-christmas(bethlehem,christmas,holiday,north,xmas)'),
            array('fas fa-steering-wheel' => 'steering-wheel(auto,car,direction,driving,navigation)'),
            array('far fa-steering-wheel' => 'steering-wheel(auto,car,direction,driving,navigation)'),
            array('fal fa-steering-wheel' => 'steering-wheel(auto,car,direction,driving,navigation)'),
            array('fas fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('far fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('fal fa-stroopwafel' => 'stroopwafel(caramel,cookie,dessert,sweets,waffle)'),
            array('fas fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('far fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fal fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fas fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync' => 'sync(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('far fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fal fa-sync-alt' => 'sync-alt(exchange,refresh,reload,rotate,swap)'),
            array('fas fa-tire' => 'tire(auto,car,rim,rubber,wheel)'),
            array('far fa-tire' => 'tire(auto,car,rim,rubber,wheel)'),
            array('fal fa-tire' => 'tire(auto,car,rim,rubber,wheel)'),
            array('fas fa-tire-rugged' => 'tire-rugged(auto,car,offroad,rim,rubber,wheel)'),
            array('far fa-tire-rugged' => 'tire-rugged(auto,car,offroad,rim,rubber,wheel)'),
            array('fal fa-tire-rugged' => 'tire-rugged(auto,car,offroad,rim,rubber,wheel)'),
            array('fas fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('far fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('fal fa-wreath' => 'wreath(christmas,decoration,door,holiday,welcome,xmas)'),
            array('fas fa-yin-yang' => 'yin-yang(daoism,opposites,taoism)'),
            array('far fa-yin-yang' => 'yin-yang(daoism,opposites,taoism)'),
            array('fal fa-yin-yang' => 'yin-yang(daoism,opposites,taoism)'),
        ),
        'Sports' => array(
            array('fas fa-baseball' => 'baseball(bat,league,mlb,slugger,softball,sport)'),
            array('far fa-baseball' => 'baseball(bat,league,mlb,slugger,softball,sport)'),
            array('fal fa-baseball' => 'baseball(bat,league,mlb,slugger,softball,sport)'),
            array('fas fa-baseball-ball' => 'baseball-ball(foul,hardball,league,leather,mlb,softball,sport)'),
            array('far fa-baseball-ball' => 'baseball-ball(foul,hardball,league,leather,mlb,softball,sport)'),
            array('fal fa-baseball-ball' => 'baseball-ball(foul,hardball,league,leather,mlb,softball,sport)'),
            array('fas fa-basketball-ball' => 'basketball-ball(dribble,dunk,hoop,nba)'),
            array('far fa-basketball-ball' => 'basketball-ball(dribble,dunk,hoop,nba)'),
            array('fal fa-basketball-ball' => 'basketball-ball(dribble,dunk,hoop,nba)'),
            array('fas fa-basketball-hoop' => 'basketball-hoop(backboard,dunk,hoop,nba)'),
            array('far fa-basketball-hoop' => 'basketball-hoop(backboard,dunk,hoop,nba)'),
            array('fal fa-basketball-hoop' => 'basketball-hoop(backboard,dunk,hoop,nba)'),
            array('fas fa-bowling-ball' => 'bowling-ball(alley,candlepin,gutter,lane,strike,tenpin)'),
            array('far fa-bowling-ball' => 'bowling-ball(alley,candlepin,gutter,lane,strike,tenpin)'),
            array('fal fa-bowling-ball' => 'bowling-ball(alley,candlepin,gutter,lane,strike,tenpin)'),
            array('fas fa-bowling-pins' => 'bowling-pins(alley,candlepin,gutter,lane,strike,tenpin)'),
            array('far fa-bowling-pins' => 'bowling-pins(alley,candlepin,gutter,lane,strike,tenpin)'),
            array('fal fa-bowling-pins' => 'bowling-pins(alley,candlepin,gutter,lane,strike,tenpin)'),
            array('fas fa-boxing-glove' => 'boxing-glove(boxer,fight,heavyweight,spar)'),
            array('far fa-boxing-glove' => 'boxing-glove(boxer,fight,heavyweight,spar)'),
            array('fal fa-boxing-glove' => 'boxing-glove(boxer,fight,heavyweight,spar)'),
            array('fas fa-cricket' => 'cricket(ball,bat,bowling,wicket)'),
            array('far fa-cricket' => 'cricket(ball,bat,bowling,wicket)'),
            array('fal fa-cricket' => 'cricket(ball,bat,bowling,wicket)'),
            array('fas fa-curling' => 'curling(ice,olympics,sport,stone)'),
            array('far fa-curling' => 'curling(ice,olympics,sport,stone)'),
            array('fal fa-curling' => 'curling(ice,olympics,sport,stone)'),
            array('fas fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('far fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('fal fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('fas fa-field-hockey' => 'field-hockey(ball,sport,stick)'),
            array('far fa-field-hockey' => 'field-hockey(ball,sport,stick)'),
            array('fal fa-field-hockey' => 'field-hockey(ball,sport,stick)'),
            array('fas fa-football-ball' => 'football-ball(ball,fall,nfl,pigskin,seasonal)'),
            array('far fa-football-ball' => 'football-ball(ball,fall,nfl,pigskin,seasonal)'),
            array('fal fa-football-ball' => 'football-ball(ball,fall,nfl,pigskin,seasonal)'),
            array('fas fa-football-helmet' => 'football-helmet(ball,concussion,fall,nfl,pigskin,protection,seasonal)'),
            array('far fa-football-helmet' => 'football-helmet(ball,concussion,fall,nfl,pigskin,protection,seasonal)'),
            array('fal fa-football-helmet' => 'football-helmet(ball,concussion,fall,nfl,pigskin,protection,seasonal)'),
            array('fas fa-futbol' => 'futbol(ball,football,mls,soccer)'),
            array('far fa-futbol' => 'futbol(ball,football,mls,soccer)'),
            array('fal fa-futbol' => 'futbol(ball,football,mls,soccer)'),
            array('fas fa-golf-ball' => 'golf-ball(caddy,eagle,putt,tee)'),
            array('far fa-golf-ball' => 'golf-ball(caddy,eagle,putt,tee)'),
            array('fal fa-golf-ball' => 'golf-ball(caddy,eagle,putt,tee)'),
            array('fas fa-golf-club' => 'golf-club(caddy,eagle,putt,tee)'),
            array('far fa-golf-club' => 'golf-club(caddy,eagle,putt,tee)'),
            array('fal fa-golf-club' => 'golf-club(caddy,eagle,putt,tee)'),
            array('fas fa-hockey-mask' => 'hockey-mask(clothing,friday,halloween,ice,jason,nhl,protection,sport,thirteenth)'),
            array('far fa-hockey-mask' => 'hockey-mask(clothing,friday,halloween,ice,jason,nhl,protection,sport,thirteenth)'),
            array('fal fa-hockey-mask' => 'hockey-mask(clothing,friday,halloween,ice,jason,nhl,protection,sport,thirteenth)'),
            array('fas fa-hockey-puck' => 'hockey-puck(ice,nhl,sport)'),
            array('far fa-hockey-puck' => 'hockey-puck(ice,nhl,sport)'),
            array('fal fa-hockey-puck' => 'hockey-puck(ice,nhl,sport)'),
            array('fas fa-hockey-sticks' => 'hockey-sticks(ice,nhl,sport)'),
            array('far fa-hockey-sticks' => 'hockey-sticks(ice,nhl,sport)'),
            array('fal fa-hockey-sticks' => 'hockey-sticks(ice,nhl,sport)'),
            array('fas fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('far fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fal fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fas fa-luchador' => 'luchador(fight,mexico,nacho libre,wrestle,wrestling)'),
            array('far fa-luchador' => 'luchador(fight,mexico,nacho libre,wrestle,wrestling)'),
            array('fal fa-luchador' => 'luchador(fight,mexico,nacho libre,wrestle,wrestling)'),
            array('fas fa-pennant' => 'pennant(banner,flag,sign,sports,win)'),
            array('far fa-pennant' => 'pennant(banner,flag,sign,sports,win)'),
            array('fal fa-pennant' => 'pennant(banner,flag,sign,sports,win)'),
            array('fas fa-quidditch' => 'quidditch(ball,bludger,broom,golden snitch,harry potter,hogwarts,quaffle,sport,wizard)'),
            array('far fa-quidditch' => 'quidditch(ball,bludger,broom,golden snitch,harry potter,hogwarts,quaffle,sport,wizard)'),
            array('fal fa-quidditch' => 'quidditch(ball,bludger,broom,golden snitch,harry potter,hogwarts,quaffle,sport,wizard)'),
            array('fas fa-racquet' => 'racquet(badminton,racket,squash,tennis)'),
            array('far fa-racquet' => 'racquet(badminton,racket,squash,tennis)'),
            array('fal fa-racquet' => 'racquet(badminton,racket,squash,tennis)'),
            array('fas fa-shuttlecock' => 'shuttlecock(badminton,birdie,feather,sport)'),
            array('far fa-shuttlecock' => 'shuttlecock(badminton,birdie,feather,sport)'),
            array('fal fa-shuttlecock' => 'shuttlecock(badminton,birdie,feather,sport)'),
            array('fas fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('far fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fal fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fas fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('far fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fal fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fas fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('far fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fal fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fas fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('far fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fal fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fas fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('far fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('fal fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('fas fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('far fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fal fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fas fa-table-tennis' => 'table-tennis(ball,paddle,ping pong)'),
            array('far fa-table-tennis' => 'table-tennis(ball,paddle,ping pong)'),
            array('fal fa-table-tennis' => 'table-tennis(ball,paddle,ping pong)'),
            array('fas fa-tennis-ball' => 'tennis-ball(racket,sport,tennis,us open)'),
            array('far fa-tennis-ball' => 'tennis-ball(racket,sport,tennis,us open)'),
            array('fal fa-tennis-ball' => 'tennis-ball(racket,sport,tennis,us open)'),
            array('fas fa-volleyball-ball' => 'volleyball-ball(beach,olympics,sport)'),
            array('far fa-volleyball-ball' => 'volleyball-ball(beach,olympics,sport)'),
            array('fal fa-volleyball-ball' => 'volleyball-ball(beach,olympics,sport)'),
            array('fas fa-whistle' => 'whistle(alert,single,sound,toot)'),
            array('far fa-whistle' => 'whistle(alert,single,sound,toot)'),
            array('fal fa-whistle' => 'whistle(alert,single,sound,toot)'),
        ),
        'Spring' => array(
            array('fas fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('far fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('fal fa-allergies' => 'allergies(allergy,freckles,hand,hives,pox,skin,spots)'),
            array('fas fa-broom' => 'broom(clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)'),
            array('far fa-broom' => 'broom(clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)'),
            array('fal fa-broom' => 'broom(clean,firebolt,fly,halloween,nimbus 2000,quidditch,sweep,witch)'),
            array('fas fa-cloud-rainbow' => 'cloud-rainbow(gold,leprechaun,prism,rain,sky)'),
            array('far fa-cloud-rainbow' => 'cloud-rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fal fa-cloud-rainbow' => 'cloud-rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fas fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('far fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('fal fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('fas fa-cloud-sun-rain' => 'cloud-sun-rain(day,overcast,precipitation,storm,summer,sunshower)'),
            array('far fa-cloud-sun-rain' => 'cloud-sun-rain(day,overcast,precipitation,storm,summer,sunshower)'),
            array('fal fa-cloud-sun-rain' => 'cloud-sun-rain(day,overcast,precipitation,storm,summer,sunshower)'),
            array('fas fa-flower' => 'flower(daffodil,nature,spring,summer)'),
            array('far fa-flower' => 'flower(daffodil,nature,spring,summer)'),
            array('fal fa-flower' => 'flower(daffodil,nature,spring,summer)'),
            array('fas fa-flower-daffodil' => 'flower-daffodil(nature,spring,summer)'),
            array('far fa-flower-daffodil' => 'flower-daffodil(nature,spring,summer)'),
            array('fal fa-flower-daffodil' => 'flower-daffodil(nature,spring,summer)'),
            array('fas fa-flower-tulip' => 'flower-tulip(nature,spring,summer)'),
            array('far fa-flower-tulip' => 'flower-tulip(nature,spring,summer)'),
            array('fal fa-flower-tulip' => 'flower-tulip(nature,spring,summer)'),
            array('fas fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('far fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fal fa-frog' => 'frog(amphibian,bullfrog,fauna,hop,kermit,kiss,prince,ribbit,toad,wart)'),
            array('fas fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('far fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('fal fa-hand-holding-seedling' => 'hand-holding-seedling(carry,grow,lift,plant)'),
            array('fas fa-rabbit' => 'rabbit(animal,bunny,fast,fauna,hare,mammal,speed,wabbit)'),
            array('far fa-rabbit' => 'rabbit(animal,bunny,fast,fauna,hare,mammal,speed,wabbit)'),
            array('fal fa-rabbit' => 'rabbit(animal,bunny,fast,fauna,hare,mammal,speed,wabbit)'),
            array('fas fa-rabbit-fast' => 'rabbit-fast(animal,bunny,fast,fauna,hare,mammal,running,speed,wabbit)'),
            array('far fa-rabbit-fast' => 'rabbit-fast(animal,bunny,fast,fauna,hare,mammal,running,speed,wabbit)'),
            array('fal fa-rabbit-fast' => 'rabbit-fast(animal,bunny,fast,fauna,hare,mammal,running,speed,wabbit)'),
            array('fas fa-rainbow' => 'rainbow(gold,leprechaun,prism,rain,sky)'),
            array('far fa-rainbow' => 'rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fal fa-rainbow' => 'rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fas fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('far fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('fal fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('fas fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('far fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fal fa-seedling' => 'seedling(flora,grow,plant,vegan)'),
            array('fas fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('far fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fal fa-shovel' => 'shovel(construction,dig,excavate,tool,trench)'),
            array('fas fa-thunderstorm' => 'thunderstorm(bolt,lightning,precipitation,rain,storm,weather)'),
            array('far fa-thunderstorm' => 'thunderstorm(bolt,lightning,precipitation,rain,storm,weather)'),
            array('fal fa-thunderstorm' => 'thunderstorm(bolt,lightning,precipitation,rain,storm,weather)'),
            array('fas fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-alt' => 'tree-alt(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('far fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('fal fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
        ),
        'Status' => array(
            array('fas fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('far fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fal fa-badge' => 'badge(discount,meatball,verified,verify)'),
            array('fas fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('far fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fal fa-badge-check' => 'badge-check(accept,achievement,agree,award,confirm,correct,done,ok,security,select,success,verified,verify,winner,yes)'),
            array('fas fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('far fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('fal fa-ban' => 'ban(abort,ban,block,cancel,delete,hide,prohibit,remove,stop,trash)'),
            array('fas fa-battery-bolt' => 'battery-bolt(charge,power,status)'),
            array('far fa-battery-bolt' => 'battery-bolt(charge,power,status)'),
            array('fal fa-battery-bolt' => 'battery-bolt(charge,power,status)'),
            array('fas fa-battery-empty' => 'battery-empty(charge,dead,power,status)'),
            array('far fa-battery-empty' => 'battery-empty(charge,dead,power,status)'),
            array('fal fa-battery-empty' => 'battery-empty(charge,dead,power,status)'),
            array('fas fa-battery-full' => 'battery-full(charge,power,status)'),
            array('far fa-battery-full' => 'battery-full(charge,power,status)'),
            array('fal fa-battery-full' => 'battery-full(charge,power,status)'),
            array('fas fa-battery-half' => 'battery-half(charge,power,status)'),
            array('far fa-battery-half' => 'battery-half(charge,power,status)'),
            array('fal fa-battery-half' => 'battery-half(charge,power,status)'),
            array('fas fa-battery-quarter' => 'battery-quarter(charge,low,power,status)'),
            array('far fa-battery-quarter' => 'battery-quarter(charge,low,power,status)'),
            array('fal fa-battery-quarter' => 'battery-quarter(charge,low,power,status)'),
            array('fas fa-battery-slash' => 'battery-slash(charge,dead,power,status)'),
            array('far fa-battery-slash' => 'battery-slash(charge,dead,power,status)'),
            array('fal fa-battery-slash' => 'battery-slash(charge,dead,power,status)'),
            array('fas fa-battery-three-quarters' => 'battery-three-quarters(charge,power,status)'),
            array('far fa-battery-three-quarters' => 'battery-three-quarters(charge,power,status)'),
            array('fal fa-battery-three-quarters' => 'battery-three-quarters(charge,power,status)'),
            array('fas fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('far fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fal fa-bell' => 'bell(alarm,alert,chime,notification,reminder)'),
            array('fas fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('far fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('fal fa-bell-school' => 'bell-school(alert,chime,class,notification,reminder)'),
            array('fas fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('far fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fal fa-bell-school-slash' => 'bell-school-slash(alert,cancel,class,disabled,notification,off,reminder)'),
            array('fas fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('far fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fal fa-bell-slash' => 'bell-slash(alert,cancel,disabled,notification,off,reminder)'),
            array('fas fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('far fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fal fa-bells' => 'bells(alert,christmas,holiday,notification,reminder,xmas)'),
            array('fas fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('far fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fal fa-calendar' => 'calendar(calendar-o,date,event,schedule,time,when)'),
            array('fas fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('far fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fal fa-calendar-alt' => 'calendar-alt(calendar,date,event,schedule,time,when)'),
            array('fas fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('far fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('fal fa-calendar-check' => 'calendar-check(accept,agree,appointment,confirm,correct,date,done,event,ok,schedule,select,success,tick,time,todo,when)'),
            array('fas fa-calendar-day' => 'calendar-day(date,detail,event,focus,schedule,single day,time,today,when)'),
            array('far fa-calendar-day' => 'calendar-day(date,detail,event,focus,schedule,single day,time,today,when)'),
            array('fal fa-calendar-day' => 'calendar-day(date,detail,event,focus,schedule,single day,time,today,when)'),
            array('fas fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('far fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('fal fa-calendar-edit' => 'calendar-edit(date,edit,event,pen,pencil,schedule,time,update,when,write)'),
            array('fas fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('far fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fal fa-calendar-exclamation' => 'calendar-exclamation(calendar,date,event,important,schedule,time,when)'),
            array('fas fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('far fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('fal fa-calendar-minus' => 'calendar-minus(calendar,date,delete,event,negative,remove,schedule,time,when)'),
            array('fas fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('far fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('fal fa-calendar-plus' => 'calendar-plus(add,calendar,create,date,event,new,positive,schedule,time,when)'),
            array('fas fa-calendar-star' => 'calendar-star(calendar,date,event,favorite,important,schedule,time,when)'),
            array('far fa-calendar-star' => 'calendar-star(calendar,date,event,favorite,important,schedule,time,when)'),
            array('fal fa-calendar-star' => 'calendar-star(calendar,date,event,favorite,important,schedule,time,when)'),
            array('fas fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('far fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('fal fa-calendar-times' => 'calendar-times(archive,calendar,date,delete,event,remove,schedule,time,when,x)'),
            array('fas fa-calendar-week' => 'calendar-week(date,detail,event,focus,schedule,single week,time,today,when)'),
            array('far fa-calendar-week' => 'calendar-week(date,detail,event,focus,schedule,single week,time,today,when)'),
            array('fal fa-calendar-week' => 'calendar-week(date,detail,event,focus,schedule,single week,time,today,when)'),
            array('fas fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('far fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fal fa-cart-arrow-down' => 'cart-arrow-down(download,save,shopping)'),
            array('fas fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('far fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('fal fa-cart-plus' => 'cart-plus(add,create,new,positive,shopping)'),
            array('fas fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment' => 'comment(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('far fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fal fa-comment-alt' => 'comment-alt(bubble,chat,commenting,conversation,feedback,message,note,notification,sms,speech,texting)'),
            array('fas fa-comment-alt-slash' => 'comment-alt-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('far fa-comment-alt-slash' => 'comment-alt-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fal fa-comment-alt-slash' => 'comment-alt-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fas fa-comment-slash' => 'comment-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('far fa-comment-slash' => 'comment-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fal fa-comment-slash' => 'comment-slash(bubble,cancel,chat,commenting,conversation,feedback,message,mute,note,notification,quiet,sms,speech,texting)'),
            array('fas fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('far fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fal fa-compass' => 'compass(directions,directory,location,menu,navigation,safari,travel)'),
            array('fas fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('far fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('fal fa-compass-slash' => 'compass-slash(directions,directory,location,lost,menu,navigation,safari,travel)'),
            array('fas fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('far fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fal fa-door-closed' => 'door-closed(enter,exit,locked)'),
            array('fas fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('far fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fal fa-door-open' => 'door-open(enter,exit,welcome)'),
            array('fas fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation' => 'exclamation(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-circle' => 'exclamation-circle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-square' => 'exclamation-square(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('far fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fal fa-exclamation-triangle' => 'exclamation-triangle(alert,danger,error,important,notice,notification,notify,problem,warning)'),
            array('fas fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('far fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fal fa-eye' => 'eye(look,optic,see,seen,show,sight,views,visible)'),
            array('fas fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('far fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fal fa-eye-slash' => 'eye-slash(blind,hide,show,toggle,unseen,views,visible,visiblity)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-file-check' => 'file-check(accept,agree,confirm,document,done,ok,select,success,synced,tick,todo)'),
            array('far fa-file-check' => 'file-check(accept,agree,confirm,document,done,ok,select,success,synced,tick,todo)'),
            array('fal fa-file-check' => 'file-check(accept,agree,confirm,document,done,ok,select,success,synced,tick,todo)'),
            array('fas fa-file-edit' => 'file-edit(edit,pen,pencil,update,write)'),
            array('far fa-file-edit' => 'file-edit(edit,pen,pencil,update,write)'),
            array('fal fa-file-edit' => 'file-edit(edit,pen,pencil,update,write)'),
            array('fas fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('far fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('fal fa-file-exclamation' => 'file-exclamation(alert,document,important,page)'),
            array('fas fa-file-minus' => 'file-minus(delete,document,negative,remove)'),
            array('far fa-file-minus' => 'file-minus(delete,document,negative,remove)'),
            array('fal fa-file-minus' => 'file-minus(delete,document,negative,remove)'),
            array('fas fa-file-plus' => 'file-plus(add,create,document,medical,new,positive)'),
            array('far fa-file-plus' => 'file-plus(add,create,document,medical,new,positive)'),
            array('fal fa-file-plus' => 'file-plus(add,create,document,medical,new,positive)'),
            array('fas fa-file-times' => 'file-times(archive,delete,document,remove,x)'),
            array('far fa-file-times' => 'file-times(archive,delete,document,remove,x)'),
            array('fal fa-file-times' => 'file-times(archive,delete,document,remove,x)'),
            array('fas fa-folder' => 'folder(archive,directory,document,file)'),
            array('far fa-folder' => 'folder(archive,directory,document,file)'),
            array('fal fa-folder' => 'folder(archive,directory,document,file)'),
            array('fas fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('far fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fal fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fas fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('far fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('fal fa-gas-pump' => 'gas-pump(car,fuel,gasoline,petrol)'),
            array('fas fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('far fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('fal fa-gas-pump-slash' => 'gas-pump-slash(car,empty,fuel,gasoline,petrol)'),
            array('fas fa-info' => 'info(details,help,information,more,support)'),
            array('far fa-info' => 'info(details,help,information,more,support)'),
            array('fal fa-info' => 'info(details,help,information,more,support)'),
            array('fas fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('far fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('fal fa-info-circle' => 'info-circle(details,help,information,more,support)'),
            array('fas fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('far fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('fal fa-info-square' => 'info-square(details,help,information,more,support)'),
            array('fas fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('far fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fal fa-lightbulb' => 'lightbulb(energy,idea,inspiration,light)'),
            array('fas fa-lightbulb-slash' => 'lightbulb-slash(dark,light,off)'),
            array('far fa-lightbulb-slash' => 'lightbulb-slash(dark,light,off)'),
            array('fal fa-lightbulb-slash' => 'lightbulb-slash(dark,light,off)'),
            array('fas fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('far fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fal fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fas fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('far fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fal fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fas fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock' => 'lock(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-alt' => 'lock-alt(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-open' => 'lock-open(admin,lock,open,password,private,protect,security)'),
            array('fas fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('far fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('fal fa-lock-open-alt' => 'lock-open-alt(admin,lock,open,password,private,protect,security)'),
            array('fas fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker' => 'map-marker(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker-alt' => 'map-marker-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-alt-slash' => 'map-marker-alt-slash(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marker-alt-slash' => 'map-marker-alt-slash(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marker-alt-slash' => 'map-marker-alt-slash(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marker-slash' => 'map-marker-slash(agree,cancel,coordinates,destination,location,map,missing,navigation,pin,place)'),
            array('far fa-map-marker-slash' => 'map-marker-slash(agree,cancel,coordinates,destination,location,map,missing,navigation,pin,place)'),
            array('fal fa-map-marker-slash' => 'map-marker-slash(agree,cancel,coordinates,destination,location,map,missing,navigation,pin,place)'),
            array('fas fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone' => 'microphone(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt' => 'microphone-alt(audio,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-alt-slash' => 'microphone-alt-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fas fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('far fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fal fa-microphone-slash' => 'microphone-slash(audio,disable,mute,podcast,record,sing,sound,voice)'),
            array('fas fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('far fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('fal fa-minus' => 'minus(collapse,delete,hide,minify,negative,remove,trash)'),
            array('fas fa-minus-circle' => 'minus-circle(delete,hide,negative,remove,shape,trash)'),
            array('far fa-minus-circle' => 'minus-circle(delete,hide,negative,remove,shape,trash)'),
            array('fal fa-minus-circle' => 'minus-circle(delete,hide,negative,remove,shape,trash)'),
            array('fas fa-minus-hexagon' => 'minus-hexagon(delete,hide,negative,remove,shape,trash)'),
            array('far fa-minus-hexagon' => 'minus-hexagon(delete,hide,negative,remove,shape,trash)'),
            array('fal fa-minus-hexagon' => 'minus-hexagon(delete,hide,negative,remove,shape,trash)'),
            array('fas fa-minus-octagon' => 'minus-octagon(delete,hide,negative,remove,shape,trash)'),
            array('far fa-minus-octagon' => 'minus-octagon(delete,hide,negative,remove,shape,trash)'),
            array('fal fa-minus-octagon' => 'minus-octagon(delete,hide,negative,remove,shape,trash)'),
            array('fas fa-minus-square' => 'minus-square(collapse,delete,hide,minify,negative,remove,shape,trash)'),
            array('far fa-minus-square' => 'minus-square(collapse,delete,hide,minify,negative,remove,shape,trash)'),
            array('fal fa-minus-square' => 'minus-square(collapse,delete,hide,minify,negative,remove,shape,trash)'),
            array('fas fa-parking' => 'parking(auto,car,garage,meter)'),
            array('far fa-parking' => 'parking(auto,car,garage,meter)'),
            array('fal fa-parking' => 'parking(auto,car,garage,meter)'),
            array('fas fa-parking-circle' => 'parking-circle(auto,car,garage,meter)'),
            array('far fa-parking-circle' => 'parking-circle(auto,car,garage,meter)'),
            array('fal fa-parking-circle' => 'parking-circle(auto,car,garage,meter)'),
            array('fas fa-parking-circle-slash' => 'parking-circle-slash(auto,car,garage,meter)'),
            array('far fa-parking-circle-slash' => 'parking-circle-slash(auto,car,garage,meter)'),
            array('fal fa-parking-circle-slash' => 'parking-circle-slash(auto,car,garage,meter)'),
            array('fas fa-parking-slash' => 'parking-slash(auto,car,garage,meter)'),
            array('far fa-parking-slash' => 'parking-slash(auto,car,garage,meter)'),
            array('fal fa-parking-slash' => 'parking-slash(auto,car,garage,meter)'),
            array('fas fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('far fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fal fa-phone' => 'phone(call,earphone,number,support,telephone,voice)'),
            array('fas fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('far fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fal fa-phone-slash' => 'phone-slash(call,cancel,earphone,mute,number,support,telephone,voice)'),
            array('fas fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('far fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fal fa-plus' => 'plus(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-circle' => 'plus-circle(add,create,expand,new,positive,shape)'),
            array('far fa-plus-circle' => 'plus-circle(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-circle' => 'plus-circle(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-hexagon' => 'plus-hexagon(add,create,expand,new,positive,shape)'),
            array('far fa-plus-hexagon' => 'plus-hexagon(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-hexagon' => 'plus-hexagon(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-octagon' => 'plus-octagon(add,create,expand,new,positive,shape)'),
            array('far fa-plus-octagon' => 'plus-octagon(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-octagon' => 'plus-octagon(add,create,expand,new,positive,shape)'),
            array('fas fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('far fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fal fa-plus-square' => 'plus-square(add,create,expand,new,positive,shape)'),
            array('fas fa-print' => 'print(business,copy,document,office,paper)'),
            array('far fa-print' => 'print(business,copy,document,office,paper)'),
            array('fal fa-print' => 'print(business,copy,document,office,paper)'),
            array('fas fa-print-slash' => 'print-slash(business,copy,document,office,offline,paper)'),
            array('far fa-print-slash' => 'print-slash(business,copy,document,office,offline,paper)'),
            array('fal fa-print-slash' => 'print-slash(business,copy,document,office,offline,paper)'),
            array('fas fa-question' => 'question(help,information,support,unknown)'),
            array('far fa-question' => 'question(help,information,support,unknown)'),
            array('fal fa-question' => 'question(help,information,support,unknown)'),
            array('fas fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('far fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('fal fa-question-circle' => 'question-circle(help,information,support,unknown)'),
            array('fas fa-question-square' => 'question-square(help,information,support,unknown)'),
            array('far fa-question-square' => 'question-square(help,information,support,unknown)'),
            array('fal fa-question-square' => 'question-square(help,information,support,unknown)'),
            array('fas fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('far fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fal fa-shield' => 'shield(achievement,armor,award,block,cleric,defend,defense,holy,paladin,security,winner)'),
            array('fas fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('far fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fal fa-shield-alt' => 'shield-alt(achievement,award,block,defend,security,winner)'),
            array('fas fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('far fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('fal fa-shield-check' => 'shield-check(achievement,award,block,defend,security,select,success,tick,todo,winner)'),
            array('fas fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('far fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fal fa-sign-in' => 'sign-in(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fas fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('far fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fal fa-sign-in-alt' => 'sign-in-alt(arrow,enter,join,log in,login,sign in,sign up,sign-in,signin,signup)'),
            array('fas fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('far fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('fal fa-sign-out' => 'sign-out(arrow,exit,leave,log out,logout)'),
            array('fas fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('far fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('fal fa-sign-out-alt' => 'sign-out-alt(arrow,exit,leave,log out,logout,sign-out)'),
            array('fas fa-signal' => 'signal(bars,graph,online,reception,status)'),
            array('far fa-signal' => 'signal(bars,graph,online,reception,status)'),
            array('fal fa-signal' => 'signal(bars,graph,online,reception,status)'),
            array('fas fa-signal-1' => 'signal-1(bars,graph,online,reception,status)'),
            array('far fa-signal-1' => 'signal-1(bars,graph,online,reception,status)'),
            array('fal fa-signal-1' => 'signal-1(bars,graph,online,reception,status)'),
            array('fas fa-signal-2' => 'signal-2(bars,graph,online,reception,status)'),
            array('far fa-signal-2' => 'signal-2(bars,graph,online,reception,status)'),
            array('fal fa-signal-2' => 'signal-2(bars,graph,online,reception,status)'),
            array('fas fa-signal-3' => 'signal-3(bars,graph,online,reception,status)'),
            array('far fa-signal-3' => 'signal-3(bars,graph,online,reception,status)'),
            array('fal fa-signal-3' => 'signal-3(bars,graph,online,reception,status)'),
            array('fas fa-signal-4' => 'signal-4(bars,graph,online,reception,status)'),
            array('far fa-signal-4' => 'signal-4(bars,graph,online,reception,status)'),
            array('fal fa-signal-4' => 'signal-4(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt' => 'signal-alt(bars,graph,online,reception,status)'),
            array('far fa-signal-alt' => 'signal-alt(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt' => 'signal-alt(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-1' => 'signal-alt-1(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-1' => 'signal-alt-1(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-1' => 'signal-alt-1(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-2' => 'signal-alt-2(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-2' => 'signal-alt-2(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-2' => 'signal-alt-2(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-3' => 'signal-alt-3(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-3' => 'signal-alt-3(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-3' => 'signal-alt-3(bars,graph,online,reception,status)'),
            array('fas fa-signal-alt-slash' => 'signal-alt-slash(bars,graph,online,reception,status)'),
            array('far fa-signal-alt-slash' => 'signal-alt-slash(bars,graph,online,reception,status)'),
            array('fal fa-signal-alt-slash' => 'signal-alt-slash(bars,graph,online,reception,status)'),
            array('fas fa-signal-slash' => 'signal-slash(bars,graph,online,reception,status)'),
            array('far fa-signal-slash' => 'signal-slash(bars,graph,online,reception,status)'),
            array('fal fa-signal-slash' => 'signal-slash(bars,graph,online,reception,status)'),
            array('fas fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('far fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('fal fa-smoking-ban' => 'smoking-ban(ban,cancel,no smoking,non-smoking)'),
            array('fas fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('far fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fal fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fas fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('far fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fal fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fas fa-star-half-alt' => 'star-half-alt(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('far fa-star-half-alt' => 'star-half-alt(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fal fa-star-half-alt' => 'star-half-alt(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fas fa-stream' => 'stream(flow,list,timeline)'),
            array('far fa-stream' => 'stream(flow,list,timeline)'),
            array('fal fa-stream' => 'stream(flow,list,timeline)'),
            array('fas fa-thermometer-empty' => 'thermometer-empty(cold,mercury,status,temperature)'),
            array('far fa-thermometer-empty' => 'thermometer-empty(cold,mercury,status,temperature)'),
            array('fal fa-thermometer-empty' => 'thermometer-empty(cold,mercury,status,temperature)'),
            array('fas fa-thermometer-full' => 'thermometer-full(fever,hot,mercury,status,temperature)'),
            array('far fa-thermometer-full' => 'thermometer-full(fever,hot,mercury,status,temperature)'),
            array('fal fa-thermometer-full' => 'thermometer-full(fever,hot,mercury,status,temperature)'),
            array('fas fa-thermometer-half' => 'thermometer-half(mercury,status,temperature)'),
            array('far fa-thermometer-half' => 'thermometer-half(mercury,status,temperature)'),
            array('fal fa-thermometer-half' => 'thermometer-half(mercury,status,temperature)'),
            array('fas fa-thermometer-quarter' => 'thermometer-quarter(mercury,status,temperature)'),
            array('far fa-thermometer-quarter' => 'thermometer-quarter(mercury,status,temperature)'),
            array('fal fa-thermometer-quarter' => 'thermometer-quarter(mercury,status,temperature)'),
            array('fas fa-thermometer-three-quarters' => 'thermometer-three-quarters(mercury,status,temperature)'),
            array('far fa-thermometer-three-quarters' => 'thermometer-three-quarters(mercury,status,temperature)'),
            array('fal fa-thermometer-three-quarters' => 'thermometer-three-quarters(mercury,status,temperature)'),
            array('fas fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('far fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fal fa-thumbs-down' => 'thumbs-down(disagree,disapprove,dislike,hand,social,thumbs-o-down)'),
            array('fas fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('far fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fal fa-thumbs-up' => 'thumbs-up(agree,approve,favorite,hand,like,ok,okay,social,success,thumbs-o-up,yes,you got it dude)'),
            array('fas fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('far fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('fal fa-tint' => 'tint(color,drop,droplet,raindrop,waterdrop)'),
            array('fas fa-tint-slash' => 'tint-slash(color,drop,droplet,raindrop,waterdrop)'),
            array('far fa-tint-slash' => 'tint-slash(color,drop,droplet,raindrop,waterdrop)'),
            array('fal fa-tint-slash' => 'tint-slash(color,drop,droplet,raindrop,waterdrop)'),
            array('fas fa-toggle-off' => 'toggle-off(switch)'),
            array('far fa-toggle-off' => 'toggle-off(switch)'),
            array('fal fa-toggle-off' => 'toggle-off(switch)'),
            array('fas fa-toggle-on' => 'toggle-on(switch)'),
            array('far fa-toggle-on' => 'toggle-on(switch)'),
            array('fal fa-toggle-on' => 'toggle-on(switch)'),
            array('fas fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('far fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('fal fa-unlock' => 'unlock(admin,lock,password,private,protect)'),
            array('fas fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('far fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('fal fa-unlock-alt' => 'unlock-alt(admin,lock,password,private,protect)'),
            array('fas fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('far fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-alt-slash' => 'user-alt-slash(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-alt-slash' => 'user-alt-slash(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-alt-slash' => 'user-alt-slash(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-slash' => 'user-slash(ban,delete,remove)'),
            array('far fa-user-slash' => 'user-slash(ban,delete,remove)'),
            array('fal fa-user-slash' => 'user-slash(ban,delete,remove)'),
            array('fas fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('far fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('fal fa-video' => 'video(camera,film,movie,record,video-camera)'),
            array('fas fa-video-slash' => 'video-slash(add,create,film,new,positive,record,video)'),
            array('far fa-video-slash' => 'video-slash(add,create,film,new,positive,record,video)'),
            array('fal fa-video-slash' => 'video-slash(add,create,film,new,positive,record,video)'),
            array('fas fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('far fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fal fa-volume' => 'volume(audio,control,music,sound,speaker)'),
            array('fas fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('far fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fal fa-volume-down' => 'volume-down(audio,lower,music,quieter,sound,speaker)'),
            array('fas fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('far fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fal fa-volume-mute' => 'volume-mute(audio,music,quiet,sound,speaker)'),
            array('fas fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-off' => 'volume-off(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('far fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fal fa-volume-slash' => 'volume-slash(audio,ban,music,mute,quiet,silent,sound)'),
            array('fas fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('far fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fal fa-volume-up' => 'volume-up(audio,higher,louder,music,sound,speaker)'),
            array('fas fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('far fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fal fa-wifi' => 'wifi(connection,hotspot,internet,network,wireless)'),
            array('fas fa-wifi-1' => 'wifi-1(connection,hotspot,internet,network,weak,wireless)'),
            array('far fa-wifi-1' => 'wifi-1(connection,hotspot,internet,network,weak,wireless)'),
            array('fal fa-wifi-1' => 'wifi-1(connection,hotspot,internet,network,weak,wireless)'),
            array('fas fa-wifi-2' => 'wifi-2(average,connection,hotspot,internet,network,wireless)'),
            array('far fa-wifi-2' => 'wifi-2(average,connection,hotspot,internet,network,wireless)'),
            array('fal fa-wifi-2' => 'wifi-2(average,connection,hotspot,internet,network,wireless)'),
            array('fas fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
            array('far fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
            array('fal fa-wifi-slash' => 'wifi-slash(ban,broken,connection,disabled,hotspot,internet,network,unavailable,wireless)'),
        ),
        'Summer' => array(
            array('fas fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('far fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fal fa-anchor' => 'anchor(berth,boat,dock,embed,link,maritime,moor,secure)'),
            array('fas fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('far fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('fal fa-fish' => 'fish(fauna,gold,seafood,swimming)'),
            array('fas fa-glass' => 'glass(alcohol,beverage,drink,glass,water)'),
            array('far fa-glass' => 'glass(alcohol,beverage,drink,glass,water)'),
            array('fal fa-glass' => 'glass(alcohol,beverage,drink,glass,water)'),
            array('fas fa-hotdog' => 'hotdog(bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)'),
            array('far fa-hotdog' => 'hotdog(bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)'),
            array('fal fa-hotdog' => 'hotdog(bun,chili,frankfurt,frankfurter,kosher,polish,sandwich,sausage,vienna,weiner)'),
            array('fas fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('far fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('fal fa-ice-cream' => 'ice-cream(chocolate,cone,dessert,frozen,scoop,sorbet,vanilla,yogurt)'),
            array('fas fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('far fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('fal fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('fas fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('far fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('fal fa-kite' => 'kite(air,benjamin,fall,flying,franklin,outdoors,seasonal,sky,wind)'),
            array('fas fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('far fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fal fa-lemon' => 'lemon(citrus,lemonade,lime,tart)'),
            array('fas fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('far fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('fal fa-shish-kebab' => 'shish-kebab(grill,kabob,kebob,meat,shawarma,skewer,souvlaki)'),
            array('fas fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('far fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fal fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fas fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('far fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fal fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fas fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('far fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('fal fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('fas fa-temperature-hot' => 'temperature-hot(heat,mercury,summer,thermometer)'),
            array('far fa-temperature-hot' => 'temperature-hot(heat,mercury,summer,thermometer)'),
            array('fal fa-temperature-hot' => 'temperature-hot(heat,mercury,summer,thermometer)'),
            array('fas fa-tree-palm' => 'tree-palm(coconut,frond,tropical)'),
            array('far fa-tree-palm' => 'tree-palm(coconut,frond,tropical)'),
            array('fal fa-tree-palm' => 'tree-palm(coconut,frond,tropical)'),
            array('fas fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('far fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('fal fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('fas fa-volleyball-ball' => 'volleyball-ball(beach,olympics,sport)'),
            array('far fa-volleyball-ball' => 'volleyball-ball(beach,olympics,sport)'),
            array('fal fa-volleyball-ball' => 'volleyball-ball(beach,olympics,sport)'),
            array('fas fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('far fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('fal fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
        ),
        'Toggle' => array(
            array('fas fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('far fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fal fa-bullseye' => 'bullseye(archery,goal,objective,target)'),
            array('fas fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('far fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('fal fa-bullseye-arrow' => 'bullseye-arrow(archery,arrow,goal,objective,robin hood,target)'),
            array('fas fa-check-circle' => 'check-circle(accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('far fa-check-circle' => 'check-circle(accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('fal fa-check-circle' => 'check-circle(accept,agree,confirm,correct,done,ok,select,success,tick,todo,yes)'),
            array('fas fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('far fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fal fa-circle' => 'circle(circle-thin,diameter,dot,ellipse,notification,round)'),
            array('fas fa-dot-circle' => 'dot-circle(bullseye,notification,target)'),
            array('far fa-dot-circle' => 'dot-circle(bullseye,notification,target)'),
            array('fal fa-dot-circle' => 'dot-circle(bullseye,notification,target)'),
            array('fas fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('far fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fal fa-location' => 'location(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fas fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('far fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fal fa-location-slash' => 'location-slash(address,coordinate,direction,gps,map,navigation,place,where)'),
            array('fas fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('far fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fal fa-star' => 'star(achievement,award,favorite,important,night,rating,score)'),
            array('fas fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('far fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fal fa-star-half' => 'star-half(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fas fa-star-half-alt' => 'star-half-alt(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('far fa-star-half-alt' => 'star-half-alt(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fal fa-star-half-alt' => 'star-half-alt(achievement,award,rating,score,star-half-empty,star-half-full)'),
            array('fas fa-toggle-off' => 'toggle-off(switch)'),
            array('far fa-toggle-off' => 'toggle-off(switch)'),
            array('fal fa-toggle-off' => 'toggle-off(switch)'),
            array('fas fa-toggle-on' => 'toggle-on(switch)'),
            array('far fa-toggle-on' => 'toggle-on(switch)'),
            array('fal fa-toggle-on' => 'toggle-on(switch)'),
        ),
        'Travel' => array(
            array('fas fa-archway' => 'archway(arc,monument,road,street,tunnel)'),
            array('far fa-archway' => 'archway(arc,monument,road,street,tunnel)'),
            array('fal fa-archway' => 'archway(arc,monument,road,street,tunnel)'),
            array('fas fa-atlas' => 'atlas(book,directions,geography,globe,map,travel,wayfinding)'),
            array('far fa-atlas' => 'atlas(book,directions,geography,globe,map,travel,wayfinding)'),
            array('fal fa-atlas' => 'atlas(book,directions,geography,globe,map,travel,wayfinding)'),
            array('fas fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('far fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fal fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fas fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('far fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fal fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fas fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('far fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('fal fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('fas fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('far fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('fal fa-cocktail' => 'cocktail(alcohol,beverage,drink,gin,glass,margarita,martini,vodka)'),
            array('fas fa-concierge-bell' => 'concierge-bell(attention,hotel,receptionist,service,support)'),
            array('far fa-concierge-bell' => 'concierge-bell(attention,hotel,receptionist,service,support)'),
            array('fal fa-concierge-bell' => 'concierge-bell(attention,hotel,receptionist,service,support)'),
            array('fas fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('far fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('fal fa-dumbbell' => 'dumbbell(exercise,gym,strength,weight,weight-lifting)'),
            array('fas fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini' => 'glass-martini(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('far fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('fal fa-glass-martini-alt' => 'glass-martini-alt(alcohol,bar,beverage,drink,liquor)'),
            array('fas fa-globe-africa' => 'globe-africa(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe-africa' => 'globe-africa(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe-africa' => 'globe-africa(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-globe-americas' => 'globe-americas(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe-americas' => 'globe-americas(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe-americas' => 'globe-americas(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-globe-asia' => 'globe-asia(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe-asia' => 'globe-asia(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe-asia' => 'globe-asia(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-globe-europe' => 'globe-europe(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('far fa-globe-europe' => 'globe-europe(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fal fa-globe-europe' => 'globe-europe(all,country,earth,global,gps,language,localize,location,map,online,place,planet,translate,travel,world)'),
            array('fas fa-hot-tub' => 'hot-tub(bath,jacuzzi,massage,sauna,spa)'),
            array('far fa-hot-tub' => 'hot-tub(bath,jacuzzi,massage,sauna,spa)'),
            array('fal fa-hot-tub' => 'hot-tub(bath,jacuzzi,massage,sauna,spa)'),
            array('fas fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('far fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('fal fa-hotel' => 'hotel(building,inn,lodging,motel,resort,travel)'),
            array('fas fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('far fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('fal fa-island-tropical' => 'island-tropical(castaway,desert,palm tree,sand,stranded,summer,vacation)'),
            array('fas fa-luggage-cart' => 'luggage-cart(bag,baggage,suitcase,travel)'),
            array('far fa-luggage-cart' => 'luggage-cart(bag,baggage,suitcase,travel)'),
            array('fal fa-luggage-cart' => 'luggage-cart(bag,baggage,suitcase,travel)'),
            array('fas fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map' => 'map(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marked' => 'map-marked(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marked' => 'map-marked(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marked' => 'map-marked(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-map-marked-alt' => 'map-marked-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('far fa-map-marked-alt' => 'map-marked-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fal fa-map-marked-alt' => 'map-marked-alt(address,coordinates,destination,gps,localize,location,map,navigation,paper,pin,place,point of interest,position,route,travel)'),
            array('fas fa-monument' => 'monument(building,historic,landmark,memorable)'),
            array('far fa-monument' => 'monument(building,historic,landmark,memorable)'),
            array('fal fa-monument' => 'monument(building,historic,landmark,memorable)'),
            array('fas fa-passport' => 'passport(document,id,identification,issued,travel)'),
            array('far fa-passport' => 'passport(document,id,identification,issued,travel)'),
            array('fal fa-passport' => 'passport(document,id,identification,issued,travel)'),
            array('fas fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('far fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fal fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fas fa-plane-arrival' => 'plane-arrival(airplane,arriving,destination,fly,land,landing,location,mode,travel,trip)'),
            array('far fa-plane-arrival' => 'plane-arrival(airplane,arriving,destination,fly,land,landing,location,mode,travel,trip)'),
            array('fal fa-plane-arrival' => 'plane-arrival(airplane,arriving,destination,fly,land,landing,location,mode,travel,trip)'),
            array('fas fa-plane-departure' => 'plane-departure(airplane,departing,destination,fly,location,mode,take off,taking off,travel,trip)'),
            array('far fa-plane-departure' => 'plane-departure(airplane,departing,destination,fly,location,mode,take off,taking off,travel,trip)'),
            array('fal fa-plane-departure' => 'plane-departure(airplane,departing,destination,fly,location,mode,take off,taking off,travel,trip)'),
            array('fas fa-rings-wedding' => 'rings-wedding(diamond,engagement,gold,marriage,matrimony,platinum,proposal)'),
            array('far fa-rings-wedding' => 'rings-wedding(diamond,engagement,gold,marriage,matrimony,platinum,proposal)'),
            array('fal fa-rings-wedding' => 'rings-wedding(diamond,engagement,gold,marriage,matrimony,platinum,proposal)'),
            array('fas fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('far fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fal fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fas fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('far fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('fal fa-spa' => 'spa(flora,massage,mindfulness,plant,wellness)'),
            array('fas fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('far fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fal fa-suitcase' => 'suitcase(baggage,luggage,move,suitcase,travel,trip)'),
            array('fas fa-suitcase-rolling' => 'suitcase-rolling(baggage,luggage,move,suitcase,travel,trip)'),
            array('far fa-suitcase-rolling' => 'suitcase-rolling(baggage,luggage,move,suitcase,travel,trip)'),
            array('fal fa-suitcase-rolling' => 'suitcase-rolling(baggage,luggage,move,suitcase,travel,trip)'),
            array('fas fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('far fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fal fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fas fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('far fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('fal fa-swimming-pool' => 'swimming-pool(ladder,recreation,swim,water)'),
            array('fas fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('far fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fal fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fas fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('far fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fal fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fas fa-tree-palm' => 'tree-palm(coconut,frond,tropical)'),
            array('far fa-tree-palm' => 'tree-palm(coconut,frond,tropical)'),
            array('fal fa-tree-palm' => 'tree-palm(coconut,frond,tropical)'),
            array('fas fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('far fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('fal fa-umbrella-beach' => 'umbrella-beach(protection,recreation,sand,shade,summer,sun)'),
            array('fas fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('far fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fal fa-wine-glass' => 'wine-glass(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fas fa-wine-glass-alt' => 'wine-glass-alt(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('far fa-wine-glass-alt' => 'wine-glass-alt(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
            array('fal fa-wine-glass-alt' => 'wine-glass-alt(alcohol,beverage,cabernet,drink,grapes,merlot,sauvignon)'),
        ),
        'Users & People' => array(
            array('fab fa-accessible-icon' => 'accessible-icon(accessibility,handicap,person,wheelchair,wheelchair-alt)'),
            array('fas fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('far fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('fal fa-address-book' => 'address-book(contact,directory,index,little black book,rolodex)'),
            array('fas fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('far fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('fal fa-address-card' => 'address-card(about,contact,id,identification,postcard,profile)'),
            array('fas fa-angel' => 'angel(christmas,decoration,halo,holiday,holy,michael landon,wings,xmas)'),
            array('far fa-angel' => 'angel(christmas,decoration,halo,holiday,holy,michael landon,wings,xmas)'),
            array('fal fa-angel' => 'angel(christmas,decoration,halo,holiday,holy,michael landon,wings,xmas)'),
            array('fas fa-baby' => 'baby(child,diaper,doll,human,infant,kid,offspring,person,sprout)'),
            array('far fa-baby' => 'baby(child,diaper,doll,human,infant,kid,offspring,person,sprout)'),
            array('fal fa-baby' => 'baby(child,diaper,doll,human,infant,kid,offspring,person,sprout)'),
            array('fas fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('far fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fal fa-bed' => 'bed(lodging,rest,sleep,travel)'),
            array('fas fa-blind' => 'blind(cane,disability,person,sight)'),
            array('far fa-blind' => 'blind(cane,disability,person,sight)'),
            array('fal fa-blind' => 'blind(cane,disability,person,sight)'),
            array('fas fa-chalkboard-teacher' => 'chalkboard-teacher(blackboard,instructor,learning,professor,school,whiteboard,writing)'),
            array('far fa-chalkboard-teacher' => 'chalkboard-teacher(blackboard,instructor,learning,professor,school,whiteboard,writing)'),
            array('fal fa-chalkboard-teacher' => 'chalkboard-teacher(blackboard,instructor,learning,professor,school,whiteboard,writing)'),
            array('fas fa-child' => 'child(boy,girl,kid,toddler,young)'),
            array('far fa-child' => 'child(boy,girl,kid,toddler,young)'),
            array('fal fa-child' => 'child(boy,girl,kid,toddler,young)'),
            array('fas fa-female' => 'female(human,person,profile,user,woman)'),
            array('far fa-female' => 'female(human,person,profile,user,woman)'),
            array('fal fa-female' => 'female(human,person,profile,user,woman)'),
            array('fas fa-file-user' => 'file-user(account,document,page,personnel,profile,resume)'),
            array('far fa-file-user' => 'file-user(account,document,page,personnel,profile,resume)'),
            array('fal fa-file-user' => 'file-user(account,document,page,personnel,profile,resume)'),
            array('fas fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('far fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fal fa-frown' => 'frown(disapprove,emoticon,face,rating,sad)'),
            array('fas fa-head-side' => 'head-side(bald,face,profile,user)'),
            array('far fa-head-side' => 'head-side(bald,face,profile,user)'),
            array('fal fa-head-side' => 'head-side(bald,face,profile,user)'),
            array('fas fa-head-vr' => 'head-vr(3d,augmented,face,occulus,profile,reality,virtual)'),
            array('far fa-head-vr' => 'head-vr(3d,augmented,face,occulus,profile,reality,virtual)'),
            array('fal fa-head-vr' => 'head-vr(3d,augmented,face,occulus,profile,reality,virtual)'),
            array('fas fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('far fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fal fa-hiking' => 'hiking(activity,backpack,fall,fitness,outdoors,person,seasonal,walking)'),
            array('fas fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('far fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('fal fa-id-badge' => 'id-badge(address,contact,identification,license,profile)'),
            array('fas fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('far fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('fal fa-id-card' => 'id-card(contact,demographics,document,identification,issued,profile)'),
            array('fas fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('far fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('fal fa-id-card-alt' => 'id-card-alt(contact,demographics,document,identification,issued,profile)'),
            array('fas fa-male' => 'male(human,man,person,profile,user)'),
            array('far fa-male' => 'male(human,man,person,profile,user)'),
            array('fal fa-male' => 'male(human,man,person,profile,user)'),
            array('fas fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('far fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fal fa-meh' => 'meh(emoticon,face,neutral,rating)'),
            array('fas fa-people-carry' => 'people-carry(box,carry,fragile,help,movers,package)'),
            array('far fa-people-carry' => 'people-carry(box,carry,fragile,help,movers,package)'),
            array('fal fa-people-carry' => 'people-carry(box,carry,fragile,help,movers,package)'),
            array('fas fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('far fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('fal fa-person-booth' => 'person-booth(changing,changing room,election,human,person,vote,voting)'),
            array('fas fa-person-carry' => 'person-carry(human,lift,mover,person,transport)'),
            array('far fa-person-carry' => 'person-carry(human,lift,mover,person,transport)'),
            array('fal fa-person-carry' => 'person-carry(human,lift,mover,person,transport)'),
            array('fas fa-person-dolly' => 'person-dolly(human,lift,mover,person,transport)'),
            array('far fa-person-dolly' => 'person-dolly(human,lift,mover,person,transport)'),
            array('fal fa-person-dolly' => 'person-dolly(human,lift,mover,person,transport)'),
            array('fas fa-person-dolly-empty' => 'person-dolly-empty(human,lift,mover,person,transport)'),
            array('far fa-person-dolly-empty' => 'person-dolly-empty(human,lift,mover,person,transport)'),
            array('fal fa-person-dolly-empty' => 'person-dolly-empty(human,lift,mover,person,transport)'),
            array('fas fa-person-sign' => 'person-sign(advocate,human,information,person,protest,protester,volunteer)'),
            array('far fa-person-sign' => 'person-sign(advocate,human,information,person,protest,protester,volunteer)'),
            array('fal fa-person-sign' => 'person-sign(advocate,human,information,person,protest,protester,volunteer)'),
            array('fas fa-poll-people' => 'poll-people(candidates,election,people,person,results,survey,trend,vote,voting)'),
            array('far fa-poll-people' => 'poll-people(candidates,election,people,person,results,survey,trend,vote,voting)'),
            array('fal fa-poll-people' => 'poll-people(candidates,election,people,person,results,survey,trend,vote,voting)'),
            array('fas fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('far fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('fal fa-poo' => 'poo(crap,poop,shit,smile,turd)'),
            array('fas fa-portrait' => 'portrait(id,image,photo,picture,selfie)'),
            array('far fa-portrait' => 'portrait(id,image,photo,picture,selfie)'),
            array('fal fa-portrait' => 'portrait(id,image,photo,picture,selfie)'),
            array('fas fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('far fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('fal fa-power-off' => 'power-off(cancel,computer,on,reboot,restart)'),
            array('fas fa-pray' => 'pray(kneel,preach,religion,worship)'),
            array('far fa-pray' => 'pray(kneel,preach,religion,worship)'),
            array('fal fa-pray' => 'pray(kneel,preach,religion,worship)'),
            array('fas fa-restroom' => 'restroom(bathroom,john,loo,potty,washroom,waste,wc)'),
            array('far fa-restroom' => 'restroom(bathroom,john,loo,potty,washroom,waste,wc)'),
            array('fal fa-restroom' => 'restroom(bathroom,john,loo,potty,washroom,waste,wc)'),
            array('fas fa-running' => 'running(exercise,health,jog,person,run,sport,sprint)'),
            array('far fa-running' => 'running(exercise,health,jog,person,run,sport,sprint)'),
            array('fal fa-running' => 'running(exercise,health,jog,person,run,sport,sprint)'),
            array('fas fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('far fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fal fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fas fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('far fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fal fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fas fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('far fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('fal fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('fas fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('far fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fal fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fas fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('far fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fal fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fas fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('far fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('fal fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('fas fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('far fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fal fa-smile' => 'smile(approve,emoticon,face,happy,rating,satisfied)'),
            array('fas fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('far fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fal fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fas fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('far fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fal fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fas fa-street-view' => 'street-view(directions,location,map,navigation)'),
            array('far fa-street-view' => 'street-view(directions,location,map,navigation)'),
            array('fal fa-street-view' => 'street-view(directions,location,map,navigation)'),
            array('fas fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('far fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fal fa-swimmer' => 'swimmer(athlete,head,man,olympics,person,pool,water)'),
            array('fas fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('far fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user' => 'user(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-alt' => 'user-alt(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-alt-slash' => 'user-alt-slash(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-alt-slash' => 'user-alt-slash(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-alt-slash' => 'user-alt-slash(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-astronaut' => 'user-astronaut(avatar,clothing,cosmonaut,nasa,space,suit)'),
            array('far fa-user-astronaut' => 'user-astronaut(avatar,clothing,cosmonaut,nasa,space,suit)'),
            array('fal fa-user-astronaut' => 'user-astronaut(avatar,clothing,cosmonaut,nasa,space,suit)'),
            array('fas fa-user-chart' => 'user-chart(chart,person,presentation,teacher)'),
            array('far fa-user-chart' => 'user-chart(chart,person,presentation,teacher)'),
            array('fal fa-user-chart' => 'user-chart(chart,person,presentation,teacher)'),
            array('fas fa-user-check' => 'user-check(accept,check,person,verified)'),
            array('far fa-user-check' => 'user-check(accept,check,person,verified)'),
            array('fal fa-user-check' => 'user-check(accept,check,person,verified)'),
            array('fas fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('far fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('fal fa-user-circle' => 'user-circle(account,avatar,head,human,man,person,profile)'),
            array('fas fa-user-clock' => 'user-clock(alert,person,remind,time)'),
            array('far fa-user-clock' => 'user-clock(alert,person,remind,time)'),
            array('fal fa-user-clock' => 'user-clock(alert,person,remind,time)'),
            array('fas fa-user-cog' => 'user-cog(admin,cog,person,settings)'),
            array('far fa-user-cog' => 'user-cog(admin,cog,person,settings)'),
            array('fal fa-user-cog' => 'user-cog(admin,cog,person,settings)'),
            array('fas fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('far fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('fal fa-user-crown' => 'user-crown(admin,avatar,person,special)'),
            array('fas fa-user-edit' => 'user-edit(edit,pen,pencil,person,update,write)'),
            array('far fa-user-edit' => 'user-edit(edit,pen,pencil,person,update,write)'),
            array('fal fa-user-edit' => 'user-edit(edit,pen,pencil,person,update,write)'),
            array('fas fa-user-friends' => 'user-friends(group,people,person,team,users)'),
            array('far fa-user-friends' => 'user-friends(group,people,person,team,users)'),
            array('fal fa-user-friends' => 'user-friends(group,people,person,team,users)'),
            array('fas fa-user-graduate' => 'user-graduate(cap,clothing,commencement,gown,graduation,person,student)'),
            array('far fa-user-graduate' => 'user-graduate(cap,clothing,commencement,gown,graduation,person,student)'),
            array('fal fa-user-graduate' => 'user-graduate(cap,clothing,commencement,gown,graduation,person,student)'),
            array('fas fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('far fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('fal fa-user-hard-hat' => 'user-hard-hat(construction,hardhat,helmet,safety)'),
            array('fas fa-user-headset' => 'user-headset(gaming,headphones,help,person,support,telemarketer,telemarketing)'),
            array('far fa-user-headset' => 'user-headset(gaming,headphones,help,person,support,telemarketer,telemarketing)'),
            array('fal fa-user-headset' => 'user-headset(gaming,headphones,help,person,support,telemarketer,telemarketing)'),
            array('fas fa-user-injured' => 'user-injured(cast,injury,ouch,patient,person,sling)'),
            array('far fa-user-injured' => 'user-injured(cast,injury,ouch,patient,person,sling)'),
            array('fal fa-user-injured' => 'user-injured(cast,injury,ouch,patient,person,sling)'),
            array('fas fa-user-lock' => 'user-lock(admin,lock,person,private,unlock)'),
            array('far fa-user-lock' => 'user-lock(admin,lock,person,private,unlock)'),
            array('fal fa-user-lock' => 'user-lock(admin,lock,person,private,unlock)'),
            array('fas fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('far fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('fal fa-user-md' => 'user-md(job,medical,nurse,occupation,physician,profile,surgeon)'),
            array('fas fa-user-md-chat' => 'user-md-chat(advice,comment,diagnosis,opinion,prescription)'),
            array('far fa-user-md-chat' => 'user-md-chat(advice,comment,diagnosis,opinion,prescription)'),
            array('fal fa-user-md-chat' => 'user-md-chat(advice,comment,diagnosis,opinion,prescription)'),
            array('fas fa-user-minus' => 'user-minus(delete,negative,remove)'),
            array('far fa-user-minus' => 'user-minus(delete,negative,remove)'),
            array('fal fa-user-minus' => 'user-minus(delete,negative,remove)'),
            array('fas fa-user-ninja' => 'user-ninja(assassin,avatar,dangerous,deadly,sneaky)'),
            array('far fa-user-ninja' => 'user-ninja(assassin,avatar,dangerous,deadly,sneaky)'),
            array('fal fa-user-ninja' => 'user-ninja(assassin,avatar,dangerous,deadly,sneaky)'),
            array('fas fa-user-nurse' => 'user-nurse(doctor,midwife,practitioner,surgeon)'),
            array('far fa-user-nurse' => 'user-nurse(doctor,midwife,practitioner,surgeon)'),
            array('fal fa-user-nurse' => 'user-nurse(doctor,midwife,practitioner,surgeon)'),
            array('fas fa-user-plus' => 'user-plus(add,avatar,positive,sign up,signup,team)'),
            array('far fa-user-plus' => 'user-plus(add,avatar,positive,sign up,signup,team)'),
            array('fal fa-user-plus' => 'user-plus(add,avatar,positive,sign up,signup,team)'),
            array('fas fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('far fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('fal fa-user-secret' => 'user-secret(clothing,coat,hat,incognito,person,privacy,spy,whisper)'),
            array('fas fa-user-shield' => 'user-shield(admin,person,private,protect,safe)'),
            array('far fa-user-shield' => 'user-shield(admin,person,private,protect,safe)'),
            array('fal fa-user-shield' => 'user-shield(admin,person,private,protect,safe)'),
            array('fas fa-user-slash' => 'user-slash(ban,delete,remove)'),
            array('far fa-user-slash' => 'user-slash(ban,delete,remove)'),
            array('fal fa-user-slash' => 'user-slash(ban,delete,remove)'),
            array('fas fa-user-tag' => 'user-tag(avatar,discount,label,person,role,special)'),
            array('far fa-user-tag' => 'user-tag(avatar,discount,label,person,role,special)'),
            array('fal fa-user-tag' => 'user-tag(avatar,discount,label,person,role,special)'),
            array('fas fa-user-tie' => 'user-tie(avatar,business,clothing,formal,professional,suit)'),
            array('far fa-user-tie' => 'user-tie(avatar,business,clothing,formal,professional,suit)'),
            array('fal fa-user-tie' => 'user-tie(avatar,business,clothing,formal,professional,suit)'),
            array('fas fa-user-times' => 'user-times(archive,delete,remove,x)'),
            array('far fa-user-times' => 'user-times(archive,delete,remove,x)'),
            array('fal fa-user-times' => 'user-times(archive,delete,remove,x)'),
            array('fas fa-users' => 'users(friends,group,people,persons,profiles,team)'),
            array('far fa-users' => 'users(friends,group,people,persons,profiles,team)'),
            array('fal fa-users' => 'users(friends,group,people,persons,profiles,team)'),
            array('fas fa-users-class' => 'users-class(chalkboard,group,presentation,students,teachers,team)'),
            array('far fa-users-class' => 'users-class(chalkboard,group,presentation,students,teachers,team)'),
            array('fal fa-users-class' => 'users-class(chalkboard,group,presentation,students,teachers,team)'),
            array('fas fa-users-cog' => 'users-cog(admin,cog,group,person,settings,team)'),
            array('far fa-users-cog' => 'users-cog(admin,cog,group,person,settings,team)'),
            array('fal fa-users-cog' => 'users-cog(admin,cog,group,person,settings,team)'),
            array('fas fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('far fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('fal fa-users-crown' => 'users-crown(admin,avatar,group,person,special,team)'),
            array('fas fa-users-medical' => 'users-medical(group,patients,physician,team)'),
            array('far fa-users-medical' => 'users-medical(group,patients,physician,team)'),
            array('fal fa-users-medical' => 'users-medical(group,patients,physician,team)'),
            array('fas fa-walking' => 'walking(exercise,health,pedometer,person,steps)'),
            array('far fa-walking' => 'walking(exercise,health,pedometer,person,steps)'),
            array('fal fa-walking' => 'walking(exercise,health,pedometer,person,steps)'),
            array('fas fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('far fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fal fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
        ),
        'Vehicles' => array(
            array('fab fa-accessible-icon' => 'accessible-icon(accessibility,handicap,person,wheelchair,wheelchair-alt)'),
            array('fas fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('far fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fal fa-ambulance' => 'ambulance(emergency,emt,er,help,hospital,support,vehicle)'),
            array('fas fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('far fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fal fa-baby-carriage' => 'baby-carriage(buggy,carrier,infant,push,stroller,transportation,walk,wheels)'),
            array('fas fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('far fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fal fa-bicycle' => 'bicycle(bike,gears,pedal,transportation,vehicle)'),
            array('fas fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('far fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fal fa-bus' => 'bus(public transportation,transportation,travel,vehicle)'),
            array('fas fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('far fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('fal fa-bus-alt' => 'bus-alt(mta,public transportation,transportation,travel,vehicle)'),
            array('fas fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car' => 'car(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-car-alt' => 'car-alt(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car-alt' => 'car-alt(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car-alt' => 'car-alt(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-car-bump' => 'car-bump(auto,automobile,off-road,sedan,transportation,vehicle)'),
            array('far fa-car-bump' => 'car-bump(auto,automobile,off-road,sedan,transportation,vehicle)'),
            array('fal fa-car-bump' => 'car-bump(auto,automobile,off-road,sedan,transportation,vehicle)'),
            array('fas fa-car-crash' => 'car-crash(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('far fa-car-crash' => 'car-crash(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fal fa-car-crash' => 'car-crash(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fas fa-car-side' => 'car-side(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('far fa-car-side' => 'car-side(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fal fa-car-side' => 'car-side(auto,automobile,sedan,transportation,travel,vehicle)'),
            array('fas fa-car-tilt' => 'car-tilt(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('far fa-car-tilt' => 'car-tilt(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fal fa-car-tilt' => 'car-tilt(accident,auto,automobile,insurance,sedan,transportation,vehicle,wreck)'),
            array('fas fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('far fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('fal fa-fighter-jet' => 'fighter-jet(airplane,fast,fly,goose,maverick,plane,quick,top gun,transportation,travel)'),
            array('fas fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('far fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('fal fa-helicopter' => 'helicopter(airwolf,apache,chopper,flight,fly,travel)'),
            array('fas fa-horse' => 'horse(equus,fauna,mammmal,mare,neigh,pony)'),
            array('far fa-horse' => 'horse(equus,fauna,mammmal,mare,neigh,pony)'),
            array('fal fa-horse' => 'horse(equus,fauna,mammmal,mare,neigh,pony)'),
            array('fas fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('far fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fal fa-motorcycle' => 'motorcycle(bike,machine,transportation,vehicle)'),
            array('fas fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('far fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fal fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fas fa-pegasus' => 'pegasus(fantasy,horse,unicorn,wings)'),
            array('far fa-pegasus' => 'pegasus(fantasy,horse,unicorn,wings)'),
            array('fal fa-pegasus' => 'pegasus(fantasy,horse,unicorn,wings)'),
            array('fas fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('far fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fal fa-plane' => 'plane(airplane,destination,fly,location,mode,travel,trip)'),
            array('fas fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('far fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('fal fa-plane-alt' => 'plane-alt(airplane,destination,fly,location,mode,travel,trip)'),
            array('fas fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('far fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fal fa-rocket' => 'rocket(aircraft,app,jet,launch,nasa,space)'),
            array('fas fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('far fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fal fa-rv' => 'rv(camping,cousin eddie,recreational,travel,vehicle)'),
            array('fas fa-ship' => 'ship(boat,sea,water)'),
            array('far fa-ship' => 'ship(boat,sea,water)'),
            array('fal fa-ship' => 'ship(boat,sea,water)'),
            array('fas fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('far fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fal fa-shopping-cart' => 'shopping-cart(buy,checkout,grocery,payment,purchase)'),
            array('fas fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('far fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fal fa-shuttle-van' => 'shuttle-van(airport,machine,public-transportation,transportation,travel,vehicle)'),
            array('fas fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('far fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('fal fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('fas fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('far fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('fal fa-sleigh' => 'sleigh(christmas,claus,fly,holiday,santa,sled,snow,xmas)'),
            array('fas fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('far fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fal fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fas fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('far fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fal fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fas fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('far fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('fal fa-space-shuttle' => 'space-shuttle(astronaut,machine,nasa,rocket,transportation)'),
            array('fas fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('far fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('fal fa-subway' => 'subway(machine,railway,train,transportation,vehicle)'),
            array('fas fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('far fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fal fa-taxi' => 'taxi(cab,cabbie,car,car service,lyft,machine,transportation,travel,uber,vehicle)'),
            array('fas fa-tractor' => 'tractor(agriculture,farm,vehicle)'),
            array('far fa-tractor' => 'tractor(agriculture,farm,vehicle)'),
            array('fal fa-tractor' => 'tractor(agriculture,farm,vehicle)'),
            array('fas fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('far fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('fal fa-train' => 'train(bullet,commute,locomotive,railway,subway)'),
            array('fas fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('far fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fal fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fas fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('far fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fal fa-truck' => 'truck(cargo,delivery,shipping,vehicle)'),
            array('fas fa-truck-monster' => 'truck-monster(offroad,vehicle,wheel)'),
            array('far fa-truck-monster' => 'truck-monster(offroad,vehicle,wheel)'),
            array('fal fa-truck-monster' => 'truck-monster(offroad,vehicle,wheel)'),
            array('fas fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('far fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('fal fa-truck-pickup' => 'truck-pickup(cargo,vehicle)'),
            array('fas fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('far fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('fal fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('fas fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('far fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
            array('fal fa-wheelchair' => 'wheelchair(accessible,handicap,person)'),
        ),
        'Weather' => array(
            array('fas fa-bolt' => 'bolt(electricity,lightning,weather,zap)'),
            array('far fa-bolt' => 'bolt(electricity,lightning,weather,zap)'),
            array('fal fa-bolt' => 'bolt(electricity,lightning,weather,zap)'),
            array('fas fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('far fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fal fa-cloud' => 'cloud(atmosphere,fog,overcast,save,upload,weather)'),
            array('fas fa-cloud-drizzle' => 'cloud-drizzle(precipitation,rain,sprinkle)'),
            array('far fa-cloud-drizzle' => 'cloud-drizzle(precipitation,rain,sprinkle)'),
            array('fal fa-cloud-drizzle' => 'cloud-drizzle(precipitation,rain,sprinkle)'),
            array('fas fa-cloud-hail' => 'cloud-hail(golf balls,ice,precipitation,sleet,snow,storm)'),
            array('far fa-cloud-hail' => 'cloud-hail(golf balls,ice,precipitation,sleet,snow,storm)'),
            array('fal fa-cloud-hail' => 'cloud-hail(golf balls,ice,precipitation,sleet,snow,storm)'),
            array('fas fa-cloud-hail-mixed' => 'cloud-hail-mixed(freezing,ice,precipitation,rain,sleet,snow,storm)'),
            array('far fa-cloud-hail-mixed' => 'cloud-hail-mixed(freezing,ice,precipitation,rain,sleet,snow,storm)'),
            array('fal fa-cloud-hail-mixed' => 'cloud-hail-mixed(freezing,ice,precipitation,rain,sleet,snow,storm)'),
            array('fas fa-cloud-meatball' => 'cloud-meatball(FLDSMDFR,food,spaghetti,storm)'),
            array('far fa-cloud-meatball' => 'cloud-meatball(FLDSMDFR,food,spaghetti,storm)'),
            array('fal fa-cloud-meatball' => 'cloud-meatball(FLDSMDFR,food,spaghetti,storm)'),
            array('fas fa-cloud-moon' => 'cloud-moon(crescent,evening,lunar,night,partly cloudy,sky)'),
            array('far fa-cloud-moon' => 'cloud-moon(crescent,evening,lunar,night,partly cloudy,sky)'),
            array('fal fa-cloud-moon' => 'cloud-moon(crescent,evening,lunar,night,partly cloudy,sky)'),
            array('fas fa-cloud-moon-rain' => 'cloud-moon-rain(crescent,evening,lunar,night,partly cloudy,precipitation,rain,sky,storm)'),
            array('far fa-cloud-moon-rain' => 'cloud-moon-rain(crescent,evening,lunar,night,partly cloudy,precipitation,rain,sky,storm)'),
            array('fal fa-cloud-moon-rain' => 'cloud-moon-rain(crescent,evening,lunar,night,partly cloudy,precipitation,rain,sky,storm)'),
            array('fas fa-cloud-rain' => 'cloud-rain(precipitation,rain,sky,storm)'),
            array('far fa-cloud-rain' => 'cloud-rain(precipitation,rain,sky,storm)'),
            array('fal fa-cloud-rain' => 'cloud-rain(precipitation,rain,sky,storm)'),
            array('fas fa-cloud-rainbow' => 'cloud-rainbow(gold,leprechaun,prism,rain,sky)'),
            array('far fa-cloud-rainbow' => 'cloud-rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fal fa-cloud-rainbow' => 'cloud-rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fas fa-cloud-showers' => 'cloud-showers(precipitation,rain,sky,storm)'),
            array('far fa-cloud-showers' => 'cloud-showers(precipitation,rain,sky,storm)'),
            array('fal fa-cloud-showers' => 'cloud-showers(precipitation,rain,sky,storm)'),
            array('fas fa-cloud-showers-heavy' => 'cloud-showers-heavy(precipitation,rain,sky,storm)'),
            array('far fa-cloud-showers-heavy' => 'cloud-showers-heavy(precipitation,rain,sky,storm)'),
            array('fal fa-cloud-showers-heavy' => 'cloud-showers-heavy(precipitation,rain,sky,storm)'),
            array('fas fa-cloud-sleet' => 'cloud-sleet(freezing,hail,precipitation,rain,winter,wintry mix)'),
            array('far fa-cloud-sleet' => 'cloud-sleet(freezing,hail,precipitation,rain,winter,wintry mix)'),
            array('fal fa-cloud-sleet' => 'cloud-sleet(freezing,hail,precipitation,rain,winter,wintry mix)'),
            array('fas fa-cloud-snow' => 'cloud-snow(blizzard,noreaster,precipitation,winter)'),
            array('far fa-cloud-snow' => 'cloud-snow(blizzard,noreaster,precipitation,winter)'),
            array('fal fa-cloud-snow' => 'cloud-snow(blizzard,noreaster,precipitation,winter)'),
            array('fas fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('far fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('fal fa-cloud-sun' => 'cloud-sun(clear,day,daytime,fall,outdoors,overcast,partly cloudy)'),
            array('fas fa-cloud-sun-rain' => 'cloud-sun-rain(day,overcast,precipitation,storm,summer,sunshower)'),
            array('far fa-cloud-sun-rain' => 'cloud-sun-rain(day,overcast,precipitation,storm,summer,sunshower)'),
            array('fal fa-cloud-sun-rain' => 'cloud-sun-rain(day,overcast,precipitation,storm,summer,sunshower)'),
            array('fas fa-clouds' => 'clouds(cloudy,fog,haze,overcast,smoke,storm,weather)'),
            array('far fa-clouds' => 'clouds(cloudy,fog,haze,overcast,smoke,storm,weather)'),
            array('fal fa-clouds' => 'clouds(cloudy,fog,haze,overcast,smoke,storm,weather)'),
            array('fas fa-clouds-moon' => 'clouds-moon(cloudy,moonlight,night,overcast,sky)'),
            array('far fa-clouds-moon' => 'clouds-moon(cloudy,moonlight,night,overcast,sky)'),
            array('fal fa-clouds-moon' => 'clouds-moon(cloudy,moonlight,night,overcast,sky)'),
            array('fas fa-clouds-sun' => 'clouds-sun(cloudy,day,moonlight,overcast,sky,summer)'),
            array('far fa-clouds-sun' => 'clouds-sun(cloudy,day,moonlight,overcast,sky,summer)'),
            array('fal fa-clouds-sun' => 'clouds-sun(cloudy,day,moonlight,overcast,sky,summer)'),
            array('fas fa-dewpoint' => 'dewpoint(air,fog,humidity,temperature,water)'),
            array('far fa-dewpoint' => 'dewpoint(air,fog,humidity,temperature,water)'),
            array('fal fa-dewpoint' => 'dewpoint(air,fog,humidity,temperature,water)'),
            array('fas fa-eclipse' => 'eclipse(lunar,moon,shadow,solar,sun)'),
            array('far fa-eclipse' => 'eclipse(lunar,moon,shadow,solar,sun)'),
            array('fal fa-eclipse' => 'eclipse(lunar,moon,shadow,solar,sun)'),
            array('fas fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('far fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('fal fa-eclipse-alt' => 'eclipse-alt(lunar,moon,shadow,solar,sun)'),
            array('fas fa-fire-smoke' => 'fire-smoke(burn,caliente,flame,fog,heat,hot)'),
            array('far fa-fire-smoke' => 'fire-smoke(burn,caliente,flame,fog,heat,hot)'),
            array('fal fa-fire-smoke' => 'fire-smoke(burn,caliente,flame,fog,heat,hot)'),
            array('fas fa-fog' => 'fog(haze,karl,mist,opaque,san francisco,visibility,weather)'),
            array('far fa-fog' => 'fog(haze,karl,mist,opaque,san francisco,visibility,weather)'),
            array('fal fa-fog' => 'fog(haze,karl,mist,opaque,san francisco,visibility,weather)'),
            array('fas fa-house-flood' => 'house-flood(building,devastation,disaster,home,insurance,water)'),
            array('far fa-house-flood' => 'house-flood(building,devastation,disaster,home,insurance,water)'),
            array('fal fa-house-flood' => 'house-flood(building,devastation,disaster,home,insurance,water)'),
            array('fas fa-humidity' => 'humidity(evaporation,fog,precipitation,rain)'),
            array('far fa-humidity' => 'humidity(evaporation,fog,precipitation,rain)'),
            array('fal fa-humidity' => 'humidity(evaporation,fog,precipitation,rain)'),
            array('fas fa-hurricane' => 'hurricane(coriolis effect,eye,storm,tropical cyclone,typhoon)'),
            array('far fa-hurricane' => 'hurricane(coriolis effect,eye,storm,tropical cyclone,typhoon)'),
            array('fal fa-hurricane' => 'hurricane(coriolis effect,eye,storm,tropical cyclone,typhoon)'),
            array('fas fa-meteor' => 'meteor(armageddon,asteroid,comet,shooting star,space)'),
            array('far fa-meteor' => 'meteor(armageddon,asteroid,comet,shooting star,space)'),
            array('fal fa-meteor' => 'meteor(armageddon,asteroid,comet,shooting star,space)'),
            array('fas fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('far fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('fal fa-moon' => 'moon(contrast,crescent,dark,lunar,night)'),
            array('fas fa-moon-cloud' => 'moon-cloud(crescent,dark,lunar,night,overcast)'),
            array('far fa-moon-cloud' => 'moon-cloud(crescent,dark,lunar,night,overcast)'),
            array('fal fa-moon-cloud' => 'moon-cloud(crescent,dark,lunar,night,overcast)'),
            array('fas fa-moon-stars' => 'moon-stars(clear,crescent,lunar,star)'),
            array('far fa-moon-stars' => 'moon-stars(clear,crescent,lunar,star)'),
            array('fal fa-moon-stars' => 'moon-stars(clear,crescent,lunar,star)'),
            array('fas fa-poo-storm' => 'poo-storm(bolt,cloud,euphemism,lightning,mess,poop,shit,turd)'),
            array('far fa-poo-storm' => 'poo-storm(bolt,cloud,euphemism,lightning,mess,poop,shit,turd)'),
            array('fal fa-poo-storm' => 'poo-storm(bolt,cloud,euphemism,lightning,mess,poop,shit,turd)'),
            array('fas fa-rainbow' => 'rainbow(gold,leprechaun,prism,rain,sky)'),
            array('far fa-rainbow' => 'rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fal fa-rainbow' => 'rainbow(gold,leprechaun,prism,rain,sky)'),
            array('fas fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('far fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('fal fa-raindrops' => 'raindrops(precipitation,rain,sprinkle,storm)'),
            array('fas fa-smog' => 'smog(dragon,fog,haze,pollution,smoke,weather)'),
            array('far fa-smog' => 'smog(dragon,fog,haze,pollution,smoke,weather)'),
            array('fal fa-smog' => 'smog(dragon,fog,haze,pollution,smoke,weather)'),
            array('fas fa-smoke' => 'smoke(cloud,fire,fog,haze)'),
            array('far fa-smoke' => 'smoke(cloud,fire,fog,haze)'),
            array('fal fa-smoke' => 'smoke(cloud,fire,fog,haze)'),
            array('fas fa-snow-blowing' => 'snow-blowing(blizzard,precipitation,storm,winter)'),
            array('far fa-snow-blowing' => 'snow-blowing(blizzard,precipitation,storm,winter)'),
            array('fal fa-snow-blowing' => 'snow-blowing(blizzard,precipitation,storm,winter)'),
            array('fas fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('far fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fal fa-snowflake' => 'snowflake(precipitation,rain,winter)'),
            array('fas fa-snowflakes' => 'snowflakes(precipitation,rain,winter)'),
            array('far fa-snowflakes' => 'snowflakes(precipitation,rain,winter)'),
            array('fal fa-snowflakes' => 'snowflakes(precipitation,rain,winter)'),
            array('fas fa-stars' => 'stars(galaxy,magic,night)'),
            array('far fa-stars' => 'stars(galaxy,magic,night)'),
            array('fal fa-stars' => 'stars(galaxy,magic,night)'),
            array('fas fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('far fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fal fa-sun' => 'sun(brighten,contrast,day,lighter,sol,solar,star,weather)'),
            array('fas fa-sun-cloud' => 'sun-cloud(cloud,day,lighter,sol,solar,star,weather)'),
            array('far fa-sun-cloud' => 'sun-cloud(cloud,day,lighter,sol,solar,star,weather)'),
            array('fal fa-sun-cloud' => 'sun-cloud(cloud,day,lighter,sol,solar,star,weather)'),
            array('fas fa-sun-dust' => 'sun-dust(day,dry,haze,heat)'),
            array('far fa-sun-dust' => 'sun-dust(day,dry,haze,heat)'),
            array('fal fa-sun-dust' => 'sun-dust(day,dry,haze,heat)'),
            array('fas fa-sun-haze' => 'sun-haze(fog,heat,hot,sweltering)'),
            array('far fa-sun-haze' => 'sun-haze(fog,heat,hot,sweltering)'),
            array('fal fa-sun-haze' => 'sun-haze(fog,heat,hot,sweltering)'),
            array('fas fa-sunrise' => 'sunrise(dawn,day,daybreak,daylight,daytime,morning,sun up)'),
            array('far fa-sunrise' => 'sunrise(dawn,day,daybreak,daylight,daytime,morning,sun up)'),
            array('fal fa-sunrise' => 'sunrise(dawn,day,daybreak,daylight,daytime,morning,sun up)'),
            array('fas fa-sunset' => 'sunset(dusk,night,nighttime,sun down)'),
            array('far fa-sunset' => 'sunset(dusk,night,nighttime,sun down)'),
            array('fal fa-sunset' => 'sunset(dusk,night,nighttime,sun down)'),
            array('fas fa-temperature-frigid' => 'temperature-frigid(cold,mercury,thermometer,winter)'),
            array('far fa-temperature-frigid' => 'temperature-frigid(cold,mercury,thermometer,winter)'),
            array('fal fa-temperature-frigid' => 'temperature-frigid(cold,mercury,thermometer,winter)'),
            array('fas fa-temperature-high' => 'temperature-high(cook,mercury,summer,thermometer,warm)'),
            array('far fa-temperature-high' => 'temperature-high(cook,mercury,summer,thermometer,warm)'),
            array('fal fa-temperature-high' => 'temperature-high(cook,mercury,summer,thermometer,warm)'),
            array('fas fa-temperature-hot' => 'temperature-hot(heat,mercury,summer,thermometer)'),
            array('far fa-temperature-hot' => 'temperature-hot(heat,mercury,summer,thermometer)'),
            array('fal fa-temperature-hot' => 'temperature-hot(heat,mercury,summer,thermometer)'),
            array('fas fa-temperature-low' => 'temperature-low(cold,cool,mercury,thermometer,winter)'),
            array('far fa-temperature-low' => 'temperature-low(cold,cool,mercury,thermometer,winter)'),
            array('fal fa-temperature-low' => 'temperature-low(cold,cool,mercury,thermometer,winter)'),
            array('fas fa-thunderstorm' => 'thunderstorm(bolt,lightning,precipitation,rain,storm,weather)'),
            array('far fa-thunderstorm' => 'thunderstorm(bolt,lightning,precipitation,rain,storm,weather)'),
            array('fal fa-thunderstorm' => 'thunderstorm(bolt,lightning,precipitation,rain,storm,weather)'),
            array('fas fa-thunderstorm-moon' => 'thunderstorm-moon(bolt,lightning,lunar,moon,precipitation,rain,storm,weather)'),
            array('far fa-thunderstorm-moon' => 'thunderstorm-moon(bolt,lightning,lunar,moon,precipitation,rain,storm,weather)'),
            array('fal fa-thunderstorm-moon' => 'thunderstorm-moon(bolt,lightning,lunar,moon,precipitation,rain,storm,weather)'),
            array('fas fa-thunderstorm-sun' => 'thunderstorm-sun(bolt,lightning,precipitation,rain,solar,storm,sun,weather)'),
            array('far fa-thunderstorm-sun' => 'thunderstorm-sun(bolt,lightning,precipitation,rain,solar,storm,sun,weather)'),
            array('fal fa-thunderstorm-sun' => 'thunderstorm-sun(bolt,lightning,precipitation,rain,solar,storm,sun,weather)'),
            array('fas fa-tornado' => 'tornado(cyclone,dorothy,landspout,toto,twister,vortext,waterspout,weather,whirlwind)'),
            array('far fa-tornado' => 'tornado(cyclone,dorothy,landspout,toto,twister,vortext,waterspout,weather,whirlwind)'),
            array('fal fa-tornado' => 'tornado(cyclone,dorothy,landspout,toto,twister,vortext,waterspout,weather,whirlwind)'),
            array('fas fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('far fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('fal fa-umbrella' => 'umbrella(protection,rain,storm,wet)'),
            array('fas fa-volcano' => 'volcano(caldera,lava,magma,mountain,smoke)'),
            array('far fa-volcano' => 'volcano(caldera,lava,magma,mountain,smoke)'),
            array('fal fa-volcano' => 'volcano(caldera,lava,magma,mountain,smoke)'),
            array('fas fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('far fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('fal fa-water' => 'water(lake,liquid,ocean,sea,swim,wet)'),
            array('fas fa-water-lower' => 'water-lower(flood,lake,liquid,ocean,recede,sea,swim,wet)'),
            array('far fa-water-lower' => 'water-lower(flood,lake,liquid,ocean,recede,sea,swim,wet)'),
            array('fal fa-water-lower' => 'water-lower(flood,lake,liquid,ocean,recede,sea,swim,wet)'),
            array('fas fa-water-rise' => 'water-rise(flood,lake,liquid,ocean,sea,swim,wet)'),
            array('far fa-water-rise' => 'water-rise(flood,lake,liquid,ocean,sea,swim,wet)'),
            array('fal fa-water-rise' => 'water-rise(flood,lake,liquid,ocean,sea,swim,wet)'),
            array('fas fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('far fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('fal fa-wind' => 'wind(air,blow,breeze,fall,seasonal,weather)'),
            array('fas fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
            array('far fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
            array('fal fa-wind-warning' => 'wind-warning(air,alert,blow,breeze,fall,hurricane,seasonal,tornado,weather)'),
            array('fas fa-windsock' => 'windsock(air,blow,breeze,fall,seasonal,weather)'),
            array('far fa-windsock' => 'windsock(air,blow,breeze,fall,seasonal,weather)'),
            array('fal fa-windsock' => 'windsock(air,blow,breeze,fall,seasonal,weather)'),
        ),
        'Winter' => array(
            array('fas fa-ball-pile' => 'ball-pile(balance,cannon,group,pyramid,snowball)'),
            array('far fa-ball-pile' => 'ball-pile(balance,cannon,group,pyramid,snowball)'),
            array('fal fa-ball-pile' => 'ball-pile(balance,cannon,group,pyramid,snowball)'),
            array('fas fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('far fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fal fa-boot' => 'boot(clothing,foot,hiking,shoe,sturdy)'),
            array('fas fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('far fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('fal fa-chimney' => 'chimney(brick,exhaust,fireplace,house,roof,vent)'),
            array('fas fa-ear-muffs' => 'ear-muffs(accessory,clothing,cold,head,puffy,soft,winter)'),
            array('far fa-ear-muffs' => 'ear-muffs(accessory,clothing,cold,head,puffy,soft,winter)'),
            array('fal fa-ear-muffs' => 'ear-muffs(accessory,clothing,cold,head,puffy,soft,winter)'),
            array('fas fa-frosty-head' => 'frosty-head(carrot,hat,snowman,winter)'),
            array('far fa-frosty-head' => 'frosty-head(carrot,hat,snowman,winter)'),
            array('fal fa-frosty-head' => 'frosty-head(carrot,hat,snowman,winter)'),
            array('fas fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('far fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('fal fa-glass-whiskey' => 'glass-whiskey(alcohol,bar,beverage,bourbon,drink,liquor,neat,rye,scotch,whisky)'),
            array('fas fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('far fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('fal fa-glass-whiskey-rocks' => 'glass-whiskey-rocks(alcohol,bar,beverage,bourbon,drink,ice,liquor,rye,scotch,whisky)'),
            array('fas fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('far fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('fal fa-globe-snow' => 'globe-snow(diorama,scene,seasonal,shake,souvenir,winter)'),
            array('fas fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('far fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('fal fa-hat-winter' => 'hat-winter(accessory,clothing,cold,head,knitted,seasonal)'),
            array('fas fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('far fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fal fa-ice-skate' => 'ice-skate(blade,clothing,figure skating,hockey,seasonal,shoe)'),
            array('fas fa-icicles' => 'icicles(cold,frozen,hanging,ice,seasonal,sharp)'),
            array('far fa-icicles' => 'icicles(cold,frozen,hanging,ice,seasonal,sharp)'),
            array('fal fa-icicles' => 'icicles(cold,frozen,hanging,ice,seasonal,sharp)'),
            array('fas fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('far fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('fal fa-igloo' => 'igloo(dome,dwelling,eskimo,home,house,ice,snow)'),
            array('fas fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('far fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fal fa-mitten' => 'mitten(clothing,cold,glove,hands,knitted,seasonal,warmth)'),
            array('fas fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('far fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('fal fa-mug-marshmallows' => 'mug-marshmallows(cocoa,coffee,cup,drink,hot chocolate,seasonal,sweet,warmth)'),
            array('fas fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('far fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('fal fa-scarf' => 'scarf(clothing,knitted,neck,seasonal,warmth)'),
            array('fas fa-shovel-snow' => 'shovel-snow(construction,dig,excavate,plow,tool,trench)'),
            array('far fa-shovel-snow' => 'shovel-snow(construction,dig,excavate,plow,tool,trench)'),
            array('fal fa-shovel-snow' => 'shovel-snow(construction,dig,excavate,plow,tool,trench)'),
            array('fas fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('far fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fal fa-skating' => 'skating(activity,figure skating,fitness,ice,person,winter)'),
            array('fas fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('far fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fal fa-ski-jump' => 'ski-jump(activity,fast,fitness,olympics,outdoors,person,snowman)'),
            array('fas fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('far fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('fal fa-ski-lift' => 'ski-lift(machine,outdoors,resort,seasonal,seat,skiing,tow)'),
            array('fas fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('far fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fal fa-skiing' => 'skiing(activity,downhill,fast,fitness,olympics,outdoors,person,seasonal,slalom)'),
            array('fas fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('far fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fal fa-skiing-nordic' => 'skiing-nordic(activity,cross country,fitness,outdoors,person,seasonal)'),
            array('fas fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('far fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('fal fa-sledding' => 'sledding(activity,luge,outdoors,person,seasonal,snow,toboggan)'),
            array('fas fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('far fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fal fa-snowboarding' => 'snowboarding(activity,fitness,olympics,outdoors,person)'),
            array('fas fa-snowflakes' => 'snowflakes(precipitation,rain,winter)'),
            array('far fa-snowflakes' => 'snowflakes(precipitation,rain,winter)'),
            array('fal fa-snowflakes' => 'snowflakes(precipitation,rain,winter)'),
            array('fas fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('far fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fal fa-snowmobile' => 'snowmobile(fast,person,transportation,treads,vehicle,winter)'),
            array('fas fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('far fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fal fa-snowplow' => 'snowplow(clean up,cold,road,storm,winter)'),
            array('fas fa-temperature-frigid' => 'temperature-frigid(cold,mercury,thermometer,winter)'),
            array('far fa-temperature-frigid' => 'temperature-frigid(cold,mercury,thermometer,winter)'),
            array('fal fa-temperature-frigid' => 'temperature-frigid(cold,mercury,thermometer,winter)'),
            array('fas fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('far fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fal fa-tram' => 'tram(crossing,machine,mountains,seasonal,transportation)'),
            array('fas fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('far fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fal fa-tree-large' => 'tree-large(bark,fall,flora,forest,nature,plant,seasonal)'),
            array('fas fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('far fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
            array('fal fa-truck-plow' => 'truck-plow(clean up,cold,seasonal,snow,winter)'),
        ),
        'Writing' => array(
            array('fas fa-archive' => 'archive(box,package,save,storage)'),
            array('far fa-archive' => 'archive(box,package,save,storage)'),
            array('fal fa-archive' => 'archive(box,package,save,storage)'),
            array('fas fa-blog' => 'blog(journal,log,online,personal,post,web 2.0,wordpress,writing)'),
            array('far fa-blog' => 'blog(journal,log,online,personal,post,web 2.0,wordpress,writing)'),
            array('fal fa-blog' => 'blog(journal,log,online,personal,post,web 2.0,wordpress,writing)'),
            array('fas fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('far fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fal fa-book' => 'book(diary,documentation,journal,library,read)'),
            array('fas fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('far fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fal fa-bookmark' => 'bookmark(favorite,marker,read,remember,save)'),
            array('fas fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('far fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fal fa-edit' => 'edit(edit,pen,pencil,update,write)'),
            array('fas fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope' => 'envelope(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('far fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fal fa-envelope-open' => 'envelope-open(e-mail,email,letter,mail,message,notification,support)'),
            array('fas fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('far fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fal fa-eraser' => 'eraser(art,delete,remove,rubber)'),
            array('fas fa-file' => 'file(document,new,page,pdf,resume)'),
            array('far fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fal fa-file' => 'file(document,new,page,pdf,resume)'),
            array('fas fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('far fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fal fa-file-alt' => 'file-alt(document,file-text,invoice,new,page,pdf)'),
            array('fas fa-folder' => 'folder(archive,directory,document,file)'),
            array('far fa-folder' => 'folder(archive,directory,document,file)'),
            array('fal fa-folder' => 'folder(archive,directory,document,file)'),
            array('fas fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('far fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fal fa-folder-open' => 'folder-open(archive,directory,document,empty,file,new)'),
            array('fas fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('far fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fal fa-keyboard' => 'keyboard(accessory,edit,input,text,type,write)'),
            array('fas fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('far fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('fal fa-newspaper' => 'newspaper(article,editorial,headline,journal,journalism,news,press)'),
            array('fas fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('far fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fal fa-paper-plane' => 'paper-plane(air,float,fold,mail,paper,send)'),
            array('fas fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('far fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fal fa-paperclip' => 'paperclip(attach,attachment,connect,link)'),
            array('fas fa-paragraph' => 'paragraph(edit,format,text,writing)'),
            array('far fa-paragraph' => 'paragraph(edit,format,text,writing)'),
            array('fal fa-paragraph' => 'paragraph(edit,format,text,writing)'),
            array('fas fa-pen' => 'pen(design,edit,update,write)'),
            array('far fa-pen' => 'pen(design,edit,update,write)'),
            array('fal fa-pen' => 'pen(design,edit,update,write)'),
            array('fas fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('far fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fal fa-pen-alt' => 'pen-alt(design,edit,update,write)'),
            array('fas fa-pen-square' => 'pen-square(edit,pencil-square,update,write)'),
            array('far fa-pen-square' => 'pen-square(edit,pencil-square,update,write)'),
            array('fal fa-pen-square' => 'pen-square(edit,pencil-square,update,write)'),
            array('fas fa-pencil' => 'pencil(design,edit,update,write)'),
            array('far fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fal fa-pencil' => 'pencil(design,edit,update,write)'),
            array('fas fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('far fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fal fa-pencil-alt' => 'pencil-alt(design,edit,pencil,update,write)'),
            array('fas fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('far fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fal fa-quote-left' => 'quote-left(mention,note,phrase,text,type)'),
            array('fas fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('far fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fal fa-quote-right' => 'quote-right(mention,note,phrase,text,type)'),
            array('fas fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('far fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('fal fa-sticky-note' => 'sticky-note(message,note,paper,reminder,sticker)'),
            array('fas fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('far fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
            array('fal fa-thumbtack' => 'thumbtack(coordinates,location,marker,pin,thumb-tack)'),
        ),
        'Other' => array(
            array('fab fa-500px' => '500px'),
            array('fab fa-accusoft' => 'accusoft'),
            array('fab fa-adn' => 'adn'),
            array('fab fa-adobe' => 'adobe(acrobat,app,design,illustrator,indesign,photoshop)'),
            array('fab fa-adversal' => 'adversal'),
            array('fab fa-affiliatetheme' => 'affiliatetheme'),
            array('fab fa-airbnb' => 'airbnb'),
            array('fab fa-algolia' => 'algolia'),
            array('fab fa-amazon' => 'amazon'),
            array('fab fa-amilia' => 'amilia'),
            array('fab fa-android' => 'android(robot)'),
            array('fab fa-angellist' => 'angellist'),
            array('fab fa-angrycreative' => 'angrycreative'),
            array('fab fa-angular' => 'angular'),
            array('fab fa-app-store' => 'app-store'),
            array('fab fa-app-store-ios' => 'app-store-ios'),
            array('fab fa-apper' => 'apper'),
            array('fab fa-apple' => 'apple(fruit,ios,mac,operating system,os,osx)'),
            array('fab fa-artstation' => 'artstation'),
            array('fab fa-asymmetrik' => 'asymmetrik'),
            array('fab fa-atlassian' => 'atlassian'),
            array('fab fa-audible' => 'audible'),
            array('fab fa-autoprefixer' => 'autoprefixer'),
            array('fab fa-avianex' => 'avianex'),
            array('fab fa-aviato' => 'aviato'),
            array('fab fa-aws' => 'aws'),
            array('fas fa-backspace' => 'backspace(command,delete,erase,keyboard,undo)'),
            array('far fa-backspace' => 'backspace(command,delete,erase,keyboard,undo)'),
            array('fal fa-backspace' => 'backspace(command,delete,erase,keyboard,undo)'),
            array('fab fa-bandcamp' => 'bandcamp'),
            array('fab fa-battle-net' => 'battle-net'),
            array('fab fa-behance' => 'behance'),
            array('fab fa-behance-square' => 'behance-square'),
            array('fab fa-bimobject' => 'bimobject'),
            array('fab fa-bitbucket' => 'bitbucket(atlassian,bitbucket-square,git)'),
            array('fab fa-bity' => 'bity'),
            array('fab fa-black-tie' => 'black-tie'),
            array('fab fa-blackberry' => 'blackberry'),
            array('fas fa-blender-phone' => 'blender-phone(appliance,cocktail,communication,fantasy,milkshake,mixer,puree,silly,smoothie)'),
            array('far fa-blender-phone' => 'blender-phone(appliance,cocktail,communication,fantasy,milkshake,mixer,puree,silly,smoothie)'),
            array('fal fa-blender-phone' => 'blender-phone(appliance,cocktail,communication,fantasy,milkshake,mixer,puree,silly,smoothie)'),
            array('fab fa-blogger' => 'blogger'),
            array('fab fa-blogger-b' => 'blogger-b'),
            array('fab fa-bootstrap' => 'bootstrap'),
            array('fab fa-buffer' => 'buffer'),
            array('fab fa-buromobelexperte' => 'buromobelexperte'),
            array('fab fa-buysellads' => 'buysellads'),
            array('fab fa-canadian-maple-leaf' => 'canadian-maple-leaf(canada,flag,flora,nature,plant)'),
            array('fab fa-centercode' => 'centercode'),
            array('fab fa-centos' => 'centos(linux,operating system,os)'),
            array('fab fa-chrome' => 'chrome(browser)'),
            array('fab fa-chromecast' => 'chromecast'),
            array('fab fa-cloudscale' => 'cloudscale'),
            array('fab fa-cloudsmith' => 'cloudsmith'),
            array('fab fa-cloudversify' => 'cloudversify'),
            array('fab fa-codepen' => 'codepen'),
            array('fab fa-codiepie' => 'codiepie'),
            array('fab fa-confluence' => 'confluence(atlassian)'),
            array('fab fa-connectdevelop' => 'connectdevelop'),
            array('fab fa-contao' => 'contao'),
            array('fab fa-cpanel' => 'cpanel'),
            array('fab fa-creative-commons' => 'creative-commons'),
            array('fab fa-creative-commons-by' => 'creative-commons-by'),
            array('fab fa-creative-commons-nc' => 'creative-commons-nc'),
            array('fab fa-creative-commons-nc-eu' => 'creative-commons-nc-eu'),
            array('fab fa-creative-commons-nc-jp' => 'creative-commons-nc-jp'),
            array('fab fa-creative-commons-nd' => 'creative-commons-nd'),
            array('fab fa-creative-commons-pd' => 'creative-commons-pd'),
            array('fab fa-creative-commons-pd-alt' => 'creative-commons-pd-alt'),
            array('fab fa-creative-commons-remix' => 'creative-commons-remix'),
            array('fab fa-creative-commons-sa' => 'creative-commons-sa'),
            array('fab fa-creative-commons-sampling' => 'creative-commons-sampling'),
            array('fab fa-creative-commons-sampling-plus' => 'creative-commons-sampling-plus'),
            array('fab fa-creative-commons-share' => 'creative-commons-share'),
            array('fab fa-creative-commons-zero' => 'creative-commons-zero'),
            array('fas fa-crown' => 'crown(award,favorite,king,queen,royal,tiara)'),
            array('far fa-crown' => 'crown(award,favorite,king,queen,royal,tiara)'),
            array('fal fa-crown' => 'crown(award,favorite,king,queen,royal,tiara)'),
            array('fab fa-css3' => 'css3(code)'),
            array('fab fa-css3-alt' => 'css3-alt'),
            array('fab fa-cuttlefish' => 'cuttlefish'),
            array('fab fa-dashcube' => 'dashcube'),
            array('fab fa-delicious' => 'delicious'),
            array('fab fa-deploydog' => 'deploydog'),
            array('fab fa-deskpro' => 'deskpro'),
            array('fab fa-dev' => 'dev'),
            array('fab fa-deviantart' => 'deviantart'),
            array('fab fa-dhl' => 'dhl(Dalsey,Hillblom and Lynn,german,package,shipping)'),
            array('fab fa-diaspora' => 'diaspora'),
            array('fab fa-digg' => 'digg'),
            array('fab fa-digital-ocean' => 'digital-ocean'),
            array('fab fa-discord' => 'discord'),
            array('fab fa-discourse' => 'discourse'),
            array('fab fa-dochub' => 'dochub'),
            array('fab fa-docker' => 'docker'),
            array('fab fa-draft2digital' => 'draft2digital'),
            array('fab fa-dribbble' => 'dribbble'),
            array('fab fa-dribbble-square' => 'dribbble-square'),
            array('fab fa-dropbox' => 'dropbox'),
            array('fab fa-drupal' => 'drupal'),
            array('fas fa-dumpster-fire' => 'dumpster-fire(alley,bin,commercial,danger,dangerous,euphemism,flame,heat,hot,trash,waste)'),
            array('far fa-dumpster-fire' => 'dumpster-fire(alley,bin,commercial,danger,dangerous,euphemism,flame,heat,hot,trash,waste)'),
            array('fal fa-dumpster-fire' => 'dumpster-fire(alley,bin,commercial,danger,dangerous,euphemism,flame,heat,hot,trash,waste)'),
            array('fab fa-dyalog' => 'dyalog'),
            array('fab fa-earlybirds' => 'earlybir